<?php


namespace App\Services\Nati;

use App\Repositories\Nati\SatEquipamentoRepository;
use App\Validators\Nati\SatEquipamentoValidator;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;

class SatEquipamentosService
{
    private $repository;
    private $validator;


    public function __construct(SatEquipamentoRepository $repository, SatEquipamentoValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function getById($id) {

        return $this->repository->find($id);
    }

    public function all()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        return $this->repository->all();
    }

    public function create($request)
    {
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $eqpSat = [
            "serial" => $request['serial'],
            "Active" => $request['Active'],
            "DataCadastro" => Carbon::now(),
            "dtAlteracao" => Carbon::now()
        ];


        return $this->repository->create($eqpSat);
    }

    public function update($request, $id)
    {
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        return $this->repository->update($request, $id);

    }
    public function delete($id)
    {

        return $this->repository->update(['Active' => false], $id);

    }
}
