<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateSalesView extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement($this->dropView());
        DB::statement($this->createView());
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement($this->dropView());
    }

    private function createView()
    {
        return 'create view sales_list as
            select v.idVenda, v.idAbertura, c.stCliente, v.flAtivo, sum(v.vrTotal + v.vrAcrescimo - v.vrDesconto) as vrTotal, v.dtData, v.flNotaFiscal, g.idCaixa, o.stApelido from cx_Vendas v
            inner join dlv_Clientes c on v.idCliente = c.idCliente
            inner join cx_Gerenciador g on g.idAbertura = v.idAbertura
            inner join op_Operadores o on o.idOperador = g.idOperador
            group by v.idVenda, v.idAbertura, v.dtData, v.flNotaFiscal, c.stCliente, v.flAtivo, g.idCaixa,o.stApelido
            union
            select v.idVenda, v.idAbertura, c.stCliente, v.flAtivo,sum(v.vrTotal + v.vrAcrescimo - v.vrDesconto) as vrTotal, v.dtData, v.flNotaFiscal, g.idCaixa, o.stApelido from cx_Vendas_Temp v
            inner join dlv_Clientes c on v.idCliente = c.idCliente
            inner join cx_Gerenciador g on g.idAbertura = v.idAbertura
            inner join op_Operadores o on o.idOperador = g.idOperador
            group by v.idVenda, v.idAbertura, v.dtData, v.flNotaFiscal, c.stCliente, v.flAtivo, g.idCaixa,o.stApelido';
    }
    /**
     * Reverse the migrations.
     *
     * @return string
     */
    private function dropView()
    {
        return "if exists(select 1 from sys.views where name='sales_list' and type='v')
                drop view sales_list;";
    }
}
