<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class V6210 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('ncm');

        if (!Schema::hasTable('ncm')) {
            Schema::create('ncm', function (Blueprint $table) {
                $table->increments('id');
                $table->string('ncm', 9);
                $table->string('description', 255);
                $table->decimal('aliquota_federal')->default(0);
                $table->decimal('aliquota_estadual')->default(0);
                $table->decimal('aliquota_municipal')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ncm');
    }
}
