<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinChequesPagarTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_ChequesPagar')) {

            DB::statement('CREATE TABLE [dbo].[fin_ChequesPagar](
                  [idCheque] [int] NOT NULL,
                  [idContaBancaria] [smallint] NOT NULL,
                  [nrCheque] [decimal](18, 0) NOT NULL,
                  [vrCheque] [decimal](9, 2) NOT NULL,
                  [dtEmissao] [datetime] NOT NULL,
                  [dtDeposito] [datetime] NULL,
                  [dtCompensacao] [datetime] NOT NULL,
                  [stNomeContato] [nvarchar](20) NULL,
                  [nrTelefoneContato] [decimal](8, 0) NULL,
                  [stStatus] [nvarchar](1) NOT NULL,
                  [stObservacao] [nvarchar](255) NULL,
                  [stOperador] [nvarchar](20) NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL,
                  [idAlinea] [int] NOT NULL,
                  CONSTRAINT [PK_fin_ChequesPagar] PRIMARY KEY CLUSTERED
                    (
                      [idCheque] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_ChequesPagar');

    }
}
