<?php

namespace Database\Seeders;

use App\Entities\Nati\Ncm;
use App\Jobs\ProcessIbptTable;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class NcmsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('ncm')->truncate();

        $data = [
            ['ncm' => '1012100', 'description' => 'Cavalos reprodutores,de raca pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1012900', 'description' => 'Cavalos vivos,exceto reprodutores de raca pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1013000', 'description' => 'Asininos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1019000', 'description' => 'Outros asininos e muares,vivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1022110', 'description' => 'Bovinos reprodutores,de raca pura,prenhe ou com cria ao pe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1022190', 'description' => 'Outros bovinos reprodutores,de raca pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1022911', 'description' => 'Outros bovinos para reprodução, prenhe ou com cria ao pe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1022919', 'description' => 'Outros bovinos domésticos para reprodução', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1022990', 'description' => 'Outros bovinos domésticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1023110', 'description' => 'Búfalos reprodutores,de raca pura, prenhe ou com cria ao pe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1023190', 'description' => 'Outros búfalos reprodutores,de raca pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1023911', 'description' => 'Outros búfalos para reprodução, prenhe ou com cria ao pe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1023919', 'description' => 'Outros búfalos para reprodução', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1023990', 'description' => 'Outros búfalos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1029000', 'description' => 'Outros animais vivos da espécie bovina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1031000', 'description' => 'Suinos  reprodutores de raça pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1039100', 'description' => 'Outros suinos,vivos,de peso inferior a 50kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1039200', 'description' => 'Outros suinos,vivos,de peso igual ou superior a 50kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1041011', 'description' => 'Ovinos reprodutores,de raca pura,prenhe ou c/cria ao pe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1041019', 'description' => 'Outros ovinos,reprodutores,de raca pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1041090', 'description' => 'Outros ovinos,vivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1042010', 'description' => 'Caprinos reprodutores,de raca pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1042090', 'description' => 'Outros caprinos,vivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1051110', 'description' => 'Galos e galinhas,p<=185g,de linha pura/hibrida, p/reprod', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1051190', 'description' => 'Outros galos e galinhas,vivos,de peso n/superior a 185g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1051200', 'description' => 'Peruas e perus,vivos,de peso nao superior a 185g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1051300', 'description' => 'Patos vivos,de peso<=185g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1051400', 'description' => 'Gansos, vivos,de peso<=185g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1051500', 'description' => 'Galinhas dangola (pintadas),vivos,de peso<=185g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1059400', 'description' => 'Outros galos e galinhas,vivos de peso>185g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1059900', 'description' => 'Patos,gansos,perus,peruas,pintadas,vivos,de peso>185g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1061100', 'description' => 'Primatas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1061200', 'description' => 'Baleias, golfinhos e botos, peixes-boi e digongos, otárias e focas, leões-marinhos e morsas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1061300', 'description' => 'Camelos e outros camelídeos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1061400', 'description' => 'Coelhos e lebres', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1061900', 'description' => 'Outros animais mamíferos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1062000', 'description' => 'Répteis incluídas as serpentes e as tartarugas marinhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1063100', 'description' => 'Aves de rapina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1063200', 'description' => 'Psitaciformes (incluídos os papagaios, os periquitos, as araras e as cacatuas)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1063310', 'description' => 'Avestruzes para reprodução', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1063390', 'description' => 'Outros avestruzes, emus', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1063900', 'description' => 'Outras aves', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1064100', 'description' => 'Abelhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1064900', 'description' => 'Outro insetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '1069000', 'description' => 'Outros animais vivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2011000', 'description' => 'Carcacas e meias carcacas,de bovino,frescas ou refriger', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2012010', 'description' => 'Quartos dianteiros,de bovino,n/desossad. frescos/refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2012020', 'description' => 'Quartos traseiros,de bovino,n/desossados, frescos/refrig', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2012090', 'description' => 'Outs.carnes de bovino,nao desossadas, frescas ou refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2013000', 'description' => 'Carnes de bovino,desossadas,frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2021000', 'description' => 'Carcacas e meias-carcacas,de bovino, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2022010', 'description' => 'Quartos dianteiros,de bovino,nao desossados, congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2022020', 'description' => 'Quartos traseiros,de bovino,nao desossados, congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '2022090', 'description' => 'Outras carnes de bovino,nao desossadas, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2023000', 'description' => 'Carnes de bovino,desossadas,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2031100', 'description' => 'Carcacas e meias-carcacas,de suino,frescas ou refriger.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2031200', 'description' => 'Pernas,pas,etc.de suino,n/desossados,frescos ou refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2031900', 'description' => 'Outras carnes,de suino,frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2032100', 'description' => 'Carcacas e meias-carcacas,de suino, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2032200', 'description' => 'Pernas,pas e pedacos,de suinos,n/desossados, congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2032900', 'description' => 'Outras carnes,de suino,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2041000', 'description' => 'Carcacas e meias-carcacas,de cordeiro, frescas ou refrig', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2042100', 'description' => 'Carcacas e meias-carcacas,de ovino,frescas ou refriger.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2042200', 'description' => 'Outras carnes,de ovino,nao desossadas, ]frescas ou refrig', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2042300', 'description' => 'Carnes de ovino,desossadas,frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2043000', 'description' => 'Carcacas e meias-carcacas,de cordeiro, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2044100', 'description' => 'Carcacas e meias-carcacas,de ovino, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2044200', 'description' => 'Outras carnes de ovino,nao desossadas, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2044300', 'description' => 'Carnes de ovino,desossadas,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2045000', 'description' => 'Carnes de caprino,frescas,refrigeradas ou congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2050000', 'description' => 'Carnes de cavalo,asinino e muar,frescas, refrig.ou cong.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2061000', 'description' => 'Miudezas comestiveis,de bovino,frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2062100', 'description' => 'Linguas de bovino,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2062200', 'description' => 'Figados de bovino,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2062910', 'description' => 'Rabos de bovino,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2062990', 'description' => 'Outras miudezas comestiveis,de bovino, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2063000', 'description' => 'Miudezas comestiveis,de suino,frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2064100', 'description' => 'Figados de suino,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2064900', 'description' => 'Outras miudezas,comestiveis,de suino, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2068000', 'description' => 'Miudezas comestiveis,de ovino,etc. frescas/refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2069000', 'description' => 'Miudezas comestiveis,de ovino,caprino, etc.congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2071100', 'description' => 'Carnes de galos/galinhas,n/cort.pedacos, frescas/refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2071200', 'description' => 'Carnes de galos/galinhas,n/cortadas em pedacos,congel.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2071300', 'description' => 'Pedacos e miudezas,de galos/galinhas, frescos/refriger.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2071400', 'description' => 'Pedacos e miudezas,comest.de galos/galinhas, congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2072400', 'description' => 'Carnes de peruas/perus,n/cort.pedacos, frescas/refriger.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2072500', 'description' => 'Carnes de peruas/perus,n/cortadas em pedacos,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2072600', 'description' => 'Carnes de peruas/perus,em pedacos,miudez. frescos/refrig', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2072700', 'description' => 'Carnes de peruas/perus,em pedacos e miudezas,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2074100', 'description' => 'Carnes de patos, n/cort.em pedacos, frescas/refriger.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2074200', 'description' => 'Carnes de patos,gansos,etc.n/cort.em pedacos,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2074300', 'description' => 'Figados gordos,de patos (foie gras), frescos/refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2074400', 'description' => 'Outs.carnes/miudezas,de patos,frescas, refrig', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2074500', 'description' => 'Outs.carnes,miudezas,de patos, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2075100', 'description' => 'Carnes de gansos n/cort.em pedacos, frescas/refriger.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2075200', 'description' => 'Carnes de  gansos n/cort.em pedacos,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2075300', 'description' => 'Figados gordos,de gansos (foie gras), frescos/ refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2075400', 'description' => 'Outs.carnes/miudezas,de gansos, frescas, refrig', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2075500', 'description' => 'Outs.carnes,miudezas,de gansos, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2076000', 'description' => 'Carnes e miudezas comestíveis de galinhas dangola (pintadas), frescas/refriger/ congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2081000', 'description' => 'Carnes/miudezas,de coelhos/lebres,frescas/ refrig/congel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2083000', 'description' => 'Carnes e miudezas,de primatas,frescos/ refrig/congel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2084000', 'description' => 'Carnes e miudezas,de baleias,golfinhos e botos, peixes-boi e digongos, otárias e focas, leões-marinhos e morsas ,frescos/ refrig/ congel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2085000', 'description' => 'Carnes e miudezas,de répteis(incluidas as serpentes e as tartarugas marinhas), frescos/ refrig/congel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2086000', 'description' => 'Carnes e miudezas,de camelos e outros camelídeos, frescos/ refrig/congel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2089000', 'description' => 'Carnes e miudezas,de outs.animais,frescos/ refrig/congel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '2091011', 'description' => 'Toucinho de porco sem partes magras, fresco/ refrigerado/ congelado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2091019', 'description' => 'Toucinho sem partes magras,salgado/ salmoura/ seco/defum.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2091021', 'description' => 'Gordura de porco,fresca,refrigerada ou congelada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2091029', 'description' => 'Gordura de porco,n/fundida,salgada,em salmoura,seca,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2099000', 'description' => 'Gordura de aves,n/fundida,fresca, refrigerada,congel.etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2101100', 'description' => 'Pernas/pas/pedacos,de suino,n/desossados, salgados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2101200', 'description' => 'Barrigas e peitos,entremeados,de suino,salgados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2101900', 'description' => 'Outs.carnes de suino,salgadas ou em salmoura,secas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2102000', 'description' => 'Carnes de bovinos,salgadas/em salmoura/ secas/defumadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109100', 'description' => 'Carnes e miudezas,de primatas,salgados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109100', 'description' => 'Miudezas, farinhas e pós dessas miudezas de primatas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109200', 'description' => 'Carnes e miudezas,de baleias,golfinhos e botos, peixes-boi e digongos, otárias e focas, leões-marinhos e morsas,salgados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109200', 'description' => 'Miudezas, farinhas e pós dessas miudezas de baleias, golfinhos e botos  mamíferos da ordem dos cetáceos , de peixes-boi  manatins  e dugongos  mamíferos da ordem dos sirênios , de otárias e focas, leões-marinhos e morsas  mamíferos da subordem dos piníped', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109300', 'description' => 'Carnes e miudezas,de répteis(incluidas as serpentes e as tartarugas marinhas), salgados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109300', 'description' => 'Miudezas, farinhas e pós dessas miudezas de répteis  incluindo as serpentes e as tartarugas marinhas ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109911', 'description' => 'De galos e de galinhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109919', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109920', 'description' => 'Carnes da espécie ovina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109930', 'description' => 'Carnes da espécie cavalar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109940', 'description' => 'Miudezas comestíveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109990', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '2109990', 'description' => 'Farinhas e pós das miudezas do código 0210.99.40', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '3011110', 'description' => 'Aruanã (peixe ornamental)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3011190', 'description' => 'Outros peixes ornamentais, vivos,  de água doce', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3011900', 'description' => 'Outros peixes ornamentais vivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019110', 'description' => 'Trutas (salmo trutta e oncorhynchus),para reproducao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019190', 'description' => 'Outros trutas (salmo trutta e oncorhynchus),vivas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019210', 'description' => 'Enguias (anguilla spp.) para reproducao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019290', 'description' => 'Outros enguias (anguilla spp.) vivas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019310', 'description' => 'Carpas para reproducao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019390', 'description' => 'Outros carpas vivas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019410', 'description' => 'Atuns-azuis (thunnus thynnus, thunnus orientalis) para reprodução', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019490', 'description' => 'Outros atuns-azuis (thunnus thynnus, thunnus orientalis)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019510', 'description' => 'Atuns-do-sul (thunnus maccoyii) para reprodução', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019590', 'description' => 'Outros  atuns-do-sul (thunnus maccoyii)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019911', 'description' => 'Tilapias,peixes para reproducao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019912', 'description' => 'Esturjões,peixes para reproducao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019919', 'description' => 'Outros peixes vivos para reprodução', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019991', 'description' => 'Tilapias,peixes vivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019992', 'description' => 'Esturjões,peixes vivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3019999', 'description' => 'Outros peixes vivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3021100', 'description' => 'Trutas frescas,refrig.exc.files,outs. carnes, figados,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3021300', 'description' => 'Salmoes-do-pacifico, frescos,refrig. exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3021400', 'description' => 'Salmoes-do-atlantico, frescos,refrig. exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3021900', 'description' => 'Outros salmonideos frescos,refrig.exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3022100', 'description' => 'Linguados-gigantes,frescos,refrig.exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3022200', 'description' => 'Solhas ou patrucas,frescas,refrig.exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3022300', 'description' => 'Linguados frescos,refrig.exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3022400', 'description' => 'Pregado (psetta maxima),frescos,refrig.exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3022900', 'description' => 'Outros peixes chatos,frescos,refrig.exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3023100', 'description' => 'Atuns-brancos ou germoes,frescos/refriger. exc.files,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3023200', 'description' => 'Albacoras/atuns barbat.amarela,frescas/ refrig. exc.files', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3023300', 'description' => 'Bonitos-listrados,etc.frescos,refrig.exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '3023400', 'description' => 'Albacoras-bandolim (patutos) thunnus thinnus', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3023500', 'description' => 'Atuns azuis (thunnus thinnus (…)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3023600', 'description' => 'Atuns do sul thunnus maccoyii', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3023900', 'description' => 'Outs.atuns frescos,refrig.exc.files, outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024100', 'description' => 'Arenques frescos/refrigerados,exc. files,outs.carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024210', 'description' => 'Anchoitas frescos/refrigerados,exc. files,outs.carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024290', 'description' => 'Outras anchovas frescos/refrigerados,exc. files,outs.carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024300', 'description' => 'Sardinhas frescos/refrigerados,exc. files,outs.carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024400', 'description' => 'Cavalinhas frescos/refrigerados,exc. files,outs.carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024500', 'description' => 'Chicharros frescos/refrigerados,exc. files,outs.carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024600', 'description' => 'Bijupirás frescos/refrigerados,exc. files,outs.carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024700', 'description' => 'Espadartes frescos/refrigerados,exc. files,outs.carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024910', 'description' => 'Espadins, marlins, veleiros (Istiophoridae)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3024990', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3025100', 'description' => 'Bacalhau do atlantico (...), bacalhau da groelandia (…) e bacalhau do pacífico (...), frescos/refrigerados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3025200', 'description' => 'Bacalhau haddoch ou lubina, frescos/refrigerados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3025300', 'description' => 'Bacalhau saithe frescos/refrigerados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3025400', 'description' => 'Merluzas e abróteas, frescos/refrigerados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3025500', 'description' => 'Merluza do alasca, frescos/refrigerados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3025600', 'description' => 'Verdinhos (…), frescos/refrigerados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3025900', 'description' => 'Outros peixes das fam. bregmacerotidae, gadidae, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3027100', 'description' => 'Tilápias frescas,refrig.exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3027210', 'description' => 'Bagres (...),frescas,refrig.exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3027290', 'description' => 'Outros bagres, frescas,refrig.exc.files, outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3027300', 'description' => 'Carpas,frescas,refrig.exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3027400', 'description' => 'Enguias, frescas,refrig.exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3027900', 'description' => 'Outros,frescas,refrig.exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028100', 'description' => 'Esqualos frescos,refrig.exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028200', 'description' => 'Raias, frescos,refrig.exc.files, outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028310', 'description' => 'Merluzas-negras (dissostichus eleginoides)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028320', 'description' => 'Merluzas antárticas (dissostichus mawsoni)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028400', 'description' => 'Robalos, frescos,refrig.exc.files, outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028500', 'description' => 'Pargos ou sargos, frescos,refrig.exc.files, outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028910', 'description' => 'Pargo (Lutjanus purpureus)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028921', 'description' => 'Cherne-poveiro (polyprion americanus), frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028922', 'description' => 'Garoupas (acanthistius spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028923', 'description' => 'Esturjões (ascipenser baeri)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028924', 'description' => 'Peixes-rei (atherindae spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028931', 'description' => 'Curimatas (prochilodus spp.), fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028932', 'description' => 'Tilapias, fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028933', 'description' => 'Surubins (pseudoplatystoma spp.), fres. ou refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028934', 'description' => 'Traíras (hoplias malabaricus & h. cf. lacerdae)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028935', 'description' => 'Piaus (leporinus spp.), fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028936', 'description' => 'Tainhas, fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028937', 'description' => 'Pirarucu (arapaima gigas), fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028938', 'description' => 'Pescadas, fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028941', 'description' => 'Piramutabas, fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028942', 'description' => 'Douradas, fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028943', 'description' => 'Pacus, fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028944', 'description' => 'Tambaquis, fresco ou refrigerado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028945', 'description' => 'Tambacu fresco ou resfriado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3028990', 'description' => 'Outs.peixes frescos,refrig.exc.files, outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3029100', 'description' => 'Fígados, ovas e gônadas masculinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '3029200', 'description' => 'Barbatanas de tubarão', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3029900', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3031100', 'description' => 'Salmoesvermelhos,congelados,exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3031200', 'description' => 'Oiutros salmoes do pacífico ,congelados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3031300', 'description' => 'Salmoes-do-atlantico e danubio,congelados, exc.files,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3031400', 'description' => 'Trutas (salmo trutta,etc.) congeladas, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3031900', 'description' => 'Outs.salmonideos congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3032300', 'description' => 'Tilapias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3032410', 'description' => 'Bagres congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3032490', 'description' => 'Outros bagres congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3032500', 'description' => 'Carpas congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3032600', 'description' => 'Enguias congeladas,exc.files,outs.carnes, figados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3032900', 'description' => 'Outros tilapias, bagres, perca-do-nilo (...), congeladas,exc.files,outs.carnes, figados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3033100', 'description' => 'Linguados-gigantes congelados,exc.files. outs. carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3033200', 'description' => 'Solhas ou patrucas,congeladas,exc.files, outs. carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3033300', 'description' => 'Linguados congelados,exc.files,outs.carnes, figados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3033400', 'description' => 'Pregados,congelados,exc.files, outs. carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3033900', 'description' => 'Outs.peixes chatos,congelados,exc.files, outs. carnes,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3034100', 'description' => 'Albacoras brancas,congelados, exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3034200', 'description' => 'Albacoras/laje,congeladas, exc.files,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3034300', 'description' => 'Bonitos-listrados,etc.congelados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3034400', 'description' => 'Albacoras-bandolin (patudos) congelados, exc.files, outs. carnes,figados,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3034500', 'description' => 'Atuns-azuis (...), congelados,exc.files, outs.carnes, figados,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3034600', 'description' => 'Atuns do sul congelados,exc.files, outs. carnes,figados,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3034900', 'description' => 'Outs.atuns congelados,exc.files,outs. carnes, figados,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035100', 'description' => 'Arenques congelados,exc.files,outs. carnes, figados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035300', 'description' => 'Sardinhas, (…) anchovetas, congeladas, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035400', 'description' => 'Cavalinhas,congeladas, exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035500', 'description' => 'Chicharros,congeladas, exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035600', 'description' => 'Bijupirás,congeladas, exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035700', 'description' => 'Espadartes congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035910', 'description' => 'Espadins, marlins, veleiros (Istiophoridae)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035920', 'description' => 'Anchoita (Engraulis anchoita)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3035990', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3036300', 'description' => 'Bacalhau do atlantico,bacalhau da groelandia (...), congelados,exc.files, outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3036400', 'description' => 'Haddocks congelados,exc.files,outs. carnes, figados,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3036500', 'description' => 'Saithe congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3036600', 'description' => 'Merluzas e abroteas,congeladas, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3036700', 'description' => 'Merluzas do alasca,congeladas, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3036800', 'description' => 'Verdinhos,congelados, exc.files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3036910', 'description' => 'Merluzas rosadas congelados,exc.files,outs. carnes, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3036990', 'description' => 'Outros peixes das famílias bregmacerotidae (...), congelados,exc.files,outs. carnes, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038111', 'description' => 'Tubaroes-azuis inteiros,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038112', 'description' => 'Tubaroes-azuis, congelad.eviscerad. s/cabeca, s/barbatana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038113', 'description' => 'Tubaroes-azuis,congelados,em pedacos, com pele', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038114', 'description' => 'Tubaroes-azuis,congelados,em pedacos, sem pele', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038119', 'description' => 'Outros  tubaroes-azuis congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038190', 'description' => 'Outs.peixes esqualos,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038200', 'description' => 'Raias,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038311', 'description' => 'Merluzas negras congelados,exc.files, outs. carnes, etc. evisceradas, sem cabeça e sem cauda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038319', 'description' => 'Outras merluzas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038321', 'description' => 'Meluzas do antartico evisceradas, sem cabeça e sem cauda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038329', 'description' => 'Outras merluzas do antartico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '3038400', 'description' => 'Robalos congeladas,exc. files,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038910', 'description' => 'Corvinas congeladas,exc.files,outs.carnes, figados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038920', 'description' => 'Pescadas congeladas,exc.files,outs.carnes, figados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038932', 'description' => 'Pargos congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038933', 'description' => 'Peixes-sapo congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038941', 'description' => 'Chernes-poveiro congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038942', 'description' => 'Garoupas congelados,exc.files,outs. carnes, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038943', 'description' => 'Tainhas congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038944', 'description' => 'Esturjões congelados,exc.files,outs. carnes, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038945', 'description' => 'Peixes-rei congelados,exc.files,outs. carnes, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038946', 'description' => 'Nototenias congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038951', 'description' => 'Curimatãs congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038952', 'description' => 'Tilapias congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038953', 'description' => 'Surubins congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038954', 'description' => 'Trairas congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038955', 'description' => 'Piaus congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038956', 'description' => 'Pirarucus congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038961', 'description' => 'Piramutabas congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038962', 'description' => 'Douradas congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038963', 'description' => 'Pacus congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038964', 'description' => 'Tambaquis congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038965', 'description' => 'Tambacus congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3038990', 'description' => 'Outs.peixes congelados,exc.files,outs. carnes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3039100', 'description' => 'Fígados, ovas e gônadas masculinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3039200', 'description' => 'Barbatanas de tubarão', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3039910', 'description' => 'Cabeças de Merluza negra (Dissostichus eleginoides)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3039920', 'description' => 'Cabeças de Merluza antártica (Dissostichus mawsoni)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3039990', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3043100', 'description' => 'Files de tilapias,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3043210', 'description' => 'Files de bagres,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3043290', 'description' => 'Files de outros bagres,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3043300', 'description' => 'Files de perca-do-nilo,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3043900', 'description' => 'Outros files,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044100', 'description' => 'Files e outs.carnes de salmões do pacífico,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044200', 'description' => 'Files e outs.carnes de trutas,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044300', 'description' => 'Files e outs.carnes de peixes chatos,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044400', 'description' => 'Files e outs.carnes de peixes da família  das bregmacerotidae,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044500', 'description' => 'Files e outs.carnes de espadarte,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044600', 'description' => 'Files e outs.carnes de merluza-negra e merluza-antártica,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044700', 'description' => 'Cação e Outros tubarões', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044800', 'description' => 'Raias (rajidae)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044910', 'description' => 'Files e outs.carnes de cherne-poveiro, frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044920', 'description' => 'Files e outs.carnes de garoupa,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3044990', 'description' => 'Files e outs.carnes de outros peixes,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3045100', 'description' => 'Files e outs.carnes de tilápias,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3045200', 'description' => 'Files e outs.carnes de salmonídeos,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3045300', 'description' => 'Files e outs.carnes de peixes da família  das bregmacerotidae,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3045400', 'description' => 'Files e outs.carnes de espadarte,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3045500', 'description' => 'Files e outs.carnes de merluza-negra e merluza-antártica,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3045600', 'description' => 'Cacao e outros tubaroes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3045700', 'description' => 'Raias (rajidae)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3045900', 'description' => 'Files e outs.carnes de peixes,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3046100', 'description' => 'Files de tilápias,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '3046210', 'description' => 'Files de bagre,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3046290', 'description' => 'Files de outros bagres,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3046300', 'description' => 'Files de perca-do-nilo,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3046900', 'description' => 'Files de outras tilápias,congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3047100', 'description' => 'Bacalhau do atlantico,bacalhau da groelandia (...), files congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3047200', 'description' => 'Haddocks,  files  congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3047300', 'description' => 'Saithe, files  congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3047400', 'description' => 'Merluzas e abroteas,  files congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3047500', 'description' => 'Merluzas do alasca,  files,  congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3047900', 'description' => 'Outros peixes das famílias bregmacerotidae (...),  files, congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048100', 'description' => 'Salmões do pacífico (...),  files, congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048200', 'description' => 'Trutas,  files, congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048300', 'description' => 'Peixes chatos,  files congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048400', 'description' => 'Espadarte,  files congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048510', 'description' => 'Merluza negra,  files congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048520', 'description' => 'Merluza antártica,  files congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048600', 'description' => 'Arenques,  files, congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048700', 'description' => 'Atuns (...), bonito listrado (...),  files, congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048810', 'description' => 'Tubarao azul (prionace glauca)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048890', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048910', 'description' => 'Pargo, files congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048920', 'description' => 'Cherne-poveiro,  files, congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048930', 'description' => 'Garoupas,  files, congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3048990', 'description' => 'Files de outros peixes, congelados.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049100', 'description' => 'Outros carnes de espadartes,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049211', 'description' => 'Outros carnes de merluzas negras, congeladas – bochechas (cheeks)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049212', 'description' => 'Outros carnes de merluzas negras, congeladas – colares (collars)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049219', 'description' => 'Outros carnes de merluzas negras,congeladas – outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049221', 'description' => 'Outros carnes de merluzas do antártico ,congeladas – bochechas (cheeks)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049222', 'description' => 'Outros carnes de merluzas do antartico,congeladas – colares (collars)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049229', 'description' => 'Outros carnes de merluzas doantartico,congeladas – outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049300', 'description' => 'Outros carnes de tilápias,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049400', 'description' => 'Outros carnes de merluza do alasca,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049500', 'description' => 'Outros carnes de peixes da família das bregmacerotidae (...), congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049600', 'description' => 'Cacao e outros tubaroes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049700', 'description' => 'Raias (rajidae)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3049900', 'description' => 'Outros carnes de peixes,congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3051000', 'description' => 'Farinhas,pos e pellets de peixes, próprios p/ alimentacao  humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3052000', 'description' => 'Figados,ovas e semen,de peixes,secos, defumados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3053100', 'description' => 'Tilápias (...),secos, salgados/ salmoura, n/defum', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3053210', 'description' => 'Bacalhaus do atlantico, bacalhau da groelândia (…), secos, salgados/ salmoura, n/defum', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3053220', 'description' => 'Saithes(polachius virens), secos, salgados/ salmoura, n/defum', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3053230', 'description' => 'Ling (molva molva) e zarbo (brosme brosme)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3053290', 'description' => 'Outros peixes da família das bregmacerotidae (...), secos, salgados/ salmoura,n/defum', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3053900', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3054100', 'description' => 'Salmoes-do-pacifico,do atlantico e do danubio, defumados, mesmo em filés', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3054200', 'description' => 'Arenques defumados,mesmo em files', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3054300', 'description' => 'Trutas defumadas,mesmo em files', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3054400', 'description' => 'Tilápias defumadas,mesmo em files', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3054910', 'description' => 'Bacalhaus (gadus) defumados,mesmo em files', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3054920', 'description' => 'Saithes (pollachius virens), lings (molva molva) e zarbos (brosme brosme)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3054990', 'description' => 'Outros peixes defumados,mesmo em files', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3055100', 'description' => 'Bacalhaus (gadus) secos,mesmo salgados mas n/defumados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '3055200', 'description' => 'Tilapias (oreochromis spp), bagres (peixes gato*) (pangasius spp, silurus spp, clarias spp, ictalurus spp), carpas (cyprinus spp, carassius spp, ctenopharyngodon idellus, hypophthalmichthys spp, cirrhinus spp, mylopharyngodon piceus, catla catla, labeo sp', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3055310', 'description' => 'Bacalhau polar (boreogadus saida), saithe (pollachius virens), ling (molva molva), ling azul (molva dypterygia), zarbo (brosme brosme), abrotea do alto (urophycis blennoides) e haddock ou lubina (melanogrammus aeglefinus)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3055390', 'description' => 'Outros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3055400', 'description' => 'Arenques (clupea harengus, clupea pallasii), anchovas (biqueiroes*) (engraulis spp), sardinhas (sardina pilchardus, sardinops spp, sardinella spp) (sardinha (sardina pilchardus) e sardinelas (sardinops spp, sardinella spp)*), anchoveta (espadilha*) (sprat', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3055900', 'description' => 'Outros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3056100', 'description' => 'Arenques salgados,nao secos,nao defumados e em salmoura', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3056200', 'description' => 'Bacalhaus (gadus) salgados,n/secos, n/defumados,salmoura', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3056300', 'description' => 'Anchovas salgadas,nao secas,nao defumadas e em salmoura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3056400', 'description' => 'Tilápias, bagres, carpas (…) salgados n/secos, n/defum e em salmoura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3056910', 'description' => 'Saithes(polachius virens),lings e zarbos(brosme brosme)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3056990', 'description' => 'Outros peixes salgados n/secos, n/defum e em salmoura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3057100', 'description' => 'Barbatanas de tubarão', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3057100', 'description' => 'Barbatanas de tubarão seco, mesmo salgado mas nao defumado', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3057200', 'description' => 'Cabeças, caudas, bexigas, natatórias, de peixes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3057200', 'description' => 'Cabeças, caudas, bexigas, natatórias, de peixes defumados, mesmo em filés, exceto dos códigos 0305.41.00, 0305.42.00 e 0305.49.10', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3057200', 'description' => 'Cabeças, caudas, bexigas, natatórias, de peixes salgados, não secos nem defumados e peixes em salmoura, exceto dos códigos 0305.61.00 e 0305.62.00', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3057900', 'description' => 'Outros desperdícios comestíveis de peixes secos,mesmo salgados mas nao defumados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3057900', 'description' => 'Outros desperdícios comestíveis de peixes defumados, mesmo em filés, exceto dos códigos 0305.41.00, 0305.42.00 e 0305.49.10', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3057900', 'description' => 'Outros desperdícios comestíveis de peixes salgados, não secos nem defumados e peixes em salmoura, exceto dos códigos 0305.61.00 e 0305.62.00', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061110', 'description' => 'Lagostas inteiras(palinurus,panulirus e jasus) congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061190', 'description' => 'Outras lagostas (palinurus,panulirus e jasus) congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061200', 'description' => 'Lavagantes (homards)(homarus spp) congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061400', 'description' => 'Caranguejos congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061500', 'description' => 'Lagostas norueguesas congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061610', 'description' => 'Camaroes de água fria inteiros congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061690', 'description' => 'Outros camaroes de água fria congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061710', 'description' => 'Outros camaroes inteiro congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061790', 'description' => 'Outros camaroescongelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061910', 'description' => 'Camaroes krillcongelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3061990', 'description' => 'Outs.crustaceos congel.incl.farinhas,etc. p/alim.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3063100', 'description' => 'Lagostas (palinurus spp, panulirus spp, jasus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3063200', 'description' => 'Lavagantes (homarus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3063300', 'description' => 'Caranguejos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3063400', 'description' => 'Lagosta norueguesa (lagostim*) (nephrops norvegicus)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3063500', 'description' => 'Camaroes de agua fria (pandalus spp, crangon crangon)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3063600', 'description' => 'Outros camaroes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3063910', 'description' => 'Lagosta de agua doce (cherax quadricarinatus)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3063990', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3069100', 'description' => 'Lagostas (palinurus spp, panulirus spp, jasus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3069200', 'description' => 'Lavagantes (homarus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3069300', 'description' => 'Caranguejos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3069400', 'description' => 'Lagosta norueguesa (lagostim*) (nephrops norvegicus)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3069500', 'description' => 'Camaroes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3069910', 'description' => 'Lagosta de agua doce (cherax quadricarinatus)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3069990', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3071100', 'description' => 'Ostras vivas,frescas,refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3071200', 'description' => 'Congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3071900', 'description' => 'Ostras congeladas,secas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3072100', 'description' => 'Vieiras,outs.mariscos (pecten,etc) vivos, frescos,refrig', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3072200', 'description' => 'Congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3072900', 'description' => 'Vieiras,outs.mariscos (pecten,etc) congelados,secos,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3073100', 'description' => 'Mexilhoes (mytilus,perna) vivos,frescos, refrigeraos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3073200', 'description' => 'Congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '3073900', 'description' => 'Mexilhoes (mytilus,perna) congelados,secos, algados,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3074200', 'description' => 'Vivas, frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3074310', 'description' => 'Lulas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3074320', 'description' => 'Sepias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3074900', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3075100', 'description' => 'Polvos (octopus spp) vivos,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3075200', 'description' => 'Congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3075900', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3076000', 'description' => 'Caracois,exceto.os do mar,vivos,frescos, refrigerados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3077100', 'description' => 'Ameijoas, berbigões e arcas (...),vivos, frescos, refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3077200', 'description' => 'Congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3077900', 'description' => 'Ameijoas, berbigões e arcas (...), congelados,secos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3078100', 'description' => 'Abalones,vivos,frescos,refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3078200', 'description' => 'Estrombos (strombus spp) vivos, frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3078300', 'description' => 'Abalones (orelhas do mar*) (haliotis spp) congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3078400', 'description' => 'Estrombos (strombus spp) congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3078700', 'description' => 'Outros abalones (outras orelhas do mar*) (haliotis spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3078800', 'description' => 'Outros estrombos (strombus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3079100', 'description' => 'Outs.moluscos,invertebr.aquaticos,vivos, frescos ,refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3079200', 'description' => 'Congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3079900', 'description' => 'Outs.moluscos,invertebr.aquaticos,congelados,secos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3081100', 'description' => 'Pepinos-do-mar, vivos, frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3081200', 'description' => 'Congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3081900', 'description' => 'Pepinos-do-mar,congelados,secos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3082100', 'description' => 'Ouriços-do-mar, vivos, frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3082200', 'description' => 'Congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3082900', 'description' => 'Ouriços do mar,congelados,secos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3083000', 'description' => 'Medusas (águas vivas) (…)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '3089000', 'description' => 'Outros inveetebrados aquáticos, exceto crustáceos e moluscos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4011010', 'description' => 'Leite uht,cont.materia gorda<=1%,nao concentrado,n/adoc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4011090', 'description' => 'Outs.leites e cremes,mater.gorda <=1%, n/concentr.n/adoc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4012010', 'description' => 'Leite uht,1%<materia gorda<=6%,nao  concentrado,n/adoc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4012090', 'description' => 'Outs.leites e cremes,1%<mat.gorda<=6%,n/ concentr.n/adoc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4014010', 'description' => 'Leite cont.materia gorda >6%, mas não superior a 10%, não concentrado, n/adocicado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4014021', 'description' => 'Creme de leite,uht,materia gorda>6% mas não superior a 10%, não concentr.n/adoc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4014021', 'description' => 'Creme de leite,uht,materia gorda>6% mas não superior a 10%, não concentr.n/adoc, acondicionado em recipiente metálico hermeticamente fechado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4014029', 'description' => 'Outs.cremes de leite,materia gorda>6% mas não superior a 10%, n/concentr.n/adoc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4014029', 'description' => 'Outs.cremes de leite,materia gorda>6% mas não superior a 10%, n/concentr.n/adoc, acondicionados em recipiente metálico hermeticamente fechado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4015010', 'description' => 'Leite cont.materia gorda>10%,nao concentrado, n/adocicado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4015021', 'description' => 'Creme de leite,uht,materia gorda>10%,nao concentr.n/adoc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4015021', 'description' => 'Creme de leite,uht,materia gorda>10%,nao concentr.n/adoc, acondicionado em recipiente metálico hermeticamente fechado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4015029', 'description' => 'Outs.cremes de leite,materia gorda>10%, n/concentr.n/adoc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4015029', 'description' => 'Outs.cremes de leite,materia gorda>10%, n/concentr.n/adoc, acondicionados em recipiente metálico hermeticamente fechado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4021010', 'description' => 'Leite em po,mat.gorda<=1,5%,arsenio<5ppm, concentr.adoc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4021090', 'description' => 'Outs.leites,cremes,em po,mat.gorda<=1,5%, concentr.adoc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4022110', 'description' => 'Leite integral,em po,materia gorda>1.5%, concentr.n/adoc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4022120', 'description' => 'Leite parc.desnat.em po,mat.gorda>1.5%, concentr.n/adoc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4022130', 'description' => 'Creme de leite,em po,materia gorda>1.5%, concentr.n/adoc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4022910', 'description' => 'Leite integral,em po,etc.materia gorda>1.5%, adocicado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4022920', 'description' => 'Leite parcialm.desnatado,em po,materia gorda>1.5%,adoc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4022930', 'description' => 'Creme de leite,em po,etc.materia gorda>1.5%, adocicado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4029100', 'description' => 'Outs.leites,cremes de leite,concentrados, n/adocicados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4029100', 'description' => 'Outs.leites,cremes de leite,concentrados, n/adocicados, em estado líquido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '4029900', 'description' => 'Outs.leites,cremes de leite,concentrados, adocicados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4029900', 'description' => 'Outs.leites,cremes de leite,concentrados, adocicados, em estado líquido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4031000', 'description' => 'Iogurte', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4031000', 'description' => 'Iogurte, acondicionado em embalagem de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4039000', 'description' => 'Leitelho,leite,creme de leite,coalhados, fermentados,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4039000', 'description' => 'Leitelho,leite,creme de leite,coalhados, fermentados,etc, acondicionados em embalagem de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4041000', 'description' => 'Soro de leite,modificado ou nao,mesmo concentrado,adoc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4041000', 'description' => 'Soro de leite,modificado ou nao,mesmo concentrado,adoc., em estado pastoso ou sólido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4049000', 'description' => 'Outs.prods.constituidos do leite,mesmo adocicados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4049000', 'description' => 'Outs.prods.constituidos do leite,mesmo adocicados,etc., em estado pastoso ou sólido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4051000', 'description' => 'Manteiga', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4052000', 'description' => 'Pastas de espalhar (barrar) de prods. proven. do leite', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4059010', 'description' => 'Oleo butirico de manteiga (butter oil)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4059090', 'description' => 'Outros materias gordas provenientes do leite', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4061010', 'description' => 'Queijo tipo mussarela,fresco (nao curado)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4061090', 'description' => 'Outs.queijos frescos (nao curados),incl. requeijao,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4062000', 'description' => 'Queijos ralados ou em po,de qualquer tipo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4063000', 'description' => 'Queijos fundidos,exceto ralados ou em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4064000', 'description' => 'Queijos de pasta mofada (azul)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4069010', 'description' => 'Queijos cont.teor de umidade<36%,em peso (massa dura)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4069020', 'description' => 'Queijos cont.36%<=teor de umidade<46%,(massa semidura)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4069030', 'description' => 'Queijos cont.46%<=teor de umidade<55%,(massa macia)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4069090', 'description' => 'Outros queijos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4071100', 'description' => 'Ovos de galinha,para incubacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4071900', 'description' => 'Ovos de outs.aves,para incubacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4072100', 'description' => 'Outs.ovos de aves,com casca,frescos, aves da espécie gallus domesticus', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4072900', 'description' => 'Outs.ovos de aves,com casca,frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4079000', 'description' => 'Outs.ovos de aves,com casca,conservados,cozidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4081100', 'description' => 'Gemas de ovos,secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4081900', 'description' => 'Outras gemas de ovos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4081900', 'description' => 'Outras gemas de ovos, frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4089100', 'description' => 'Ovos de aves,sem casca,secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4089900', 'description' => 'Outs.ovos de aves,sem casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4089900', 'description' => 'Outs.ovos de aves,sem casca, frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4090000', 'description' => 'Mel natural', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4090000', 'description' => 'Mel natural, acondicionado em embalagem de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '4100000', 'description' => 'Outros produtos comestiveis de origem animal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5010000', 'description' => 'Cabelos em bruto e desperdicios de cabelo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5021011', 'description' => 'Cerdas de porco,lavadas,alvejadas ou desengorduradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5021019', 'description' => 'Outros cerdas de porco e seus desperdicios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5021090', 'description' => 'Cerdas de javali e seus desperdicios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5029010', 'description' => 'Pelos de texugo e outs.pelos p/escovas, pinceis,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5029020', 'description' => 'Desperdicios de pelos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5040011', 'description' => 'Tripas de bovinos,frescas,refrig.congel. salg.defumadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5040012', 'description' => 'Tripas de ovinos,frescas,refrig.congel. salgad.defumadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5040013', 'description' => 'Tripas de suinos,frescas,refrig.congel. salgad.defumadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5040019', 'description' => 'Tripas de outs.animais,exc.peixes,frescas, refrig.etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5040090', 'description' => 'Bexigas e estomagos,de animais,exc.peixes, frescas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5051000', 'description' => 'Penas para enchimento ou estofamento,e penugem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5059000', 'description' => 'Peles e outs.partes de aves,com suas penas, penugem,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5061000', 'description' => 'Osseina e ossos acidulados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5069000', 'description' => 'Outs.ossos e nucleos corneos,em bruto, desengord.etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5071000', 'description' => 'Marfim,seus pos e desperdicios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '5079000', 'description' => 'Carapacas de tartarugas,chifres,galhadas, cascos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5080000', 'description' => 'Coral,conchas,carapacas de moluscos,etc.em bruto,prepar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5100010', 'description' => 'Pancreas de bovinos,p/prepar.prod. farmaceut.frescas,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5100090', 'description' => 'Outs.substancias de animais,p/prepar.prods. farmaceuts.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5111000', 'description' => 'Semen de bovino', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5119110', 'description' => 'Ovas de peixes,fecundadas para reproducao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5119190', 'description' => 'Outs.prods.de peixes,etc.improprios p/aliment.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5119910', 'description' => 'Embrioes de animais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5119920', 'description' => 'Semen animal (exceto bovino)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5119930', 'description' => 'Ovos de bicho-da-seda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5119991', 'description' => 'Crinas e seus desperdícios, mesmo em mantas, com ou sem suportes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '5119999', 'description' => 'Outs.prods.de animais,improprios p/alimentacao humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6011000', 'description' => 'Bulbos,tuberculos,rizomas,etc.em repouso vegetativo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6012000', 'description' => 'Bulbos,tuberculos,etc.em veget.em flor,muda de chicoria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6021000', 'description' => 'Estacas nao enraizadas e enxertos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6022000', 'description' => 'Arvores,arbustos e silvados,de frutos comestiveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6023000', 'description' => 'Rododendros e azaleias,enxertados ou nao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6024000', 'description' => 'Roseiras,enxertadas ou nao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6029010', 'description' => 'Micelios de cogumelos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6029021', 'description' => 'Mudas de orquideas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6029029', 'description' => 'Mudas de outs.plantas ornamentais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6029081', 'description' => 'Mudas de cana-de-acucar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6029082', 'description' => 'Mudas de videira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6029083', 'description' => 'Mudas de cafe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6029089', 'description' => 'Mudas de outs.plantas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6029090', 'description' => 'Outros plantas vivas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6031100', 'description' => 'Rosas e seus botoes,frescos,cortados p/buques,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6031200', 'description' => 'Cravos e seus botoes,frescos,cortados p/buques,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6031300', 'description' => 'Orquideas e seus botoes,frescos,cortados p/buques,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6031400', 'description' => 'Crisântemos e seus botoes,frescos,cortados p/buques,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6031500', 'description' => 'Lírios e seus botoes,frescos,cortados p/buques,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6031900', 'description' => 'Outs flores e seus botoes,frescos,cortados p/buques,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6039000', 'description' => 'Flores e seus botoes,secos,etc.cortados p/buques,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6042000', 'description' => 'Folhagem, folhas, ramos e outras partes de plantas, sem flores nem botões de flores, e ervas, musgos e líquenes, para buquês ou para ornamentação, frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '6049000', 'description' => 'Folhagem, folhas, ramos e outras partes de plantas, sem flores nem botões de flores, e ervas, musgos e líquenes, para buquês ou para ornamentação, secos, branqueados, tingidos, impregnados ou preparados de outro modo.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7011000', 'description' => 'Batatas para semeadura (batata semente)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7019000', 'description' => 'Outros batatas frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7020000', 'description' => 'Tomates,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7031011', 'description' => 'Cebolas para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7031019', 'description' => 'Outros cebolas frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7031021', 'description' => 'Echalotes para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7031029', 'description' => 'Outros echalotes frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7032010', 'description' => 'Alho para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7032090', 'description' => 'Outros alhos frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7039010', 'description' => 'Alho-porro e outs.prods.horticolas aliaceos,p/semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7039090', 'description' => 'Outs.alhos-porros,prods.horticolas aliaceos,frescos,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7041000', 'description' => 'Couve-flor e brocolos,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7042000', 'description' => 'Couve-de-bruxelas,fresca ou refrigerada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7049000', 'description' => 'Couves,repolho,etc.do genero brassica, frescos,refrig.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7051100', 'description' => 'Alfaces repolhudas,frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7051900', 'description' => 'Outros alfaces frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7052100', 'description' => 'Chicorias witloof,frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7052900', 'description' => 'Outros chicorias,frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '7061000', 'description' => 'Cenouras e nabos,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7069000', 'description' => 'Beterrabas,rabanetes e outs.raizes,frescas, refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7070000', 'description' => 'Pepinos e pepininhos cornichons,frescos, refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7081000', 'description' => 'Ervilhas (pisum sativum),frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7082000', 'description' => 'Feijoes (vigna,phaseolus spp) frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7089000', 'description' => 'Outros legumes de vagem,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7092000', 'description' => 'Aspargos frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7093000', 'description' => 'Berinjelas frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7094000', 'description' => 'Aipo fresco ou refrigerado,exc.aipo-rabano', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7095100', 'description' => 'Cogumelos frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7095900', 'description' => 'Outros cogumelos frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7096000', 'description' => 'Pimentoes e pimentas,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7097000', 'description' => 'Espinafres frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7099100', 'description' => 'Alcachofras frescas ou refrigeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7099200', 'description' => 'Azeitonas,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7099300', 'description' => 'Abóboras, abobrinhas e cabaças (curcubita spp.)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7099911', 'description' => 'Milho doce,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7099919', 'description' => 'Milho doce,fresco ou refrig.exc.p/semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7099990', 'description' => 'Outros produtos horticolas,frescos ou refrigerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7101000', 'description' => 'Batatas congeladas,nao cozidas ou cozidas em agua/vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7102100', 'description' => 'Ervilhas congeladas,nao cozidas/cozidas em agua/vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7102200', 'description' => 'Feijoes congelados,nao cozidos ou cozidos em agua/vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7102900', 'description' => 'Outs.legumes de vagem,congel.n/cozidos/ cozidos agua/etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7103000', 'description' => 'Espinafres congelad.n/cozidos ou cozidos em agua/vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7104000', 'description' => 'Milho doce congelado,n/cozido ou cozido em agua/vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7108000', 'description' => 'Outs.prods.horticolas congel.n/cozidos/ cozidos agua/etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7109000', 'description' => 'Misturas de prods.horts.cong.n/cozidos/ cozidos agua/etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7112010', 'description' => 'Azeitonas conserv.com agua salgada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7112020', 'description' => 'Azeitonas conserv.com agua sulfurada/adic.de outs.subst', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7112090', 'description' => 'Outros azeitonas conservadas transitoriamente', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7114000', 'description' => 'Pepinos e pepininhos  cornichons', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7114000', 'description' => 'Pepinos e pepininhos  cornichons, com água salgada, sulfurada ou adicionada de outras substâncias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7115100', 'description' => 'Cogumelos (agaricus)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7115100', 'description' => 'Cogumelos (agaricus), com água salgada, sulfurada ou adicionada de outras substâncias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7115900', 'description' => 'Outs.cogumelos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7115900', 'description' => 'Outs.cogumelos, com água salgada, sulfurada ou adicionada de outras substâncias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7119000', 'description' => 'Outros produtos horticolas,misturas de produtos hoticolas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7119000', 'description' => 'Outros produtos horticolas,misturas de produtos hoticolas, com água salgada, sulfurada ou adicionada de outras substâncias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7122000', 'description' => 'Cebolas secas,incl.pedacos,fatias,po,etc. s/qq.out.prep.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7123100', 'description' => 'Cogumelos (agaricus),secos,incl.pedacos, etc.s/qq.out.prep', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7123200', 'description' => 'Orelhas-de-judas,secos,incl.pedacos,etc. s/qq.out.prep', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7123300', 'description' => 'Tremelas,secos,incl.pedacos,etc.s/qq.out. prep', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7123900', 'description' => 'Outros cogumelos e trufas,secos,incl. pedacos,etc.s/qq.out.prep', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7129010', 'description' => 'Alho comum em po sem qualquer outro preparo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7129090', 'description' => 'Outs.prods.horts/misturas,secos,incl.pedacos,fatias,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7129090', 'description' => 'Milho doce', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7131010', 'description' => 'Ervilhas (pisum sativum),secas,em graos,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7131090', 'description' => 'Outros ervilhas (pisum sativum),secas,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7132010', 'description' => 'Grao-de-bico,seco,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7132090', 'description' => 'Outros graos-de-bico,secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133110', 'description' => 'Feijoes (vigna mungo ou radiata) secos,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133190', 'description' => 'Outs.feijoes (vigna mungo ou radiata),secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133210', 'description' => 'Feijao adzuki,seco,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133290', 'description' => 'Outros feijoes adzuki,secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133311', 'description' => 'Feijao comum,preto,seco,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133319', 'description' => 'Outros feijoes comuns,pretos,secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133321', 'description' => 'Feijao comum,branco,seco,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133329', 'description' => 'Outros feijoes comuns,brancos,secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133391', 'description' => 'Outros feijoes comuns,secos,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133399', 'description' => 'Outros feijoes comuns,secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133410', 'description' => 'Feijão-bambara (vigna subterranea ou voandzeia subterranea) para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133490', 'description' => 'Outros feijoes-bambara (vigna subterranea ou voandzeia subterranea),secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133510', 'description' => 'Feião fradinho seco ,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133590', 'description' => 'Outros feijoes fradinho ,secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133910', 'description' => 'Outs.feijoes (vigna ou phaseolus),secos,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7133990', 'description' => 'Outros feijoes (vigna ou phaseolus),secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7134010', 'description' => 'Lentilhas secas,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7134090', 'description' => 'Outros lentilhas secas,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7135010', 'description' => 'Favas e fava forrageira,secas,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7135090', 'description' => 'Outros favas e fava forrageira,secas,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7136010', 'description' => 'Feijões-guando,secos,em graos,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7136090', 'description' => 'Outros feijões-guando,secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7139010', 'description' => 'Outs.legumes de vagem,secos,em graos,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7139090', 'description' => 'Outros legumes de vagem,secos,em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7141000', 'description' => 'Raizes de mandioca,frescas,refrigeradas, congel.ou secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7142000', 'description' => 'Batatas-doces,frescas,refrigeradas, congeladas ou secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7143000', 'description' => 'Inhames (...),frescos,etc.e medula de sagueiro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7144000', 'description' => 'Taros (...),frescos,etc.e medula de sagueiro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7145000', 'description' => 'Mangaritos (...),frescos,etc.e medula de sagueiro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '7149000', 'description' => 'Outs.raizes,tuberculos,frescos,etc.e medula de sagueiro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8011100', 'description' => 'Cocos dessecados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8011100', 'description' => 'Cocos dessecados, acondicionados em embalagens de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8011200', 'description' => 'Cocos na casca interna (endocarpo)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8011900', 'description' => 'Outros cocos frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8012100', 'description' => 'Castanha-do-para,fresca ou seca,com casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8012100', 'description' => 'Castanha-do-para,com casca, seca e acondicionada em embalagem de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8012200', 'description' => 'Castanha-do-para,fresca ou seca,sem casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8012200', 'description' => 'Castanha-do-para,sem casca, seca e acondicionada em embalagem de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8013100', 'description' => 'Castanha de caju,fresca ou seca,com casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8013100', 'description' => 'Castanha de caju,com casca, seca e acondicionada em embalagem de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8013200', 'description' => 'Castanha de caju,fresca ou seca,sem casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8013200', 'description' => 'Castanha de caju,sem casca, seca e acondicionada em embalagem de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8021100', 'description' => 'Amendoas frescas ou secas,com casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8021200', 'description' => 'Amendoas frescas ou secas, sem casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8022100', 'description' => 'Avelas (corylus spp) frescas ou secas,com casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8022200', 'description' => 'Avelas (corylus spp) frescas ou secas, sem casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8023100', 'description' => 'Nozes frescas ou secas,com casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8023200', 'description' => 'Nozes frescas ou secas, sem casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8024100', 'description' => 'Castanhas (castanea spp) frescas ou secas, com casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8024200', 'description' => 'Castanhas (castanea spp) frescas ou secas, sem casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8025100', 'description' => 'Pitácios com casca, frescos ou secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8025200', 'description' => 'Pitácios sem casca, frescos ou secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8026100', 'description' => 'Nozes de macadâmia,frescas ou secas, com casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8026200', 'description' => 'Nozes de macadâmia,frescas ou secas, sem casca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '8027000', 'description' => 'Nozes de cola (...),frescas ou secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8028000', 'description' => 'Nozes de areca (...),frescas ou secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8029000', 'description' => 'Outros frutas de casca rija,frescas ou secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8031000', 'description' => 'Bananas da terra  frescas ou secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8031000', 'description' => 'Bananas da terra  frescas ou secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8039000', 'description' => 'Outras bananas frescas ou secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8039000', 'description' => 'Outras bananas, secas e acondicionadas em embalagens de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8041010', 'description' => 'Tamaras frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8041020', 'description' => 'Tamaras secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8042010', 'description' => 'Figos frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8042020', 'description' => 'Figos secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8043000', 'description' => 'Abacaxis frescos ou secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8043000', 'description' => 'Abacaxis ananases, secos e acondicionados em embalagens de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8044000', 'description' => 'Abacates frescos ou secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8044000', 'description' => 'Abacates, secos e acondicionados em embalagens de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8045010', 'description' => 'Goiabas,frescos ou secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8045010', 'description' => 'Goiabas, secas e acondicionadas em embalagens de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8045020', 'description' => 'Mangas,frescos ou secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8045020', 'description' => 'Mangas, secas e acondicionadas em embalagens de apresentação', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8045030', 'description' => 'Mangostoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8045030', 'description' => 'Mangostoes, secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8051000', 'description' => 'Laranjas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8051000', 'description' => 'Laranjas, secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8052100', 'description' => 'Mandarinas (incluindo as tangerinas e as satsumas)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8052100', 'description' => 'Mandarinas (incluindo as tangerinas e as satsumas)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8052200', 'description' => 'Clementinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8052200', 'description' => 'Clementinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8052900', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8052900', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8054000', 'description' => 'Toranjas e pomelos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8054000', 'description' => 'Toranjas e pomelos, secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8055000', 'description' => 'Limoes (citrus limon, citrus limonum) e limas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8055000', 'description' => 'Limoes (citrus limon, citrus limonum) e limas, secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8059000', 'description' => 'Outros citricos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8059000', 'description' => 'Outros citricos, secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8061000', 'description' => 'Uvas frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8062000', 'description' => 'Uvas secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8071100', 'description' => 'Melancias frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8071900', 'description' => 'Meloes frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8072000', 'description' => 'Mamoes (papaias) frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8081000', 'description' => 'Macas frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8083000', 'description' => 'Peras frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8084000', 'description' => 'Marmelos frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8091000', 'description' => 'Damascos frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8092100', 'description' => 'Cerejas ácidas, frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8092900', 'description' => 'Outras cerejas frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8093010', 'description' => 'Pessegos frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8093020', 'description' => 'Brugnons e nectarinas,frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8094000', 'description' => 'Ameixas e abrunhos,frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8101000', 'description' => 'Morangos frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8102000', 'description' => 'Framboesas,amoras e amoras-framboesas,frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8103000', 'description' => 'Groselhas, incluindo o cassis, frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8104000', 'description' => 'Airelas,mirtilos e outs.frutas genero vaccinium,frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '8105000', 'description' => 'Quivis kiwis,frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8106000', 'description' => 'Durioes frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8107000', 'description' => 'Caquis (...) frescos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8109011', 'description' => 'Carambolas (Averrhoa carambola)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8109012', 'description' => 'Anonas e outras frutas do gênero Annona', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8109013', 'description' => 'Jacas (Artocarpus heterophyllus)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8109014', 'description' => 'Lechias (Litchi chinensis)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8109015', 'description' => 'Maracujás (Passiflora edulis)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8109016', 'description' => 'Pitaias (Hylocereus spp., Selenicereus undatus)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8109017', 'description' => 'Tamarindos (Tamarindus indica)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8109090', 'description' => 'Outras frutas frescas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8111000', 'description' => 'Morangos congelados,nao cozidos/cozidos em agua/vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8111000', 'description' => 'Morangos congelados,nao cozidos/cozidos em agua/vapor, adicionados de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8112000', 'description' => 'Framboesas,amoras,groselhas,congeladas,cozidas ou nao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8112000', 'description' => 'Framboesas,amoras,groselhas,congeladas,cozidas ou não, adicionados de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8119000', 'description' => 'Outs.frutas congeladas,n/cozidas,cozidas em agua/vapor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8119000', 'description' => 'Outs.frutas congeladas,n/cozidas,cozidas em agua/vapor, adicionadas de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8121000', 'description' => 'Cerejas conservadas em agua salgada, sulfurada,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8129000', 'description' => 'Outs.frutas conservadas em agua salgada, sulfurada,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8131000', 'description' => 'Damascos secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8132010', 'description' => 'Ameixas secas,com caroco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8132020', 'description' => 'Ameixas secas,sem caroco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8133000', 'description' => 'Macas secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8134010', 'description' => 'Peras secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8134090', 'description' => 'Outros frutas secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8135000', 'description' => 'Misturas de frutas secas ou de frutas de casca rija', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '8140000', 'description' => 'Cascas de citricos,meloes,melancias,frescas, secas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9011110', 'description' => 'Cafe nao torrado,nao descafeinado,em grao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9011190', 'description' => 'Cafe nao torrado,nao descafeinado,exceto em grao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9011190', 'description' => 'Cafe nao torrado,nao descafeinado, moídos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9011200', 'description' => 'Cafe nao torrado,descafeinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9012100', 'description' => 'Cafe torrado,nao descafeinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9012200', 'description' => 'Cafe torrado,descafeinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9019000', 'description' => 'Cascas,peliculas de cafe e sucedaneos do cafe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9019000', 'description' => 'Cascas e películas de café', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9021000', 'description' => 'Cha verde (nao fermentado),em embalagens imediatas<=3kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9022000', 'description' => 'Cha verde (nao fermentado),apresentado em qq.out.forma', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9023000', 'description' => 'Cha preto (fermentado/parcialm.),embalag. imediatas<=3kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9024000', 'description' => 'Cha preto (fermentado/parcialm.) apresent. qq.out.forma', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9030010', 'description' => 'Mate simplesmente cancheado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9030010', 'description' => 'Mate simplesmente cancheado, em embalagens imediatas de conteúdo não superior a 5 kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9030090', 'description' => 'Outros tipos de mate', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9030090', 'description' => 'Outros tipos de mate, em embalagens imediatas de conteúdo não superior a 5 kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9041100', 'description' => 'Pimenta piper,seca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9041200', 'description' => 'Pimenta piper,triturada ou em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9042100', 'description' => 'Pimentoes e pimentas capsicum/pimenta, secos, não triturados nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9042200', 'description' => 'Pimentoes e pimentas capsicum/pimenta, secos, triturados ou em  po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9051000', 'description' => 'Baunilha, não triturados nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9052000', 'description' => 'Baunilha, triturados ou em  po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9061100', 'description' => 'Canela (cinnamomum zeylanicum blume) ,nao trituradas nem em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9061900', 'description' => 'Outras canela e flores de caneleira,nao trituradas nem em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9062000', 'description' => 'Canela e flores de caneleira,trituradas ou em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9071000', 'description' => 'Cravo-da-india (frutos,flores e pedunculos) não triturados nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '9072000', 'description' => 'Cravo-da-india (frutos,flores e pedunculos), triturados ou em  po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9081100', 'description' => 'Noz-moscada, não triturados nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9081200', 'description' => 'Noz-moscada, triturados ou em  po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9082100', 'description' => 'Macis, não triturados nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9082200', 'description' => 'Macis, triturados ou em  po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9083100', 'description' => 'Amomos e cardamomos, não triturados nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9083200', 'description' => 'Amomos e cardamomos, triturados ou em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9092100', 'description' => 'Sementes de coentro, não trituradas nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9092200', 'description' => 'Sementes de coentro, trituradas ou em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9093100', 'description' => 'Sementes de cominho, não trituradas nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9093200', 'description' => 'Sementes de cominho, trituradas ou em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9096110', 'description' => 'Sementes de anis (anis verde), não trituradas nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9096120', 'description' => 'Sementes de badiana (anis estrelado), não trituradas nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9096190', 'description' => 'Sementes de funcho e bagas de zimbro, não trituradas nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9096210', 'description' => 'Sementes de anis (anis verde), trituradas ou em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9096220', 'description' => 'Sementes de badiana (anis estrelado), trituradas ou em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9096290', 'description' => 'Sementes de funcho e bagas de zimbro, trituradas ou em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9101100', 'description' => 'Gengibre, não trituradas nem em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9101200', 'description' => 'Gengibre, trituradas ou em pó', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9102000', 'description' => 'Acafrao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9103000', 'description' => 'Acafrao-da-terra (curcuma)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9109100', 'description' => 'Misturas de especiarias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '9109900', 'description' => 'Outros especiarias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10011100', 'description' => 'Trigo duro,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10011900', 'description' => 'Outros especies de trigo duro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10019100', 'description' => 'Outros especies de trigo,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10019900', 'description' => 'Outs.especies de trigo e misturas de trigo com centeio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10021000', 'description' => 'Centeio para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10029000', 'description' => 'Outros especies de centeio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10031000', 'description' => 'Cevada para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10039010', 'description' => 'Cevada cervejeira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10039080', 'description' => 'Outros especies de cevada,em grao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10039090', 'description' => 'Outros especies de cevada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10041000', 'description' => 'Aveia para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10049000', 'description' => 'Outros especies de aveia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10051000', 'description' => 'Milho para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10059010', 'description' => 'Outros especies de milho,em grao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10059090', 'description' => 'Outros especies de milho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10061010', 'description' => 'Arroz (paddy) com casca,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10061091', 'description' => 'Arroz (paddy) com casca,parboilizado (estufado)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10061092', 'description' => 'Arroz (paddy) com casca,nao parboilizado (n/estufado)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10062010', 'description' => 'Arroz (cargo ou castanho),descascado, parboilizado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10062020', 'description' => 'Arroz (cargo ou castanho),descascado,nao parboilizado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10063011', 'description' => 'Arroz semibranqueado,etc.parboilizado, polido ou brunido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10063019', 'description' => 'Outs.tipos de arroz semibranqueado,etc. parboilizado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10063021', 'description' => 'Arroz semibranqueado,etc.n/parboilizado, polido,brunido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10063029', 'description' => 'Outs.tipos de arroz semibranqueado,etc. n/parboilizado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10064000', 'description' => 'Arroz quebrado (trinca de arroz)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10071000', 'description' => 'Sorgo em grao,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10079000', 'description' => 'Outros graos de sorgo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10081010', 'description' => 'Trigo mourisco,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10081090', 'description' => 'Outros graos de trigo mourisco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10082110', 'description' => 'Painço para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '10082190', 'description' => 'Outros painço', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10082910', 'description' => 'Milheto (pennisetum glaucum)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10082990', 'description' => 'Outros milheto (pennisetum glaucum)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10083010', 'description' => 'Alpiste para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10083090', 'description' => 'Outros graos de alpiste', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10084010', 'description' => 'Milhã para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10084090', 'description' => 'Outros milhã', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10085010', 'description' => 'Quinoa para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10085090', 'description' => 'Outros quinoa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10086010', 'description' => 'Triticale para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10086090', 'description' => 'Outros triticale', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10089010', 'description' => 'Outros cereais para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '10089090', 'description' => 'Outros cereais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11010010', 'description' => 'Farinhas de trigo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11010020', 'description' => 'Farinhas de mistura de trigo com centeio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11022000', 'description' => 'Farinha de milho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11029000', 'description' => 'Farinhas de outs.cereais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11031100', 'description' => 'Grumos e semolas,de trigo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11031300', 'description' => 'Grumos e semolas,de milho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11031900', 'description' => 'Grumos e semolas,de outs.cereais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11032000', 'description' => 'Pellets de cereais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11041200', 'description' => 'Graos de aveia,esmagados ou em flocos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11041900', 'description' => 'Graos de outs.cereais,esmagados ou em flocos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11042200', 'description' => 'Graos de aveia,descascados,em perolas, cortados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11042300', 'description' => 'Graos de milho,descascados,em perolas, cortados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11042900', 'description' => 'Graos de outs.cereais,descascados,em perolas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11043000', 'description' => 'Germes de cereais,inteiros,esmagados,em flocos,moidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11051000', 'description' => 'Farinha,semola e po,de batata', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11052000', 'description' => 'Flocos,granulos e pellets,de batata', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11061000', 'description' => 'Farinhas,semolas e pos,dos legumes de vagem,secos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11062000', 'description' => 'Farinhas,semolas e pos,de sagu,de raizes e tuberculos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11063000', 'description' => 'Farinhas,semolas e pos,de frutas,cascas de citricos,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11071010', 'description' => 'Malte nao torrado,inteiro ou partido', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11071020', 'description' => 'Malte nao torrado,moido ou em farinha', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11072010', 'description' => 'Malte torrado,inteiro ou partido', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11072020', 'description' => 'Malte torrado,moido ou em farinha', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11081100', 'description' => 'Amido de trigo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11081200', 'description' => 'Amido de milho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11081300', 'description' => 'Fecula de batata', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11081400', 'description' => 'Fecula de mandioca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11081900', 'description' => 'Outros amidos e feculas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11082000', 'description' => 'Inulina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '11090000', 'description' => 'Gluten de trigo,mesmo seco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12011000', 'description' => 'Soja, mesmo triturada, para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12019000', 'description' => 'Outros graos de soja,mesmo triturados, exceto para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12023000', 'description' => 'Amendoins não torrados nem cozidos, para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12024100', 'description' => 'Amendoins com casca,nao torrados,nem cozidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12024200', 'description' => 'Outs.graos de amendoins,descascados, n/torrados,n/cozid., mesmo triturados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12030000', 'description' => 'Copra em graos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12040010', 'description' => 'Sementes de linho (linhaca) para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12040090', 'description' => 'Outs.sementes de linho (linhaca),mesmo trituradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12051010', 'description' => 'Sementes de nabo silvestre ou de colza com baixo teor de ácido erúcico,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12051090', 'description' => 'Outs.sementes de nabo silvestre,de colza, mesmo triturad', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '12059010', 'description' => 'Sementes de nabo silvestre ou de colza ,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12059090', 'description' => 'Outs.sementes de nabo silvestre,de colza, mesmo triturad', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12060010', 'description' => 'Sementes de girassol,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12060090', 'description' => 'Outros sementes de girassol,mesmo trituradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12071010', 'description' => 'Nozes e amêndoas de palma (palmiste) para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12071090', 'description' => 'Outras nozes e amêndoas de palma (palmiste)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12072100', 'description' => 'Sementes de algodao,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12072900', 'description' => 'Outros sementes de algodao,mesmo trituradas, exceto para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12073010', 'description' => 'Sementes de ricino,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12073090', 'description' => 'Outros sementes de ricino,mesmo trituradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12074010', 'description' => 'Sementes de gergelim,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12074090', 'description' => 'Outros sementes de gergelim,mesmo trituradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12075010', 'description' => 'Sementes de mostarda,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12075090', 'description' => 'Outros sementes de mostarda,mesmo trituradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12076010', 'description' => 'Sementes de cártamo (carthamus tinctorius) para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12076090', 'description' => 'Outras sementes de cártamos (carthamus tinctorius)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12077010', 'description' => 'Sementes de melão,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12077090', 'description' => 'Outras sementes de melão', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12079110', 'description' => 'Sementes de dormideira ou papoula,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12079190', 'description' => 'Outs.sementes de dormideira ou papoula,mesmo trituradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12079910', 'description' => 'Outs.sementes e frutos oleaginosos,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12079990', 'description' => 'Outs.sementes e frutos oleaginosos,mesmo triturados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12081000', 'description' => 'Farinhas de soja', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12089000', 'description' => 'Farinhas de outs.sementes,frutos oleag.exc.de mostarda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12091000', 'description' => 'Sementes de beterraba sacarina,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12092100', 'description' => 'Sementes de alfafa (luzerna),para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12092200', 'description' => 'Sementes de trevo (trifolium spp),para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12092300', 'description' => 'Sementes de festuca,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12092400', 'description' => 'Sementes de pasto dos prados do kentucky,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12092500', 'description' => 'Sementes de azevem,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12092900', 'description' => 'Outros sementes forrageiras,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12093000', 'description' => 'Sementes de plantas herbaceas,cult. p/flores, p/semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12099100', 'description' => 'Sementes de produtos horticolas,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12099900', 'description' => 'Outros sementes,frutos e esporos,para semeadura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12101000', 'description' => 'Cones de lupulo,frescos,secos, n/triturados, n/moidos,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12102010', 'description' => 'Cones de lupulo,triturados ou moidos,ou em pellets', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12102020', 'description' => 'Lupulina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12112000', 'description' => 'Raizes de ginseng', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12112000', 'description' => 'Raizes de ginseng, secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12113000', 'description' => 'Coca (folha de),p/util.perfum.medicina,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12113000', 'description' => 'Coca (folha de),p/util.perfum.medicina,etc., seca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12114000', 'description' => 'Palha de papoula,p/util.perfum.medicina,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12114000', 'description' => 'Palha de papoula,p/util.perfum.medicina,etc., seca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12115000', 'description' => 'Efedra', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12115000', 'description' => 'Efedra', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12119010', 'description' => 'Orégano Origanum vulgare,incl.cort.tritur.po, p/medicina,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12119010', 'description' => 'Orégano Origanum vulgare,incl.cort.tritur.po, p/medicina,etc., seco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12119090', 'description' => 'Outs.plantas e partes,p/perfumaria,medicina e semelhs.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12119090', 'description' => 'Outs.plantas e partes,p/perfumaria,medicina e semelhs., secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12122100', 'description' => 'Algas próprias para a alimentação humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12122100', 'description' => 'Algas próprias para a alimentação humana, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12122900', 'description' => 'Outras algas frescas,refrigeradas,congeladas, secas ou em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12122900', 'description' => 'Outras algas, das espécies utilizadas principalmente em medicina, secas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '12129100', 'description' => 'Beterraba sacarina,fresca,refriger. congelada, seca,em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12129200', 'description' => 'Alfarroba utiliz.principalm.na aliment.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12129200', 'description' => 'Alfarroba utiliz.principalm.na aliment.humana, seca, incluídas as suas sementes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12129300', 'description' => 'Cana-de-açúcar utiliz.principalm.na aliment.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12129400', 'description' => 'Raízes de chicória utiliz.principalm.na aliment.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12129910', 'description' => 'Stevia rebaudiana (kaa heê)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12129990', 'description' => 'Outs.prods.vegetais utiliz.principalm.na aliment.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12130000', 'description' => 'Palhas,cascas de cereais,em bruto,moidas, prensadas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12141000', 'description' => 'Farinhas e pellets,de alfafa (luzerna)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '12149000', 'description' => 'Rutabagas,raizes forrageiras e outs.prods. forrageiros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13012000', 'description' => 'Goma-arabica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13019010', 'description' => 'Goma-laca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13019090', 'description' => 'Outs.gomas,resinas,gomas-resinas, oleorresinas,naturais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021110', 'description' => 'Concentrado de palha de papoula', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021190', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021200', 'description' => 'Sucos e extratos,de alcacuz', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021300', 'description' => 'Sucos e extratos,de lupulo', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021400', 'description' => 'De efedra', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021910', 'description' => 'Sucos e extratos,de mamao (carica papaya),seco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021920', 'description' => 'Sucos e extratos,de semente de pomelo (grapefruit)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021930', 'description' => 'Sucos e extratos,de ginkgo biloba,seco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021940', 'description' => 'Sucos e extratos,valepotriatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021950', 'description' => 'Sucos e extratos,de ginseng', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021960', 'description' => 'Sucos e extratos,silimarina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021991', 'description' => 'Sucos e extratos,de piretro ou de raizes c/rotenona', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13021999', 'description' => 'Sucos e extratos,de outs.vegetais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13022010', 'description' => 'Materias pecticas (pectinas)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13022090', 'description' => 'Outros materias pecticas,pectinatos e pectatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13023100', 'description' => 'Agar-agar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13023211', 'description' => 'Farinha de endosperma', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13023219', 'description' => 'Outs.prods.mucilag.espessantes,de alfarroba e sementes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13023220', 'description' => 'Prods.mucilaginosos e espessantes,de sementes de guare', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13023910', 'description' => 'Prods.mucilaginosos e espessantes,de carragenina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '13023990', 'description' => 'Prods.mucilaginosos e espessantes, deriv. outs.vegetais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '14011000', 'description' => 'Bambus para cestaria ou espartaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '14012000', 'description' => 'Rotins para cestaria ou espartaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '14019000', 'description' => 'Outs.materias vegetais para cestaria ou espartaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '14042010', 'description' => 'Linteres de algodao,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '14042090', 'description' => 'Outros linteres de algodao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '14049010', 'description' => 'Matérias vegetais das espécies principalmente utilizadas na fabricação de vassouras ou de escovas (por exemplo sorgo, piaçaba, raiz de grama, tampico), mesmo torcidas ou em feixes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '14049090', 'description' => 'Outros produtos de origem vegetal,não especificados nem compreendidos em outras posições', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15011000', 'description' => 'Banha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15012000', 'description' => 'Outras gorduras de porco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15019000', 'description' => 'Gordura de aves', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15021011', 'description' => 'Sebo bovino,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15021012', 'description' => 'Sebo bovino,fundido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15021019', 'description' => 'Outros sebos bovinos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15021090', 'description' => 'Outros sebos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15029000', 'description' => 'Outros gorduras bovinas,ovinas ou caprinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15030000', 'description' => 'Estearina solar,oleo de banha de porco, etc.n/preparados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15041011', 'description' => 'Oleos de figados de bacalhau,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15041019', 'description' => 'Outros oleos de figados de bacalhau', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15041090', 'description' => 'Oleos de figados de outs.peixes e respectivas fracoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '15042000', 'description' => 'Gorduras e oleos,de peixe e respectivas fracoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15043000', 'description' => 'Gorduras e oleos,de mamiferos marinhos, respect.fracoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15050010', 'description' => 'Lanolina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15050090', 'description' => 'Outros substancias gordas derivadas da suarda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15060000', 'description' => 'Outs.gorduras,oleos,animais,incl.refin.mas n/quim.modif', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15071000', 'description' => 'Oleo de soja,em bruto,mesmo degomado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15079011', 'description' => 'Oleo de soja,refinado (em recipientes com capacidade <=5l)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15079019', 'description' => 'Oleo de soja,refinado (outros)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15079090', 'description' => 'Outros oleos de soja', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15081000', 'description' => 'Oleo de amendoim,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15089000', 'description' => 'Outros oleos de amendoim', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15091000', 'description' => 'Azeite de oliva,virgem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15099010', 'description' => 'Azeite de oliva,refinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15099090', 'description' => 'Outros azeites de oliva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15100000', 'description' => 'Outs.oleos de azeitonas e misturas c/azeites de oliva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15111000', 'description' => 'Oleos de dende,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15119000', 'description' => 'Outros oleos de dende', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15121110', 'description' => 'Oleo de girassol,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15121120', 'description' => 'Oleo de cartamo,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15121911', 'description' => 'Outros oleos de girassol - refinado, em recipientes com capacidade <=5l)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15121919', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15121920', 'description' => 'Outros oleos de cartamo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15122100', 'description' => 'Oleo de algodao,em bruto,mesmo desprovido de gossypol', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15122910', 'description' => 'Oleo de algodao,refinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15122990', 'description' => 'Outros oleos de algodao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15131100', 'description' => 'Oleo de coco (oleo de copra),em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15131900', 'description' => 'Outros oleos de coco (oleos de copra)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15132110', 'description' => 'Oleo de palmiste,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15132120', 'description' => 'Oleo de babacu,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15132910', 'description' => 'Outros oleos de palmiste', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15132920', 'description' => 'Outros oleos de babacu', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15141100', 'description' => 'Oleos de nabo silvestre ou de colza,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15141910', 'description' => 'Outs.oleos de nabo silvestre,de colza, refinados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15141990', 'description' => 'Outs.oleos de nabo silvestre,de colza', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15149100', 'description' => 'Outs.oleos de nabo silvestre,de colza ou de mostarda,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15149910', 'description' => 'Outs.oleos de nabo silvestre,de colza ou de mostarda,refinados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15149990', 'description' => 'Outs.oleos de nabo silvestre,de colza ou de mostarda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15151100', 'description' => 'Oleo de linhaca,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15151900', 'description' => 'Outros oleos de linhaca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15152100', 'description' => 'Oleo de milho,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15152910', 'description' => 'Refinado, em recipientes com capacidade <=5l', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15152990', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15153000', 'description' => 'Oleo de ricino', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15155000', 'description' => 'Oleo de gergelim', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15159010', 'description' => 'Oleo de jojoba e respectivas frações', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15159021', 'description' => 'Oleo de tungue,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15159022', 'description' => 'Oleo de tungue,refinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15159090', 'description' => 'Outs.gorduras e oleos,vegetais,fixos,mesmo refinados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15161000', 'description' => 'Gorduras e oleos,animais,hidrogens. interesterifs.etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15162000', 'description' => 'Gorduras e oleos,vegetais,hidrogens. interesterifs.etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15171000', 'description' => 'Margarina,exceto a margarina liquida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15179010', 'description' => 'Outras - misturas de óleos refinados, em recipientes com capacidade <= 5l', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15179090', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '15180010', 'description' => 'Oleo vegetal epoxidado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15180090', 'description' => 'Outs.gorduras e oleos animais/veget. cozidos,oxidad.etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15200010', 'description' => 'Glicerol em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15200020', 'description' => 'Agua e lixivia,glicericas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15211000', 'description' => 'Ceras vegetais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15211000', 'description' => 'Ceras vegetais, refinadas, branqueadas ou coloridas artificialmente', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15219011', 'description' => 'Cera de abelha,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15219019', 'description' => 'Outros ceras de abelha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15219019', 'description' => 'Outros ceras de abelha, refinadas, branqueadas ou coloridas artificialmente', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15219090', 'description' => 'Ceras de outs.insetos e espermacete,mesmo refin.corados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15219090', 'description' => 'Ceras de insetos, refinadas, branqueadas ou coloridas artificialmente', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15219090', 'description' => 'Espermacete, prensado ou refinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '15220000', 'description' => 'Degras e residuos do tratam.das materias graxas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '16010000', 'description' => 'Enchidos de carne,miudezas,sangue,suas prepars.aliments', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '16021000', 'description' => 'Prepars.aliments.homogeneiz.de carnes, miudezas,sangue', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16022000', 'description' => 'Prepars.alimenticias e conservas,de figados de animais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '16023100', 'description' => 'Preparacoes alimenticias e conservas,de peru', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16023210', 'description' => 'Galo/galinha c/cont.carne/miud.>=57% em peso nao cozida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16023220', 'description' => 'Galo/galinha c/cont.carne/miud.>=57% em peso cozidas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16023230', 'description' => 'Galo/galinha c/cont.carne/miud.>=25 e <57% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16023290', 'description' => 'Outras preparações / conservas de galo e galinhas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16023900', 'description' => 'Preparacoes alimenticias e conservas,de outs.aves', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16024100', 'description' => 'Prepars.alim.conservas,de pernas,seus pedacos,de suinos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16024200', 'description' => 'Prepars.aliment.conservas,de pas,seus pedacos,de suinos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16024900', 'description' => 'Outs.prepars.aliments.e conservas,de suinos e misturas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16025000', 'description' => 'Preparacoes alimenticias e conservas,de bovinos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16029000', 'description' => 'Outs.prepars.alims.conservas,de carnes, miudezas,sangue', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '16030000', 'description' => 'Extratos e sucos,de carnes,de peixes,de crustaceos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041100', 'description' => 'Prepars.e conservas,de salmoes,inteiros ou em pedacos', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041200', 'description' => 'Prepars.e conservas,de arenques,inteiros ou em pedacos', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041310', 'description' => 'Prepars.e conservas,de sardinhas,inteiras ou em pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041390', 'description' => 'Prepars.conservas,de sardinelas, espadilhas, int.pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041410', 'description' => 'Preparacoes e conservas,de atuns,inteiros ou em pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041420', 'description' => 'Prepars.conservas,de bonitos-listrados, inteiros,pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041430', 'description' => 'Prepars.conservas,de bonitos-cachorros, inteiros,pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041500', 'description' => 'Prepars.conservas,de cavalas,cavalinhas, etc.int.pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041600', 'description' => 'Prepars.e conservas,de anchovas,inteiras ou em pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041700', 'description' => 'Prepars.e conservas,de enguias,inteiros,  em pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041800', 'description' => 'Barbatanas de tubarao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16041900', 'description' => 'Prepars.e conservas,de outs.peixes,inteiros,  em pedacos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16042010', 'description' => 'Outros preparacoes e conservas,de atuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16042020', 'description' => 'Outs.preparacoes e conservas,de bonitos-listrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16042030', 'description' => 'Outs.prepars.e conservas,de sardinhas, sardinelas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16042090', 'description' => 'Outros preparacoes e conservas,de outs. peixes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16043100', 'description' => 'Caviar', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16043200', 'description' => 'Sucedaneos do caviar', 'aliquota_federal' => 6.63, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16051000', 'description' => 'Preparacoes e conservas,de caranguejos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16052100', 'description' => 'Preparacoes e conservas,de camaroes não acondicionados em recipientes hermeticamentre fechados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16052900', 'description' => 'Preparacoes e conservas,de camaroes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16053000', 'description' => 'Preparacoes e conservas,de lavagantes (homards)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16054000', 'description' => 'Preparacoes e conservas,de outs.crustaceos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16055100', 'description' => 'Prepars.e conservas,de ostras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16055200', 'description' => 'Prepars.e conservas,de vieiras e outros mariscos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '16055300', 'description' => 'Prepars.e conservas,de mexilhões', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16055400', 'description' => 'Prepars.e conservas,de sépias e lulas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16055500', 'description' => 'Prepars.e conservas,de polvos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16055600', 'description' => 'Prepars.e conservas,de ameijoas, berbigões (…)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16055700', 'description' => 'Prepars.e conservas,de abalones', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16055800', 'description' => 'Prepars.e conservas,de caracóis, exceto do mar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16055900', 'description' => 'Prepars.e conservas,de outros moluscos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16056100', 'description' => 'Prepars.e conservas,de pepinos do mar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16056200', 'description' => 'Prepars.e conservas,de ouriços do mar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16056300', 'description' => 'Prepars.e conservas,de medusas (águas vivas)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '16056900', 'description' => 'Prepars.e conservas,de invertebr.aquat.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 4.50, 'aliquota_municipal' => 0.00],
            ['ncm' => '17011200', 'description' => 'Acucar de beterraba,em bruto', 'aliquota_federal' => 7.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17011300', 'description' => 'Acucar de cana,em bruto (mencionado na nota 2 de subposição do presente capítulo)', 'aliquota_federal' => 7.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17011400', 'description' => 'Outros acucares de cana,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17019100', 'description' => 'Outs.acucares de cana,beterraba, c/aromatizante, corante', 'aliquota_federal' => 7.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17019900', 'description' => 'Outs.acucares de cana,beterraba,sol.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17019900', 'description' => 'Sacarose quimicamente pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17021100', 'description' => 'Lactose e xarope de lactose,peso>=99% de lactose,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17021900', 'description' => 'Outros lactoses e xaropes de lactose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17022000', 'description' => 'Acucar e xarope,de bordo (acer)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17023011', 'description' => 'Glicose quimicamente pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17023019', 'description' => 'Outs.glicoses contendo estado seco,peso<20% de frutose', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17023020', 'description' => 'Xarope de glicose cont.estado seco,peso<20% de frutose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17024010', 'description' => 'Glicose contendo estado seco,20%<=peso<50% de frutose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17024020', 'description' => 'Xarope de glicose,cont.estado seco, 20%<=p<50% frutose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17025000', 'description' => 'Frutose quimicamente pura', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17026010', 'description' => 'Frutose contendo no estado seco,peso>50% de frutose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17026020', 'description' => 'Xarope de frutose,cont.no estado seco,p>50% de frutose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17029000', 'description' => 'Outs.acucares,xaropes de acucares, sucedaneos do mel,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17031000', 'description' => 'Melacos de cana', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17039000', 'description' => 'Outros melacos da extracao ou refinacao do acucar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17041000', 'description' => 'Gomas de mascar,sem cacau,mesmo revestidas de acucar', 'aliquota_federal' => 6.57, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17049010', 'description' => 'Chocolate branco,sem cacau', 'aliquota_federal' => 6.06, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17049020', 'description' => 'Bombons,caramelos,confeitos e pastilhas,sem cacau', 'aliquota_federal' => 6.57, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '17049090', 'description' => 'Outros produtos de confeitaria,sem cacau', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18010000', 'description' => 'Cacau inteiro ou partido,em bruto ou torrado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18010000', 'description' => 'Cacau torrado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18020000', 'description' => 'Cascas,peliculas e outs.desperdicios de cacau', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18031000', 'description' => 'Pasta de cacau,nao desengordurada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18032000', 'description' => 'Pasta de cacau,total ou parcialmente desengordurada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18040000', 'description' => 'Manteiga,gordura e oleo,de cacau', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18050000', 'description' => 'Cacau em po,sem adicao de acucar ou outs. edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18061000', 'description' => 'Cacau em po,com adicao de acucar ou outs. edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18062000', 'description' => 'Outs.prepars.aliment.c/cacau,em blocos, barras,p>2kg,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18063110', 'description' => 'Chocolate recheado,em tabletes,barras e paus', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18063120', 'description' => 'Outs.prepars.aliments.c/cacau,recheadas,em tabletes,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18063210', 'description' => 'Chocolate nao recheado,em tabletes,barras e paus', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18063220', 'description' => 'Outs.prepars.alims.c/cacau,n/recheadas,em tabletes,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18069000', 'description' => 'Outs.chocolates e preparacoes alimenticias cont.cacau', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '18069000', 'description' => 'Achocolatados, assim entendidos os produtos à base de chocolate, em pó ou em grânulos, destinados à mistura com água ou leite', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19011010', 'description' => 'Leite modificado,para alimentacao de criancas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19011020', 'description' => 'Farinha lactea,para alimentacao de criancas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19011030', 'description' => 'Prepars.a base farinha,semola,amido,p/alim.de criancas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '19011090', 'description' => 'Outros preparacoes para alimentacao de criancas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19012000', 'description' => 'Misturas e pastas,p/prepar.prods.padaria, pastelaria,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19012000', 'description' => 'Pré-misturas próprias para fabricação de pão do tipo comum', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19019010', 'description' => 'Extrato de malte', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19019020', 'description' => 'Doce de leite', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19019090', 'description' => 'Outros prepars.alims.de farinhas,semolas, etc.p<40% caca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19021100', 'description' => 'Massas alimenticias,cont.ovos,n/cozidas, n/recheadas,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19021900', 'description' => 'Outs.massas alimenticias,nao cozidas,nao recheadas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19022000', 'description' => 'Massas aliments.recheadas,incl.cozidas, prepars.out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19023000', 'description' => 'Outros massas alimenticias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19024000', 'description' => 'Couscous', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19030000', 'description' => 'Tapioca,seus sucedaneos,de feculas,em flocos,grumos,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19041000', 'description' => 'Prods.a base de cereais,obtidos por expansao, torrefacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19042000', 'description' => 'Prepars.aliment.obtidas de flocos de cereais e misturas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19043000', 'description' => 'Trigo burgol', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19049000', 'description' => 'Outs.cereais em graos,pre-cozidos,prepars.de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19051000', 'description' => 'Pao denominado knackebrot', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19052010', 'description' => 'Panetone', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19052090', 'description' => 'Pao de especiarias - outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19053100', 'description' => 'Bolachas e biscoitos,adicionados de edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19053200', 'description' => 'Wafles e wafers', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19054000', 'description' => 'Torradas,pao torrado e produtos semelhantes torrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19059010', 'description' => 'Outs.prods.de padaria,pastelaria,inds.de biscoitos,etc. - pão de forma', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19059020', 'description' => 'Outs.prods.de padaria,pastelaria,inds.de biscoitos,etc. - bolachas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19059090', 'description' => 'Outs.prods.de padaria,pastelaria,inds.de biscoitos,etc. - outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '19059090', 'description' => 'Pão do tipo comum', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20011000', 'description' => 'Pepinos e pepininhos,prepars/conserv. vinagre,ac.acetico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20019000', 'description' => 'Outs.prods.horts,etc.prepars/conserv.vinagre,ac.acetico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20021000', 'description' => 'Tomates inteiros ou pedacos,preparados ou conservados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20021000', 'description' => 'Tomates inteiros ou em pedaços, cozidos  exceto em água ou vapor  e congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20029010', 'description' => 'Sucos de tomates', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20029090', 'description' => 'Outs.tomates prepars.conservs.exc.em vinagre,ac.acetico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20029090', 'description' => 'Outs.tomates prepars.conservs., cozidos  exceto em água ou vapor  e congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20031000', 'description' => 'Cogumelos do genero agaricus', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20031000', 'description' => 'Cogumelos do genero agaricus, cozidos  exceto em água ou vapor  e congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20039000', 'description' => 'Outs cogumelos preparados ou conservados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20039000', 'description' => 'Outs cogumelos preparados ou conservados, cozidos  exceto em água ou vapor  e congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20039000', 'description' => 'Trufas cozidas  exceto em água ou vapor  e congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20039000', 'description' => 'Outras trufas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20041000', 'description' => 'Batatas preparadas ou conservadas, congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20041000', 'description' => 'Batatas, cozidas  exceto em água ou vapor ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20049000', 'description' => 'Outs.prods.horts.prepar/conserv.cong.exc.em vinagre,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20049000', 'description' => 'Outros produtos hortícolas e misturas de produtos hortícolas, cozidos  exceto em água ou vapor ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20051000', 'description' => 'Prods.horticolas homogen.prepars/conserv. n/congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20052000', 'description' => 'Batatas preparadas ou conservadas,nao congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20054000', 'description' => 'Ervilhas preparadas ou conservadas,nao congeladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20055100', 'description' => 'Feijao em grao,preparado ou conservado,nao congelado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20055900', 'description' => 'Outs.feijoes prepars/conservs.n/cong.exc.em vinagre,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20056000', 'description' => 'Aspargos preparados ou conservados,nao congelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20057000', 'description' => 'Azeitonas preparadas/conserv.n/cong.exc.em vinagre,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20058000', 'description' => 'Milho doce,preparado ou conservado,nao congelado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20059100', 'description' => 'Brotos de bambu', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20059900', 'description' => 'Outs.prods.horts.prepar/conserv.n/cong.exc.vinagre,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '20060000', 'description' => 'Prods.horticolas,frutas e cascas,etc. conservs.em acucar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20071000', 'description' => 'Prepars.homogen.de frutas,por cozimento, p/alim.criancas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079100', 'description' => 'Geleias e marmelades,de cítricos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079910', 'description' => 'Geleias e marmelades,de outs.frutas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079921', 'description' => 'De açaí (Euterpe oleracea)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079922', 'description' => 'De acerola (Malpighia spp.)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079923', 'description' => 'De banana (Musa spp.)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079924', 'description' => 'De goiaba (Psidium guajava)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079925', 'description' => 'De manga (Mangifera indica)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079926', 'description' => 'De cupuaçu (Theobroma grandiflorum)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079927', 'description' => 'De mamão (papaia) (Carica papaya L.)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079929', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20079990', 'description' => 'Doces,pures e pastas,de outs.frutas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20081100', 'description' => 'Amendoins preparados ou conservados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20081900', 'description' => 'Outs.frutas de casca rija,outs.sementes, prepars/conserv, incluindo as misturas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20081900', 'description' => 'Outs.frutas de casca rija,outs.sementes, prepars/conserv, cozidos exceto em água e vapor , congelados e sem adição de açúcar ou de outros edulcorantes, excluídas as misturas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20082010', 'description' => 'Abacaxis preparados ou conserv.em agua edulcorada,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20082090', 'description' => 'Abacaxis preparados ou conserv.de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20082090', 'description' => 'Abacaxis, cozidos  exceto em água e vapor , congelados e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20083000', 'description' => 'Citricos preparados ou conservados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20083000', 'description' => 'Frutos cítricos cozidos  exceto em água e vapor , congelados e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20084010', 'description' => 'Peras prepars/conservs.em agua edulcorada,incl.xarope', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20084090', 'description' => 'Peras preparadas ou conservadas de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20084090', 'description' => 'Peras preparadas ou conservadas de out.modo, cozidas  exceto em água e vapor , congeladas e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20085000', 'description' => 'Damascos preparados ou conservados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20085000', 'description' => 'Damascos cozidos  exceto em água e vapor , congelados e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20086010', 'description' => 'Cerejas prepars/conservs.em agua edulcorada,incl.xarope', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20086090', 'description' => 'Cerejas preparadas ou conservadas de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20086090', 'description' => 'Cerejas preparadas ou conservadas de out.modo, cozidas  exceto em água e vapor , congeladas e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20087010', 'description' => 'Pessegos prepars/conserv.em agua edulcorada,incl.xarope', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20087020', 'description' => 'Pessegos em polpa com valor brix igual ou superior a 20', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20087090', 'description' => 'Pessegos preparados ou conservados de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20087090', 'description' => 'Pessegos preparados ou conservados de out.modo, cozidos  exceto em água e vapor , congelados e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20088000', 'description' => 'Morangos preparados ou conservados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20088000', 'description' => 'Morangos, cozidos  exceto em água e vapor , congelados e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20089100', 'description' => 'Palmitos preparados ou conservados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20089300', 'description' => 'Airelas vermelhas (…) prepars/ conservs. out. modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20089300', 'description' => 'Airelas vermelhas  Vaccinium macrocarpon, Vaccinium oxycoccos, Vaccinium vitis-idaea, cozidas  exceto em água e vapor , congeladas e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20089710', 'description' => 'Misturas de frutas preparadas,conservs.em agua edulcora, inclusive xaropes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20089790', 'description' => 'Misturas de frutas preparadas,conservadas de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20089790', 'description' => 'Misturas de frutas preparadas,conservadas de out.modo, cozidas  exceto em água e vapor , congeladas e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20089900', 'description' => 'Outs.frutas,partes de plantas,prepars/ conservs.out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20089900', 'description' => 'Outs.frutas,partes de plantas,prepars/ conservs.out.modo, cozidas  exceto em água e vapor , congeladas e sem adição de açúcar ou de outros edulcorantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20091100', 'description' => 'Sucos de laranjas,congelados,nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20091200', 'description' => 'Sucos de laranjas,não congelados,com valor brix =<20', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20091900', 'description' => 'Outros sucos de laranjas,nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20092100', 'description' => 'Sucos de pomelos (grapefruit),com valor brix =<20', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20092900', 'description' => 'Outs sucos de pomelos (grapefruit),nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20093100', 'description' => 'Sucos de outs.citricos,com valor brix =<20', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20093900', 'description' => 'Outs sucos de outs.citricos,nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20094100', 'description' => 'Sucos de abacaxis (ananases),com valor brix =<20', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20094900', 'description' => 'Outs sucos de abacaxis (ananases),nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20095000', 'description' => 'Sucos de tomates,nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '20096100', 'description' => 'Sucos de uvas (incl.os mostos de uvas), com valor brix =<20', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20096900', 'description' => 'Outs sucos de uvas (incl.os mostos de uvas),nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20097100', 'description' => 'Sucos de macas,com valor brix =<20', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20097900', 'description' => 'Outs sucos de macas,nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20098100', 'description' => 'Sucos de airelas vermelhas (...),nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20098911', 'description' => 'Suco (sumo), de pêssego, com valor Brix igual ou superior a 60', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20098912', 'description' => 'Suco (sumo), de acerola (Malpighia spp.)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20098913', 'description' => 'Suco (sumo), de maracujá (Passiflora edulis)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20098919', 'description' => 'Suco (sumo), outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20098921', 'description' => 'Agua de coco (Cocos nucifera) com valor Brix não superior a 7,4', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20098922', 'description' => 'Agua de coco (Cocos nucifera) com valor Brix superior a 7,4', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20098990', 'description' => 'Sucos (sumo) de outras frutas,n/fermen. s/adicao de acu.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '20099000', 'description' => 'Misturas de sucos,nao fermentados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21011110', 'description' => 'Cafe soluvel,mesmo descafeinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21011190', 'description' => 'Outros extratos,essencias e concentrados,de cafe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21011200', 'description' => 'Prepars.a base de extratos,essencias, concentrad. de cafe', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21012010', 'description' => 'Extratos,essencias,concentrados e suas prepars.de cha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21012020', 'description' => 'Extratos,essencias,concentrados e suas prepars.de mate', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21013000', 'description' => 'Chicoria torrada,outs.sucedaneos torrados do cafe,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21021010', 'description' => 'Saccharomyces boulardii', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21021090', 'description' => 'Outras leveduras vivas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21022000', 'description' => 'Leveduras mortas,outs.microorgans. monocelulares mortos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21022000', 'description' => 'Leveduras mortas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21023000', 'description' => 'Pos para levedar,preparados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21031010', 'description' => 'Molhos de soja,preparados,embalagens imediatas,p<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21031090', 'description' => 'Outros molhos de soja,preparados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21032010', 'description' => 'Ketchup e outs.molhos tomate, prepar. embal.imed.p<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21032090', 'description' => 'Outs.ketchup e outs.molhos de tomate, preparados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21033010', 'description' => 'Farinha de mostarda', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21033021', 'description' => 'Mostarda preparada,em embalagens imediatas,peso<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21033029', 'description' => 'Outros mostardas preparadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21039011', 'description' => 'Maionese em embalagens imediatas,peso<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21039019', 'description' => 'Outros maioneses', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21039021', 'description' => 'Condimentos e temperos,compostos, embalag.imediat.p<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21039029', 'description' => 'Outros condimentos e temperos,compostos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21039091', 'description' => 'Outs.prepars.p/molhos,molhos prepars.embal. imed.p<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21039099', 'description' => 'Outros preparacoes para molhos e molhos preparados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21041011', 'description' => 'Preparacoes p/caldos e sopas,embalags. imediatas,p<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21041019', 'description' => 'Outros preparacoes para caldos e sopas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21041021', 'description' => 'Caldos e sopas,preparados,embalagens imediatas,p<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21041029', 'description' => 'Outros caldos e sopas,preparados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21042000', 'description' => 'Preparacoes alimenticias compostas, homogeneizadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21050010', 'description' => 'Sorvetes,mesmo contendo cacau,embalags. imediatas,p<=2kg', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21050090', 'description' => 'Outros sorvetes,mesmo contendo cacau', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21061000', 'description' => 'Concentrados de proteinas,substs.proteicas texturizadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069010', 'description' => 'Outros preparacoes para elaboracao de bebidas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069010', 'description' => 'Preparações compostas, não alcoólicas  extratos concentrados ou sabores concentrados , para elaboração de bebida da posição 22.02, com capacidade de diluição superior a 10 partes da bebida para cada parte do concentrado', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069010', 'description' => 'Preparações compostas, não alcoólicas  extratos concentrados  ou sabores concentrados , para elaboração de bebida refrigerante do Capítulo 22, com capacidade de diluição  de até 10 partes da bebida para cada parte do concentrado', 'aliquota_federal' => 17.30, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069021', 'description' => 'Pos p/preparacoes de pudins,embalagens imediatas,p<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069029', 'description' => 'Pos p/prepars.de cremes,sorvetes, gelatinas, flans,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069030', 'description' => 'Complementos alimentares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069040', 'description' => 'Misturas a base de ascorbato sodio,glucose, p/embutidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069050', 'description' => 'Gomas de mascar, sem açucar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '21069060', 'description' => 'Caramelos, confeitos, pastilhas e produtos semelhantes, sem açucar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '21069090', 'description' => 'Outros preparacoes alimenticias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22011000', 'description' => 'Agua mineral/gaseif.n/adicion.acucar, n/aromatizada,etc.', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22011000', 'description' => 'Águas minerais naturais comercializadas em recipientes com capacidade nominal inferior a 10  dez  litros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22011000', 'description' => 'Águas minerais naturais comercializadas em recipientes com capacidade nominal igual ou superior a 10  dez  litros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22019000', 'description' => 'Outs.aguas,s/acucar,n/aromatizadas,etc.gelo e neve', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22021000', 'description' => 'Agua incl.mineral/gaseif.adicion.acucar, aromatizada,etc', 'aliquota_federal' => 14.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22021000', 'description' => 'Refrescos', 'aliquota_federal' => 14.76, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22029100', 'description' => 'Cerveja sem alcool', 'aliquota_federal' => 19.11, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22029900', 'description' => 'Outras', 'aliquota_federal' => 5.44, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22029900', 'description' => 'Outras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22029900', 'description' => 'Outras', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22029900', 'description' => 'Outras', 'aliquota_federal' => 14.69, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22029900', 'description' => 'Outras', 'aliquota_federal' => 14.69, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22030000', 'description' => 'Cervejas de malte', 'aliquota_federal' => 19.11, 'aliquota_estadual' => 22.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22030000', 'description' => 'Chope', 'aliquota_federal' => 19.11, 'aliquota_estadual' => 22.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22041010', 'description' => 'Vinhos de uvas frescas,tipo champanha (champagne)', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22041090', 'description' => 'Outs.vinhos de uvas frescas,espumantes e espumosos', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042100', 'description' => 'Outs.vinhos,mostos de uvas,ferm.imped. alcool,recips<=2l', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042100', 'description' => 'Vinhos da madeira, do porto e de xerez', 'aliquota_federal' => 10.02, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042211', 'description' => 'Em recipientes de capacidade nao superior a 5 l', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042211', 'description' => 'Em recipientes de capacidade nao superior a 5 l', 'aliquota_federal' => 10.02, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042219', 'description' => 'Outros', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042219', 'description' => 'Outros', 'aliquota_federal' => 10.02, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042220', 'description' => 'Mostos', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042910', 'description' => 'Vinhos', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042910', 'description' => 'Vinhos', 'aliquota_federal' => 10.02, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22042920', 'description' => 'Mostos', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22043000', 'description' => 'Outros mostos de uvas', 'aliquota_federal' => 7.37, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22051000', 'description' => 'Vermutes,outs.vinhos uvas frescas, aromatizs.recips<=2l', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22059000', 'description' => 'Outs.vermutes e vinhos de uvas frescas, aromatizados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22060010', 'description' => 'Sidra', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22060090', 'description' => 'Outs.bebidas fermentadas e misturas de bebidas ferments', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22060090', 'description' => 'Outs.bebidas fermentadas e misturas de bebidas ferments, com teor alcoólico superior a 14%', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22071010', 'description' => 'Alcool etilico n/desnaturado, c/vol.teor alcoolico>=80%, c/teor agua <= 1% vol', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22071010', 'description' => 'Para fins carburantes, com as especificações determinadas pela ANP', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22071010', 'description' => 'Retificado  álcool neutro ', 'aliquota_federal' => 17.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22071090', 'description' => 'Outros alcool etilico n/desnaturado', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22071090', 'description' => 'Para fins carburantes, com as especificações determinadas pela ANP', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22071090', 'description' => 'Retificado  álcool neutro ', 'aliquota_federal' => 17.48, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22072011', 'description' => 'Alcool etilico desnaturado c/qq.teor alcoolico,  c/ teor agua <= 1% volume', 'aliquota_federal' => 17.48, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22072011', 'description' => 'Para fins carburantes, com as especificações determinadas pela ANP', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22072019', 'description' => 'Alcool etilico desnaturado c/qq.teor alcoolico', 'aliquota_federal' => 17.48, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22072019', 'description' => 'Para fins carburantes, com as especificações determinadas pela ANP', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22072020', 'description' => 'Aguardente desnaturado com qualquer teor alcoolico', 'aliquota_federal' => 8.23, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22082000', 'description' => 'Aguardente de vinho ou de bagaco de uvas', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22083010', 'description' => 'Uisques,vol.teor alcoolico>50%,recips. capac>=50 litros', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22083020', 'description' => 'Uisques,embalagens de capacidade<=2 litros', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22083090', 'description' => 'Outros uisques', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22084000', 'description' => 'Rum e outras aguardentes provenientes da destilação, após fermentação, de produtos da cana-de-açúcar', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22084000', 'description' => 'Rum e outras aguardentes obtidas do melaço da cana', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22085000', 'description' => 'Gim e genebra', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22086000', 'description' => 'Vodca', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '22087000', 'description' => 'Licores', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22089000', 'description' => 'Outros bebidas alcoolicas', 'aliquota_federal' => 16.77, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22089000', 'description' => 'Álcool etílico', 'aliquota_federal' => 17.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22089000', 'description' => 'Bebida refrescante com teor alcoólico inferior a 8%', 'aliquota_federal' => 13.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '22090000', 'description' => 'Vinagres e sucedan.obtidos acid.acetico,p/uso alimentar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23011010', 'description' => 'Farinhas,pos e pellets de carne,impropr. p/alim.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23011090', 'description' => 'Farinhas de miudezas,improprs.p/alim.humana e torresmos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23012010', 'description' => 'Farinhas,pos,pellets de peixes,improprs. p/alim.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23012090', 'description' => 'Farinhas,pos,de crustaceos,etc.improprs. p/alim.humana', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23021000', 'description' => 'Semeas,farelos e outs.residuos,de milho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23023010', 'description' => 'Farelo de trigo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23023090', 'description' => 'Semeas e outs.residuos,de trigo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23024000', 'description' => 'Semeas,farelos e outs.residuos,de outs.cereais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23025000', 'description' => 'Semeas,farelos e outs.residuos,de leguminosas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23031000', 'description' => 'Residuos da fabricacao do amido e residuos semelhantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23032000', 'description' => 'Polpas e bagacos e outs.derperdicios da ind.do acucar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23033000', 'description' => 'Borras e desperds.da ind.da cerveja e das destilarias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23040010', 'description' => 'Farinhas e pellets,da soja', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23040090', 'description' => 'Bagacos e outs.residuos solidos,da extr.do oleo de soja', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23050000', 'description' => 'Tortas e outs.residuos solidos,do amendoim', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23061000', 'description' => 'Tortas e outs.residuos solidos,do algodao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23062000', 'description' => 'Tortas e outs.residuos solidos,da linhaca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23063010', 'description' => 'Tortas,farinhas e pellets,do girassol', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23063090', 'description' => 'Outros residuos solidos,do girassol', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23064100', 'description' => 'Tortas,outs.resids.solidos,do nabo silvestre,da colza, com baixo teor de acido erucico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23064900', 'description' => 'Outs tortas,outs.resids.solidos,do nabo silvestre,da colza', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23065000', 'description' => 'Tortas e outs.residuos solidos,do coco ou da copra', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23066000', 'description' => 'Tortas e outs.resids.solidos,de nozes ou de palmiste', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23069010', 'description' => 'Tortas e outs.residuos solidos,do germe de milho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23069090', 'description' => 'Outs.tortas,resids.solids.da extr.gordura/ oleos vegets.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23070000', 'description' => 'Borras de vinho e tartaro em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23080000', 'description' => 'Materias,desperdicios,resids.etc.vegetais,p/alim.animal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23091000', 'description' => 'Alimentos para caes e gatos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099010', 'description' => 'Alimentos compostos completos,para animais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099010', 'description' => 'Alimentos compostos completos,para animais', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099020', 'description' => 'Preparacoes a base de sal iodado,etc. p/aliment.animal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099030', 'description' => 'Bolachas e biscoitos,para alimentacao de animais', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099040', 'description' => 'Preparacoes cont.diclazuril,p/alimentacao de animais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099050', 'description' => 'Preparações com teor de cloridrato de ractopamina igual ou superior a 2%, em peso, com suporte de farelo de soja', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099060', 'description' => 'Preparações contendo xilanase e betagluconase, com suporte de farinha de trigo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099060', 'description' => 'Preparações alimentícias para cães ou gatos, não acondicionadas para a venda a retalho', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099090', 'description' => 'Outros preparacoes para alimentacao de animais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '23099090', 'description' => 'Outras preparações alimentícias para cães ou gatos, não acondicionadas para a venda a retalho', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24011010', 'description' => 'Fumo n/manufat.n/destalado,em folhas, s/secar,n/ferment.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24011020', 'description' => 'Fumo n/manufat.n/destal.em fls.secas,etc.tipo capeiro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24011030', 'description' => 'Fumo n/manufat.n/destal.em fls.secas,etc.tipo virginia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24011040', 'description' => 'Fumo n/manufat.n/destal.em fls.secas,etc.tipo turco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24011090', 'description' => 'Outros fumos nao manufaturados,nao destalados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24012010', 'description' => 'Fumo n/manuf.total/parc.destal.em fls.s/secar, n/fermen.', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24012020', 'description' => 'Fumo n/manuf.total/parc.destal.fls. secas, fermen.capeiro', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24012030', 'description' => 'Fumo n/manuf.total/parc.destal.fls.secas, etc.virginia', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24012040', 'description' => 'Fumo n/manuf.total/parc.destal.fls.secas,tipo burley', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24012090', 'description' => 'Outs.fumos nao manufaturados,total/parcialm. destalados', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '24013000', 'description' => 'Desperdicios de fumo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24021000', 'description' => 'Charutos e cigarrilhas,de fumo', 'aliquota_federal' => 30.93, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24021000', 'description' => 'Cigarrillhas', 'aliquota_federal' => 38.88, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24022000', 'description' => 'Cigarros de fumo', 'aliquota_federal' => 38.88, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24022000', 'description' => 'Cigarros de fumo, feitos à mão', 'aliquota_federal' => 30.93, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24029000', 'description' => 'Charutos,cigarrilhas e cigarros,de sucedaneos do fumo', 'aliquota_federal' => 30.93, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24029000', 'description' => 'Cigarros não contendo tabaco, exceto os feitos à mão', 'aliquota_federal' => 38.88, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24031100', 'description' => 'Tabaco para narguilé (cachimbo de água) mencionado na nota 1 de subposição do presente capítulo', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24031900', 'description' => 'Tabaco manufaturado,p/fumar,mesmo cont.sucedaneos do tabaco', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24039100', 'description' => 'Tabaco manufaturado,homogeneizado ou reconstituido', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24039910', 'description' => 'Extratos e molhos,de tabaco', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '24039990', 'description' => 'Outs.produtos do tabaco e seus sucedaneos, manufaturados', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 32.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25010011', 'description' => 'Sal marinho ( nve )', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25010019', 'description' => 'Outros tipos de sal a granel,sem agregados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25010020', 'description' => 'Sal de mesa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25010090', 'description' => 'Outs.tipos de sal,cloreto de sodio puro e agua do mar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25010090', 'description' => 'Cloreto de sódio puro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25020000', 'description' => 'Piritas de ferro nao ustuladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25030010', 'description' => 'Enxofre a granel,exc.sublimado,precipitado ou coloidal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25030010', 'description' => 'Em bruto ou não refinado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25030090', 'description' => 'Outs.formas de enxofre,exc.sublimado, precipit.coloidal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25041000', 'description' => 'Grafita natural em po ou em escamas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25049000', 'description' => 'Outros formas de grafita natural', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25051000', 'description' => 'Areias siliciosas e areias quartzosas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25059000', 'description' => 'Outros areias naturais,mesmo coradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25061000', 'description' => 'Quartzo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25062000', 'description' => 'Quartzitos em bruto ou desbastados, cortado à serra ou outro meio, em bloco ou placa, de forma quadrada, retangular ...', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25070010', 'description' => 'Caulim', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25070090', 'description' => 'Outros argilas caulinicas,mesmo calcinadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25081000', 'description' => 'Bentonita', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25083000', 'description' => 'Argilas refratarias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25084010', 'description' => 'Argilas plasticas,teor de f2o3<1.5%,perda p/calcin>12%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25084090', 'description' => 'Outros argilas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25085000', 'description' => 'Andaluzita,cianita e silimanita', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25086000', 'description' => 'Mulita', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25087000', 'description' => 'Barro cozido em po (terra chamotte) e terra de dinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25090000', 'description' => 'Cre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25101010', 'description' => 'Fosfatos de calcio,naturais,nao moidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25101090', 'description' => 'Fosfatos aluminocalcicos,naturs.cre-fosfatado,n/moidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25102010', 'description' => 'Fosfatos de calcio,naturais,moidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25102090', 'description' => 'Fosfatos aluminocalcicos,naturais,cre-fosfatado,moidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25111000', 'description' => 'Sulfato de bario natural (baritina)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25112000', 'description' => 'Carbonato de bario natural (witherita)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25120000', 'description' => 'Farinhas siliciosas fosseis,outs.terras siliciosas,d<=1', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25131000', 'description' => 'Pedras-pomes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25132000', 'description' => 'Esmeril,corindo/granada naturais,outs.abrasivos naturs.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25140000', 'description' => 'Ardosia incl.desbastada ou cortada em blocos ou placas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25151100', 'description' => 'Marmores e travertinos,em bruto ou desbastados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25151210', 'description' => 'Marmores cortados em blocos ou placas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25151220', 'description' => 'Travertinos cortados em blocos ou placas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25152000', 'description' => 'Granitos belgas,outs.pedras calcarias de cantaria,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25161100', 'description' => 'Granito em bruto ou desbastado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25161200', 'description' => 'Granito cortado em blocos ou placas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '25162000', 'description' => 'Arenito em bruto ou desbastados, cortado à serra ou outro meio, em bloco ou placa, de forma quadrada, retangular ...', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25169000', 'description' => 'Outros pedras de cantaria ou de construcao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25171000', 'description' => 'Calhaus,cascalhos e pedras britadas,para concreto,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25172000', 'description' => 'Macadame de escorias de altos-fornos,outs.escorias,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25173000', 'description' => 'Tarmacadame', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25174100', 'description' => 'Granulos,lascas e pos,de marmore', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25174900', 'description' => 'Granulos,lascas e pos,granito e outs.pedras de cantaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25181000', 'description' => 'Dolomita nao calcinada nem sinterizada,crua', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25182000', 'description' => 'Dolomita calcinada ou sinterizada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25183000', 'description' => 'Aglomerados de dolomita', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25191000', 'description' => 'Carbonato de magnesio natural (magnesita)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25199010', 'description' => 'Magnesia eletrofundida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25199090', 'description' => 'Magnesia calcinada a fundo e outs.oxidos de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25201011', 'description' => 'Gipsita em pedacos irregulares (pedras)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25201019', 'description' => 'Outros formas de gipsitas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25201020', 'description' => 'Anidrita', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25202010', 'description' => 'Gesso moido,apto para uso odontologico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25202090', 'description' => 'Outros formas de gesso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25210000', 'description' => 'Castinas,pedras calcarias p/fabr.de cal ou de cimento', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25221000', 'description' => 'Cal viva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25222000', 'description' => 'Cal apagada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25223000', 'description' => 'Cal hidraulica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25231000', 'description' => 'Cimentos nao pulverizados (clinkers)', 'aliquota_federal' => 6.91, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25232100', 'description' => 'Cimentos portland,brancos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25232910', 'description' => 'Cimentos portland,comuns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25232990', 'description' => 'Outros tips de cimento portland', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25233000', 'description' => 'Cimentos aluminosos', 'aliquota_federal' => 6.91, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25239000', 'description' => 'Outros cimentos hidraulicos', 'aliquota_federal' => 6.91, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25241000', 'description' => 'Crocidolita', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25249000', 'description' => 'Outros amiantos (arbesto)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25251000', 'description' => 'Mica em bruto ou clivada em folhas,lamelas irregulares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25252000', 'description' => 'Mica em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25253000', 'description' => 'Desperdicios de mica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25261000', 'description' => 'Esteatita natural,nao triturada nem em po', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25262000', 'description' => 'Esteatita natural,triturada ou em po e talco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25280000', 'description' => 'Boratos naturais e seus concentrados (calcinados ou não), exceto boratos extraídos de salmouras naturais, ácido bórico natural com um teor máximo de 85 % de h3bo3, em produto seco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25291000', 'description' => 'Feldspato', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25292100', 'description' => 'Espatofluor contendo peso<=97% de fluoreto de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25292200', 'description' => 'Espatofluor contendo peso>97% de fluoreto de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25293000', 'description' => 'Leucita,nefelina e nefelina-sienito', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25301010', 'description' => 'Perlita nao expandida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25301090', 'description' => 'Vermiculita e cloritas,nao expandidas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25302000', 'description' => 'Kieserita,epsomita (sulfatos de magnesio naturais)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25309010', 'description' => 'Espodumenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25309020', 'description' => 'Areias de zirconio microniz.p/prepar.de esmaltes ceram.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25309030', 'description' => 'Minerais de metais das terras raras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25309040', 'description' => 'Terras corantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '25309090', 'description' => 'Outros materias minerais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26011100', 'description' => 'Minerios de ferro nao aglomerados e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26011210', 'description' => 'Minerios de ferro e seus concentrados aglomerados por processo de peletizaçao, de diametro superior ou igual a 8mm e inferior ou igual a 18mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26011290', 'description' => 'Outros minerios de ferro aglomerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26012000', 'description' => 'Piritas de ferro ustuladas (cinzas de piritas)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26020010', 'description' => 'Minerios de manganes aglomerados e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '26020090', 'description' => 'Outros minerios de manganes aglomerados e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26030010', 'description' => 'Sulfetos de minerios de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26030090', 'description' => 'Outros minerios de cobre e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26040000', 'description' => 'Minerios de niquel e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26050000', 'description' => 'Minerios de cobalto e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26060011', 'description' => 'Bauxita nao calcinada (minerio de aluminio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26060012', 'description' => 'Bauxita calcinada (minerio de aluminio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26060090', 'description' => 'Outros minerios de aluminio e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26070000', 'description' => 'Minerios de chumbo e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26080010', 'description' => 'Sulfetos de minerios de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26080090', 'description' => 'Outros minerios de zinco e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26090000', 'description' => 'Minerios de estanho e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26100010', 'description' => 'Cromita (minerios de cromo)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26100090', 'description' => 'Outros minerios de cromo e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26110000', 'description' => 'Minerios de tungstenio e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26121000', 'description' => 'Minerios de uranio e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26122000', 'description' => 'Minerios de torio e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26131010', 'description' => 'Molibdenita ustulada (minerios de molibdenio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26131090', 'description' => 'Outs.minerios de molibdenio,ustulados,seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26139010', 'description' => 'Molibdenita nao ustulada (minerios de molibdenio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26139090', 'description' => 'Outs.minerios de molibdenio n/ustulados e concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26140010', 'description' => 'Ilmenita (minerios de titanio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26140090', 'description' => 'Outros minerios de titanio e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26151010', 'description' => 'Badeleita (minerio de zirconio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26151020', 'description' => 'Zirconita (minerio de zirconio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26151090', 'description' => 'Outros minerios de zirconio e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26159000', 'description' => 'Minerios de niobio,tantalo ou vanadio,seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26161000', 'description' => 'Minerios de prata e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26169000', 'description' => 'Minerios de outs.metais preciosos e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26171000', 'description' => 'Minerios de antimonio e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26179000', 'description' => 'Outros minerios e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26180000', 'description' => 'Escoria de altos-fornos granul.da fabr.do ferro e aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 8.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26190000', 'description' => 'Outs.escorias e desperdicios,da fabr.do ferro e aco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26201100', 'description' => 'Mates de galvanizacao (contendo zinco)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26201900', 'description' => 'Outros cinzas e residuos contendo zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26202100', 'description' => 'Lamas de gasolina contendo chumbo e lamas de compostos antidetonantes contendo chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26202900', 'description' => 'Outs cinzas e residuos contendo chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26203000', 'description' => 'Cinzas e residuos contendo cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26204000', 'description' => 'Cinzas e residuos contendo aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26206000', 'description' => 'Cinzas e residuos contendo arsenio, mercurio, talio ou suas misturas, dos tipos utilizados p/ extr. arsenio ou desses metais p/ fab. desses metais ou seus compostos quimicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26209100', 'description' => 'Outs cinzas e residuos contendo antimonio, berílio, cádmio,cromo ou suas misturas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26209910', 'description' => 'Outs cinzas e residuos contendo principalmente titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26209990', 'description' => 'Outs cinzas e residuos contendo outs.metais ou compostos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26211000', 'description' => 'Outros escorias e cinzas,incl.as cinzas de algas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26219010', 'description' => 'Cinzas de origem vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '26219090', 'description' => 'Outros escorias e cinzas,incl.as cinzas de algas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27011100', 'description' => 'Hulha antracita,nao aglomerada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27011200', 'description' => 'Hulha betuminosa,nao aglomerada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27011900', 'description' => 'Outros hulhas,mesmo em po,mas nao aglomeradas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27012000', 'description' => 'Briquetes,bolas em aglomerados,etc.obtidos da hulha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27021000', 'description' => 'Linhitas,mesmo em po,mas nao aglomeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27022000', 'description' => 'Linhitas aglomeradas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27030000', 'description' => 'Turfa,incl.aglomerada e a turfa p/cama de animais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 16.25, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '27040011', 'description' => 'Com granulometria igual ou superior a 80 mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27040012', 'description' => 'Com granulometria inferior a 80 mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27040090', 'description' => 'Semicoques de hulha,linhita ou turfa,carvao de retorta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27050000', 'description' => 'Gas de hulha,agua,etc.exc.de petroleo/ hidrocarb.gasosos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27060000', 'description' => 'Alcatroes de hulha,de linhita ou de turfa,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27071000', 'description' => 'Benzois (prods.da destilacao dos alcatroes de hulha)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27072000', 'description' => 'Toluois (prods.da destilacao dos alcatroes de hulha)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27073000', 'description' => 'Xilois (prods.da destilacao dos alcatroes de hulha)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27074000', 'description' => 'Naftaleno (prods.da destilacao dos alcatroes de hulha)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27075010', 'description' => 'Misturas que contenham trimetilbenzenos e etiltoluenos, como componentes majoritários', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27075090', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27079100', 'description' => 'Oleos de creosoto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27079910', 'description' => 'Cresois (isomeros fenolicos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27079990', 'description' => 'Outs.oleos e prods.da destil.dos alcatroes da hulha,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27081000', 'description' => 'Breu obtido de alcatroes minerais', 'aliquota_federal' => 6.04, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27082000', 'description' => 'Coque de breu obtido de alcatroes minerais', 'aliquota_federal' => 6.04, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27090010', 'description' => 'Oleos brutos de petroleo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27090090', 'description' => 'Oleos brutos de minerais betuminosos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101210', 'description' => 'Hexano comercial', 'aliquota_federal' => 7.07, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101221', 'description' => 'Diisobutileno (mistura de alquilidenos)', 'aliquota_federal' => 7.07, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101229', 'description' => 'Outros misturas de alquilidenos', 'aliquota_federal' => 7.07, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101230', 'description' => 'Aguarras mineral (white spirit)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101241', 'description' => 'Naftas para petroquimica (que possa servir a formulação de gasolina ou diesel)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101249', 'description' => 'Outras naftas, exceto para petroquímica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101251', 'description' => 'Gasolinas de aviacao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101259', 'description' => 'Outros gasolinas, exceto para aviação', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101260', 'description' => 'Mistura de hidrocarbonetos acíclicos e cíclicos, saturados, derivados de frações de petróleo, contendo em peso, menos de 2%, de hidrocarbonetos aromáticos, cuja curva de destilação, segundo o método astm d 86, apresenta um ponto inicial mínimo de 70ºc e u', 'aliquota_federal' => 7.07, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101290', 'description' => 'Outs.oleos de leves e preparações', 'aliquota_federal' => 7.07, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101290', 'description' => 'Óleos parcialmente refinados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101290', 'description' => 'Óleos para lamparina de mecha  “signal-oil” ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101911', 'description' => 'Querosenes de aviacao', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101919', 'description' => 'Outros querosenes - iso-parafina, normal parafina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101921', 'description' => 'Gasoleo (oleo diesel)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101922', 'description' => 'Fuel-oil (oleo combustivel)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101929', 'description' => 'Outros oleos combustiveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101931', 'description' => 'Oleos lubrificantes sem aditivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101932', 'description' => 'Oleos lubrificantes com aditivos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101991', 'description' => 'Oleos minerais brancos (oleos de vaselina ou parafina)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101992', 'description' => 'Liquidos para transmissoes hidraulicas', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101993', 'description' => 'Oleos para isolamento eletrico', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101994', 'description' => 'Mistura de hidrocarbonetos acíclicos e cíclicos, saturados, derivados de frações de petróleo, contendo, em peso, menos de 2%, de hidrocarbonetos aromáticos, que destila, segundo o método astm d 86,  uma fração inferior a 90%, em volume, a 210ºc com um pon', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101999', 'description' => 'Outs.oleos de petroleo,minerais betuminosos e prepars.', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101999', 'description' => 'Óleos parcialmente refinados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27101999', 'description' => 'Óleos para lamparina de mecha  “signal-oil” ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27102000', 'description' => 'Óleos de petróleo ou de minerais betuminosos (exceto óleos brutos) e preparações não especificadas nem compreendidas noutras posições, que contenham, como constituintes básicos, 70 % ou mais, em peso, de óleos de petróleo ou de minerais betuminosos, que c', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27102000', 'description' => 'Óleos leves e preparações, exceto óleos para lamparina de mecha  “signal-oil” ', 'aliquota_federal' => 7.07, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27109100', 'description' => 'Desperdicios de oleos contendo difenilas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27109900', 'description' => 'Outros desperdicios de oleos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27111100', 'description' => 'Gas natural,liquefeito', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 15.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27111210', 'description' => 'Propano bruto', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27111290', 'description' => 'Outros propanos liquefeitos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27111300', 'description' => 'Butanos liquefeitos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27111400', 'description' => 'Etileno,propileno,butileno e butadieno,liquefeitos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '27111910', 'description' => 'Gas liquefeito de petroleo (glp)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27111990', 'description' => 'Outs.gases liquefeitos de hidrocarbonetos gasosos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27112100', 'description' => 'Gas natural no estado gasoso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 15.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27112910', 'description' => 'Butanos no estado gasoso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27112990', 'description' => 'Outs.hidrocarb.gasosos e gas petroleo,no estado gasoso', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27121000', 'description' => 'Vaselina', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27122000', 'description' => 'Parafina contendo peso<0.75% de oleo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27129000', 'description' => 'Cera de petroleo microcristalina,ceras minerais,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27131100', 'description' => 'Coque de petroleo nao calcinado', 'aliquota_federal' => 5.69, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27131200', 'description' => 'Coque de petroleo calcinado', 'aliquota_federal' => 5.69, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27132000', 'description' => 'Betume de petroleo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27139000', 'description' => 'Outs.resids.dos oleos de petroleo,minerais betuminosos', 'aliquota_federal' => 5.69, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27141000', 'description' => 'Xistos e areias betuminosos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27149000', 'description' => 'Betumes,asfaltos naturais,asfaltitas,rocha alfalticas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27150000', 'description' => 'Misturas betuminosas a base de asfalto,de betumes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '27160000', 'description' => 'Energia eletrica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28011000', 'description' => 'Cloro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28012010', 'description' => 'Iodo sublimado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28012090', 'description' => 'Outros formas de iodo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28013000', 'description' => 'Fluor e bromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28020000', 'description' => 'Enxofre sublimado ou precipitado e enxofre coloidal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28030011', 'description' => 'Negros de acetileno (negros de carbono)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28030019', 'description' => 'Outros negros de carbono', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28030090', 'description' => 'Outros formas de carbono', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28041000', 'description' => 'Hidrogenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28042100', 'description' => 'Argonio (gases raros)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28042910', 'description' => 'Helio liquido (gases raros)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28042990', 'description' => 'Outros gases raros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28043000', 'description' => 'Nitrogenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28044000', 'description' => 'Oxigenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28045000', 'description' => 'Boro e telurio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28046100', 'description' => 'Silicio contendo em peso>=99.99% de silicio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28046900', 'description' => 'Outros silicios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28047010', 'description' => 'Fosforo branco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28047020', 'description' => 'Fosforo vermelho ou amorfo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28047030', 'description' => 'Fosforo negro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28048000', 'description' => 'Arsenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28049000', 'description' => 'Selenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28051100', 'description' => 'Sodio (metal alcalino)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28051200', 'description' => 'Calcio (metal alcalino terroso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28051910', 'description' => 'Estroncio (metal alcalino terroso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28051920', 'description' => 'Bario (metal alcalino terroso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28051990', 'description' => 'Outros metais alcalinos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28053010', 'description' => 'Liga de cerio com peso<=5% de ferro (mischmetal)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28053090', 'description' => 'Outros metais de terras raras,escandio e itrio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28054000', 'description' => 'Mercurio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28061010', 'description' => 'Cloreto de hidrogenio (ac.cloridrico),gasoso,liquefeito', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28061020', 'description' => 'Cloreto de hidrogenio (ac.cloridrico),em solucao aquosa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28062000', 'description' => 'Acido clorossulfurico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28070010', 'description' => 'Acido sulfurico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28070020', 'description' => 'Oleum (acido sulfurico fumante)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28080010', 'description' => 'Acido nitrico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28080020', 'description' => 'Acido sulfonitrico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '28091000', 'description' => 'Pentoxido de difosforo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28092011', 'description' => 'Acido fosforico com teor de ferro < 750 ppm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28092019', 'description' => 'Outros acidos fosforicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28092020', 'description' => 'Acido metafosforico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28092030', 'description' => 'Acido pirofosforico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28092090', 'description' => 'Outros acidos polifosforicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28100010', 'description' => 'Acido ortoborico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28100090', 'description' => 'Oxidos de boro e outs.acidos boricos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28111100', 'description' => 'Fluoreto de hidrogenio (acido fluoridrico)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28111200', 'description' => 'Cianeto de hidrogenio (acido cianidrico ou acido hidrocianico)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28111910', 'description' => 'Acido aminossulfonico (acido sulfamico)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28111920', 'description' => 'Acido fosfonico (acido fosforoso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28111930', 'description' => 'Acido perclorico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28111940', 'description' => 'Fluoracidos e outs.compostos de fluor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28111990', 'description' => 'Outros acidos inorganicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28112100', 'description' => 'Dioxido de carbono', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28112210', 'description' => 'Dioxido de silicio obtido por precipitacao quimica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28112220', 'description' => 'Dioxido de silicio tipo aerogel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28112230', 'description' => 'Gel de silica (dioxido de silicio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28112290', 'description' => 'Outros dioxidos de silicio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28112910', 'description' => 'Dioxido de enxofre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28112990', 'description' => 'Outs.compostos oxigen.inorgan.dos elementos n/metalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121100', 'description' => 'Dicloreto de carbonila (fosgenio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121200', 'description' => 'Oxicloreto de fosforo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121300', 'description' => 'Tricloreto de fosforo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121400', 'description' => 'Pentacloreto de fosforo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121500', 'description' => 'Monocloreto de enxofre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121600', 'description' => 'Dicloreto de enxofre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121700', 'description' => 'Cloreto de tionila', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121911', 'description' => 'Tricloreto de arsenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121919', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28121920', 'description' => 'Oxicloretos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28129000', 'description' => 'Outs.halogenetos,oxialogenetos dos elem.n/metalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28131000', 'description' => 'Dissulfeto de carbono', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28139010', 'description' => 'Pentassulfeto de difosforo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28139090', 'description' => 'Outs.sulfetos dos elem.n/metals.e trissulf.fosforo com.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28141000', 'description' => 'Amoniaco anidro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28142000', 'description' => 'Amoniaco em solucao aquosa (amonia)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28151100', 'description' => 'Hidroxido de sodio (soda caustica) solido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28151200', 'description' => 'Hidroxido de sodio em sol.aquosa (lixivia soda caustica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28152000', 'description' => 'Hidroxido de potassio (potassa caustica)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28153000', 'description' => 'Peroxidos de sodio ou de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28161010', 'description' => 'Hidroxido de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28161020', 'description' => 'Peroxido de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28164010', 'description' => 'Hidroxido de bario', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28164090', 'description' => 'Oxido,hidroxido e peroxido de estroncio ou de bario', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28170010', 'description' => 'Oxido de zinco (branco de zinco)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28170020', 'description' => 'Peroxido de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28181010', 'description' => 'Corindo artificial,branco,de granulometria<=63 microns', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28181090', 'description' => 'Outs.corindos artificiais,quimicamente definido ou nao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28182010', 'description' => 'Alumina calcinada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28182090', 'description' => 'Outros oxidos de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28183000', 'description' => 'Hidroxido de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '28191000', 'description' => 'Trioxido de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28199010', 'description' => 'Oxidos de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28199020', 'description' => 'Hidroxidos de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28201000', 'description' => 'Dioxido de manganes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28209010', 'description' => 'Oxido manganoso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28209020', 'description' => 'Trioxido de dimanganes (sesquioxido de manganes)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28209030', 'description' => 'Tetraoxido de trimanganes (oxido salino de manganes)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28209040', 'description' => 'Heptaoxido de dimanganes (anidrido permanganico)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28211011', 'description' => 'Oxido ferrico com teor em peso>=85% de fe2o3', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28211019', 'description' => 'Outros oxidos ferricos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28211020', 'description' => 'Oxido ferroso-ferrico (oxido magnetico de ferro)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28211030', 'description' => 'Hidroxidos de ferro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28211090', 'description' => 'Outros oxidos de ferro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28212000', 'description' => 'Terras corantes,peso>=70% de ferro combinado,em fe2o3', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28220010', 'description' => 'Tetraoxido de tricobalto (oxido salino de cobalto)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28220090', 'description' => 'Outs.oxidos e hidroxidos de cobalto,incl.os comerciais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28230010', 'description' => 'Oxidos de titanio,tipo anatase', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28230090', 'description' => 'Outros oxidos de titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28241000', 'description' => 'Monoxido de chumbo (litargirio,massicote)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28249010', 'description' => 'Minio (zarcao) e minio-laranja (mine-orange)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28249090', 'description' => 'Outros oxidos de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28251010', 'description' => 'Hidrazina e seus sais inorganicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28251020', 'description' => 'Hidroxilamina e seus sais inorganicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28252010', 'description' => 'Oxido de litio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28252020', 'description' => 'Hidroxido de litio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28253010', 'description' => 'Pentoxido de divanadio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28253090', 'description' => 'Outros oxidos e hidroxidos de vanadio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28254010', 'description' => 'Oxido niqueloso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28254090', 'description' => 'Outros oxidos e hidroxidos de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28255010', 'description' => 'Oxido cuprico,com teor de cuo>=98%,em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28255090', 'description' => 'Outros oxidos e hidroxidos de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28256010', 'description' => 'Oxidos de germanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28256020', 'description' => 'Dioxido de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28257010', 'description' => 'Trioxido de molibdenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28257090', 'description' => 'Outros oxidos e hidroxidos de molibdenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28258010', 'description' => 'Trioxido de antimonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28258090', 'description' => 'Outros oxidos de antimonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28259010', 'description' => 'Oxido de cadmio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28259020', 'description' => 'Trioxido de tungstenio (volframio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28259090', 'description' => 'Oxidos,hidroxidos e peroxidos de outs.metais,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28261200', 'description' => 'Fluoretos de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28261910', 'description' => 'Trifluoreto de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28261920', 'description' => 'Fluoreto acido de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28261990', 'description' => 'Outros fluoretos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28263000', 'description' => 'Hexafluoraluminato de sodio (criolita sintetica)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28269010', 'description' => 'Fluoraluminato de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28269020', 'description' => 'Fluossilicatos de sodio ou de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28269090', 'description' => 'Outs.fluossilicatos,fluoraluminatos,sais complexs.fluor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28271000', 'description' => 'Cloreto de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28272010', 'description' => 'Cloreto de calcio,com teor>=98% de cacl2,em base seca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28272090', 'description' => 'Outros cloretos de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273110', 'description' => 'Cloreto de magnesio,com teor<98% mgcl2 e teor<=0.5% ca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273190', 'description' => 'Outros cloretos de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '28273200', 'description' => 'Cloreto de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273500', 'description' => 'Cloreto de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273910', 'description' => 'Cloreto de cobre i (cloreto cuproso,monocloreto cobre)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273920', 'description' => 'Cloreto de titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273940', 'description' => 'Cloreto de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273950', 'description' => 'Cloreto de antimonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273960', 'description' => 'Cloreto de litio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273970', 'description' => 'Cloreto de bismuto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273991', 'description' => 'Cloreto de cadmio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273992', 'description' => 'Cloreto de cesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273993', 'description' => 'Cloreto de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273994', 'description' => 'Cloreto de estroncio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273995', 'description' => 'Cloreto de manganes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273996', 'description' => 'Cloreto de ferro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273997', 'description' => 'Cloreto de cobalto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273998', 'description' => 'Cloreto de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28273999', 'description' => 'Outros cloretos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28274110', 'description' => 'Oxicloretos de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28274120', 'description' => 'Hidroxicloretos de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28274911', 'description' => 'Oxicloretos de bismuto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28274912', 'description' => 'Oxicloretos de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28274919', 'description' => 'Outros oxicloretos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28274921', 'description' => 'Hidroxicloretos de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28274929', 'description' => 'Outros hidroxicloretos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28275100', 'description' => 'Brometos de sodio ou de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28275900', 'description' => 'Outros brometos e oxibrometos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28276011', 'description' => 'Iodetos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28276012', 'description' => 'Iodetos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28276019', 'description' => 'Outros iodetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28276021', 'description' => 'Oxiiodetos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28276029', 'description' => 'Outros oxiiodetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28281000', 'description' => 'Hipocloritos de calcio,incl.o comercial', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28289011', 'description' => 'Hipocloritos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28289019', 'description' => 'Outros hipocloritos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28289020', 'description' => 'Clorito de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28289090', 'description' => 'Outros cloritos e hipobromitos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28291100', 'description' => 'Cloratos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28291910', 'description' => 'Cloratos de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28291920', 'description' => 'Cloratos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28291990', 'description' => 'Outros cloratos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299011', 'description' => 'Bromatos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299012', 'description' => 'Bromatos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299019', 'description' => 'Outros bromatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299021', 'description' => 'Perbromatos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299022', 'description' => 'Perbromatos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299029', 'description' => 'Outros perbromatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299031', 'description' => 'Iodatos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299032', 'description' => 'Iodatos de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299039', 'description' => 'Outros iodatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299040', 'description' => 'Periodatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28299050', 'description' => 'Percloratos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28301010', 'description' => 'Sulfeto de dissodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28301020', 'description' => 'Sulfeto de monossodio (hidrogenossulfeto de sodio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '28309011', 'description' => 'Sulfetos de molibnedio iv (dissulfeto de molibdenio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28309012', 'description' => 'Sulfeto de bario', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28309013', 'description' => 'Sulfeto de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28309014', 'description' => 'Sulfeto de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28309015', 'description' => 'Sulfeto de estroncio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28309016', 'description' => 'Sulfeto de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28309019', 'description' => 'Outros sulfetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28309020', 'description' => 'Polissulfetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28311011', 'description' => 'Ditionitos (hidrossulfitos) de sodio estabilizados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28311019', 'description' => 'Outros ditionitos (hidrossulfitos) de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28311021', 'description' => 'Sulfoxilatos de sodio,estabilizados com formaldeido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28311029', 'description' => 'Outros sulfoxilatos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28319010', 'description' => 'Ditionito de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28319090', 'description' => 'Outros ditionitos e sulfoxilatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28321010', 'description' => 'Sulfito de dissodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28321090', 'description' => 'Outros sulfitos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28322000', 'description' => 'Outros sulfitos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28323010', 'description' => 'Tiossulfato de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28323020', 'description' => 'Tiossulfato de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28323090', 'description' => 'Outros tiossulfatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28331110', 'description' => 'Sulfato dissodico anidro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28331190', 'description' => 'Outros sulfatos dissodicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28331900', 'description' => 'Outros sulfatos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332100', 'description' => 'Sulfato de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332200', 'description' => 'Sulfato de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332400', 'description' => 'Sulfato de niquel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332510', 'description' => 'Sulfato cuproso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332520', 'description' => 'Sulfato cuprico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332710', 'description' => 'Sulfato de bario com teor em peso>=97.5% de baso4', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332790', 'description' => 'Outros sulfatos de bario', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332910', 'description' => 'Sulfato de antimonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332920', 'description' => 'Sulfato de litio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332930', 'description' => 'Sulfato de estroncio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332940', 'description' => 'Sulfato ferroso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332950', 'description' => 'Sulfato neutro de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332960', 'description' => 'Sulfato de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332970', 'description' => 'Sulfato de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28332990', 'description' => 'Outros sulfatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28333000', 'description' => 'Alumes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28334010', 'description' => 'Peroxossulfato (persulfato) de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28334020', 'description' => 'Peroxossulfato (persulfato) de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28334090', 'description' => 'Outros peroxossulfatos (persulfatos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28341010', 'description' => 'Nitrito de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28341090', 'description' => 'Outros nitritos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28342110', 'description' => 'Nitrato de potassio,com teor em peso<=98% de kno3', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28342190', 'description' => 'Outros nitratos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28342910', 'description' => 'Nitrato de calcio com teor em peso<=16% de nitrogenio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28342930', 'description' => 'Nitrato de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28342940', 'description' => 'Nitrato de litio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28342990', 'description' => 'Outros nitratos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28351011', 'description' => 'Fosfinato (hipofosfito) de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28351019', 'description' => 'Outros fosfinatos (hipofosfitos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28351021', 'description' => 'Fosfonato (fosfito) dibasico de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '28351029', 'description' => 'Outros fosfonatos (fosfitos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352200', 'description' => 'Fosfato mono ou dissodico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352400', 'description' => 'Fosfato de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352500', 'description' => 'Fosfato hidrogeno-ortofosfato de calcio (dicalcico)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352600', 'description' => 'Outros fosfatos de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352910', 'description' => 'Fosfato de ferro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352920', 'description' => 'Fosfato de cobalto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352930', 'description' => 'Fosfato de cobre', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352940', 'description' => 'Fosfato de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352950', 'description' => 'Fosfato de estroncio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352960', 'description' => 'Fosfato de manganes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352970', 'description' => 'Fosfato de triamonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352980', 'description' => 'Fosfato de trissodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28352990', 'description' => 'Outros fosfatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28353110', 'description' => 'Trifosfato de sodio (tripolifosfato de sodio) grau alimenticio,  de acordo com o estabelecido pela fao-oms ou pelo fcc (food chemical codex)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28353190', 'description' => 'Outros trifosfato de sodio (tripolifosfato de sodio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28353910', 'description' => 'Metafosfatos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28353920', 'description' => 'Pirofosfatos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28353930', 'description' => 'Pirofosfato de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28353990', 'description' => 'Outros polifosfatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28362010', 'description' => 'Carbonato dissodico anidro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28362090', 'description' => 'Outros carbonatos dissodicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28363000', 'description' => 'Hidrogenocarbonato (bicarbonato) de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28364000', 'description' => 'Carbonatos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28365000', 'description' => 'Carbonato de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28366010', 'description' => 'Carbonato de bario, com um teor de BaCO3 superior ou igual a 98% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28366090', 'description' => 'Carbonato de bario, outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28369100', 'description' => 'Carbonatos de litio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28369200', 'description' => 'Carbonato de estroncio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28369911', 'description' => 'Carbonato de magnesio com densidade<200kg/m3', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28369912', 'description' => 'Carbonato de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28369913', 'description' => 'Carbonatos de amonio inclusive o comercial', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28369919', 'description' => 'Outros carbonatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28369920', 'description' => 'Peroxocarbonatos (percarbonatos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28371100', 'description' => 'Cianeto e oxicianeto de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28371911', 'description' => 'Cianeto de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28371912', 'description' => 'Cianeto de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28371914', 'description' => 'Cianeto de cobre i (cianeto cuproso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28371915', 'description' => 'Cianeto de cobre ii (cianeto cuprico)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28371919', 'description' => 'Outros cianetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28371920', 'description' => 'Oxicianetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28372011', 'description' => 'Ferrocianeto de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28372012', 'description' => 'Ferrocianeto de ferro ii (ferrocianeto ferroso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28372019', 'description' => 'Outros ferrocianetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28372021', 'description' => 'Ferricianeto de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28372022', 'description' => 'Ferricianeto de ferro ii (ferricianeto ferroso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28372023', 'description' => 'Ferricianeto de ferro iii (ferricianeto ferrico)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28372029', 'description' => 'Outros ferricianetos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28372090', 'description' => 'Outros cianetos complexos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28391100', 'description' => 'Metassilicatos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28391900', 'description' => 'Outros silicatos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28399010', 'description' => 'Silicato de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28399020', 'description' => 'Silicato de aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '28399030', 'description' => 'Silicato de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28399040', 'description' => 'Silicato de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28399050', 'description' => 'Silicato de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28399090', 'description' => 'Outros silicatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28401100', 'description' => 'Tetraborato dissodico (borax refinado) anidro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28401900', 'description' => 'Outros tetraboratos dissodicos (borax refinado)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28402000', 'description' => 'Outros boratos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28403000', 'description' => 'Peroxoboratos (perboratos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28413000', 'description' => 'Dicromato de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28415011', 'description' => 'Cromato de amonio e dicromato de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28415012', 'description' => 'Cromato de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28415013', 'description' => 'Cromato de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28415014', 'description' => 'Dicromato de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28415015', 'description' => 'Cromatos de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28415016', 'description' => 'Cromatos de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28415019', 'description' => 'Outros cromatos e dicromatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28415020', 'description' => 'Peroxocromatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28416100', 'description' => 'Permanganato de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28416910', 'description' => 'Manganitos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28416920', 'description' => 'Manganatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28416930', 'description' => 'Outros permanganatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28417010', 'description' => 'Molibdato de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28417020', 'description' => 'Molibdato de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28417090', 'description' => 'Outros molibdatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28418010', 'description' => 'Tungstato (volframato) de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28418020', 'description' => 'Tungstato (volframato) de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28418090', 'description' => 'Outros tungstatos (volframatos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419011', 'description' => 'Titanato de chumbo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419012', 'description' => 'Titanatos de bario ou de bismuto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419013', 'description' => 'Titanatos de calcio ou de estroncio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419014', 'description' => 'Titanato de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419015', 'description' => 'Titanatos de lantanio ou de neodimio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419019', 'description' => 'Outros titanatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419021', 'description' => 'Ferrito de bario', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419022', 'description' => 'Ferrito de estrôncio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419029', 'description' => 'Outros ferritos e ferratos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419030', 'description' => 'Vanadatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419041', 'description' => 'Estanato de bario', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419042', 'description' => 'Estanato de bismuto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419043', 'description' => 'Estanato de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419049', 'description' => 'Outros estanatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419050', 'description' => 'Plumbatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419060', 'description' => 'Antimoniatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419070', 'description' => 'Zincatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419081', 'description' => 'Aluminato de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419082', 'description' => 'Aluminato de magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419083', 'description' => 'Aluminato de bismuto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419089', 'description' => 'Outros aluminatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28419090', 'description' => 'Outs.sais dos acidos oxometalicos ou peroxometalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28421010', 'description' => 'Zeólitas dos tipos utilizados como trocadores de íons para tratamento de água', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28421090', 'description' => 'Outs silicatos duplos ou complexos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28429000', 'description' => 'Outros sais dos acidos ou peroxoacidos inorganicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28431000', 'description' => 'Metais preciosos no estado coloidal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '28432100', 'description' => 'Nitrato de prata', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28432910', 'description' => 'Vitelinato de prata', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28432990', 'description' => 'Outros compostos de prata', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28433010', 'description' => 'Sulfeto de ouro em dispersao de gelatina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28433090', 'description' => 'Outros compostos de ouro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28439011', 'description' => 'Dexormaplatina, enloplatina, iproplatina, lobaplatina, miboplatina, ormaplatina, sebriplatina e zeniplatina , apresentados como medicamentos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28439019', 'description' => 'Outs.compostos, amalgamas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28439020', 'description' => 'Tricloreto de rutênio em solução aquosa com uma concentração igual ou superior a 17 %, mas inferior ou igual a 27 %, em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28439030', 'description' => 'Ácido hexacloroirídico em solução aquosa com uma concentração igual ou superior a 17 %, mas inferior ou igual a 27 %, em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28439090', 'description' => 'Outs.compostos inorg/org.amalgamas,de metais preciosos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28441000', 'description' => 'Uranio natural e seus compostos,ligas, dispersoes,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28442000', 'description' => 'Uranio enriquecido em u235,plutonio,seus compostos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28443000', 'description' => 'Uranio empobrecido em u235,torio,seus compostos,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28444010', 'description' => 'Molibdenio 99 absorv.em alumina,p/obtencao tecnecio 99', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28444020', 'description' => 'Cobalto 60', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28444030', 'description' => 'Iodo 131', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28444090', 'description' => 'Outs.elementos,isotopos e compostos, radioativos, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28445000', 'description' => 'Elementos combustiveis,usados,de reatores nucleares', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28451000', 'description' => 'Agua pesada (oxido de deuterio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28459000', 'description' => 'Outs.isotopos e seus compostos inorganicos ou organicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28461010', 'description' => 'Oxido cerico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28461090', 'description' => 'Outros compostos de cerio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28469010', 'description' => 'Oxido de praseodimio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28469020', 'description' => 'Cloretos dos demais metais das terras raras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28469030', 'description' => 'Gadopentetato de dimeglumina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28469090', 'description' => 'Outs.compostos dos metais das terras raras,de itrio,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28470000', 'description' => 'Peroxido de hidrogenio (agua oxigenada)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28491000', 'description' => 'Carboneto de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28492000', 'description' => 'Carboneto de silicio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28499010', 'description' => 'Carboneto de boro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28499020', 'description' => 'Carboneto de tantalo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28499030', 'description' => 'Carboneto de tungstenio (volframio)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28499090', 'description' => 'Outros carbonetos de constituicao quimica definida ou n', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28500010', 'description' => 'Nitreto de boro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28500020', 'description' => 'Silicieto de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28500090', 'description' => 'Hidretos,azidas,boretos e outs.nitretos e silicietos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521011', 'description' => 'Oxidos de mercurio, inorganicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521012', 'description' => 'Cloreto de mercurio i (cloreto mercuroso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521013', 'description' => 'Outs.preparacoes quimicas p/usos fotograficos, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521014', 'description' => 'Cloreto de mercúrio ii (cloreto mercúrico), apresentado de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521019', 'description' => 'Outros compostos inorganicos do mercurio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521021', 'description' => 'Acetato de mercurio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521022', 'description' => 'Timerosal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521023', 'description' => 'Estearato de mercúrio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521024', 'description' => 'Lactato de mercúrio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521025', 'description' => 'Salicilato de mercúrio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28521029', 'description' => 'Outros compostos orgânicos de mercúrio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28529000', 'description' => 'Outros compostos de mercúrio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28531000', 'description' => 'Cloreto de cianogenio (clorociano)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28539011', 'description' => 'De aluminio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28539012', 'description' => 'De magnesio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28539013', 'description' => 'De cobre (fosfetos de cobre), contendo mais de 15 %, em peso, de fosforo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28539019', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '28539020', 'description' => 'Cianamida e seus derivados metalicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28539030', 'description' => 'Sulfocloretos de fosforo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28539090', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '28539090', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29011000', 'description' => 'Hidrocarbonetos aciclicos saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29012100', 'description' => 'Etileno nao saturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29012200', 'description' => 'Propeno (propileno) nao saturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29012300', 'description' => 'Buteno (butileno) nao saturado e seus isomeros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29012410', 'description' => 'Buta-1,3-dieno nao saturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29012420', 'description' => 'Isopreno nao saturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29012900', 'description' => 'Outros hidrocarbonetos aciclicos nao saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29021100', 'description' => 'Cicloexano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29021910', 'description' => 'Limoneno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29021990', 'description' => 'Outs.hidrocarbonetos ciclanicos,ciclenicos,cicloterpen.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29022000', 'description' => 'Benzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29023000', 'description' => 'Tolueno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29024100', 'description' => 'O-xileno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29024200', 'description' => 'M-xileno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29024300', 'description' => 'P-xileno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29024400', 'description' => 'Mistura de isomeros do xileno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29025000', 'description' => 'Estireno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29026000', 'description' => 'Etilbenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29027000', 'description' => 'Cumeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29029010', 'description' => 'Difenila (1,1-bifenila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29029020', 'description' => 'Naftaleno (hidrocarboneto ciclico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29029030', 'description' => 'Antraceno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29029040', 'description' => 'Alfa-metilestireno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29029090', 'description' => 'Outros hidrocarbonetos ciclicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031110', 'description' => 'Clorometano (cloreto de metila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031120', 'description' => 'Cloroetano (cloreto de etila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031200', 'description' => 'Diclorometano (cloreto de metileno)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031300', 'description' => 'Cloroformio (triclorometano)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031400', 'description' => 'Tetracloreto de carbono', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031500', 'description' => '1,2-dicloroetano (cloreto de etileno)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031910', 'description' => '1,1,1-tricloroetano (metilcloroformio)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031920', 'description' => '1,1,2-tricloroetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29031990', 'description' => 'Outs.derivs.clorados saturados dos hidrocarb.aciclicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29032100', 'description' => 'Cloreto de vinila (cloroetileno)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29032200', 'description' => 'Tricloroetileno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29032300', 'description' => 'Tetracloroetileno (percloroetileno)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29032900', 'description' => 'Outs.derivs.clorados n/saturad.dos hidrocarb.aciclicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033100', 'description' => 'Dibrometo de etileno (iso) (1,2-dibromoetano)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033911', 'description' => '1,1,1,2-tetrafluoretano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033912', 'description' => '1,1,3,3,3 - pentafluor-2 (trifluormetil) prop-1-eno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033919', 'description' => 'Outs.derivs.fluorados dos hidrocarbonetos aciclicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033921', 'description' => 'Bromometano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033929', 'description' => 'Outs.derivados bromados dos hidrocarbonetos aciclicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033931', 'description' => 'Iodoetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033932', 'description' => 'Iodoformio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29033939', 'description' => 'Outs.derivados iodados dos hidrocarbonetos aciclicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037100', 'description' => 'Clorodifluormetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037200', 'description' => 'Diclorotrifluoretanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037300', 'description' => 'Diclorofluoretanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29037400', 'description' => 'Clorodifluoretanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037500', 'description' => 'Dicloropentafluorpropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037600', 'description' => 'Bromoclorodifluormetano,bromotrifluormetano,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037711', 'description' => 'Triclorofluormetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037712', 'description' => 'Diclorodifluormetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037713', 'description' => 'Clorotrifluormetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037721', 'description' => 'Triclorotrifluoretanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037722', 'description' => 'Diclorotetrafluoretanos e cloropentafluoretano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037723', 'description' => 'Pentaclorofluoretano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037724', 'description' => 'Tetraclorodifluoretanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037731', 'description' => 'Heptaclorofluorpropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037732', 'description' => 'Hexaclorodifluorpropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037733', 'description' => 'Pentaclorotrifluorpropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037734', 'description' => 'Tetraclorotetrafluorpropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037735', 'description' => 'Tricloropentafluorpropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037736', 'description' => 'Dicloroexafluorpropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037737', 'description' => 'Cloroeptafluorpropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037790', 'description' => 'Outros derivados peralogenados, unicamente com fluor e cloro', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037800', 'description' => 'Outs.derivs.peralogen.dos hidroc.acicl.c/2 halog.difer.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037911', 'description' => 'Clorofluoretanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037912', 'description' => 'Clorotetrafluoretanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037919', 'description' => 'Outs.derivs.do metano,etano,etc.halogen. c/fluor e cloro', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037920', 'description' => 'Derivs.do metano,etano,propano,halogen. c/fluor e bromo', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037931', 'description' => 'Halotano (bromoclorotrifluoretano)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037939', 'description' => 'Outros derivados do bromoclorotrifluoretano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29037990', 'description' => 'Outs.derivs.halogen.dos hidroc.acicl.c/2 halogen.difer.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29038110', 'description' => 'Lindano (1,2,3,4,5,6-hexaclorocicloexano)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29038190', 'description' => 'Outs.derivados do 1,2,3,4,5,6-hexaclorocicloexano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29038210', 'description' => 'Aldrin (deriv.halogen.dos hidrocarbon. ciclanicos,etc.)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29038220', 'description' => 'Clordano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29038230', 'description' => 'Heptacloro (deriv.halogen.dos hidrocarb. ciclanicos,etc)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29038300', 'description' => 'Mirex (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29038900', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039110', 'description' => 'Clorobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039120', 'description' => 'O-diclorobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039130', 'description' => 'P-diclorobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039210', 'description' => 'Hexaclorobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039220', 'description' => 'Ddt [1,1,1-tricloro-2,2-bis(p-clorofenil)etano]', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039300', 'description' => 'Pentaclorobenzeno (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039400', 'description' => 'Hexabromobifenilas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039911', 'description' => 'Cloreto de benzila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039912', 'description' => 'P-clorotolueno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039913', 'description' => 'Cloreto de neofila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039914', 'description' => 'Triclorobenzenos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039915', 'description' => 'Cloronaftalenos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039916', 'description' => 'Cloreto de benzilideno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039917', 'description' => 'Cloretos de xilila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039918', 'description' => 'Bifenilas policloradas (pcb), terfenilas policloradas (pct)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039919', 'description' => 'Outros derivs.halogen.dos hidrocarb. aromaticos unicamente com clor', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039921', 'description' => 'Bromobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039922', 'description' => 'Brometos de xilila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039923', 'description' => 'Bromodifenilmetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039924', 'description' => 'Bifenilas polibromadas (pbb)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29039929', 'description' => 'Outs.derivs.halogenados de hidrocarb.aromaticos unicamente c/bromo', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039931', 'description' => '4-cloro-alfa,alfa,alfa-trifluortolueno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039939', 'description' => 'Outs.derivs.halogen.de hidrocarb.aromat.c/cloro e fluor', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29039990', 'description' => 'Outs.derivs.halogenados dos hidrocarbonetos aromaticos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041011', 'description' => 'Acido metanossulfonico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041012', 'description' => 'Metanossulfonato de chumbo', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041013', 'description' => 'Metanossulfonato de estanho', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041019', 'description' => 'Outs.derivs.do acido metanossulfonico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041020', 'description' => 'Acido dodecilbenzenossulfonico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041030', 'description' => 'Acido toluenossulfonico,xilenossulfonico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041040', 'description' => 'Acido etanossulfonico e acido etilenossulfonico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041051', 'description' => 'Naftalenossulfonatos de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041052', 'description' => 'Acido beta-naftalenossulfonico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041053', 'description' => 'Acido alquil e diaquilnaftalenossulfonico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041059', 'description' => 'Outs.acidos naftalenossulfonicos,sais, esteres etilicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041060', 'description' => 'Acido benzenossulfonico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29041090', 'description' => 'Outs.derivs.sulfonados dos hidrocarbonetos,sais,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042010', 'description' => 'Mononitrotoluenos (mnt)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042020', 'description' => 'Nitropropanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042030', 'description' => 'Dinitrotoluenos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042041', 'description' => '2,4,6-trinitrotolueno (tnt)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042049', 'description' => 'Outros trinitrotoluenos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042051', 'description' => 'Nitrobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042052', 'description' => '1,3,5-trinitrobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042059', 'description' => 'Outros derivados nitrados do benzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042060', 'description' => 'Derivados nitrados do xileno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042070', 'description' => 'Mononitroetano e nitrometanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29042090', 'description' => 'Outs.derivs.nitrados ou nitrosados dos hidrocarbonetos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29043100', 'description' => 'Acido perfluoroctano sulfonico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29043200', 'description' => 'Perfluoroctanossulfonato de amonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29043300', 'description' => 'Perfluoroctanossulfonato de litio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29043400', 'description' => 'Perfluoroctanossulfonato de potassio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29043500', 'description' => 'Outros sais do acido perfluoroctano sulfonico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29043600', 'description' => 'Fluoreto de perfluoroctanossulfonila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049100', 'description' => 'Tricloronitrometano (cloropicrina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049911', 'description' => '1 cloro 4 nitrobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049912', 'description' => '1 cloro 2,4 dinitrobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049913', 'description' => '2 cloro 1,3 dinitrobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049914', 'description' => '4 cloro alfa,alfa,alfa trifluor 3,5 dinitrotolueno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049915', 'description' => 'O nitroclorobenzeno, m nitroclorobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049916', 'description' => '1,2 dicloro 4 nitrobenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049919', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049921', 'description' => 'Acidos dinitroestilbenodissulfonicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049929', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049930', 'description' => 'Cloreto de p toluenossulfonila (cloreto de tosila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049940', 'description' => 'Cloreto de o toluenossulfonila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29049990', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051100', 'description' => 'Metanol (alcool metilico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051210', 'description' => 'Alcool propilico (propan-1-ol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051220', 'description' => 'Alcool isopropilico (propan-2-ol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051300', 'description' => 'Butan-1-ol (alcool n-butilico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051410', 'description' => 'Alcool isobutilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051420', 'description' => 'Alcool sec-butilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29051430', 'description' => 'Alcool ter-butilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051600', 'description' => 'Octanol (alcool octilico) e seus isomeros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051710', 'description' => 'Alcool laurilico (dodecan-1-ol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051720', 'description' => 'Alcool cetilico (hexadecan-1-ol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051730', 'description' => 'Alcool estearico (octadecan-1-ol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051911', 'description' => 'N-decanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051912', 'description' => 'Isodecanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051919', 'description' => 'Outros decanois,saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051921', 'description' => 'Etilato de magnesio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051922', 'description' => 'Metilato de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051923', 'description' => 'Etilato de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051929', 'description' => 'Outros alcoolatos metalicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051991', 'description' => '4-metilpentan-2-ol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051992', 'description' => 'Isononanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051993', 'description' => 'Isotridecanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051994', 'description' => 'Tetraidrolinalol (3,7-dimetiloctan-3-ol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051995', 'description' => '3,3-dimetibutan-2-ol (álcool', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051996', 'description' => 'Pentanol (alcool amilico) e seus isomeros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29051999', 'description' => 'Outros monoalcoois saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29052210', 'description' => 'Linalol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29052220', 'description' => 'Geraniol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29052230', 'description' => 'Diidromircenol (2,6-dimetil-7-octen-2-ol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29052290', 'description' => 'Outros alcoois terpenicos aciclicos,nao saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29052910', 'description' => 'Alcool alilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29052990', 'description' => 'Outros monoalcoois nao saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29053100', 'description' => 'Etilenoglicol (etanodiol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29053200', 'description' => 'Propilenoglicol (propano-1,2-diol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29053910', 'description' => '2-metil-2,4-pentanodiol (hexilenoglicol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29053920', 'description' => 'Trimetilenoglicol (1,3-propanodiol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29053930', 'description' => '1,3-butilenoglicol (1,3-butanodiol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29053990', 'description' => 'Outros alcoois diois,nao saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29054100', 'description' => '2-etil-2-(hidroximetil)propano-1,3-diol (trimetiolprop.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29054200', 'description' => 'Pentaeritritol (pentaeritrita)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29054300', 'description' => 'Manitol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29054400', 'description' => 'D-glucitol (sorbitol) (polialcool)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29054500', 'description' => 'Glicerol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29054900', 'description' => 'Outros polialcoois,nao saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29055100', 'description' => 'Etclorvinol (dc)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29055910', 'description' => 'Hidrato de cloral', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29055990', 'description' => 'Outs.derivs.halogens.etc.dos alcoois aciclicos,n/satur.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061100', 'description' => 'Mentol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061200', 'description' => 'Cicloexanol,metilcicloexanois e dimetilcicloexanois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061300', 'description' => 'Esterois e inositois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061910', 'description' => 'Derivados do mentol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061920', 'description' => 'Borneol e isoborneol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061930', 'description' => 'Terpina e seu hidrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061940', 'description' => 'Alcool fenchilico (1,3,3-trimetil-2-norbornanol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061950', 'description' => 'Terpineois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29061990', 'description' => 'Outs.alcoois ciclanicos,ciclenicos e cicloterpenicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29062100', 'description' => 'Alcool benzilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29062910', 'description' => '2-feniletanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29062920', 'description' => 'Dicofol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29062990', 'description' => 'Outs.alcoois ciclicos aromaticos e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29071100', 'description' => 'Fenol (hidroxibenzeno) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071200', 'description' => 'Cresois e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071300', 'description' => 'Octilfenol,nonilfenol,seus isomeros e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071510', 'description' => 'Beta-naftol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071590', 'description' => 'Outros naftois e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071910', 'description' => '2,6-di-ter-butil-p-cresol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071920', 'description' => 'O-fenilfenol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071930', 'description' => 'P-ter-butilfenol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071940', 'description' => 'Xilenois e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29071990', 'description' => 'Outros monofenois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29072100', 'description' => 'Resorcinol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29072200', 'description' => 'Hidroquinona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29072300', 'description' => '4-4-isopropilidenodifenol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29072900', 'description' => 'Outros polifenois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081100', 'description' => 'Pentaclorofenol (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081911', 'description' => '4-cloro-m-cresol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081912', 'description' => 'Diclorofenois e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081913', 'description' => 'P-clorofenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081914', 'description' => 'Triclorofenois e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081915', 'description' => 'Tetraclorofenois e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081919', 'description' => 'Outros derivados halogenados unicamente com cloro', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081921', 'description' => '2,4,6-tribromofenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081929', 'description' => 'Outros derivados halogenados unicamente com bromo', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29081990', 'description' => 'Outs.deriv.halog.dos fenois/fenois-alcoois e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089100', 'description' => 'Dinoseb (iso) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089200', 'description' => '4,6-dinitro-o-cresol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089912', 'description' => 'P-nitrofenol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089913', 'description' => 'Acido picrico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089919', 'description' => 'Outs.deriv.nitrados dos fenois/fenois-alcoois,seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089921', 'description' => 'Disofenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089929', 'description' => 'Outs.derivs.nitroalogenados dos fenois/fenois-alcoois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089930', 'description' => 'Derivados sulfonados dos fenois,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29089990', 'description' => 'Outs.derivs.nitrosados,etc.dos fenois/fenois-alcoois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29091100', 'description' => 'Eter dietilico (oxido de dietila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29091910', 'description' => 'Eter metil-ter-butilico (mtbe)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29091920', 'description' => 'Sevoflurano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29091990', 'description' => 'Outs.eteres aciclicos e seus derivados halogenados,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29092000', 'description' => 'Eteres ciclanicos,ciclenicos, cicloterpenicos e derivs.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29093011', 'description' => 'Anetol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29093012', 'description' => 'Eter difenilico (eter fenilico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29093013', 'description' => 'Eter dibenzilico (eter benzilico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29093014', 'description' => 'Eter feniletil-isoamilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29093019', 'description' => 'Outros eteres aromaticos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29093021', 'description' => 'Oxifluorfeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29093029', 'description' => 'Outs.derivados halogenados,etc.dos eteres aromaticos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094100', 'description' => '2,2-oxidietanol (dietilenoglicol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094310', 'description' => 'Eteres monobutilicos do etilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094320', 'description' => 'Eteres monobutilicos do dietilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094411', 'description' => 'Eter etilico do etilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094412', 'description' => 'Eter isobutilico do etilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094413', 'description' => 'Eter hexilico do etilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094419', 'description' => 'Outros eteres monometilicos do etilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094421', 'description' => 'Eter etilico do dietilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29094429', 'description' => 'Outros eteres monometilicos do dietilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094910', 'description' => 'Guaifenesina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094921', 'description' => 'Trietilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094922', 'description' => 'Tetraetilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094923', 'description' => 'Pentaetilenoglicol e seus eteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094924', 'description' => 'Eter fenilico do etilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094929', 'description' => 'Outros etilenoglicois e seus eteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094931', 'description' => 'Dipropilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094932', 'description' => 'Eteres do mono-,di- e tripropilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094939', 'description' => 'Outros propilenoglicois e seus eteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094941', 'description' => 'Eter etilico do butilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094949', 'description' => 'Butilenoglicois e outs.eteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094950', 'description' => 'Alcool fenoxibenzilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29094990', 'description' => 'Outs.eteres-alcoois e seus derivados halogenados,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29095011', 'description' => 'Triclosan', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29095012', 'description' => 'Eugenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29095013', 'description' => 'Isoeugenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29095019', 'description' => 'Outros eteres-fenois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29095090', 'description' => 'Eteres-alcoois-fenois e seus derivados halogenados,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29096011', 'description' => 'Hidroperoxido de diisopropilbenzeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29096012', 'description' => 'Hidroperoxido de ter-butila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29096013', 'description' => 'Hidroperoxido de p-mentano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29096019', 'description' => 'Outs.hidroperoxidos de alcoois,eteres,cetonas e derivs.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29096020', 'description' => 'Peroxidos de alcoois,eteres,cetonas,derivs.halogen.etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29101000', 'description' => 'Oxirano (oxido de etileno)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29102000', 'description' => 'Metiloxirano (oxido de propileno)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29103000', 'description' => '1-cloro-2,3-epoxipropano (epicloridrina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29104000', 'description' => 'Dieldrin (iso, dci)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29105000', 'description' => 'Endrin (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29109010', 'description' => 'Oxido de estireno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29109090', 'description' => 'Outs.epoxidos,epoxialcoois,etc.com 3 atomos no ciclo', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29110010', 'description' => 'Dimetilacetal do 2-nitrobenzaldeido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29110090', 'description' => 'Outs.acetais,semi-acetais e seus derivs.halogenados,etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121100', 'description' => 'Metanal (formaldeido)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121200', 'description' => 'Etanal (acetaldeido)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121911', 'description' => 'Glioxal', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121912', 'description' => 'Glutaraldeido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121919', 'description' => 'Outros dialdeidos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121921', 'description' => 'Citral', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121922', 'description' => 'Citronelal (3,7-dimetil-6-octenal)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121923', 'description' => 'Bergamal (3,7-dimetil-2-metileno-6-octenal)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121929', 'description' => 'Outros monoaldeidos nao saturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121991', 'description' => 'Heptanal', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29121999', 'description' => 'Outs.aldeidos aciclicos n/cont.outs.funcoes oxigenadas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29122100', 'description' => 'Benzaldeido (aldeido benzoico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29122910', 'description' => 'Aldeido alfa-amilcinamico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29122920', 'description' => 'Aldeido alfa-hexilcinamico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29122990', 'description' => 'Outs.aldeidos ciclicos n/cont.outs.funcoes oxigenadas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29124100', 'description' => 'Vanilina (aldeido metilprotocatequico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29124200', 'description' => 'Etilvanilina (aldeido etilprotocatequico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29124910', 'description' => '3-fenoxibenzaldeido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29124920', 'description' => '3-hidroxibenzaldeido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29124930', 'description' => '3,4,5-trimetoxibenzaldeido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29124941', 'description' => '4-(4-hidroxi-4metilpentil)-3-cicloexeno-1-carboxialdeid', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29124949', 'description' => 'Outros aldeidos-alcoois', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29124990', 'description' => 'Outros aldeidos-eteres,aldeidos-fenois e c/funcoes oxig', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29125000', 'description' => 'Polimeros ciclicos dos aldeidos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29126000', 'description' => 'Paraformaldeido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29130010', 'description' => 'Tricloroacetaldeido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29130090', 'description' => 'Outs.derivados halogenados,sulfonados,etc.dos aldeidos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141100', 'description' => 'Acetona nao contendo outs.funcoes oxigenadas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141200', 'description' => 'Butanona (metiletilcetona)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141300', 'description' => '4-metilpentan-2-ona (metilisobutilcetona)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141910', 'description' => 'Forona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141921', 'description' => 'Acetilacetona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141922', 'description' => 'Acetonilacetona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141923', 'description' => 'Diacetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141929', 'description' => 'Outros dicetonas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141930', 'description' => 'Metilexilcetona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141940', 'description' => 'Pseudoiononas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141950', 'description' => 'Metilisopropilcetona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29141990', 'description' => 'Outs.cetonas aciclicas n/cont.outs.funcoes oxigenadas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29142210', 'description' => 'Cicloexanona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29142220', 'description' => 'Metilcicloexanonas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29142310', 'description' => 'Iononas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29142320', 'description' => 'Metiliononas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29142910', 'description' => 'Carvona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29142920', 'description' => '1-mentona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29142990', 'description' => 'Outs.cetonas ciclanicas,etc.n/cont.outs. funcoes oxigen.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29143100', 'description' => 'Fenilacetona (fenilpropan-2-ona)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29143910', 'description' => 'Acetofenona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29143990', 'description' => 'Outs.cetonas aromaticas n/contendo outs.funcoes oxigen.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29144010', 'description' => '4-hidroxi-4-metilpentano-2-ona (diacetona alcool)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29144091', 'description' => 'Benzoina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29144099', 'description' => 'Outros cetonas-alcoois e cetonas-aldeidos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29145010', 'description' => 'Nabumetona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29145020', 'description' => '1,8-diidroxi-3-metil-9-antrona e sua forma enolica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29145090', 'description' => 'Outs.cetonas-fenois e cetonas cont.outs.funcoes oxigen.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29146100', 'description' => 'Antraquinona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29146200', 'description' => 'Coenzima q10 (ubidecarenona (dci))', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29146910', 'description' => 'Lapachol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29146920', 'description' => 'Menadiona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29146990', 'description' => 'Outros quinonas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29147100', 'description' => 'Clordecona (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29147911', 'description' => '1 cloro 5 hexanona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29147919', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29147921', 'description' => 'Bissulfito sodico de menadiona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29147922', 'description' => 'Acido 2 hidroxi 4 metoxibenzofenona 5 sulfonico (sulisobenzona)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29147929', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29147990', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29151100', 'description' => 'Acido formico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29151210', 'description' => 'Sal de sodio,do acido formico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29151290', 'description' => 'Outros sais do acido formico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29151310', 'description' => 'Ester de geranila,do acido formico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29151390', 'description' => 'Outros esteres do acido formico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29152100', 'description' => 'Acido acetico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29152400', 'description' => 'Anidrido acetico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29152910', 'description' => 'Acetato de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29152920', 'description' => 'Acetato de cobalto', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29152990', 'description' => 'Outros sais do acido acetico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153100', 'description' => 'Acetato de etila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153200', 'description' => 'Acetato de vinila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153300', 'description' => 'Acetato de n-butila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153600', 'description' => 'Acetato de dinoseb (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153910', 'description' => 'Acetato de linalila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153921', 'description' => 'Triacetina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153929', 'description' => 'Outros acetatos de glicerila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153931', 'description' => 'Acetato de n-propila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153932', 'description' => 'Acetato de 2-etoxietila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153939', 'description' => 'Outros acetatos de monoálcoois acíclicos saturados de até 8 átomos de carbono', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153941', 'description' => 'Acetato de decila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153942', 'description' => 'Acetato de hexenila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153951', 'description' => 'Acetato de benzestrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153952', 'description' => 'Acetato de dienoestrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153953', 'description' => 'Acetato de hexestrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153954', 'description' => 'Acetato de mestilbol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153955', 'description' => 'Acetato de estildestrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153961', 'description' => 'Acetato de tricloro-alfa-feniletila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153962', 'description' => 'Acetato de triclorometilfenilcarbinila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153963', 'description' => 'Diacetato de etilenoglicol (diacetato de etileno)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153991', 'description' => 'Esteres de 2-ter-butilcicloexila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153992', 'description' => 'Esteres de bornila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153993', 'description' => 'Esteres de dimetilbenzilcarbinila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153994', 'description' => 'Bis(p-acetoxifenil)cicloexilidenometano (ciclofenil)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29153999', 'description' => 'Outros esteres do acido acetico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29154010', 'description' => 'Acido monocloroacetico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29154020', 'description' => 'Monocloroacetato de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29154090', 'description' => 'Acido di- ou tricloroacetico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29155010', 'description' => 'Acido propionico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29155020', 'description' => 'Sais do acido propionico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29155030', 'description' => 'Esteres do acido propionico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29156011', 'description' => 'Acido butirico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29156012', 'description' => 'Butirato de etila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29156019', 'description' => 'Outros esteres do acido butirico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29156021', 'description' => 'Acido pivalico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29156029', 'description' => 'Sais e esteres do acido pivalico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29157011', 'description' => 'Acido palmitico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29157019', 'description' => 'Outros (seus sais e esteres)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29157020', 'description' => 'Acido estearico (ac.monocarboxilico aciclico saturado)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29157031', 'description' => 'Sais de zinco do acido estearico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29157039', 'description' => 'Outros sais do acido estearico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29157040', 'description' => 'Esteres do acido estearico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159010', 'description' => 'Cloreto de cloroacetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159021', 'description' => 'Acido 2-etilexanoico (acido 2-etilexoico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159022', 'description' => '2-etilexanoato de estanho ii', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159023', 'description' => 'Di(2-etilexanotato) de trietilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159024', 'description' => 'Cloreto de 2-etilexanoila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159029', 'description' => 'Outros sais e esteres do acido 2-etilexanoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159031', 'description' => 'Acido miristico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29159032', 'description' => 'Acido caprilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159033', 'description' => 'Miristato de isopropila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159039', 'description' => 'Outs.sais e esteres dos acidos miristico ou caprilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159041', 'description' => 'Acido laurico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159042', 'description' => 'Sais e esteres do acido laurico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159050', 'description' => 'Peroxidos dos acidos monocarboxilicos aciclicos satur.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159060', 'description' => 'Peracidos dos acidos monocarboxilicos aciclicos satur.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29159090', 'description' => 'Outs.acidos monocarboxil.acicl.satur.seus anidridos,etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161110', 'description' => 'Acido acrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161120', 'description' => 'Sais do acido acrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161210', 'description' => 'Esteres de metila do acido acrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161220', 'description' => 'Esteres de etila do acido acrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161230', 'description' => 'Esteres de butila do acido acrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161240', 'description' => 'Esteres de 2-etilexila do acido acrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161290', 'description' => 'Outros esteres do acido acrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161310', 'description' => 'Acido metacrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161320', 'description' => 'Sais do acido metacrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161410', 'description' => 'Esteres de metila do acido metacrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161420', 'description' => 'Esteres de etila do acido metacrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161430', 'description' => 'Esteres de n-butila do acido metacrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161490', 'description' => 'Outros esteres do acido metacrilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161511', 'description' => 'Oleato de manitol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161519', 'description' => 'Acido oleico,outs.sais e esteres (ac.monocarbox.acicl.)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161520', 'description' => 'Acido linoleico e acido linonenico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161600', 'description' => 'Binapacril(iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161911', 'description' => 'Sorbato de potassio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161919', 'description' => 'Acido sorbico,seus outs.sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161921', 'description' => 'Acido undecilenico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161922', 'description' => 'Undecilinato de metila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161923', 'description' => 'Undecilinato de zinco', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161929', 'description' => 'Outros sais e esteres do acido undecilenico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29161990', 'description' => 'Outs.acidos monocarboxilicos aciclicos n/saturados,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29162011', 'description' => 'Acido 3(2,2dibromovinil)-2,2 dimetilciclopropanocarboxil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29162012', 'description' => 'Cloreto do ac.3(2,2diclorovinil)2,2 dimetilciclopr.(dvo)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29162013', 'description' => 'Aletrinas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29162014', 'description' => 'Permetrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29162015', 'description' => 'Bifentrin', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29162019', 'description' => 'Outros derivados do acido ciclopropanocarboxilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29162090', 'description' => 'Outs.acidos monocarboxilicos ciclanicos, ciclenicos,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163110', 'description' => 'Acido benzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163121', 'description' => 'Sais de sodio do acido benzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163122', 'description' => 'Sais de amonio do acido benzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163129', 'description' => 'Outros sais do acido benzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163131', 'description' => 'Esteres de metila do acido benzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163132', 'description' => 'Esteres de benzila do acido benzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163139', 'description' => 'Outros esteres do acido benzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163210', 'description' => 'Peroxido de benzoila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163220', 'description' => 'Cloreto de benzoila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163400', 'description' => 'Acido fenilacetico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163910', 'description' => 'Cloreto de 4-cloro-alfa-(1-metiletil) benzenoacetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163920', 'description' => 'Ibuprofeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163930', 'description' => 'Acido 4-cloro-3-nitrobenzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29163940', 'description' => 'Perbenzoato de ter-butila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29163990', 'description' => 'Outs.acidos monocarboxilicos aromats.seus anidridos,etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171110', 'description' => 'Acido oxalico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171120', 'description' => 'Esteres do acido oxalico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171210', 'description' => 'Acido adipico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171220', 'description' => 'Sais e esteres do acido adipico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171310', 'description' => 'Acido azelaico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171321', 'description' => 'Acido sebacico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171322', 'description' => 'Sebacato de dibutila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171323', 'description' => 'Sebacato de dioctila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171329', 'description' => 'Outros sais e esteres do acido sebacico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171400', 'description' => 'Anidrido maleico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171910', 'description' => 'Dioctilsulfossuccinato de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171921', 'description' => 'Acido maleico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171922', 'description' => 'Sais e esteres do acido maleico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171930', 'description' => 'Acido fumarico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29171990', 'description' => 'Outs.acidos policarboxilicos acicls.seus anidridos,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29172000', 'description' => 'Acido policarboxilico ciclanico,ciclenico,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173200', 'description' => 'Ortoftalatos de dioctila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173300', 'description' => 'Ortoftalatos de dinonila ou de didecila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173400', 'description' => 'Outros esteres do acido ortoftalico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173500', 'description' => 'Anidrido ftalico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173600', 'description' => 'Acido tereftalico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173700', 'description' => 'Tereftalato de dimetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173911', 'description' => 'Esteres do acido m-ftalico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173919', 'description' => 'Acido m-ftalico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173920', 'description' => 'Acido o-ftalico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173931', 'description' => 'Esteres de dioctila do acido tereftalico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173939', 'description' => 'Outros esteres do acido tereftalico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173940', 'description' => 'Sais e esteres do ac.trimelitico (1,2,4-benzenotricarb)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173950', 'description' => 'Anidrido trimelitico (ac.1,3dioxo-5isobenzofuranocarb.)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29173990', 'description' => 'Outs.acidos policarboxilicos aromats.seus anidridos,etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181100', 'description' => 'Acido lactico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181200', 'description' => 'Acido tartarico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181310', 'description' => 'Sais do acido tartarico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181320', 'description' => 'Esteres do acido tartarico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181400', 'description' => 'Acido citrico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181500', 'description' => 'Sais e esteres do acido citrico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181610', 'description' => 'Gluconato de calcio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181690', 'description' => 'Acido gluconico,seus outs.sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181700', 'description' => 'Acido 2,2 difenil 2 hidroxiacetico (acido benzilico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181800', 'description' => 'Clorobenzilato (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181910', 'description' => 'Bromopropilato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181921', 'description' => 'Ursodiol (acido ursodeoxicolico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181922', 'description' => 'Acido quenodeoxicolico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181929', 'description' => 'Acido biliar,seus outs.sais,esteres e derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181930', 'description' => 'Acido 12-hidroxiestearico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181942', 'description' => 'Sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181943', 'description' => 'Ésteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29181990', 'description' => 'Outs.acidos carboxilicos de funcao alcool,anidridos,etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182110', 'description' => 'Acido salicilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182120', 'description' => 'Sais do acido salicilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182211', 'description' => 'Acido o-acetilsalicilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182212', 'description' => 'O-acetilsalicilato de aluminio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29182219', 'description' => 'Outros sais do acido o-acetilsalicilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182220', 'description' => 'Esteres do acido o-acetilsalicilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182300', 'description' => 'Outros esteres do acido salicilico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182910', 'description' => 'Acido hidroxinaftoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182921', 'description' => 'Acido p-hidroxibenzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182922', 'description' => 'Metilparabeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182923', 'description' => 'Propilparabeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182929', 'description' => 'Outros sais e esteres do acido p-hidroxibenzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182930', 'description' => 'Acido galico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182940', 'description' => 'Tetrakis(3(3,5d.t.butil-4hidroxif.)prop. pentaeritritila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182950', 'description' => '3-(3,5-d.t.butil-4hidroxifenil)propionato de octadecila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29182990', 'description' => 'Outs.acidos carboxilicos de funcao fenol, anidridos,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29183010', 'description' => 'Cetoprofeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29183020', 'description' => 'Butirilacetato de metila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29183031', 'description' => 'Acido deidrocolico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29183032', 'description' => 'Deidrocolato de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29183033', 'description' => 'Deidrocolato de magnesio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29183039', 'description' => 'Outros sais do acido deidrocolico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29183040', 'description' => 'Acetilacetato de 2-nitrometilbenzilideno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29183090', 'description' => 'Outs.acidos carboxils.de funcao aldeido ou cetona,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189100', 'description' => '2,4,5-t (iso) (ácido 2,4,5-triclorofenoxiacético), seus sais e seus ésteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189911', 'description' => 'Acido fenoxiacetico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189912', 'description' => 'Acido 2,4-diclorofenoxiacetico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189919', 'description' => 'Outs.derivados do acido fenoxiacetico,sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189921', 'description' => 'Ácidos diclorofenoxibutanóicos, seus sais e seus ésteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189929', 'description' => 'Outros ácidos fenoxibutanóicos, seus sais e seus ésteres, derivados destes produtos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189930', 'description' => 'Acifluorfen sodico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189940', 'description' => 'Naproxeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189950', 'description' => 'Acido 3(2-cloro-alfa,alfa,alfa-trifluor-p-toliloxi)benzoico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189960', 'description' => 'Diclofop-metila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189991', 'description' => 'Fenofibrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189992', 'description' => 'Acido metilclorofenoxiacetico,seus sais e esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189993', 'description' => '5-(2-cloro-4-trifluormetilfenoxi)-2-nitrobenzoato. etc.(lactofen)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189994', 'description' => 'Acido 4-(4-hidroxifenoxi)-3,5-diiodofenilacetico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29189999', 'description' => 'Outs.acidos carboxilicos cont.funcoes oxigen.suplem.etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29191000', 'description' => 'Fosfato de tris(2,3-dibromopropila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29199010', 'description' => 'Ester fosforico de tributila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29199020', 'description' => 'Ester fosforico de tricresila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29199030', 'description' => 'Ester fosforico de trifenila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29199040', 'description' => 'Diclorvos (ddvp)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29199050', 'description' => 'Lactofosfato de calcio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29199060', 'description' => 'Clorfenvinfos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29199090', 'description' => 'Outs.esteres fosforicos,seus sais,deriv. halogenados,etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29201110', 'description' => 'Paration (etil paration)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29201120', 'description' => 'Paration-metila (metil paration)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29201910', 'description' => 'Fenitrotion', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29201920', 'description' => 'Cloreto de fosforotioato de dimetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29201990', 'description' => 'Outs.esteres tiofosforicos,seus sais,derivs. halogen.etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202100', 'description' => 'Fosfito de dimetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202200', 'description' => 'Fosfito de dietila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202300', 'description' => 'Fosfito de trimetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202400', 'description' => 'Fosfito de trietila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202910', 'description' => 'Fosfito de alquila de c3 a c13 ou de alquil arila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29202920', 'description' => 'Fosfito de difenila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202930', 'description' => 'Outros fosfitos, de arila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202940', 'description' => 'Fosetil al', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202950', 'description' => 'Fosfito de tris(2,4 di ter butilfenila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29202990', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29203000', 'description' => 'Endossulfan (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209022', 'description' => 'Propargite', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209029', 'description' => 'Outros sulfitos de esteres de acidos inorganicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209031', 'description' => 'Nitrato de propatila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209032', 'description' => 'Nitroglicerina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209033', 'description' => 'Tetranitrato de pentaeritritol (petn,nitropenta,etc.)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209039', 'description' => 'Outros nitratos de esteres de acidos inorganicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209041', 'description' => 'Sulfato de alquila de c6 a c22', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209042', 'description' => 'Sulfato de monoalquil(di ou tri)etilenoglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209049', 'description' => 'Outros sulfatos de esteres de acidos inorganicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209051', 'description' => 'Silicato de etila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209059', 'description' => 'Outros silicatos de esteres de acidos inorganicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29209090', 'description' => 'Outs.esteres dos acidos inorgan.sais,derivs.halogen.etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211111', 'description' => 'Monometilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211112', 'description' => 'Sais de monometilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211121', 'description' => 'Dimetilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211122', 'description' => '2,4-diclorofenoxiacetato de dimetilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211123', 'description' => 'Metilclorofenoxiacetato de dimetilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211129', 'description' => 'Outros sais de dimetilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211131', 'description' => 'Trimetilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211132', 'description' => 'Cloridrato de trimetilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211139', 'description' => 'Outros sais de trimetilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211200', 'description' => 'Cloridrato de 2 cloroetil(n,n dimetilamina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211300', 'description' => 'Cloridrato de 2 cloroetil(n,n dietilamina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211400', 'description' => 'Cloridrato de 2 cloroetil(n,n diisopropilamina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211911', 'description' => 'Monoetilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211912', 'description' => 'Trietilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211913', 'description' => 'Bis (2-cloroetil) etilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211914', 'description' => 'Triclormetina (tris (2-cloroetil) amina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211915', 'description' => 'Dietilamina e seus sais, exceto etansilato (ethamsylate)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211919', 'description' => 'Outros etilaminas,seus derivados e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211921', 'description' => 'Mono-n-propilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211922', 'description' => 'Di-n-propilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211923', 'description' => 'Monoisopropilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211924', 'description' => 'Diisopropilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211929', 'description' => 'Outros n-propilaminas,isopropilaminas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211931', 'description' => 'Diisobutilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211939', 'description' => 'Outros butilaminas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211941', 'description' => 'Metildialquilaminas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211949', 'description' => 'Monoalquil- e outs.dialquilaminas,alquila de c10 a c18', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211991', 'description' => 'Clormetina (bis (2-cloroetil) metilamina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211992', 'description' => 'N,n-dialquil-2-cloroetilamina, com grupos alquila .... sais protonados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211993', 'description' => 'Mucato de isometepteno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211994', 'description' => 'N,N-Dimetilcetilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29211999', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29212100', 'description' => 'Etilenodiamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29212200', 'description' => 'Hexametilenodiamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29212910', 'description' => 'Dietilenotriamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29212920', 'description' => 'Trietilenotetramina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29212990', 'description' => 'Outs.poliaminas aciclicas,seus derivados e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29213011', 'description' => 'Monocicloexilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29213012', 'description' => 'Dicicloexilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29213019', 'description' => 'Outros cicloexilaminas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29213020', 'description' => 'Propilexedrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29213090', 'description' => 'Outs.monoaminas e poliaminas ciclanicas,ciclenicas,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214100', 'description' => 'Anilina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214211', 'description' => 'Acido sulfanilico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214219', 'description' => 'Outros acidos aminobenzenossulfonicos e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214221', 'description' => '3,4-dicloroanilina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214229', 'description' => 'Outros cloroanilinas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214231', 'description' => '4-nitroanilina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214239', 'description' => 'Outros nitroanilinas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214241', 'description' => '5-cloro-2-nitroanilina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214249', 'description' => 'Outros cloronitroanilinas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214290', 'description' => 'Outros derivados da anilina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214311', 'description' => 'O-toluidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214319', 'description' => 'Outros toluidinas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214321', 'description' => '3-nitro-4-toluidina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214322', 'description' => 'Trifluralina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214323', 'description' => '4-cloro-2-toluidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214329', 'description' => 'Outros derivados das toluidinas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214410', 'description' => 'Difenilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214421', 'description' => 'N-octildifenilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214422', 'description' => 'N-nonildifenilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214429', 'description' => 'Outros derivados da difenilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214500', 'description' => '1-naftilamina (alfa),2-naftilamina (beta),derivs.e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214610', 'description' => 'Anfetaminas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214620', 'description' => 'Benzofetamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214630', 'description' => 'Dexanfetamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214640', 'description' => 'Etilanfetamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214650', 'description' => 'Fencanfamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214660', 'description' => 'Fentermina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214670', 'description' => 'Lefetamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214680', 'description' => 'Levanfetamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214690', 'description' => 'Mefenorex e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214910', 'description' => 'Cloridrato de fenfluramina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214921', 'description' => '2,4-xilidina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214922', 'description' => 'Pendimetalina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214929', 'description' => 'Outros xilidinas,seus derivados e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214931', 'description' => 'Sulfato de tranilcipromina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214939', 'description' => 'Outros tranilciprominas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29214990', 'description' => 'Outros monoaminas aromaticas,seus derivados e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215111', 'description' => 'M-fenilenodiamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215112', 'description' => 'Diaminotoluenos (toluilenodiaminas)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215119', 'description' => 'O-fenilenodiamina,p-fenilenodiamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215120', 'description' => 'Derivados sulfonados das fenilenodiaminas,derivs.e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215131', 'description' => 'N,n-di-sec-butil-p-fenilenodiamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215132', 'description' => 'N-isopropil-n-fenil-p-fenilenodiamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215133', 'description' => 'N-(1,3-dimetilbutil)-n-fenil-p-fenilenodiamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215134', 'description' => 'N-(1,4-dimetilpentil)-n-fenil-p-fenilenodiamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215135', 'description' => 'N-fenil-p-fenilenodiamina (4-aminodifenilamina) e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29215139', 'description' => 'Outros derivados das fenilenodiaminas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215190', 'description' => 'Outros sais da fenilenodiaminas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215911', 'description' => '3,3-diclorobenzidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215919', 'description' => 'Benzidina,outs.derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215921', 'description' => '4,4-diaminodifenilmetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215929', 'description' => 'Outros diaminodifenilmetanos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215931', 'description' => '4,4-diaminodifenilamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215932', 'description' => 'Acido 4,4-diaminodifenilamino-2-sulfonico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215939', 'description' => 'Outs.diaminodifenilaminas,seus derivados e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29215990', 'description' => 'Outros poliaminas aromaticas,seus derivados e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221100', 'description' => 'Monoetanolamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221200', 'description' => 'Dietanolamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221400', 'description' => 'Dextropropoxifeno (dci) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221500', 'description' => 'Trietanolamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221600', 'description' => 'Perfluoroctanossulfonato de dietanolamonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221700', 'description' => 'Metildietanolamina e etildietanolamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221800', 'description' => '2 (n,n diisopropilamino)etanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221911', 'description' => 'Monoisopropanolamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221912', 'description' => '2,4-diclorofenoxiacetato de triisopropanolamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221913', 'description' => '2,4-diclorofenoxiacetato de dimetilpropanolamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221919', 'description' => 'Propanolamina,outs.sais e derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221921', 'description' => 'Citrato de orfenadrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221929', 'description' => 'Orfenadrina e outs.sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221931', 'description' => 'Cloridrato de ambroxol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221939', 'description' => 'Ambroxol e outs.sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221941', 'description' => 'Cloridrato de clobutinol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221949', 'description' => 'Clobutinol e outs.sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221951', 'description' => 'N,n-dimetill-2-aminoetanol e seus sais protonados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221952', 'description' => 'N,n-dietill-2-aminoetanol e seus sais protonados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221959', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221971', 'description' => 'Cloridrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221979', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221981', 'description' => 'Tartarato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221989', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221991', 'description' => '1-p-nitrofenil-2-amino-1,3-propanodiol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221992', 'description' => 'Fumarato de benciclano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221993', 'description' => 'Clembuterol (clenbuterol) e seu cloridrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221994', 'description' => 'Mirtecaina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221995', 'description' => 'Tamoxifen e seu citrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221996', 'description' => 'Propranolol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29221999', 'description' => 'Outros aminoalcoois,seus eteres,esteres e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29222100', 'description' => 'Acido aminonaftolsulfonico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29222911', 'description' => 'P-aminofenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29222919', 'description' => 'O-aminofenois,m-aminofenois e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29222920', 'description' => 'Nitroanisidinas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29222990', 'description' => 'Outs.aminonaftois,aminofenois,seus eteres,esteres,sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29223111', 'description' => 'Dietilpropiona (amfepramone)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29223112', 'description' => 'Sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29223120', 'description' => 'Metadona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29223130', 'description' => 'Normetadona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29223910', 'description' => 'Aminoantraquinonas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29223921', 'description' => 'Cloridrato de ketamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29223929', 'description' => 'Ketamina e outs.sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29223990', 'description' => 'Outs.aminoaldeidos,aminocetonas,aminoquinonas,seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224110', 'description' => 'Lisina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224190', 'description' => 'Esteres e sais,da lisina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224210', 'description' => 'Acido glutamico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224220', 'description' => 'Sais do acido glutamico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224300', 'description' => 'Acido antranilico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224410', 'description' => 'Tilidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224420', 'description' => 'Sais de tilidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224910', 'description' => 'Glicina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224920', 'description' => 'Acido etilenodiaminotetracetico (edta) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224931', 'description' => 'Acido iminodiacetico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224932', 'description' => 'Sais do acido iminodiacetico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224940', 'description' => 'Acido dietilenotriaminopentacetico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224951', 'description' => 'Alfa-fenilglicina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224952', 'description' => 'Cloridrato do cloreto de d(-)alfa-aminobenzenoacetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224959', 'description' => 'Outros sais e derivados de alfa-fenilglicina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224961', 'description' => 'Diclofenaco de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224962', 'description' => 'Diclofenaco de potassio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224963', 'description' => 'Diclofenaco de dietilamonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224964', 'description' => 'Diclofenaco', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224969', 'description' => 'Outros diclofenacos,seus sais e derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29224990', 'description' => 'Outros aminoacidos,seus esteres e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29225011', 'description' => 'Cloridrato de fenilefrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29225019', 'description' => 'Fenilefrina e outs.sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29225031', 'description' => 'Levodopa de tirosina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29225032', 'description' => 'Metildopa de tirosina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29225039', 'description' => 'Tirosina e outs. sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29225091', 'description' => 'N(1metoxicarbonil)propen-2il)alfa amino p-etc.(napoh)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29225099', 'description' => 'Outs.aminoalcooisfenois,aminoacidosfenois,etc.func.oxig', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29231000', 'description' => 'Colina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29232000', 'description' => 'Lecitinas e outros fosfoaminolipidios', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29233000', 'description' => 'Perfluoroctanossulfonato de tetraetilamonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29234000', 'description' => 'Perfluoroctanossulfonato de didecildimetilamonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29239010', 'description' => 'Betaina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29239020', 'description' => 'Derivados da colina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29239030', 'description' => 'Cloreto de 3-cloro-2-hidroxipropiltrimetilamonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29239040', 'description' => 'Halogenetos de alquil-trimetilamonio,c/alquila c6 a c22', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29239050', 'description' => 'Halogenetos de dialquil- ou alquil-benzil-dimetilamonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29239060', 'description' => 'Halogenetos de pentametil-alquil-propilenodiamonio,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29239090', 'description' => 'Outros sais e hidroxidos de amonio quaternarios', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241100', 'description' => 'Meprobamato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241210', 'description' => 'Fluorocetamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241220', 'description' => 'Fosfamidona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241230', 'description' => 'Monocrotofos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241911', 'description' => '2-cloro-n-metilacetoacetamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241919', 'description' => 'Acetoacetamidas e outs.derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241921', 'description' => 'N-metilformamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241922', 'description' => 'N,n-dimetilformamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241929', 'description' => 'Outros formamidas e acetamidas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241931', 'description' => 'Acrilamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241932', 'description' => 'Metacrilamidas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241939', 'description' => 'Outros derivados das acrilamidas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241942', 'description' => 'Dicrotofos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29241949', 'description' => 'Crotonamidas e outs.derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241991', 'description' => 'N,n-dimetilureia', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241992', 'description' => 'Carisoprodol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241993', 'description' => 'N,n(diestearoil)etilenodiamina (etilen-bis-estearamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241994', 'description' => 'Dietanolamidas de acidos graxos de c12 a c18', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29241999', 'description' => 'Outros amidas aciclicas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242111', 'description' => 'Hexanitrocarbanilidas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242119', 'description' => 'Carbanilidas,outs.derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242120', 'description' => 'Diuron', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242190', 'description' => 'Outros ureinas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242300', 'description' => 'Acido 2-acetamidobenzoico )acido n-acetilantanilico) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242400', 'description' => 'Etinamato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242500', 'description' => 'Alaclor (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242911', 'description' => 'Acetanilida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242912', 'description' => '4-aminoacetanilida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242913', 'description' => 'Acetaminofen (paracetamol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242914', 'description' => 'Lidocaina e seu cloridrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242915', 'description' => '2,5-dimetoxiacetanilida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242919', 'description' => 'Outros derivados da acetanilida e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242920', 'description' => 'Anilidas dos acidos hidroxinaftoicos,seus derivs.e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242931', 'description' => 'Carbaril', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242932', 'description' => 'Propoxur', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242939', 'description' => 'Outros carbamatos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242941', 'description' => 'Teclozam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242943', 'description' => 'Atenolol, metolaclor', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242944', 'description' => 'Acido ioxaglico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242945', 'description' => 'Iodamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242946', 'description' => 'Cloreto do acido p-acetamidobenzenossulfonico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242947', 'description' => 'Acido ioxitalamico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242949', 'description' => 'Outros acetamidas e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242951', 'description' => 'Bromoprida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242952', 'description' => 'Metoclopramida e seu cloridrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242959', 'description' => 'Outros metoxibenzamidas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242961', 'description' => 'Propanil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242962', 'description' => 'Flutamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242963', 'description' => 'Prilocaina e seu cloridrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242964', 'description' => 'Iobitridol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242969', 'description' => 'Outros propanamidas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242991', 'description' => 'Aspartame', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242992', 'description' => 'Diflubenzuron', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242993', 'description' => 'Metalaxil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242994', 'description' => 'Triflumuron', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242995', 'description' => 'Buclosamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242996', 'description' => 'Benzoato de denatônio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29242999', 'description' => 'Outros amidas ciclicas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29251100', 'description' => 'Sacarina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29251200', 'description' => 'Glutetimida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29251910', 'description' => 'Talidomida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29251990', 'description' => 'Outros imidas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252100', 'description' => ' clordimeforme (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252911', 'description' => 'Aspartato de l-arginina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252919', 'description' => 'Outs arginina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252921', 'description' => 'Guanidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29252922', 'description' => 'N,n-difenilguanidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252923', 'description' => 'Clorexidina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252929', 'description' => 'Outros derivados da guanidina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252930', 'description' => 'Amitraz', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252940', 'description' => 'Isetionato de pentamidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252950', 'description' => 'N-(3,7-dimetil-7-hidroxioctilideno)antranilato metila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29252990', 'description' => 'Outros iminas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29261000', 'description' => 'Acrilonitrila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29262000', 'description' => '1-cianoguanidina (diciandiamida)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29263011', 'description' => 'Femproporex (fenproporex)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29263012', 'description' => 'Ssia de fenproporex', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29263020', 'description' => 'Intermediário de metadona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29264000', 'description' => 'Alfa fenilacetoacetonitrila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269011', 'description' => 'Verapamil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269012', 'description' => 'Cloridrato de verapamil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269019', 'description' => 'Outros sais de verapamil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269021', 'description' => 'Alcool alfa-ciano-3-fenoxibenzilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269022', 'description' => 'Ciflutrin', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269023', 'description' => 'Cipermetrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269024', 'description' => 'Deltametrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269025', 'description' => 'Fenvalerato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269026', 'description' => 'Cialotrin (cyhalothrin)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269029', 'description' => 'Outs.derivs,esteres do alcool alfa-ciano-3-fenoxibenzil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269030', 'description' => 'Sais de intermediario da metadona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269091', 'description' => 'Adiponitrila (1,4-dicianobutano)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269092', 'description' => 'Cianidrina de acetona (acetona cianidrina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269093', 'description' => 'Closantel', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269095', 'description' => 'Clorotalonil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269096', 'description' => 'Cianoacrilatos de etila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29269099', 'description' => 'Outros compostos de funcao nitrila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29270010', 'description' => 'Compostos diazoicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29270021', 'description' => 'Azodicarbonamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29270029', 'description' => 'Outros compostos azoicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29270030', 'description' => 'Compostos azoxicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29280011', 'description' => 'Metiletilacetoxima', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29280019', 'description' => 'Outros acetoximas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29280020', 'description' => 'Carbidopa', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29280030', 'description' => '2-hidrazinoetanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29280041', 'description' => 'Fenilidrazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29280042', 'description' => 'Derivados da fenilidrazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29280090', 'description' => 'Outs.derivados organicos da hidrazina e hidroxilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29291010', 'description' => 'Diisocianato de difenilmetano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29291021', 'description' => 'Mistura de isomeros de diisocianatos de tolueno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29291029', 'description' => 'Outros diisocianatos de tolueno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29291030', 'description' => 'Isocianato de 3,4-diclorofenila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29291090', 'description' => 'Outros isocianatos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29299011', 'description' => 'Acido ciclamico de sodio e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29299012', 'description' => 'Acido ciclamico de calcio e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29299019', 'description' => 'Outros acidos ciclamicos e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29299021', 'description' => 'Dialogenetos de n,n-dialquil-fosforoamidatos (...)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29299022', 'description' => 'N,n-dialquil-fosforoamidatos de dialquila, (...)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29299029', 'description' => 'Outros (n,n-dialquil-fosforamidas e seus derivados)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29299090', 'description' => 'Outros compostos de funcoes nitrogenadas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29302011', 'description' => 'Eptc (tiocarbamato)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29302012', 'description' => 'Cartap', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29302013', 'description' => 'Tiobencarb (dietiltiocarbamato de s-4-clorobenzila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29302019', 'description' => 'Outros tiocarbamatos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29302021', 'description' => 'Ziram e dimetilditiocarbamato de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29302022', 'description' => 'Dietilditiocarbamato de zinco', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29302023', 'description' => 'Dibutilditiocarbamato de zinco', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29302024', 'description' => 'Metam sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29302029', 'description' => 'Outros ditiocarbamatos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29303011', 'description' => 'Monossulfeto de tetrametiltiourama', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29303012', 'description' => 'Sulfiram', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29303019', 'description' => 'Outros monossulfetos de tiourama', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29303021', 'description' => 'Thiram', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29303022', 'description' => 'Dissulfiram', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29303029', 'description' => 'Outros dissulfetos de tiourama', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29303090', 'description' => 'Tetrassulfetos de tiourama', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29304010', 'description' => 'Dl-metionina,teor de cinzas sulfatadas>0.1% em peso', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29304090', 'description' => 'Outros metioninas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29306000', 'description' => '2 (n,n dietilamino)etanotiol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29307000', 'description' => 'Sulfeto de bis(2 hidroxietila) (tiodiglicol (dci))', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29308010', 'description' => 'Aldicarb', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29308020', 'description' => 'Captafol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29308030', 'description' => 'Metamidofos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309011', 'description' => 'Acido tioglicolico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309012', 'description' => 'Cisteina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309013', 'description' => 'N,n-dialquil-2-aminoetanotiol, com grupos .... , e seus sais protonados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309019', 'description' => 'Outros tiois,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309021', 'description' => 'Tioureia', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309022', 'description' => 'Tiofanato-metila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309023', 'description' => '4-metil-3-tiosemicarbazida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309029', 'description' => 'Outros tioamidas,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309031', 'description' => '2-(etiltio)etanol com uma concentracao>=98%', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309032', 'description' => '3-(metiltio)propanal e aldicarb', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309033', 'description' => 'Clorotioformiato de s-etila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309034', 'description' => 'Acido 2-hidroxi-4-(metiltio)butanoico e seu sal calcico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309035', 'description' => 'Metomil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309036', 'description' => 'Carbocisteina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309037', 'description' => '4-sulfatoetilsulfonil-2,5-dimetoxianilina,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309039', 'description' => 'Outros tioeteres,tioesteres,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309041', 'description' => 'O,o-dietil-fosforotioato de s-(2-)dietilamino) etila) e seus sais (...)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309042', 'description' => 'Fosforoditioato de 0,0-dimetila s-(etc.)vamidotion', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309043', 'description' => 'Fosforotioato de o-(4-bromo-s-clorofenila, etc) profenofos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309049', 'description' => 'Outros (fosforotioatos,seus derivados e sais)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309051', 'description' => 'Forato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309052', 'description' => 'Dissulfoton', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309053', 'description' => 'Etion', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309054', 'description' => 'Dimetoato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309057', 'description' => 'Tiometon', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309059', 'description' => 'Outros fosforoditioatos,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309061', 'description' => 'Acefato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309069', 'description' => 'Outros fosforoamidotioatos,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309071', 'description' => 'Tiaprida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309072', 'description' => 'Bicalutamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29309079', 'description' => 'Outros sulfonas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309081', 'description' => 'Sulfeto de 2-cloroetila e de clorametila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309082', 'description' => 'Sulfeto de bis (2-cloroetila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309083', 'description' => 'Bis (2-cloroetiltio) metano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309084', 'description' => '1,2-bis (2-cloroetiltio) etano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309085', 'description' => '1,3-bis (2-cloroetiltio) n-propano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309086', 'description' => '1,4-bis (2-cloroetiltio) n-butano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309087', 'description' => '1,5-bis (2-cloroetiltio) n-pentano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309088', 'description' => 'Oxido de bis (2-cloroetiltiometila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309089', 'description' => 'Oxido de bis (2-cloroetiltioetila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309091', 'description' => 'Captan', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309093', 'description' => 'Metileno-bis-tiocianato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309094', 'description' => 'Dimetiltiofosforamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309095', 'description' => 'Etilditiofosfonato de o-etila e de s-fenila (fonofós)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309096', 'description' => 'Hidrogenio alquil  (de c1 a c3) fosfonotioatos (...)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309097', 'description' => 'Outros compostos que apresentam um átomo de fósforo ligado (...)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309098', 'description' => 'Ditiocarbonatos (xantatos e xantogenatos)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29309099', 'description' => 'Outros tiocompostos organicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29311000', 'description' => 'Chumbo tetrametila e chumbo tetraetileno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29312000', 'description' => 'Compostos de tributilestanho', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313100', 'description' => 'Metilfosfonato de dimetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313200', 'description' => 'Propilfosfonato de dimetila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313300', 'description' => 'Etilfosfonato de dietila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313400', 'description' => 'Metilfosfonato de sodio 3 (triidroxisilil)propila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313500', 'description' => '2,4,6 trioxido de 2,4,6 tripropil 1,3,5,2,4,6 trioxatrifosfinano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313600', 'description' => 'Metilfosfonato de (5 etil 2 metil 2 oxido 1,3,2 dioxafosfinan 5 il)metil metila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313700', 'description' => 'Metilfosfonato de bis[(5 etil 2 metil 2 oxido 1,3,2 dioxafosfinan 5 il)metila]', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313800', 'description' => 'Sal do acido metilfosfonico e de (aminoiminometil)ureia (1:1)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313911', 'description' => 'Etefon, difenilfosfonato(4,4  bis((dimetoxifosfinil)metil)difenila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313912', 'description' => 'Glifosato e seu sal de monoisopropilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313913', 'description' => 'Etidronato dissodico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313914', 'description' => 'Triclorfon', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313915', 'description' => 'Glufosinato de amonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313916', 'description' => 'Hidrogenofosfonato de bis(2 etilexilo)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313917', 'description' => 'Acido fosfonometiliminodiacetico, acido trimetilfosfonico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313918', 'description' => 'Acido clodronico e seu sal dissodico, fotemustina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313991', 'description' => 'Alquil(de c1 a c3)fosfonofluoridatos de o alquila (de ate c10, incluindo os cicloalquila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313992', 'description' => 'Metilfosfonocloridato de o isopropila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313993', 'description' => 'Metilfosfonocloridato de o pinacolila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313994', 'description' => 'Difluoreto de alquilfosfonila, com grupo alquila de c1 a c3', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313995', 'description' => 'Hidrogenio alquil(de c1 a c3)fosfonitos de [o 2 (dialquil(de c1 a c3)amino)etila], seus esteres de o alquila (de ate c10, incluindo os cicloalquila), sais alquilados ou protonados destes produtos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313996', 'description' => 'Outros compostos que contenham um atomo de fosforo ligado a um grupo alquila (de c1 a c3), sem outros atomos de carbono', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313997', 'description' => 'N,n dialquil(de c1 a c3)fosforoamidocianidatos de o alquila (de ate c10, incluindo os cicloalquila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29313999', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319021', 'description' => 'Bis(trimetilsilil)ureia', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319029', 'description' => 'Outros compostos organossilicicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319041', 'description' => 'Acetato de trifenilestanho', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319042', 'description' => 'Tetraoctilestanho', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319043', 'description' => 'Ciexatim', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319044', 'description' => 'Hidroxido de trifenilestanho', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319045', 'description' => 'Oxido de fembutatin (oxido de fenbutatin)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319046', 'description' => 'Sais de dimetil-estanho,etc.do acido carboxil/tioglicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319049', 'description' => 'Outros compostos organo-metalicos do estanho', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29319051', 'description' => 'Acido metilarsinico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319052', 'description' => '2-clorovinil-dicloroarsina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319053', 'description' => 'Bis (2-clorovinil) cloroarsina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319054', 'description' => 'Tris (2-clorovinil) arsina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319059', 'description' => 'Outros compostos organo-arseniais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319061', 'description' => 'Tricloreto de etilaluminio (sesquicloreto etilaluminico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319062', 'description' => 'Cloreto de dietilaluminio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319069', 'description' => 'Outros compostos organo-aluminicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29319090', 'description' => 'Outros compostos organo-inorganicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321100', 'description' => 'Tetraidrofurano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321200', 'description' => '2-furaldeido (furfural)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321310', 'description' => 'Alcool furfurilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321320', 'description' => 'Alcool tetraidrofurfurilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321400', 'description' => 'Sucralose', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321910', 'description' => 'Ranitidina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321920', 'description' => 'Nafronil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321930', 'description' => 'Nitrovin', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321940', 'description' => 'Bioresmetrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321950', 'description' => 'Diacetato de 5-nitrofurfurilideno (nfda)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29321990', 'description' => 'Outs.compostos heterocicl.c/1 ciclo furano,n/condensado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29322000', 'description' => 'Lactonas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329100', 'description' => 'Isossafrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329200', 'description' => '1-(1,3-benzodioxol-5-il) propan-2-ona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329300', 'description' => 'Piperonal', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329400', 'description' => 'Safrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329500', 'description' => 'Tetraidrocanabinóis (todos os isomeros)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329911', 'description' => 'Eucaliptol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329912', 'description' => 'Quercetina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329913', 'description' => 'Dinitrato de isossorbida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329914', 'description' => 'Carbofurano', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329991', 'description' => 'Cloridrato de amiodarona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329992', 'description' => '1,3,4,6,7,8-hexaidro-4,6,6,7,8,8-hexametilciclopent.etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329993', 'description' => 'Dibenzilideno-sorbitol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329994', 'description' => 'Carbosulfan ((dibutilaminotio) metilcarbamato de 2,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29329999', 'description' => 'Outs.compostos heterocicl.de heteroatomos de oxigenio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29331111', 'description' => 'Dipirona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29331112', 'description' => 'Magnopirol (dipirona magnesica)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29331119', 'description' => 'Outs.ac.1-fenil-2,3-dimetil-5-pirazolona-4-metilam.etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29331120', 'description' => 'Metileno-bis (4metilamino-1fenil-2,3-dimetil)pirazolona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29331190', 'description' => 'Outros fenazonas (antipirinas) e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29331911', 'description' => 'Fenilbutazona calcica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29331919', 'description' => 'Outros fenilbutazonas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29331990', 'description' => 'Outs.compostos heterocicls.c/1 ciclo pirazol,n/condens.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332110', 'description' => 'Iprodiona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332121', 'description' => 'Fenitoina e seu sal sodico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332129', 'description' => 'Outros sais da fenitoina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332190', 'description' => 'Outros hidantoinas e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332911', 'description' => '2-metil-5-nitroimidazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332912', 'description' => 'Metronidazol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332913', 'description' => 'Tinidazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332919', 'description' => 'Outs.compostos heterociclicos com 1 ciclo nitroimidazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332921', 'description' => 'Econazol e seu nitrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332922', 'description' => 'Nitrato de miconazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29332923', 'description' => 'Cloridrato de clonidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332924', 'description' => 'Nitrato de isoconazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332925', 'description' => 'Clotrimazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332929', 'description' => 'Outs.compostos heterociclicos c/ciclo benzeno clorado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332930', 'description' => 'Cimetidina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332940', 'description' => '4-metil-5-hidroximetilimidazol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332991', 'description' => 'Imidazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332992', 'description' => 'Histidina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332993', 'description' => 'Ondansetron e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332994', 'description' => '1-hidroxietil-2-undecanoilimidazolina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332995', 'description' => '1-hidroxietil-2-(8-heptadecenoil) imidazolina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29332999', 'description' => 'Outs.compostos heterocicl.1 ciclo imidazol n/condensado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333110', 'description' => 'Piridina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333120', 'description' => 'Sais de piridina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333200', 'description' => 'Piperidina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333311', 'description' => 'Alfentanil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333312', 'description' => 'Anileridina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333319', 'description' => 'Sais de alfentanil e anileridina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333321', 'description' => 'Bezitramida (ezitramide)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333322', 'description' => 'Bromazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333329', 'description' => 'Sais de bezitramida e bromazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333330', 'description' => 'Cetobemidona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333341', 'description' => 'Difenoxilato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333342', 'description' => 'Cloridrato de difenoxilato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333349', 'description' => 'Outros, sais de difenoxilato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333351', 'description' => 'Difenoxina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333352', 'description' => 'Dipipanona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333359', 'description' => 'Sais de difenoxina e dipipanona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333361', 'description' => 'Fenciclidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333362', 'description' => 'Fenoperidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333363', 'description' => 'Fentanil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333369', 'description' => 'Sais de fenciclidina, fenoperidina e fentanil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333371', 'description' => 'Metifenidato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333372', 'description' => 'Pentazocina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333379', 'description' => 'Sais de metilfenidato e pentazocina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333381', 'description' => 'Petidina (meperidina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333382', 'description' => 'Intermediario a da petidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333383', 'description' => 'Pipradrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333384', 'description' => 'Cloridrato de petidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333389', 'description' => 'Sais de petidina, intermediário a da petidina e pipradrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333391', 'description' => 'Piritramida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333392', 'description' => 'Propiram', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333393', 'description' => 'Trimeperidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333399', 'description' => 'Sais de piritramida, propiram e trimeperidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333912', 'description' => 'Droperidol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333913', 'description' => 'Acido niflumico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333914', 'description' => 'Haloxifop (acido (rs)-2-[4-(3-cloro-5-trifluormetil-etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333915', 'description' => 'Haloperidol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333919', 'description' => 'Outs.compost.heterocicl.c/fluor e/ou bromo,lig.covalent', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333921', 'description' => 'Picloram', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333922', 'description' => 'Clorpirifos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333923', 'description' => 'Malato acido de cleboprida (malato de cleboprida)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333924', 'description' => 'Cloridrato de cloperamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29333925', 'description' => 'Acido 2-(2metil-3cloroanilino) nicotinico/sal de lisina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333929', 'description' => 'Outros compostos heterocicls.c/cloro,sem fluor nem brom', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333931', 'description' => 'Terfenadina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333932', 'description' => 'Biperideno e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333933', 'description' => 'Acido isonicotinico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333934', 'description' => '5-etil-2,3-dicarboxipiridina (5-epdc)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333935', 'description' => 'Imazetapir (ac.(rs)-5-etil-2-(4-isopropil-4-metil-5-etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333936', 'description' => 'Quinuclidin-3-ol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333939', 'description' => 'Outros (cuja estrutura contém funções álcool, acido carboxilico......).....', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333943', 'description' => 'Nifedipina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333944', 'description' => 'Nitrendipina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333945', 'description' => 'Maleato de pirilamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333946', 'description' => 'Omeprazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333947', 'description' => 'Benzilado de 3-quinuclidinila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333948', 'description' => 'Nimodipina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333949', 'description' => 'Outros (cuja estrutura contém eter, ester ou ambas.............)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333981', 'description' => 'Cloridrato de benzetimida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333982', 'description' => 'Cloridrato de mepivacaina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333983', 'description' => 'Cloridrato de bupivacaina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333984', 'description' => 'Dicloreto de paraquat', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333989', 'description' => 'Outs.compost.heterocicl.c/piridina,n-subst.alquila,aril', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333991', 'description' => 'Cloridrato de fenazopiridina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333992', 'description' => 'Isoniazida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333993', 'description' => '3-cianopiridina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333994', 'description' => '4,4-bipiridina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29333999', 'description' => 'Outs.compostos heterocicl.1 ciclo piridina n/condensado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334110', 'description' => 'Levorfanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334120', 'description' => 'Sais de levorfanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334911', 'description' => 'Acido 2,3-quinolinodicarboxilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334912', 'description' => 'Rosoxacina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334913', 'description' => 'Imazaquin', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334919', 'description' => 'Outros derivados do acido quinolinocarboxilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334920', 'description' => 'Oxaminiquina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334930', 'description' => 'Broxiquinolina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334940', 'description' => 'Esteres do levorfanol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29334990', 'description' => 'Outs.compostos heterociclicos c/1 ciclo quinoleina,etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335200', 'description' => 'Malonilureia(manolinureia) (acido barbitúrico) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335311', 'description' => 'Alobarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335312', 'description' => 'Amobarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335321', 'description' => 'Barbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335322', 'description' => 'Butalbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335323', 'description' => 'Butobarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335330', 'description' => 'Ciclobarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335340', 'description' => 'Fenobarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335350', 'description' => 'Metilfenobarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335360', 'description' => 'Pentobarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335371', 'description' => 'Secbutabarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335372', 'description' => 'Secobarbital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335380', 'description' => 'Vinibital e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335400', 'description' => 'Outros derivados da malonilureia(manolinureia), metaqualona e zizeprol, sais desses produtos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335510', 'description' => 'Loprazolam e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335520', 'description' => 'Mecloqualona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335530', 'description' => 'Metaqualona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29335540', 'description' => 'Zipeprol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335911', 'description' => 'Oxatomida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335912', 'description' => 'Praziquantel', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335913', 'description' => 'Norfloxacina e seu nicotinato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335914', 'description' => 'Flunarizina e seu dicloridrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335915', 'description' => 'Enrofloxacina, sais de piperazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335916', 'description' => 'Cloridrato de buspirona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335919', 'description' => 'Outs.compostos heterociclicos,com ciclo piperazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335921', 'description' => 'Bromacil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335922', 'description' => 'Terbacil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335923', 'description' => 'Fluorouracil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335929', 'description' => 'Outs.compost.heteroc.ciclo pirimidina,halog.lig.covalen', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335931', 'description' => 'Propiltiouracil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335932', 'description' => 'Diazinon', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335933', 'description' => 'Pirazofos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335934', 'description' => 'Azatioprina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335935', 'description' => '6-mercaptopurina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335939', 'description' => 'Outs.compost.heteroc.ciclo pirimidina,enxofre,s/halogen', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335941', 'description' => 'Trimetoprima', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335942', 'description' => 'Aciclovir', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335943', 'description' => 'Tosilatos de dipiridamol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335944', 'description' => 'Nicarbazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335945', 'description' => 'Bissulfito de menadiona dimetilpirimidinol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335949', 'description' => 'Outs.comp.heteroc.cicl.pirimidina,func.alcool e/ou eter', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335991', 'description' => 'Minoxidil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335992', 'description' => '2-aminopirimidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29335999', 'description' => 'Outs.compostos heterocicl.c/ciclo pirimidina/piperazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336100', 'description' => 'Melamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336911', 'description' => '2,4,6-triclorotriazina (cloreto cianurico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336912', 'description' => 'Mercaptodiclorotriazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336913', 'description' => 'Atrazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336914', 'description' => 'Simazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336915', 'description' => 'Cianazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336916', 'description' => 'Anilazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336919', 'description' => 'Outs.compost.heteroc.ciclo triazina,c/cloro lig.covalen', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336921', 'description' => 'N,n,n-triidroxietilexaidrotriazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336922', 'description' => 'Hexazinona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336923', 'description' => 'Metribuzim', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336929', 'description' => 'Outs.compost.heteroc.ciclo triazina,s/cloro lig.covalen', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336991', 'description' => 'Ametrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336992', 'description' => 'Metenamina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29336999', 'description' => 'Outs.compostos heterocicl.1 ciclo triazina n/condensado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29337100', 'description' => '6-hexanolactama (epsilon-caprolactama)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29337210', 'description' => 'Clobazan', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29337220', 'description' => 'Metilprilona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29337910', 'description' => 'Piracetam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29337990', 'description' => 'Outros lactamas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339111', 'description' => 'Alprazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339112', 'description' => 'Camazepan', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339113', 'description' => 'Clonazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339114', 'description' => 'Clorazepato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339115', 'description' => 'Clordiazepoxido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339119', 'description' => 'Clordiazepoxido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29339121', 'description' => 'Delorazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339122', 'description' => 'Diazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339123', 'description' => 'Estazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339129', 'description' => 'Sais de delorazepam, diazepam, estazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339131', 'description' => 'Fludiazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339132', 'description' => 'Flunitrazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339133', 'description' => 'Flurazepam e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339134', 'description' => 'Halazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339139', 'description' => 'Sais de fludiazepam, flunitrazepam, flurazepam, halazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339141', 'description' => 'Loflazepato de etila', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339142', 'description' => 'Lorazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339143', 'description' => 'Lormetazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339149', 'description' => 'Sais de loflazepato, lorazepam, lormetazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339151', 'description' => 'Mazindol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339152', 'description' => 'Medazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339153', 'description' => 'Midazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339159', 'description' => 'Sais de mazindol, medazepam, midazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339161', 'description' => 'Nimetazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339162', 'description' => 'Nitrazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339163', 'description' => 'Nordazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339164', 'description' => 'Oxazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339169', 'description' => 'Sais de nimetazepam, nitrazepam, nordazepam, oxazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339171', 'description' => 'Pinazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339172', 'description' => 'Pirovalerona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339173', 'description' => 'Prazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339179', 'description' => 'Sais de pinazepam, pirovalerona, prazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339181', 'description' => 'Temazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339182', 'description' => 'Tetrazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339183', 'description' => 'Triazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339189', 'description' => 'Sais de temazepam, tetrazepam, triazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339200', 'description' => 'Azinfos metil (iso)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339911', 'description' => 'Pirazinamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339912', 'description' => 'Cloridrato de amilorida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339913', 'description' => 'Pindolol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339919', 'description' => 'Sais de alprazolam, camazepam, clonazepam, clorazepato,etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339920', 'description' => 'Outs.compostos heterocicl.c/1 ciclo diazepina(hidrogenado ou não)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339931', 'description' => 'Dibenzoazepina (iminoestilbeno)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339932', 'description' => 'Carbamazepina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339933', 'description' => 'Cloridrato de clomipramina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339934', 'description' => 'Molinate (hexaidroazepin-1-carbotioato de s-etila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339935', 'description' => 'Hexametilenoimina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339939', 'description' => 'Outs.compostos heterociclicos,com 1 ciclo azepina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339941', 'description' => 'Clemastina,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339942', 'description' => 'Amisulprida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339943', 'description' => 'Sultoprida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339944', 'description' => 'Alizaprida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339945', 'description' => 'Buflomedil,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339946', 'description' => 'Maleato de enalapril', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339947', 'description' => 'Ketorolac trometamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339949', 'description' => 'Outros compostos heterociclicos,com 1 ciclo pirrol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339951', 'description' => 'Benomil', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339952', 'description' => 'Oxifendazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339953', 'description' => 'Albendazol e seu sulfoxido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29339954', 'description' => 'Mebendazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339955', 'description' => 'Flubendazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339956', 'description' => 'Fembendazol (fenbendazole)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339959', 'description' => 'Outros compostos heterociclicos,com ciclo imidazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339961', 'description' => 'Triadimenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339962', 'description' => 'Triadimefon', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339963', 'description' => 'Triazofos (fosforotioato de o,o-dietila-o-(1-fenil-etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339969', 'description' => 'Outs.compost.heterocicl.c/1 ciclo triazol n/condensado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339991', 'description' => 'Azinfos etilico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339992', 'description' => 'Acido nalidixico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339993', 'description' => 'Clofazimina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339995', 'description' => 'Metilsulfato de amezinio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339996', 'description' => 'Hidrazida maleica e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29339999', 'description' => 'Outs.compostos heterocicl.de heteroatomos de nitrogenio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29341010', 'description' => 'Fentiazac', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29341020', 'description' => 'Cloridrato de tiazolidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29341030', 'description' => 'Tiabendazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29341090', 'description' => 'Outs.compostos heterocicl.c/1 ciclo tiazol n/condensado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342010', 'description' => '2-mercaptobenzotiazol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342020', 'description' => '2,2-ditiobis(benzotiazol) (dissulfeto de benzotiazila)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342031', 'description' => '2-(terbutilaminotio)benzotiazol (n-terbutil-benzot.etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342032', 'description' => '2-(cicloexilaminotio)benzotiazol(n-cicloexil-benzot.etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342033', 'description' => '2-(dicicloexilaminotio)benzotiazol (n,n-dicicloexil-etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342034', 'description' => '2-(4-morfonilitio)benzotiazol (n-oxidietileno-benz.etc.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342039', 'description' => 'Outros benzotiazois-sulfenamidas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342040', 'description' => '2-(tiocianometiltio)benzotiazol (tcmtb)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29342090', 'description' => 'Outs.compostos heterociclicos com ciclos de benzotiazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29343010', 'description' => 'Maleato de metotrimeprazina (maleato de levomepromazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29343020', 'description' => 'Enantato de flufenazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29343030', 'description' => 'Prometazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29343090', 'description' => 'Outs.compostos heterociclicos com ciclos fenotiazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349111', 'description' => 'Aminorex e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349112', 'description' => 'Brotizolam e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349121', 'description' => 'Clotiazepam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349122', 'description' => 'Cloxazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349123', 'description' => 'Dextromoramida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349129', 'description' => 'Sais de clotiazepam, cloxazolam, dextromoramia', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349131', 'description' => 'Ferdimetrazina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349132', 'description' => 'Fenmetrazina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349133', 'description' => 'Haloxazolam e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349141', 'description' => 'Ketazolam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349142', 'description' => 'Mesocarb', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349149', 'description' => 'Sais de ketazolam, mesocato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349150', 'description' => 'Oxazolam e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349160', 'description' => 'Pemolina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349170', 'description' => 'Sulfentanil e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349911', 'description' => 'Morfolina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349912', 'description' => 'Pirenoxina sodica (catalino sodico)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349913', 'description' => 'Nimorazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349914', 'description' => 'Anidrido isatoico (2h-3,1-benzoxazina-2,4-(1h)-diona)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349915', 'description' => '4,4-ditiodimorfolina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349919', 'description' => 'Outros compostos heterociclicos,com ciclos oxazina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349922', 'description' => 'Zidovudina (azt)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29349923', 'description' => 'Timidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349924', 'description' => 'Furazolidona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349925', 'description' => 'Citarabina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349926', 'description' => 'Oxadiazona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349927', 'description' => 'Estavudina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349929', 'description' => 'Outs.acidos nucleicos,seus sais de construção quimica não definida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349931', 'description' => 'Cetoconazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349932', 'description' => 'Cloridrato de prazosina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349933', 'description' => 'Talniflumato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349934', 'description' => 'Acido nucleico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349935', 'description' => 'Propiconazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349939', 'description' => 'Outs.compostos heterocicl.c/heteroatomos de nitrog.oxig', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349941', 'description' => 'Tiofeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349942', 'description' => 'Acido 6-aminopenicilanico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349943', 'description' => 'Acido 7-aminocefalosporanico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349944', 'description' => 'Acido 7-aminodesacetoxifalosporanico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349945', 'description' => 'Clormezanona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349946', 'description' => '9-(n-metil-4-piperidinilideno)tioxanteno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349949', 'description' => 'Outs.compost.heteroc.heteroatom<=2 enxofre,incl.nitrog.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349951', 'description' => 'Tebutiuron', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349952', 'description' => 'Tetramisol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349953', 'description' => 'Levamisol e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349954', 'description' => 'Tioconazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349959', 'description' => 'Outros compost.heterocicl.c/3 heteroatom. enxofre e nitr', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349961', 'description' => 'Cloridrato de tizanidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349969', 'description' => 'Outs.compostos heteroc.c/heteroatom.enxofre incl.nitrog', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349991', 'description' => 'Timolol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349992', 'description' => 'Maleato acido de timolol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349993', 'description' => 'Lamivudina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29349999', 'description' => 'Outs acidos nucleicos,seus sais, outs compostos heterociclicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29351000', 'description' => 'N metilperfluoroctano sulfonamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29352000', 'description' => 'N etilperfluoroctano sulfonamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29353000', 'description' => 'N etil n (2 hidroxietil)perfluoroctano sulfonamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29354000', 'description' => 'N (2 hidroxietil) n metilperfluoroctano sulfonamida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29355000', 'description' => 'Outras perfluoroctanossulfonamidas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359011', 'description' => 'Sulfadiazina e seu sal sodico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359012', 'description' => 'Clortalidona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359013', 'description' => 'Sulpirida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359014', 'description' => 'Veraliprida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359015', 'description' => 'Sulfametazina (4,6 dimetil 2 sulfanilamidopirimidina) e seu sal sodico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359019', 'description' => 'Outras', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359021', 'description' => 'Furosemida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359022', 'description' => 'Ftalilsulfatiazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359023', 'description' => 'Piroxicam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359024', 'description' => 'Tenoxicam', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359025', 'description' => 'Sulfametoxazol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359029', 'description' => 'Outras', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359091', 'description' => 'Cloramina b e cloramina t', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359092', 'description' => 'Gliburida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359093', 'description' => 'Toluenossulfonamidas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359094', 'description' => 'Nimesulida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359095', 'description' => 'Bumetanida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359096', 'description' => 'Sulfaguanidina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29359097', 'description' => 'Sulfluramida', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29359099', 'description' => 'Outras', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362111', 'description' => 'Vitamina a1 alcool (retinol)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362112', 'description' => 'Acetato de vitamina a1 alcool', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362113', 'description' => 'Palmitato de vitamina a1 alcool', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362119', 'description' => 'Outs.derivados da vitamina a1 alcool,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362190', 'description' => 'Outros vitaminas a e seus derivados,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362210', 'description' => 'Cloridrato de vitamina b1 (tiamina),nao misturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362220', 'description' => 'Mononitrato de vitamina b1 (tiamina),nao misturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362290', 'description' => 'Outs.vitaminas b1 e seus derivados,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362310', 'description' => 'Vitamina b2 (riboflavina),nao misturada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362320', 'description' => '5-fosfato sodico de vitamina b2 nao misturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362390', 'description' => 'Outros derivados da vitamina b2,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362410', 'description' => 'D-pantotenato de calcio,nao misturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362490', 'description' => 'Outs.ac.d- ou dl-pantotenico (vitamina b3/b5) e derivs.', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362510', 'description' => 'Vitamina b6,nao misturada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362520', 'description' => 'Cloridrato de piridoxina,nao misturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362590', 'description' => 'Outros derivados da vitamina b6,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362610', 'description' => 'Vitamina b12 (cianocobalamina),nao misturada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362620', 'description' => 'Cobamamida nao misturada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362630', 'description' => 'Hidroxocobalamina e seus sais,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362690', 'description' => 'Outros derivados da vitamina b12,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362710', 'description' => 'Vitamina c (acido l- ou dl-ascorbico),nao misturada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362720', 'description' => 'Ascorbato de sodio,nao misturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362790', 'description' => 'Outros derivados da vitamina c,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362811', 'description' => 'D- ou dl-alfa-tocoferol,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362812', 'description' => 'Acetato de d- ou dl-alfa-tocoferol,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362819', 'description' => 'Outs.derivados de d- ou dl-alfa-tocoferol,n/misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362890', 'description' => 'Outros vitaminas e e seus derivados,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362911', 'description' => 'Vitamina b9 (acido folico) e seus sais,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362919', 'description' => 'Outros derivados da vitamina b9,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362921', 'description' => 'Vitamina d3 (colecalciferol),nao misturada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362929', 'description' => 'Outros vitaminas d e seus derivados,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362931', 'description' => 'Vitamina h (biotina),nao misturada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362939', 'description' => 'Outros derivados da vitamina h,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362940', 'description' => 'Vitaminas k e seus derivados,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362951', 'description' => 'Acido nicotinico,nao misturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362952', 'description' => 'Nicotinamida nao misturada', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362953', 'description' => 'Nicotinato de sodio,nao misturado', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362959', 'description' => 'Outs.derivados do acido nicotinico,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29362990', 'description' => 'Outros vitaminas e seus derivados,nao misturados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29369000', 'description' => 'Provitaminas e vitaminas,misturadas ou não, incluidos os concentrados naturais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29371100', 'description' => 'Somatotropina, seus derivados e analogos estruturais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29371200', 'description' => 'Insulina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29371910', 'description' => 'Acth (corticotrofina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29371920', 'description' => 'Hcg (gonadotrofina corionica)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29371930', 'description' => 'Pmsg (gonadotrofina serica)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29371940', 'description' => 'Menotropinas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29371950', 'description' => 'Oxitocina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29371990', 'description' => 'Outs hormonios polipeptideos, proteicos, etc', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372110', 'description' => 'Cortisona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372120', 'description' => 'Hidrocortisona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372130', 'description' => 'Prednisona (deidrocortisona)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29372140', 'description' => 'Prednisolona (deidroidrocortisona)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372210', 'description' => 'Dexametasona e seus acetatos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372221', 'description' => 'Acetonida da triancinolona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372229', 'description' => 'Triancinolona e outs.derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372231', 'description' => 'Valerato de diflucortolona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372239', 'description' => 'Fluorcortolona e outs.derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372290', 'description' => 'Outs.derivs.halogen.dos hormonios corticossupra-renais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372310', 'description' => 'Medroxiprogesterona e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372321', 'description' => 'L-norgestrel (levonorgestrel)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372322', 'description' => 'Dl-norgestrel', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372329', 'description' => 'Norgestrel e outs.derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372331', 'description' => 'Estriol e seu succinato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372339', 'description' => 'Outros esteres e sais do estriol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372341', 'description' => 'Hemissuccinato de estradiol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372342', 'description' => 'Fempropionato de estradiol (17-(3-fenilpropionato)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372349', 'description' => 'Estradiol e outs.esteres,sais e derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372351', 'description' => 'Alilestrenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372359', 'description' => 'Esteres e sais do alilestrenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372360', 'description' => 'Desogestrel', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372370', 'description' => 'Linestrenol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372391', 'description' => 'Acetato de etinodiol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372392', 'description' => 'Gestodeno', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372399', 'description' => 'Outros estrogenios e progestogenios', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372910', 'description' => 'Metiliprednisolona e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372920', 'description' => '21-succinato sodico de hidrocortisona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372931', 'description' => 'Acetato de ciproterona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372939', 'description' => 'Ciproterona e outs.derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372940', 'description' => 'Mesterolona e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372950', 'description' => 'Espironolactona', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372960', 'description' => 'Deflazacorte', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29372990', 'description' => 'Outs.hormonios corticossupra-renais e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29375000', 'description' => 'Prostaglandinas, tromboxanas e leucotrienos, seus derivados e analogos estruturais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29379010', 'description' => 'Tiratricol (triac) e seu sal sódico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29379030', 'description' => 'Levotiroxina sódica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29379040', 'description' => 'Liotironina sódica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29379090', 'description' => 'Outs hormonios, prostaglandinas, tromboxanas e leucotrienos, seus derivados e analogos estruturais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29381000', 'description' => 'Rutosidio (rutina) e seus derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29389010', 'description' => 'Deslanosideo', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29389020', 'description' => 'Esteviosideo', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29389090', 'description' => 'Outs.heterosideos,seus sais,eteres,esteres e derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391110', 'description' => 'Concentrado de palha de papoula', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391121', 'description' => 'Buprenorfina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391122', 'description' => 'Codeina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391123', 'description' => 'Diidrocodeina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391131', 'description' => 'Etilmorfina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391132', 'description' => 'Etorfina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391140', 'description' => 'Folcodina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391151', 'description' => 'Diacetilmorfina,etilmorfina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391152', 'description' => 'Hidrocodona,oxicodona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391153', 'description' => 'Hidromorfona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391161', 'description' => 'Morfina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391162', 'description' => 'Cloridrato e sulfato de morfina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391169', 'description' => 'Outros derivados da morfina, sais destes produtos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29391170', 'description' => 'Nicomorfina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391181', 'description' => 'Oxicodona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391182', 'description' => 'Oximorfina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391191', 'description' => 'Tebacona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391192', 'description' => 'Tebaína e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29391900', 'description' => 'Outros derivados da morfina, sais destes produtos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29392000', 'description' => 'Alcaloides da quina,seus derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29393010', 'description' => 'Cafeina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29393020', 'description' => 'Sais da cafeina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29394100', 'description' => 'Efedrina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29394200', 'description' => 'Pseudoefedrina (dci) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29394300', 'description' => 'Catina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29394400', 'description' => 'Norefredrina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29394900', 'description' => 'Outros (derivados da efedrina e seus sais)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29395100', 'description' => 'Fenetilina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29395910', 'description' => 'Teofilina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29395920', 'description' => 'Aminofilina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29395990', 'description' => 'Derivados e sais da teofilina e aminofilina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396100', 'description' => 'Ergometrina (dci) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396200', 'description' => 'Ergotamina (dci) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396300', 'description' => 'Acido lisergico e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396911', 'description' => 'Maleato de metilergometrina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396919', 'description' => 'Outros derivados da ergometrina (dci) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396921', 'description' => 'Mesilato de diidroergotamina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396929', 'description' => 'Outros derivados da ergotamina (dci) e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396931', 'description' => 'Mesilato de diidroergocornina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396939', 'description' => 'Ergocornina e outs.derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396941', 'description' => 'Mesilato de alfa-diidroergocriptina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396942', 'description' => 'Mesilato de beta-diidroergocriptina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396949', 'description' => 'Ergocriptina e outs.derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396951', 'description' => 'Ergocristina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396952', 'description' => 'Metanossulfonato de diidroergocristina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396959', 'description' => 'Outros derivados da ergocristina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29396990', 'description' => 'Outs.alcaloides da cravagem do centeio,seus derivs.sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397111', 'description' => 'Cocaina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397112', 'description' => 'Ecgonina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397119', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397120', 'description' => 'Levometanfetamina, seus sais, esteres e outros derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397130', 'description' => 'Metanfetamina, seus sais, esteres e outros derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397140', 'description' => 'Racemato de metanfetamina, seus sais, esteres e outros derivados', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397911', 'description' => 'Brometo de n butilescopolamonio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397919', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397920', 'description' => 'Teobromina e seus derivados, sais destes produtos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397931', 'description' => 'Pilocarpina, seu nitrato e seu cloridrato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397939', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397940', 'description' => 'Tiocolquicosido', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29397990', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29398000', 'description' => 'Outros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400011', 'description' => 'Galactose', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400012', 'description' => 'Arabinose', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400013', 'description' => 'Ramnose', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400019', 'description' => 'Outros acucares quimicamente puros', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400021', 'description' => 'Acido lactobionico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29400022', 'description' => 'Lactobionato de calcio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400023', 'description' => 'Bromolactobionato de calcio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400029', 'description' => 'Outs.sais,derivs.halogen.sulfon.etc.do ac.lactobionico', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400092', 'description' => 'Frutose-1,6-difosfato de calcio ou de sodio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400093', 'description' => 'Maltitol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400094', 'description' => 'Lactogluconato de calcio', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29400099', 'description' => 'Outros eteres e esteres de acucares e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411010', 'description' => 'Ampicilina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411020', 'description' => 'Amoxicilina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411031', 'description' => 'Penicilina v potassica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411039', 'description' => 'Outros penicilinas v,derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411041', 'description' => 'Penicilina g potassica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411042', 'description' => 'Penicilina g benzatinica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411043', 'description' => 'Penicilina g procainica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411049', 'description' => 'Outros penicilinas g,derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29411090', 'description' => 'Outros penicilinas,derivs.c/estrut.ac.penicilanico e sa', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29412010', 'description' => 'Sulfatos de estreptomicinas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29412090', 'description' => 'Estreptomicinas,outs.derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29413010', 'description' => 'Cloridrato de tetraciclina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29413020', 'description' => 'Oxitetraciclina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29413031', 'description' => 'Minociclina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29413032', 'description' => 'Sais de minociclina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29413090', 'description' => 'Tetraciclina,outs.derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29414011', 'description' => 'Cloranfenicol,seu palmitato,succinato ou hemissuccinato', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29414019', 'description' => 'Outros esteres do cloranfenicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29414020', 'description' => 'Tianfenicol e seus esteres', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29414090', 'description' => 'Outros derivados e sais,do cloranfenicol', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29415010', 'description' => 'Claritromicina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29415020', 'description' => 'Eritromicina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29415090', 'description' => 'Outros derivados da eritromicina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419011', 'description' => 'Rifamicina s', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419012', 'description' => 'Rifampicina (rifamicina amp)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419013', 'description' => 'Rifamicina sv sodica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419019', 'description' => 'Outros rifamicinas,derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419021', 'description' => 'Cloridrato de lincomicina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419022', 'description' => 'Fosfato de clindamicina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419029', 'description' => 'Lincomicina,outs.derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419031', 'description' => 'Ceftriaxona e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419032', 'description' => 'Cefoperazona e seus sais,e cefazolina sodica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419033', 'description' => 'Cefaclor e cefalexina monoidratados,e cefalotina sodica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419034', 'description' => 'Cefadroxil e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419035', 'description' => 'Cefotaxima sodica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419036', 'description' => 'Cefoxitina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419037', 'description' => 'Cefalosporina c', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419039', 'description' => 'Outs.cefalosporinas e cefamicinas,derivados e sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419041', 'description' => 'Sulfato de neomicina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419042', 'description' => 'Embonato de gentamicina (pamoato de gentamicina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419043', 'description' => 'Sulfato de gentamicina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419049', 'description' => 'Outros aminoglucosideos e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419051', 'description' => 'Embonato de espiramicina (pamoato de espiramicina)', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419059', 'description' => 'Outros macrolidios e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419061', 'description' => 'Nistatina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419062', 'description' => 'Anfotericina b e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '29419069', 'description' => 'Outros polienos e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419071', 'description' => 'Monensina sodica', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419072', 'description' => 'Narasina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419073', 'description' => 'Avilamicinas', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419079', 'description' => 'Outros polieteres e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419081', 'description' => 'Polimixinas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419082', 'description' => 'Sulfato de colistina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419083', 'description' => 'Virginiamicinas e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419089', 'description' => 'Outros polipeptidios e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419091', 'description' => 'Griseofulvina e seus sais', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419092', 'description' => 'Fumarato de tiamulina', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29419099', 'description' => 'Outros antibioticos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '29420000', 'description' => 'Outros compostos organicos', 'aliquota_federal' => 9.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30012010', 'description' => 'Extratos de figados,para uso opoterapico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30012090', 'description' => 'Extratos de glandulas,outs.orgaos,etc.p/uso opoterapico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30019010', 'description' => 'Heparina e seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30019020', 'description' => 'Pedacos de pericardio de origem bovina ou suina', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30019031', 'description' => 'Figados dessecados,para uso opoterapico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30019039', 'description' => 'Glandulas e outs.orgaos,para uso opoterapico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30019090', 'description' => 'Outs.substs.humanas/animais,p/fins terapeuts. profilats.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021100', 'description' => 'Estojos de diagnostico da malaria (paludismo)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021211', 'description' => 'Antiofidicos e outros antivenenosos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021212', 'description' => 'Antitetanico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021213', 'description' => 'Anticatarral', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021214', 'description' => 'Antipiogenico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021215', 'description' => 'Antidifterico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021216', 'description' => 'Polivalentes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021219', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021221', 'description' => 'Imunoglobulina anti rh', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021222', 'description' => 'Outras imunoglobulinas sericas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021223', 'description' => 'Concentrado de fator viii', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021224', 'description' => 'Soroalbumina, em forma de gel, para preparacao de reagentes de diagnostico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021229', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021231', 'description' => 'Soroalbumina, exceto a humana', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021232', 'description' => 'Plasmina (fibrinolisina)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021233', 'description' => 'Uroquinase', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021234', 'description' => 'Imunoglobulina e cloridrato de histamina, associados', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021235', 'description' => 'Imunoglobulina g, liofilizada ou em solucao', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021236', 'description' => 'Soroalbumina humana', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021239', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021300', 'description' => 'Produtos imunologicos, nao misturados, nao apresentados em doses nem acondicionados para venda a retalho', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021410', 'description' => 'Anticorpos monoclonais em solucao tampao, contendo albumina bovina', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021490', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021510', 'description' => 'Interferon beta, peg interferon alfa 2 a', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021520', 'description' => 'Basiliximab (dci), bevacizumab (dci), daclizumab (dci), etanercept (dci), gemtuzumab ozogamicin (dci), oprelvekin (dci), rituximab (dci), trastuzumab (dci)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021590', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30021900', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022011', 'description' => 'Vacina contra a gripe,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022012', 'description' => 'Vacina contra a poliomielite,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022013', 'description' => 'Vacina contra a hepatite b,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022014', 'description' => 'Vacina contra o sarampo,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022015', 'description' => 'Vacina contra a meningite,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022016', 'description' => 'Vacina contra rubeola,sarampo e caxumba,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '30022017', 'description' => 'Outros vacinas triplices,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022018', 'description' => 'Vacinas anticatarral e antipiogenico,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022019', 'description' => 'Outros vacinas para medicina humana,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022021', 'description' => 'Vacina contra a gripe,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022022', 'description' => 'Vacina contra a poliomielite,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022023', 'description' => 'Vacina contra a hepatite b,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022024', 'description' => 'Vacina contra o sarampo,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022025', 'description' => 'Vacina contra a meningite,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022026', 'description' => 'Vacina contra rubeola,sarampo e caxumba,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022027', 'description' => 'Outros vacinas triplices,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022028', 'description' => 'Vacinas anticatarral e antipiogenico,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30022029', 'description' => 'Outros vacinas para medicina humana,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023010', 'description' => 'Vacina veterinaria,contra a raiva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023020', 'description' => 'Vacina veterinaria,contra a coccidiose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023030', 'description' => 'Vacina veterinaria,contra a querato-conjuntivite', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023040', 'description' => 'Vacina veterinaria,contra a cinomose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023050', 'description' => 'Vacina veterinaria,contra a leptospirose', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023060', 'description' => 'Vacina veterinaria,contra a febre aftosa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023070', 'description' => 'Vacina veterinaria contra as enfermidades newcastle, gumboro...', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023080', 'description' => 'Vacinas veterinarias combinadas contra as enfermidades 30023070.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30023090', 'description' => 'Outros vacinas para medicina veterinaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30029010', 'description' => 'Reagentes de origem microbiana para diagnostico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30029020', 'description' => 'Antitoxinas de origem microbiana', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30029030', 'description' => 'Tuberculinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30029091', 'description' => 'Outros toxinas,culturas de microorganismos,p/saude anim', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30029092', 'description' => 'Outros toxinas,culturas de microorganismos,p/saude huma', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30029093', 'description' => 'Saxitoxina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30029094', 'description' => 'Ricina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30029099', 'description' => 'Outs.toxinas,culturas de microorganismos,prods.semelhs.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30031011', 'description' => 'Medicamento cont.ampicilina ou seus sais,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30031012', 'description' => 'Medicamento cont.amoxicilina ou seus sais,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30031013', 'description' => 'Medicamento cont.penicilina g benzatinica,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30031014', 'description' => 'Medicamento cont.penicilina g potassica,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30031015', 'description' => 'Medicamento cont.penicilina g procainica,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30031019', 'description' => 'Medicamento cont.outs.penicilinas/derivs.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30031020', 'description' => 'Medicamento cont.estreptomicinas/derivs.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032011', 'description' => 'Medicamento contendo cloranfenicol,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032019', 'description' => 'Medicamento cont.anfenicois/outs.derivs.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032021', 'description' => 'Medicamento cont.eritromicina/seus sais,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032029', 'description' => 'Medicamento cont.macrolidios/outs.derivs.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032031', 'description' => 'Medicamento cont.rifamicina sv sodica,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032032', 'description' => 'Medicamento contendo rifampicina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032039', 'description' => 'Medicamento cont.ansamicinas/outs.derivs.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032041', 'description' => 'Medicamento cont.cloridrato de lincomicina, exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032049', 'description' => 'Medicamento cont.lincosamidas/outs.derivs. exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032051', 'description' => 'Medicamento contendo cefalotina sodica,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032052', 'description' => 'Medicamento c/cefaclor/cefalexina monoidratad.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032059', 'description' => 'Medicamento c/cefalosporinas/cefamicinas/etc. exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032061', 'description' => 'Medicamento cont.sulfato de gentamicina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032062', 'description' => 'Medicamento cont. daunorubicina, exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032063', 'description' => 'Medicamento cont. pirarubicina, idarubicina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032069', 'description' => 'Medicamento cont.aminoglicosidios/outs.derivs .exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032071', 'description' => 'Medicamento contendo vancomicina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '30032072', 'description' => 'Medicamento cont. actinomicinas, exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032073', 'description' => 'Ciclosporina a', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032079', 'description' => 'Medicamento cont.polipeptidios/outs.derivs.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032091', 'description' => 'Medicamento contendo mitomicina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032092', 'description' => 'Medicamento contendo fumarato de tiamulina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032093', 'description' => 'Medicamento cont.bleomicinas ou seus sais,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032094', 'description' => 'Medicamento contendo imipenem,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032095', 'description' => 'Medicamento contendo outs.antibioticos,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30032099', 'description' => 'Medicamento contendo outs.antibioticos,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033100', 'description' => 'Medicamento cont.insulina,n/cont.antibiot.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033911', 'description' => 'Medicamento c/hormonio crescim.(somatrofina),exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033912', 'description' => 'Medicamento c/hcg (gonadotrofina corionica),exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033913', 'description' => 'Medicamento cont.menotropinas,n/cont.antibiot.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033914', 'description' => 'Acth (corticotropina)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033915', 'description' => 'Medicamento cont.pmsg (gonadotrofina serica),exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033916', 'description' => 'Medicamento cont.somatostatina/seus sais,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033917', 'description' => 'Medicamento contendo acetato de buserelina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033918', 'description' => 'Medicamento cont.triptorelina/seus sais,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033919', 'description' => 'Medicamento contendo leuprolide ou seu acetato,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033921', 'description' => 'Medicamento contendo lh-rh (gonadorelina),exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033922', 'description' => 'Medicamento contendo oxitocina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033923', 'description' => 'Medicamento contendo sais de insulina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033924', 'description' => 'Medicamento contendo timosinas,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033925', 'description' => 'Medicamento contendo octreotida,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033926', 'description' => 'Medicamento contendo goserelina ou seu acetato,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033927', 'description' => 'Medicamento contendo nafarelina ou seu acetato,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033929', 'description' => 'Medicamento c/outs.hormon.polipeptidicos,etc.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033931', 'description' => 'Medicamento cont.hemissuccinato de estradiol,exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033932', 'description' => 'Medicamento cont.fempropionato de estradiol,exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033933', 'description' => 'Medicamento cont.estriol ou seu succinato,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033934', 'description' => 'Medicamento contendo alilestrenol,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033935', 'description' => 'Medicamento contendo linestrenol,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033936', 'description' => 'Medicamento contendo acetato de magestrol, formestano, fulvestranto, exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033937', 'description' => 'Medicamento contendo desogestrel,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033939', 'description' => 'Medicamento cont.outs.estrogenios/ progestogen.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033981', 'description' => 'Medicamento cont. levotiroxina sódica, exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033982', 'description' => 'Medicamento cont. liotironina sódica, exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033991', 'description' => 'Medicamento contendo sal sódico ou éster metílico (...)', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033992', 'description' => 'Medicamento cont.tiratricol ou seu sal sódico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033994', 'description' => 'Medicamento cont.espironolactona,nao apresent.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033995', 'description' => 'Medicamento cont.exemestano,nao apresent.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30033999', 'description' => 'Medicamento cont.outs.hormonios/ derivs.etc.exc.em doses, mas não contendo antibióticos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034100', 'description' => 'Que contenham efedrina ou seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034200', 'description' => 'Que contenham pseudoefedrina (dci) ou seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034300', 'description' => 'Que contenham norefedrina ou seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034910', 'description' => 'Vimblastina, vincristina, derivados destes produtos, topotecan ou seu cloridrato', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034920', 'description' => 'Pilocarpina, seu nitrato ou seu cloridrato', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034930', 'description' => 'Metanossulfonato de diidroergocristina', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034940', 'description' => 'Codeina ou seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034950', 'description' => 'Granisetron, tropisetrona ou seu cloridrato', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30034990', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30036000', 'description' => 'Outros, que contenham principios ativos antimalaricos (antipaludicos) descritos na nota de subposicoes 2 do presente capitulo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039011', 'description' => 'Medicamento c/folinato calcio (leucovorina),exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '30039012', 'description' => 'Medicamento cont.acido nicotinico,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039013', 'description' => 'Medicamento cont.hidroxocobalamina,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039014', 'description' => 'Medicamento cont.vitamina a1 ou derivs.exceto ácido retinóico, exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039015', 'description' => 'Medicamento cont.d-pantotenato de calcio,vitamina d3 (colecalciferol).exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039016', 'description' => 'Medicamento c/esteres das vitaminas a e d,etc.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039017', 'description' => 'Medicamento cont. ácido retinóico (tretinoína), exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039019', 'description' => 'Medicamento c/outs.vitaminas,provitam.derivs.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039021', 'description' => 'Medicamento contendo estreptoquinase,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039022', 'description' => 'Medicamento contendo l-asparaginase,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039023', 'description' => 'Medicamento contendo deoximbonuclease,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039024', 'description' => 'Medicamento contendo Idursulfase,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039029', 'description' => 'Medicamento c/outs.enzimas,n/cont.vitams.etc.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039031', 'description' => 'Medicamento contendo permetrina,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039032', 'description' => 'Medicamento cont.ácido cólico, ácido deoxicólico, sal magnésico do ácido deidrocólico,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039033', 'description' => 'Medicamento c/acido gluconico/sais/esteres,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039034', 'description' => 'Medicamento c/acido o-acetilsalicilico/etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039035', 'description' => 'Lactofosfato de calcio', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039036', 'description' => 'Medicamento cont.acido lactico/sais/etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039037', 'description' => 'Medicamento cont.acido fumarico/sais/etc. exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039038', 'description' => 'Medicamento contendo etretinato/etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039039', 'description' => 'Medicamento c/outs.acidos carboxilicos,etc. exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039041', 'description' => 'Medicamento c/sulfato de tranilcipromina,etc. exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039042', 'description' => 'Medicamento c/acido sulfanilico,sais,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039043', 'description' => 'Medicamento c/clembuterol/seu cloridrato,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039044', 'description' => 'Medicamento contendo tamoxifen/seu citrato,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039045', 'description' => 'Medicamento contendo levodopa, alfa-metildopa', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039046', 'description' => 'Medicamento c/cloridrato de fenilefrina,etc.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039047', 'description' => 'Medicamento cont.diclofenaco de sodio,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039048', 'description' => 'Medicamento contclorambucil, clormetina (dci) ou seu cloridrato, melfalano, toremifene ou seu citrato, exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039049', 'description' => 'Medicamento c/outs.compostos funcao amina,etc.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039051', 'description' => 'Medicamento contendo metoclopramida,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039052', 'description' => 'Medicamento cont.atenolol/prilocaina/etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039053', 'description' => 'Medicamento c/lidocaina/seu cloridrato,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039054', 'description' => 'Medicamento contendo femproporex,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039055', 'description' => 'Medicamento cont.paracetamol ou bromoprida,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039056', 'description' => 'Medicamento cont.amitraz ou cipermetrina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039057', 'description' => 'Medicamento cont.clorexidina/seus sais,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039058', 'description' => 'Medicamento cont.carmustina/ lomustina, etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039059', 'description' => 'Medicamento c/outs.comp.func.carboxiamida,etc.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039061', 'description' => 'Medicamento c/quercetina,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039062', 'description' => 'Medicamento contendo tiaprida,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039063', 'description' => 'Medicamento contendo etidronato dissodico,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039064', 'description' => 'Medicamento cont.cloridrato de amiodarona,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039065', 'description' => 'Medicamento cont.nitrovin ou moxidectina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039066', 'description' => 'Medicamento contendo acido clodrônico ou seu sal dissódico, estreptozocina, fotemustina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039067', 'description' => 'Medicamento cont.carbocisteina ou sulfiram,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039069', 'description' => 'Medicamento c/outs.tiocompostos organ.etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039071', 'description' => 'Medicamento c/terfenadina/talniflumato,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039072', 'description' => 'Medicamento c/cloridrato de loperamida, fembendazol, ketorolac trometamina, nifedipina, nimodipina, nitrendipina.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039073', 'description' => 'Medicamento c/albendazol ou seu sulfóxido, mebendazol, 6-mercaptopurina, metilsulfato de amezínio, oxifendazol, praziquantel.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039074', 'description' => 'Medicamento cont.alprazolam, bromazepam, clordiazepóxido, cloridrato de petidina, diazepam, droperidol, mazindol, triazolam.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039075', 'description' => 'Medicamento c/benzetimida ou seu cloridrato, fenitoína ou seu sal sódico, isoniazida, pirazinamida exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039076', 'description' => 'Medicam.c/ac.ácido 2-(2-metil-3-cloroanilina)nicotínico ou seu sal de lisina, metronidazol ou seus sais, azatioprina, nitrato de miconazol.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '30039077', 'description' => 'Medicam.contendo  enrofloxacina, maleato de enalapril, maleato de pirilamina, nicarbazina, norfloxacina, sais de piperazina , .exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039078', 'description' => 'Medicamento c/ciclosporina a/fluspirileno, etc.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039079', 'description' => 'Medicam.c/out.comp.heteroc.heteroat.nitrog.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039081', 'description' => 'Medicamento cont.levamisol/seus sais,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039082', 'description' => 'Medicamento c/sulfadiazina/seu sal sodico,etc.exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039083', 'description' => 'Medicamento cont.ketazolam/sulpirida,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039084', 'description' => 'Medicam.c/ftalilsulfatiazol/bumetanida,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039085', 'description' => 'Medicamento c/enantato de flufenazina,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039086', 'description' => 'Medicamento c/furosemida/clortalidona,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039087', 'description' => 'Medicamento c/cloridrato de tizanidina, cetoconazol,furazolidona.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039088', 'description' => 'Medicam.contendo amprenavir, aprepitanto, delavirdina ou seu mesilato, efavirenz, emtricitabina, etopósido, fosfato de fludarabina, fosamprenavir cálcico, gencitabina ou seu cloridrato, raltitrexida, ritonavir, tenipósido, .exc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039089', 'description' => 'Medicamento c/outs.compost.heterocicl. etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039091', 'description' => 'Medicamento contendo extrato de polen,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039092', 'description' => 'Medicamento cont.disofenol/crisarobina,etc.exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039093', 'description' => 'Medicamento contendo dicoflenaco resinato,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039094', 'description' => 'Medicamento contendo silimarina,exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039095', 'description' => 'Bussulfano, dexormaplatina, dietilestilbestrol ou seu dipropionato, enloplatina, filgrastina, iproplatina, lobaplatina, miboplatina, miltefosina, mitotano, ormaplatina, procarbazina ou seu cloridrato, propofol, sebriplatina, zeniplatina .exc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039096', 'description' => 'Complexo de ferro dextrana', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039097', 'description' => 'Sevoflurano', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30039099', 'description' => 'Outs.medicam.cont.prods.misturados,p/fins terapeut.etc.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30041011', 'description' => 'Medicamento contendo ampicilina ou seus sais,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30041012', 'description' => 'Medicamento contendo amoxicilina ou seus sais,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30041013', 'description' => 'Medicamento contendo penicilina g benzatinica,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30041014', 'description' => 'Medicamento contendo penicilina g potassica,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30041015', 'description' => 'Medicamento contendo penicilina g procainica,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30041019', 'description' => 'Medicamento cont.outs.penicilinas/seus derivs.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30041020', 'description' => 'Medicamento cont.estreptomicinas/seus derivs.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042011', 'description' => 'Medicamento c/cloranfenicol/seu palmitato, etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042019', 'description' => 'Medicamento contendo anfenicois/outs.sais,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042021', 'description' => 'Medicamento contendo eritromicina ou seus sais,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042029', 'description' => 'Outs.medicamentos cont.macrolideos /derivados,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042031', 'description' => 'Medicamento contendo rifamicina sv sodica,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042032', 'description' => 'Medicamento contendo rifampicina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042039', 'description' => 'Outs.medicamentos cont.ansamicinas/ derivados,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042041', 'description' => 'Medicamento contendo cloridrato de lincomicina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042049', 'description' => 'Outros medicamentos cont.lincosamidas/ derivados,em dose', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042051', 'description' => 'Medicamento contendo cafalotina sodica,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042052', 'description' => 'Medicamento c/cefaclor/cefalexina monoidratads.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042059', 'description' => 'Outros medicamentos contendo cefalosporinas,etc.em dose', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042061', 'description' => 'Medicamento contendo sulfato de gentamicina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042062', 'description' => 'Medicamento contendo daunorubicina, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042063', 'description' => 'Medicamento contendo pirarubicina, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042069', 'description' => 'Outs.medicamentos cont.aminoglucosidios/ derivs.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042071', 'description' => 'Medicamento contendo vancomicina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042072', 'description' => 'Medicamento contendo actinomicina, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042073', 'description' => 'Medicamento contendo ciclosporina a, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042079', 'description' => 'Outs.medicamentos cont.polipeptideos/derivados,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042091', 'description' => 'Medicamento contendo mitomicina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042092', 'description' => 'Medicamento contendo fumarato de tiamulina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042093', 'description' => 'Medicamento contendo bleomicinas ou seus sais,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042094', 'description' => 'Medicamento contendo imipenem,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042095', 'description' => 'Medicamentos contendo anfotericina b em lipossomas,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30042099', 'description' => 'Medicamentos contendo outs.antibioticos,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '30043100', 'description' => 'Medicamento contendo insulina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043210', 'description' => 'Hormônios corticosteróides', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043220', 'description' => 'Espironolactona', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043290', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043911', 'description' => 'Medicamento c/hormonio crescim.(somatotrofina),em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043912', 'description' => 'Medicamento cont.hcg (gonadotrofina corionica),em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043913', 'description' => 'Medicamento contendo menotropinas,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043914', 'description' => 'Medicamento contendo acth (corticotrofina),em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043915', 'description' => 'Medicamento cont.pmsg (gonadotrofina serica),em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043916', 'description' => 'Medicamento cont.somatostatina ou seus sais,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043917', 'description' => 'Medicamento contendo acetato de buserelina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043918', 'description' => 'Medicamento contendo triptorelina ou seus sais,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043919', 'description' => 'Medicamento contendo leuprolide ou seu acetato, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043921', 'description' => 'Medicamento contendo lh-rh (gonadorelina),em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043922', 'description' => 'Medicamento contendo oxitocina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043923', 'description' => 'Medicamento contendo sais de insulina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043924', 'description' => 'Medicamento contendo timosinas,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043925', 'description' => 'Medicamento contendo calcitonina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043926', 'description' => 'Medicamento contendo octreotida,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043927', 'description' => 'Medicamento contendo goserelina ou seu acetato,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043928', 'description' => 'Medicamento contendo nafarelina ou seu acetato ,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043929', 'description' => 'Medicam.c/outs.hormonios polipeptidicos, etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043931', 'description' => 'Medicamento cont.hemissuccinato de estradiol,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043932', 'description' => 'Medicamento cont.fempropionato de estradiol,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043933', 'description' => 'Medicamento contendo estriol ou seu succinato,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043934', 'description' => 'Medicamento contendo alilestrenol,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043935', 'description' => 'Medicamento contendo linestrenol,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043936', 'description' => 'Medicamento contendo acetato de megestrol, formestano, fulvestranto,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043937', 'description' => 'Medicamento contendo desogestrel,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043939', 'description' => 'Medicamento c/outs.estrogenios/ progestogenios, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043981', 'description' => 'Medicamento cont. levotiroxina sódica, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043982', 'description' => 'Medicamento cont. liotironina sódica, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043991', 'description' => 'Medicam.c/sal sodico ac.9,11,15-trii.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043992', 'description' => 'Medicam.c/tiratricol/seu sal sodico,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043994', 'description' => 'Medicamento cont.exemestano,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30043999', 'description' => 'Outs.medicamentos cont.hormonios,em doses,etc', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044100', 'description' => 'Que contenham efedrina ou seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044200', 'description' => 'Que contenham pseudoefedrina (dci) ou seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044300', 'description' => 'Que contenham norefedrina ou seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044910', 'description' => 'Vimblastina, vincristina, derivados destes produtos, topotecan ou seu cloridrato', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044920', 'description' => 'Pilocarpina, seu nitrato ou seu cloridrato', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044930', 'description' => 'Metanossulfonato de diidroergocristina', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044940', 'description' => 'Codeina ou seus sais', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044950', 'description' => 'Granisetron, tropisetrona ou seu cloridrato', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30044990', 'description' => 'Outros', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30045010', 'description' => 'Medicamento c/folinato de calcio (leucovorina),em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30045020', 'description' => 'Medicamento c/.nicotinamida, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30045030', 'description' => 'Medicamento c/hidroxocovalamina/seus sais,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30045040', 'description' => 'Medicamento cont.vitamina a1 ou derivs.exceto ácido retinóico, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30045050', 'description' => 'Medicamento cont.d-pantotenato de calcio, vitamina d3 (colecalciferol).em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30045060', 'description' => 'Medicamento cont. ácido retinóico (tretinoína), em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30045090', 'description' => 'Medicamento c/outs.vitaminas/provitaminas, etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30046000', 'description' => 'Outros, que contenham principios ativos antimalaricos (antipaludicos) descritos na nota de subposicoes 2 do presente capitulo', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '30049011', 'description' => 'Medicamento contendo estreptoquinase,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049012', 'description' => 'Medicamento contendo l-asparaginase,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049013', 'description' => 'Medicamento contendo deoxirribonuclease,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049014', 'description' => 'Medicamento contendo Idursulfase,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049019', 'description' => 'Medicamento contendo outs.enzimas,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049021', 'description' => 'Medicamento c/permetrina/nitrato propatila,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049022', 'description' => 'Medicamento contendo ácido cólico, ácido deoxicólico, sal magnésico do ácido deidrocólico, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049023', 'description' => 'Medicamento cont.acido gluconico/sais/esteres,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049024', 'description' => 'Medicamento cont.acido o-acetilsalicilico,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049025', 'description' => 'Medicamento contendo tiratricol (triac),etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049026', 'description' => 'Medicamento cont.ácido láctico, seus sais ou seus ésteres, ácido 4-(4-hidroxifenoxi)-3,5-diiodofenilacético, ácido fumárico, seus sais ou seus ésteres, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049027', 'description' => 'Medicamento cont.acido fumarico/seus sais,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049028', 'description' => 'Medicam.c/etretinato, fosfestrol ou seus sais de di ou tetrassódio, miltefosina, doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049029', 'description' => 'Outs.medicam.c/ac.monocarboxil.acicl.n/sat.etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049031', 'description' => 'Medicamento c/sulfato de tranilcipromina,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049032', 'description' => 'Medicamento c/acido sulfanilico/seus sais,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049033', 'description' => 'Medicamento cont.clembuterol ou seu cloridrato,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049034', 'description' => 'Medicamento contendo tamoxifen ou seu citrato,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049035', 'description' => 'Medicamento contendo levodopa, alfa-metildopa', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049036', 'description' => 'Medicamento cont.cloridrato de fenilefrina,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049037', 'description' => 'Medicamento contendo diclofenaco de sodio,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049038', 'description' => 'Medicamento contendo clorambucil, clormetina (dci) ou seu cloridrato, melfalano, toremifene ou seu citrato, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049039', 'description' => 'Outs.medicam.c/compostos de funcao amina,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049041', 'description' => 'Medicamentos c/metoclopramida/cloridrato,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049042', 'description' => 'Medicamento cont.atenolol/prilocaina,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049043', 'description' => 'Medicamento cont.lidocaina/seu cloridrato,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049044', 'description' => 'Medicamento contendo femproporex,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049045', 'description' => 'Medicamento cont.paracetamol ou bromoprida,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049046', 'description' => 'Medicamento contendo amitraz ou cipermetrina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049047', 'description' => 'Medicamento contendo clorexidina/seus sais,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049048', 'description' => 'Medicamento contendo aminoglutetimida, carmustina, deferoxamina (desferrioxamina b) ou seus sais, derivados destes produtos, lomustina, procarbazina ou seu cloridrato, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049049', 'description' => 'Outs.medicam.c/comp.de funcao carboxiamida,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049051', 'description' => 'Medicamento cont.quercetina, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049052', 'description' => 'Medicamento contendo tiaprida,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049053', 'description' => 'Medicamento contendo etidronato dissodico,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049054', 'description' => 'Medicamento contendo cloridrato de amiodarona,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049055', 'description' => 'Medicamento contendo nitrovin ou moxidectina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049057', 'description' => 'Medicamento contendo carbocisteina ou sulfiram,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049058', 'description' => 'Medicamento contendo ácido clodrõnico ou seu sal dissódico, estreptozocina, fotemustina, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049059', 'description' => 'Outs.medicamentos c/tiocompostos organicos,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049061', 'description' => 'Medicamento cont.terfenadina/talniflumato,etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049062', 'description' => 'Medicamento cont.cloridrato de loperamida, fembendazol, ketorolac trometamina, nifedipina nimodipina, nitrendipina, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049063', 'description' => 'Medicamento cont.albendazol ou seu sulfóxido, mebendazol, 6-mercaptopurina, metilsulfato de amezínio, oxifendazol, praziquantel, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049064', 'description' => 'Medicamento contendo alprazolam, bromazepam, clordiazepóxido, cloridrato de petidina, diazepam, droperidol, mazindol, triazolam, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049065', 'description' => 'Medicamento cont.benzetimida ou seu cloridrato, fenitoína ou seu sal sódico, isoniazida, pirazinamida, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049066', 'description' => 'Medicam.c/ac.2-(2-metil-3-cloroanilina)nicotinico, doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049067', 'description' => 'Medicamento cont.enrofloxacina, maleato de enalapril, maleato de pirilamina, nicarbazina, norfloxacina, sais de piperazina , em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049068', 'description' => 'Medicamento c/altretamina, bortezomib, dacarbazina, disoproxilfumarato de tenofovir, enfuvirtida, fluspirileno, letrozol, lopinavir, mesilato de imatinib, nelfinavir ou seu mesilato, nevirapine, pemetrexed, saquinavir, sulfato de abacavir, sulfato de ataz', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049069', 'description' => 'Outs.medicam.c/comp.heterocicl.heteroat.nitrog.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049071', 'description' => 'Medicamento c/levamisol/seus sais/tetramisol,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049072', 'description' => 'Medicamento c/sulfadiazina/seu sal sodico,sulfametoxazol, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049073', 'description' => 'Medicamento contendo cloxazolam, ketazolam, piroxicam, tenoxicam, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049074', 'description' => 'Medicamento c/ftalilsulfatiazol, inosina, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '30049075', 'description' => 'Medicamento cont.enantato de flufenazina, prometazina, gliburida, rutosídio, deslanosídio, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049076', 'description' => 'Medicamento cont.clortalidona, furosemida, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049077', 'description' => 'Medicamento cont.cloridrato de tizanidina, cetoconazol, furazolidona, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049078', 'description' => 'Medicam.contendo  amprenavir, aprepitanto, delavirdina ou seu mesilato, efavirenz, emtricitabina, etopósido, fosfato de fludarabina, fosamprenavir cálcico, gencitabina ou seu cloridrato, raltitrexida, ritonavir, tenipósido, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049079', 'description' => 'Outs.medicamentos c/compostos heterocicl.etc.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049091', 'description' => 'Medicamento contendo extrato de polen,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049092', 'description' => 'Medicamento contendo crisarobina, disofenol, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049093', 'description' => 'Medicamento contendo diclofenaco resinato,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049094', 'description' => 'Medicamento contendo silimarina,em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049095', 'description' => 'Medicamento contendo bussulfano, dexormaplatina, dietilestilbestrol ou seu dipropionato, enloplatina, filgrastina, iproplatina, lobaplatina, miboplatina, mitotano, ormaplatina, propofol, sebriplatina, zeniplatina, em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049096', 'description' => 'Medicam.cont.complexo de ferro dextrana.em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049097', 'description' => 'Medicamento Sevoflurano em doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30049099', 'description' => 'Outs.medicam.cont.prods.p/fins terapeuticos, etc.doses', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30051010', 'description' => 'Pensos adesivos impregn/recob.subst.farmaceut', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30051020', 'description' => 'Pensos adesivos cirurgicos de observ.direta de feridas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30051030', 'description' => 'Pensos adesivos impermeaveis aplicaveis sobre mucosas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30051040', 'description' => 'Pensos adesivos com obturador,para colostomia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30051050', 'description' => 'Pensos adesivos c/fecho de correr,p/fechar ferimentos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30051090', 'description' => 'Outs.pensos adesivos,artigos analogos c/camada adesiva', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30059011', 'description' => 'Pensos reabsorviveis,de acido poliglicolico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30059012', 'description' => 'Pensos reabsorvs.de copolim.de acido glicolico/lactico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30059019', 'description' => 'Outros pensos reabsorviveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30059020', 'description' => 'Campos cirurgicos,de falso tecido', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30059090', 'description' => 'Outs.pastas,gazes,semelhs.p/uso medicinal, cirurgico,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30061010', 'description' => 'Materiais para suturas cirurgicas,de polidiexzanona', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30061020', 'description' => 'Materiais para suturas cirurgicas,de aco inoxidavel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30061090', 'description' => 'Outs.categutes esterilizados,etc.p/suturas cirurgicas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30062000', 'description' => 'Reagentes p/determinacao dos grupos/fatores sanguineos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063011', 'description' => 'Preparacao opacificante,de loexol,p/exame radiografico', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063012', 'description' => 'Prepar.opacif.de locarmato dimeglumina, p/exam.radiograf', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063013', 'description' => 'Preparacao opacificante,de lopamidol,p/exame radiograf.', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063015', 'description' => 'Prepar.opacif.dioxido de zirconio,etc.p/exame radiograf', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063016', 'description' => 'Prepar.opacif.diatrizoato de sódio ou de meglumina  p/exame radiograf', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063017', 'description' => 'Prepar.opacif.loversol p/exame radiograf, a base de ioversol ou de iopromida', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063018', 'description' => 'Prepar.opacif.lotalamato de sódio, lotalamato de meglumina ou de suas misturas p/exame radiograf', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063019', 'description' => 'Outs.preparacoes opacificantes,para exames radiologicos', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063021', 'description' => 'Reagente de diagnost.de somatoliberina,p/admin. paciente', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30063029', 'description' => 'Outs.reagentes de diagnostico,p/ser administr. paciente', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30064011', 'description' => 'Cimentos para obturacao dentaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30064012', 'description' => 'Outros produtos para obturacao dentaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30064020', 'description' => 'Cimentos para reconstituicao ossea', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30065000', 'description' => 'Estojos e caixas de primeiros-socorros, guarnecidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30066000', 'description' => 'Prepars.quims.contraceptivas,de hormonios/ espermicidas', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30067000', 'description' => 'Preparações apresentadas na forma de gel p/ utilização em medicina omo lubrificante em intervenções, etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30069110', 'description' => 'Bolsas para uso em colostomia, ileostomia e urostomia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30069190', 'description' => 'Outros equipamentos identificáveis para uso em ostomia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '30069200', 'description' => 'Desperdícios farmaceuticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31010000', 'description' => 'Adubos ou fertilizantes de origem animal/vegetal, etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31021010', 'description' => 'Ureia com teor de nitrogenio>45% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31021090', 'description' => 'Outros ureias,mesmo em solucao aquosa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31022100', 'description' => 'Sulfato de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31022910', 'description' => 'Sulfonitrato de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31022990', 'description' => 'Outs.sais duplos/misturas,de sulfato/nitrato de amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '31023000', 'description' => 'Nitrato de amonio,mesmo em solucao aquosa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31024000', 'description' => 'Misturas de nitrato de amonio c/carbonato de calcio,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31025011', 'description' => 'Nitrato de sodio,natural,com teor de nitrogenio<=16.3%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31025019', 'description' => 'Outros nitratos de sodio,naturais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31025090', 'description' => 'Outros nitratos de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31025090', 'description' => 'Outros nitratos de sodio, com teor de nitrogênio superior a 16,3% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31026000', 'description' => 'Sais duplos e misturas de nitratos de calcio e amonio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31028000', 'description' => 'Misturas de ureia c/nitrato de amonio,em sol.aquosa,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31029000', 'description' => 'Outs.adubos ou fertilizs.minerais/quimicos ,nitrogenados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31029000', 'description' => 'Cianamida cálcica com teor de nitrogênio superior a 25% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31031100', 'description' => 'Que contenham, em peso, 35 % ou mais de pentoxido de difosforo (p2o5)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31031900', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31039011', 'description' => 'Hidrogeno-ortofosfato de calcio,teor de p2o5<=46%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31039019', 'description' => 'Outros hidrogenos-ortofosfatos de calcio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31039090', 'description' => 'Outs.adubos ou fertilizs.minerais/quimicos, fosfatados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31042010', 'description' => 'Cloreto de potassio,teor de oxido de potassio(k2o)<=60%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31042090', 'description' => 'Outros cloretos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31043010', 'description' => 'Sulfato de potassio,teor de oxido de potassio(k2o)<=52%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31043090', 'description' => 'Outros sulfatos de potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31049010', 'description' => 'Sulfato duplo de potassio e de magnesio,teor de k2o>30%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31049090', 'description' => 'Outs.adubos ou fertilizs.minerais/quimicos, potassicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31051000', 'description' => 'Adubos ou fertilizantes em tabletes/embalagens p<=10kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31051000', 'description' => 'Nitrato de sódio com teor de nitrogênio superior a 16,3% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31051000', 'description' => 'Cianamida cálcica com teor de nitrogênio superior a 25% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31051000', 'description' => 'Sulfato de potássio com teor de óxido de potássio  K2O  superior a 52% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31051000', 'description' => 'Sulfato duplo de magnésio e potássio com teor de óxido de potássio  K2O  com teor superior a 30% em peso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31052000', 'description' => 'Adubos ou fertilizantes c/nitrogenio,fosforo e potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31053000', 'description' => 'Hidrogeno-ortofosfato de diamônio (fosfato diamônico ou diamoniacal)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31054000', 'description' => 'Diidrogeno-ortofosfato de amonio,incl.mist.hidrogen.etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31055100', 'description' => 'Adubos ou fertilizantes c/nitrato e fosfato', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31055900', 'description' => 'Outs.adubos ou fertilizs.contendo nitrogenio e fosforo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31056000', 'description' => 'Adubos ou fertilizantes c/fosforo e potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31059011', 'description' => 'Nitrato de sodio potassico,teor de n<=15% e k2o<=15%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31059019', 'description' => 'Outros nitratos de sodio potassico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '31059090', 'description' => 'Outs.adubos/fertils.miner.quim.c/nitrogenio e potassio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32011000', 'description' => 'Extrato tanante,de quebracho', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32012000', 'description' => 'Extrato tanante,de mimosa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32019011', 'description' => 'Extrato tanante,de gambir', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32019012', 'description' => 'Extrato tanante,de carvalho ou de castanheiro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32019019', 'description' => 'Outros extratos tanantes,de origem vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32019020', 'description' => 'Taninos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32019090', 'description' => 'Sais,eteres,esteres e outs.derivados dos taninos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32021000', 'description' => 'Produtos tanantes organicos sinteticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32029011', 'description' => 'Produtos tanantes,a base de sais de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32029012', 'description' => 'Produtos tanantes,a base de sais de titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32029013', 'description' => 'Produtos tanantes,a base de sais de zirconio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32029019', 'description' => 'Outros produtos tanantes inorganicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32029021', 'description' => 'Preparacoes tanantes,a base de compostos de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32029029', 'description' => 'Outros preparacoes tanantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32029030', 'description' => 'Preparacoes enzimaticas,para a pre-curtimenta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32030011', 'description' => 'Hemateina (materia corante)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32030012', 'description' => 'Fisetina (materia corante)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32030013', 'description' => 'Morina (materia corante)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '32030019', 'description' => 'Outros materias corantes,de origem vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32030021', 'description' => 'Carmim de cochonilha (materia corante)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32030029', 'description' => 'Outros materias corantes,de origem animal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32030030', 'description' => 'Prepars.a base de materias corantes,orig.vegetal/animal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041100', 'description' => 'Corantes dispersos e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041210', 'description' => 'Corantes acidos,mesmo metalizados e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041220', 'description' => 'Corantes mordentes e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041300', 'description' => 'Corantes basicos e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041400', 'description' => 'Corantes diretos e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041510', 'description' => 'Corante indigo blue,segundo colour index 73000', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041520', 'description' => 'Corante dibenzantrona', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041530', 'description' => 'Corante 12,12-dimetoxidibenzantrona', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041590', 'description' => 'Outros corantes a cuba e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041600', 'description' => 'Corantes reagentes e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041700', 'description' => 'Pigmentos e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041911', 'description' => 'Carotenoides', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041912', 'description' => 'Prepars.da base de beta-caroteno,etc.p/ colorir alimento', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041913', 'description' => 'Outros preparacoes p/colorir alimentos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041919', 'description' => 'Outros preparacoes a base de caratenoides', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041920', 'description' => 'Corantes soluveis em solventes (corantes solventes)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041930', 'description' => 'Corantes azoicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32041990', 'description' => 'Outs.materias corantes organicas sintet.e suas prepars.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32042011', 'description' => 'Derivs.do ac.4,4-bis-(1,3,5)triazinil-6-aminoestil. etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32042019', 'description' => 'Outs.derivs.do estilbeno,util.agente avivam. fluorescent', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32042090', 'description' => 'Outs.prods.organs.sintet.util.agente avivam. fluorescent', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32049000', 'description' => 'Outros materias corantes organicas sinteticas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32050000', 'description' => 'Lacas corantes e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32061110', 'description' => 'Pigmentos tipo rutilo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32061120', 'description' => 'Outros pigmentos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32061130', 'description' => 'Preparacoes a base de dioxido de titanio, peso>=80%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32061910', 'description' => 'Pigmento const.por mica revest.pelicula dioxido titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32061990', 'description' => 'Outs.pigmentos e prepars.a base de dioxido de titanio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32062000', 'description' => 'Pigmentos e preparacoes a base de compostos de cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32064100', 'description' => 'Ultramar e suas preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32064210', 'description' => 'Litoponio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32064290', 'description' => 'Outs.pigmentos e preparacoes a base de sulfeto de zinco', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32064910', 'description' => 'Pigmentos e preparacoes a base de compostos de cadmio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32064920', 'description' => 'Pigmentos e preparacoes a base de hexacianoferratos (ferrocianetos e ferricianetos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32064990', 'description' => 'Outros materias corantes e preparacoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32065011', 'description' => 'Halofosfatos de calcio,etc.c/subst.radioativ. util.lumin', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32065019', 'description' => 'Outs.prods.inorgans.util.luminoforos,c/subst.       radioativ.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32065021', 'description' => 'Halofosfatos de calcio,etc.s/subst.radioativ. util.lumin', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32065029', 'description' => 'Outs.prods.inorgans.util.luminoforos,s/subst.        radioativ.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32071010', 'description' => 'Pigmento,opacificante,etc.a base de zirconio/ seus sais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32071090', 'description' => 'Outs.pigmentos,opacificantes/cores,preparados e prepars', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32072010', 'description' => 'Engobos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32072091', 'description' => 'Prepar. com teor de prata >=25% (...) p/ fabric. circuitos impressos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32072099', 'description' => 'Outs.pigmentos,opacificantes/cores,preparados e prepars', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32073000', 'description' => 'Polimentos liquidos e preparacoes semelhantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32074010', 'description' => 'Fritas de vidro,em po,em granulos,em lamelas ou flocos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32074090', 'description' => 'Outs.vidros em po,em granulos,em lamelas ou em flocos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32081010', 'description' => 'Tintas de poliesteres,dispersos/dissolv.meio n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32081020', 'description' => 'Vernizes de poliesteres,dispersos/dissolv.meio n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '32081030', 'description' => 'Solucoes de poliesteres,dispersos/dissolv.meio n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32082011', 'description' => 'Tintas à base de polímeros acrílicos, apresentadas em sortidos definidos na nota 3 da seção vi, dos tipos utilizados para a fabricação de circuitos impressos', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32082019', 'description' => 'Outras tintas à base de polim.acril/vinil. dispersos/ dissolv. n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32082020', 'description' => 'Vernizes de polim.acril/vinil.dispers/ dissolv. n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32082030', 'description' => 'Solucoes de polim.acril/vinil.dispers/dissolv .n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32089010', 'description' => 'Tintas de outs.polim.sint.etc.dispers/dissolv.n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32089021', 'description' => 'Vernizes de derivs.celulose,dispersos/dissolv.n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32089029', 'description' => 'Vernizes de out.polim.sint.etc.dispers/dissolv.n/aquoso', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32089031', 'description' => 'Solucoes de silicones,dispersos/dissolvs.meio n/aquoso', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32089039', 'description' => 'Outs.solucoes polim.sint.etc.dispers/dissolv.n/aquoso', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32091010', 'description' => 'Tintas de polim.acril/vinil.dispers/dissolv.meio aquoso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32091020', 'description' => 'Vernizes de polim.acril/vinil.dispersos/dissolv.aquoso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32099011', 'description' => 'Tintas de politetrafluoretileno,dispers/dissolv.aquoso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32099019', 'description' => 'Tintas de outs.polim.sint.etc.dispersos/dissolv.aquoso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32099020', 'description' => 'Vernizes de outs.polim.sint.etc.dispers/dissolv.aquoso', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32100010', 'description' => 'Outros tintas', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32100020', 'description' => 'Outros vernizes', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32100030', 'description' => 'Pigmentos a agua preparados,utiliz.p/acabam.de couros', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32110000', 'description' => 'Secantes preparados', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32121000', 'description' => 'Folhas para marcar a ferro', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32129010', 'description' => 'Aluminio em po,etc.empastado c/solvente hidrocarboneto', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32129090', 'description' => 'Outs.pigmentos dispers.meios n/aquosos,est.liquido,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32131000', 'description' => 'Cores em sortidos,p/pintura artistica,ativid.educat.etc', 'aliquota_federal' => 8.64, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32139000', 'description' => 'Outs.cores p/pintura artistica,atividade educativa,etc.', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32141010', 'description' => 'Mastique de vidraceiro,cimentos de resinas,outs.mastiq.', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32141020', 'description' => 'Indutos utilizados em pintura', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32149000', 'description' => 'Indutos n/refratarios do tipo utilizados em alvenaria', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32151100', 'description' => 'Tintas pretas,de impressao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32151900', 'description' => 'Outros tintas de impressao', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '32159000', 'description' => 'Tintas de escrever ou de desenhar e outs.tintas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33011210', 'description' => 'Oleo essencial,de petit grain de laranja', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33011290', 'description' => 'Outros oleos essenciais,de laranja', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33011300', 'description' => 'Oleo essencial,de limao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33011910', 'description' => 'Oleo essencial,de lima', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33011990', 'description' => 'Oleo essencial,de outs.citricos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012400', 'description' => 'Oleo essencial,de hortela-pimenta (mentha piperita)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012510', 'description' => 'Oleo essencial,de menta japonesa (mentha arvensis)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012520', 'description' => 'Oleo essencial,de mentha spearmint(mentha viridis l)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012590', 'description' => 'Oleo essencial,de outs.mentas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012911', 'description' => 'Oleo essencial,de citronela', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012912', 'description' => 'Oleo essencial,de cedro', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012913', 'description' => 'Oleo essencial,de pau santo (bulnesia sarmientol)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012914', 'description' => 'Oleo essencial,de lemongrass', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012915', 'description' => 'Oleo essencial,de pau-rosa', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012916', 'description' => 'Oleo essencial,de palma rosa', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012917', 'description' => 'Oleo essencial,de coriandro', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012918', 'description' => 'Oleo essencial,de cabreuva', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012919', 'description' => 'Oleo essencial,de eucalipto', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012921', 'description' => 'Oleo essencial,de alfazema ou lavanda', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012922', 'description' => 'Oleo essencial,de vetiver', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33012990', 'description' => 'Outros oleos essenciais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33013000', 'description' => 'Resinoides', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33019010', 'description' => 'Solucoes concentr.de oleos essenciais do tratam.flores', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '33019020', 'description' => 'Subprods.terpenicos resids.da desterp.oleos essenciais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33019030', 'description' => 'Agua destilada aromat.e sol.aquosa de oleos essenciais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33019040', 'description' => 'Oleorresinas de extracao', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33021000', 'description' => 'Misturas util.materia basica p/inds.alimentar/de bebida', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33029011', 'description' => 'Vetiverol para perfumaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33029019', 'description' => 'Outs.misturas utilizs.como materia basica p/perfumaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33029090', 'description' => 'Outs.misturas utilizs.como materia basica p/a industria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33030010', 'description' => 'Perfumes (extratos)', 'aliquota_federal' => 43.03, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33030020', 'description' => 'Agua-de-colonia', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33041000', 'description' => 'Produtos de maquilagem para os labios', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33042010', 'description' => 'Sombra,delineador,lapis para sobrancelhas e rimel', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33042090', 'description' => 'Outros produtos de maquilagem para os olhos', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33043000', 'description' => 'Preparacoes para manicuros e pedicuros', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33049100', 'description' => 'Pos,incluidos os compactos,para maquilagem', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33049100', 'description' => 'Talco e polvilho com ou sem perfume', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33049910', 'description' => 'Cremes de beleza,cremes nutritivos e locoes tonicas', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33049990', 'description' => 'Outs.produtos de beleza ou de maquilagem preparados,etc', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33049990', 'description' => 'Preparados bronzeadores', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33049990', 'description' => 'Preparados anti-solares, exceto os que possuam propriedades de bronzeadores', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33051000', 'description' => 'Xampus para os cabelos', 'aliquota_federal' => 19.99, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33052000', 'description' => 'Prepars.p/ondulacao/alisamento/permanentes,dos cabelos', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33053000', 'description' => 'Laques para os cabelos', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33059000', 'description' => 'Outros preparacoes capilares', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33059000', 'description' => 'Condicionadores', 'aliquota_federal' => 19.99, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33061000', 'description' => 'Dentifricios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33062000', 'description' => 'Fios utiliz.p/limpar espacos interdentais (fio dental)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33069000', 'description' => 'Outs.preparacoes para higiene bucal ou dentaria,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33071000', 'description' => 'Preparacoes para barbear (antes,durante ou apos)', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33072010', 'description' => 'Desodorantes corporais e antiperspirantes, liquidos', 'aliquota_federal' => 19.99, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33072090', 'description' => 'Outros desodorantes corporais e antiperspirantes', 'aliquota_federal' => 19.99, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33073000', 'description' => 'Sais perfumados e outs.preparacoes para banhos', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33074100', 'description' => 'Agarbate e outs.prepar.odoriferas que atuem p/combustao', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33074900', 'description' => 'Outs.preparacoes para perfumar ou desodorizar ambientes', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33079000', 'description' => 'Outs.prods.de perfumaria ou toucador, preparados,etc.', 'aliquota_federal' => 31.48, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '33079000', 'description' => 'Soluções para lentes de contato ou para olhos artificiais', 'aliquota_federal' => 24.16, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34011110', 'description' => 'Saboes medicinais,em barras,pedacos,figura moldada,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34011190', 'description' => 'Outs.prods/prepars.de toucador,em barras, pedacos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34011190', 'description' => 'Sabão', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34011900', 'description' => 'Outs.saboes/produtos/preparacoes,em barras,pedacos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34011900', 'description' => 'Papel, pastas  “ouates” , feltros e falsos tecidos, impregnados, revestidos ou recobertos de sabão ou de detergentes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34011900', 'description' => 'Produtos e preparações orgânicos tensoativos utilizados como sabão', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34011900', 'description' => 'Sabão', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34012010', 'description' => 'Saboes de toucador,sob outs.formas', 'aliquota_federal' => 18.21, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34012090', 'description' => 'Outros saboes', 'aliquota_federal' => 5.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34013000', 'description' => 'Produtos e prepar. organicos tensoativos destinados a lavagem da pele, na forma liquida...', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34021110', 'description' => 'Dibutilnaftalenossulfato de sodio (agente organ.superf)', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34021120', 'description' => 'N-metil-n-oleitaurato de sodio (agente organ.de superf)', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34021130', 'description' => 'Alquilsulfonato de sodio,secundario (agente org.superf)', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34021140', 'description' => 'Mistura de ácidos alquilsulfônicos', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34021190', 'description' => 'Outros agentes organicos de superficie,anionicos', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34021210', 'description' => 'Acetato de oleilamina (agente organico de superficie)', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34021290', 'description' => 'Outros agentes organicos de superficie,cationicos', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34021300', 'description' => 'Agentes organicos de superficie,nao ionicos', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '34021900', 'description' => 'Outros agentes organicos de superficie', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34022000', 'description' => 'Preparacoes tensoativas,para lavagem e limpeza', 'aliquota_federal' => 6.46, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029011', 'description' => 'Misturas de agente organ.de superf.cont.prods. n/ionicos', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029019', 'description' => 'Outros misturas de agentes organicos de superficie', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029021', 'description' => 'Solucoes ou emulsoes hidroalcoólicas (...)', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029022', 'description' => 'Solucoes ou emulsoes a base de nonanoiloxienzenossulfonato de sodio', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029023', 'description' => 'Soluções ou emulsões hidroalcoólicas de sulfonatos de perfluoralquiltrimetilamônio e de perfluoralquilacrilamida', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029029', 'description' => 'Outras soluções ou emulsões de produtos tensoativos (...)', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029031', 'description' => 'Prepars.de nonilfenol etoxilado (detergente) p/lavagem', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029039', 'description' => 'Outros preparacoes para lavagem (detergentes)', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34029090', 'description' => 'Outs.preparacoes tensoativas e preparacoes para limpeza', 'aliquota_federal' => 7.40, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34031110', 'description' => 'Prepars.cont.oleos de petroleo,etc.p/trat.mater.textil', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34031120', 'description' => 'Prepars.cont.oleos de petroleo,etc.p/trat.couros/peles', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34031190', 'description' => 'Prepars.cont.oleos de petroleo,etc.p/trat.outs.materias', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34031900', 'description' => 'Outs.prepars.cont.oleos de petroleo/miners.betuminosos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34039110', 'description' => 'Outs.preparacoes para tratamento de materia textil', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34039120', 'description' => 'Outs.preparacoes para tratamento de couros e peles', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34039190', 'description' => 'Outs.preparacoes para tratamento de outs.materias', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34039900', 'description' => 'Outs.prepars.lubrificantes/antiaderentes/antiferrug.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34042010', 'description' => 'Ceras artificiais de poli (oxietileno) (polietileno-glicol)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34042020', 'description' => 'Ceras preparadas de polietileno-glicois', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34049011', 'description' => 'Cera artificial de polietileno,emulsionavel', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34049012', 'description' => 'Outros ceras artificiais,de polietileno', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34049013', 'description' => 'Cera artificial de polipropilenoglicois', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34049014', 'description' => 'De dímero de alquilceteno com dois grupos alternados n-alquila de c12, c14 e c16, em grânulos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34049019', 'description' => 'Outros ceras artificiais', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34049021', 'description' => 'Cera preparada a base de vaselina e alcoois de lanolina', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34049022', 'description' => 'À base de hidroxiestearil cetil éter', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34049029', 'description' => 'Outros ceras preparadas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34051000', 'description' => 'Pomadas,cremes e prepars.semelhs.p/calcados ou couros', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34052000', 'description' => 'Encausticas/prepars.p/conservs.de moveis,etc.de madeira', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34053000', 'description' => 'Preparacoes p/dar brilho a pintura de carrocarias,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34054000', 'description' => 'Pastas,pos e outs.preparacoes para arear', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34059000', 'description' => 'Outs.preparacoes para dar brilho em vidros,metais,etc.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34060000', 'description' => 'Velas,pavios,cirios e artigos semelhantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34070010', 'description' => 'Pastas para modelar', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34070020', 'description' => 'Ceras para dentistas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '34070090', 'description' => 'Outros composicoes para dentistas,a base de gesso', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35011000', 'description' => 'Caseinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35019011', 'description' => 'Caseinato de sodio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35019019', 'description' => 'Outros caseinatos e derivados das caseinas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35019020', 'description' => 'Colas de caseina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35021100', 'description' => 'Ovalbumina seca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35021900', 'description' => 'Outros ovalbuminas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35022000', 'description' => 'Lactalbumina,incl.concentrs>=2 proteinas de soro leite', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35029010', 'description' => 'Soroalbumina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35029090', 'description' => 'Outros albuminas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35030011', 'description' => 'Gelatinas de osseina,seus derivs.c/grau pureza>=99.98%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35030012', 'description' => 'Gelatinas de osseina,seus derivs.c/grau pureza<99.98%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35030019', 'description' => 'Outros gelatinas e seus derivados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35030090', 'description' => 'Ictiocola,outs.colas de orig.animal,exc.cola de caseina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35040011', 'description' => 'Peptonas e peptonatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35040019', 'description' => 'Outros derivados das peptonas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '35040020', 'description' => 'Proteinas de soja em po,teor proteina em base seca>=90%', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35040030', 'description' => 'Proteínas de batata em pó, com teor de proteínas superior ou igual a 80%, em peso, em base seca', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35040090', 'description' => 'Outs.materias proteicas,seus derivados e po de peles', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35051000', 'description' => 'Dextrina e outs.amidos e feculas modificados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35052000', 'description' => 'Colas a base de amidos ou de feculas,de dextrina,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35061010', 'description' => 'Prods.util.como colas,adesivos,de cianoacrilatos,p<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35061090', 'description' => 'Outs.prods.utilizados como colas ou adesivos,peso<=1kg', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35069110', 'description' => 'Adesivos a base de borracha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35069120', 'description' => 'Adesivos a base de plasticos,dispersos,p/dispersar etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35069190', 'description' => 'Outros adesivos a base de plasticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35069900', 'description' => 'Outros colas e adesivos preparados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35071000', 'description' => 'Coalho e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079011', 'description' => 'Alfa-amilase (aspergillus oryzae)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079019', 'description' => 'Outros amilases e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079021', 'description' => 'Fibrinucleases', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079022', 'description' => 'Bromelina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079023', 'description' => 'Estreptoquinase', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079024', 'description' => 'Estreptodornase', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079025', 'description' => 'Mistura de estreptoquinase e estreptodornase', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079026', 'description' => 'Papaina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079029', 'description' => 'Outros proteases e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079031', 'description' => 'Lisozima e seu cloridrato', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079032', 'description' => 'L-asparaginase', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079039', 'description' => 'Outros enzimas e seus concentrados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079041', 'description' => 'Enzimas preparadas a base de celulases', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079042', 'description' => 'Enzimas preparadas a base de transglutaminase', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '35079049', 'description' => 'Outros enzimas preparadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36010000', 'description' => 'Polvoras propulsivas', 'aliquota_federal' => 24.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36020000', 'description' => 'Explosivos preparados,exceto polvoras propulsivas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36020000', 'description' => 'Explosivos preparados,exceto polvoras propulsivas, à base de poliácoois  dinamite , outros explosivos preparados com efeito equivalente ao da dinamite', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36030010', 'description' => 'Estopins e rastilhos, de segurança', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36030020', 'description' => 'Cordéis (cordões) detonantes', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36030030', 'description' => 'Escorvas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36030040', 'description' => 'Cápsulas fulminantes', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36030050', 'description' => 'Inflamadores', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36030060', 'description' => 'Detonadores elétricos', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36041000', 'description' => 'Fogos de artificio', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36049010', 'description' => 'Foguetes e cartuchos contra o granizo e semelhantes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36049090', 'description' => 'Outs.foguetes de sinalizacao e artigos de pirotecnia', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36049090', 'description' => 'Foguetes e artigos semelhantes para sinalização', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36050000', 'description' => 'Fosforos,exceto os artigos de pirotecnia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36061000', 'description' => 'Combustiveis liq.etc.util.p/carreg.isqueiro, cap<=300cm3', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '36069000', 'description' => 'Ferrocerio e outs.ligas pirofosforicas,art. mat.inflamav', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37011010', 'description' => 'Chapas/filmes planos,p/raios x,sensib.1 face,n/impress.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37011021', 'description' => 'Chapas/film.planos,p/raios x odont.sensib.2 f.n/impress', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37011029', 'description' => 'Outs.chapas/film.planos,p/raios x,sensib.2 f.n/impress.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37012010', 'description' => 'Filmes planos,revel.instant.sensib.n/impr. p/foto cores', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37012020', 'description' => 'Filmes plan.revel.instant.sensib.n/impr.p/foto monocrom', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37013010', 'description' => 'Outs.chapas/film.plan.sensib.n/impr.d>255mm,p/fot.cores', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37013021', 'description' => 'Chapas aluminio,plan.sensib.polim.fotoss. n/impr.d>255mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37013022', 'description' => 'Chapas poliester,plan.sens.polim.fotoss. n/impr.d>255mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37013029', 'description' => 'Outs.chapas planas,sensib.polim.fotoss.n/impres.d>255mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37013031', 'description' => 'Chapas aluminio,planas,sensib.out.proc .n/impres.d>255mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '37013039', 'description' => 'Outs.chapas planas,sensib.out.proc.n/impres. dim>255mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37013040', 'description' => 'Filmes planos,p/artes graficas,sensib. n/impress.d>255mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37013050', 'description' => 'Filmes plan.heliograf.poliester,sensib. n/impres.d>255mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37013090', 'description' => 'Outs.chapas e filmes planos,sensib.n/impress.dim>255mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37019100', 'description' => 'Outs.chapas/filmes,planos,sensib.n/impress.p/foto cores', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37019900', 'description' => 'Outs.chapas/filmes,planos,sensib.n/impr.p/foto monocrom', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37021010', 'description' => 'Filmes p/raios x,sensibil.1 face,n/ impression. em rolos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37021020', 'description' => 'Filmes p/raios x,sensibil.2 faces,n/impression. em rolos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37023100', 'description' => 'Outros filmes, não perfurados, de largura não superior a 105mm, para fotografia a cores (policromos)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37023200', 'description' => 'Outros filmes c/emuls.halog.prata,sensib. n/impr. l<=105mm,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37023900', 'description' => 'Outs.filmes n/perfur.sensib.n/impress. l<=105mm,em rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024100', 'description' => 'Filmes p/foto cores,sensib.n/impr.l>610mm, c>200m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024210', 'description' => 'Filmes p/artes grafs.sensib.n/impr.l>610mm, c>200m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024290', 'description' => 'Outs.filmes n/perfur.sensib.n/impr.l>610mm, c>200m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024310', 'description' => 'Filmes p/artes graf.sensib.n/impr.l>610mm, c<=200m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024320', 'description' => 'Filmes heliogr.poliest.sens.n/impr.l>61cm, c<=200m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024390', 'description' => 'Outs.filmes n/perf.sensib.n/impr. l>610mm, c<=200m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024410', 'description' => 'Filmes p/foto cores,sensib.n/impr. 105<l<=610mm, em rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024421', 'description' => 'Filmes p/artes graf.monocr.n/impr. 105<l<=610mm, em rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024422', 'description' => 'Outs.filmes monocrom.sensib.n/impres.de larg >105mm, mas não superior a 610 mm, fotopolimerizáveis, sensibilizadas à base de compostos acrílicos, dos tipos utilizados para a fabricação de circuitos impressos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37024429', 'description' => 'Outs.filmes monocrom.sensib.n/impres. 105<l<=610mm,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025200', 'description' => 'Filmes p/foto cores,sensib.n/impres.l<=16mm, c>14m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025200', 'description' => 'Filmes cinematográficos de 16 mm de largura e comprimento superior a 14m', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025300', 'description' => 'Filmes p/diaposit.cores,n/impr.16<l<=35mm, c<=30m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025411', 'description' => 'Filmes p/foto cores,sensib.n/impr.l=35mm, c<=30m,bobinas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025412', 'description' => 'Filmes p/foto cores,sensib.n/impr.l >16mm <=35mm,c<=30m (exceto p/ diapositivos)de 12 exposições (0,5m de comprimento), de 24 exposições (1,0m de comprimento) ou de 36 exposições (1,5m de comp)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025419', 'description' => 'Outs.filmes p/foto cores,n/impress.l=35mm, c<=30m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025491', 'description' => 'Filmes p/foto cores,n/impr.16<l<35mm,c<=30m,em bobinas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025499', 'description' => 'Outs.filmes p/foto cores,n/impr.16<l<35mm, c<=30m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025510', 'description' => 'Filmes p/foto cores,sensib.n/impr.l=35mm,c>30m,em rolos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025590', 'description' => 'Filmes p/foto cores,sensib.n/impr.16<l<35mm, c>30m,rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37025600', 'description' => 'Filmes p/foto cores,sensib.n/impress.l>35mm,em rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37029600', 'description' => 'Outs.filmes sensib.n/impress.de largura não superior a 35 mm e comprimento não superior a 30 m', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37029600', 'description' => 'De largura não superior a 16mm e comprimento superior a 14 metros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37029700', 'description' => 'Outs.filmes sensib.n/impress.de largura superior a 35 mm e comprimento não superior a 30 m', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37029700', 'description' => 'De largura não superior a 16mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37029800', 'description' => 'Outros filmes sensib.n/impress.l>35mm,em rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37031010', 'description' => 'Papel,etc.p/foto cores,sensib.n/impr.em rolos,l>610mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37031021', 'description' => 'Papel heliograf.monocrom.sensib.n/impr.em rolos,l>610mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37031029', 'description' => 'Outs.papeis p/foto monocrom.sensib.n/impr.rolos,l>610mm', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37032000', 'description' => 'Outs.papeis p/foto a cores,sensibil.n/impressionados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37039010', 'description' => 'Papel p/fotocomposicao,sensibilizado,nao impressionado', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37039090', 'description' => 'Outs.papeis,cartoes e texteis fotograf.sensib.n/impress', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37040000', 'description' => 'Chapas,filmes,etc.fotograficos,impress.mas n/revelados', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37040000', 'description' => 'Chapas e filmes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37050010', 'description' => 'Fotomascaras sobre vidro plano, positivas, proprias para gravacao em pastilhas de silicio (chips) para fabricacao de microestruturas eletronicas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37050090', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37061000', 'description' => 'Filmes cinematograficos impress.e revelados, l>=35mm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37069000', 'description' => 'Outros filmes cinematograficos impress.e revelados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37071000', 'description' => 'Emulsoes p/sensibilizacao de superfs.p/uso fotografico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37079010', 'description' => 'Fixadores para uso fotografico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37079021', 'description' => 'Reveladores a base de negro de fumo,etc. p/reprod.docum.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37079029', 'description' => 'Outros reveladores para uso fotografico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '37079030', 'description' => 'Compost.diazoicos fotossens.p/prepar.emulsoes fotograf.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '37079090', 'description' => 'Outs.preparacoes quimicas p/usos fotograficos, etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38011000', 'description' => 'Grafita artificial', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38012010', 'description' => 'Suspensao semicoloidal em oleos minerais (grafita)', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38012090', 'description' => 'Outros grafitas coloidais ou semicoloidais', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38013010', 'description' => 'Pasta carbonada para eletrodos', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38013090', 'description' => 'Pastas semelh.as carbonadas p/revest.interior de fornos', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38019000', 'description' => 'Outs.prepars.base de grafita/outs.carbonos,em pasta,etc', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38021000', 'description' => 'Carvoes ativados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38029010', 'description' => 'Farinhas siliciosas fosseis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38029020', 'description' => 'Bentonita (materia mineral natural ativada)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38029030', 'description' => 'Atapulgita', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38029040', 'description' => 'Outros argilas e terras ativadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38029050', 'description' => 'Bauxita (materia mineral natural ativada)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38029090', 'description' => 'Outros materias minerais naturais ativadas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38030010', 'description' => 'Tall-oil mesmo refinado, bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38030090', 'description' => 'Tall-oil mesmo refinado, outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38040011', 'description' => 'Lixivia residual da fabr.pasta de celulose,ao sulfito', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38040012', 'description' => 'Lixivia residual da fabr.pasta celulose,a soda/sulfato', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38040020', 'description' => 'Lignossulfonatos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38051000', 'description' => 'Essencias de terebintina,de pinheiro ou etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38059010', 'description' => 'Oleo de pinho', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38059090', 'description' => 'Outs.essencias terpenicas da destil/tratam. madeiras,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38061000', 'description' => 'Colofonias e acidos resinicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38062000', 'description' => 'Sais de colofonias,acidos resinicos ou de seus derivs.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38063000', 'description' => 'Gomas esteres (gomas fundidas)', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38069011', 'description' => 'Colofonias oxidadas,hidrogenadas,desidrogenadas,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38069012', 'description' => 'Abietatos de metila ou benzila,hidroabietato de metila', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38069019', 'description' => 'Outs.derivados de colofonias ou de acidos resinicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38069090', 'description' => 'Outros essencias de colofonia e oleos de colofonia', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38069090', 'description' => 'Gomas fundidas', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38070000', 'description' => 'Alcatroes de madeira,oleos de alcatrao de madeira,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38070000', 'description' => 'Solventes e diluentes compostos para vernizes ou produtos semelhantes', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38085200', 'description' => 'Ddt (iso) (clofenotano (dci)), acondicionado em embalagens com um conteudo de peso liquido nao superior a 300 g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38085910', 'description' => 'Apresentadas em formas ou embalagens exclusivamente para uso direto em aplicacoes domissanitarias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38085921', 'description' => 'A base de metamidofos (iso) ou monocrotofos (iso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38085922', 'description' => 'A base de endossulfan (iso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38085923', 'description' => 'A base de alaclor (iso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38085929', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38086100', 'description' => 'Acondicionadas em embalagens com um conteudo de peso liquido nao superior a 300 g', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38086210', 'description' => 'A base de alfa cipermetrina (iso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38086290', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38086910', 'description' => 'A base de alfa cipermetrina (iso)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38086990', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089111', 'description' => 'Inseticida cont.bromometano,etc.p/uso domissanit.direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089119', 'description' => 'Outs.inseticidas em embalagens p/uso domissanit.direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089120', 'description' => 'Inseticida cont.bromometano,etc. apresent. de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089191', 'description' => 'Inseticida a base de acefato apresentado de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089192', 'description' => 'Inseticida a base de cipermetrina/ permetrina, outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089193', 'description' => 'Inseticida a base de dicrotofos, apresent. de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089194', 'description' => 'Inseticida a base de dissulfoton/endossulfan, outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089195', 'description' => 'Inseticida a base de fosfeto de aluminio,em outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089196', 'description' => 'Inseticida a base de diclorvos/triclorfon, em outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '38089197', 'description' => 'Inseticida a base de oleo mineral/ tiometon,outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089198', 'description' => 'Inseticida a base de sulfluramida, apresent.outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089199', 'description' => 'Outs.inseticidas,apresentados de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089211', 'description' => 'Fungicida cont.bromometano,etc.p/uso domissanit.direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089219', 'description' => 'Outs.fungicidas em embalag.p/uso domissanitario direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089220', 'description' => 'Fungicida cont.bromometano, etc.apresent. de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089291', 'description' => 'Fungicida a base de hidroxido de cobre,etc. outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089292', 'description' => 'Fungicida a base de enxofre/ziram, apresent. outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089293', 'description' => 'Fungicida a base de mancozeb/maneb, apresent.outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089294', 'description' => 'Fungicida a base de sulfiram,apresent. de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089295', 'description' => 'Fungic.a base de comp.de arsenio/cobre/ cromo, outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089296', 'description' => 'Fungicida a base de thiram, apresentado de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089297', 'description' => 'Fungicida a base de propiconazol, apresent. de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089299', 'description' => 'Outs.fungicidas apresentados de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089311', 'description' => 'Herbicida cont.bromometano,etc.p/uso domissanit.direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089319', 'description' => 'Outs.herbicidas em embalag.p/uso domissanitario direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089321', 'description' => 'Herbicidas à base de ácido 2,4-diclorofenoxiacético (2,4-d), de ácido 4-(2,4-diclorofenoxi)butírico (2,4-db), de ácido (4-cloro-2-metil)fenoxiacético (mcpa) ou de derivados de 2,4-d ou 2,4-db', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089322', 'description' => 'Herbicida a base de atrazina/alaclor/diuron ou ametrina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089323', 'description' => 'Herbicida a base glifosato/sal monoisopropilamina,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089324', 'description' => 'Herbicida a base de dicloreto de paraquat, propanil,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089325', 'description' => 'Herbicida a base de trifluralina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089326', 'description' => 'Herbicida a base de trifluralina', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089327', 'description' => 'Herbicida a base de imazetapir', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089328', 'description' => 'Herbicida a base de hexazinona', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089329', 'description' => 'Outros herbicidas apresentados de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089331', 'description' => 'Inibidores de germinacao para uso domissanitario direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089332', 'description' => 'Inibidores de germinacao , apresentados em formas ou embalagens exclusivamente para uso domissanitário direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089333', 'description' => 'Outs.inibidores de germinacao apresentados de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089341', 'description' => 'Regul.crescim.plant.c/brometo metila. embal.p/domissanit', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089349', 'description' => 'Outs.regul.de crescim.de plant.embal.p/ domissanit.diret', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089351', 'description' => 'Reguladores de crescim.plantas, contendo bromometano (brometo de metila) ou bromoclorometano', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089352', 'description' => 'Reguladores de crescim.plantas,base hidrazida maleica', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089359', 'description' => 'Outs.reguladores de crescim.plantas, apresents.out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089411', 'description' => 'Desinfetantes contendo bromometano (brometo de metila) ou bromoclorometano para uso domissanitario direto', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089411', 'description' => 'Com propriedades acessórias odoríferas ou desodorizantes de ambientes, apresentados em embalagem tipo aerossol', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089419', 'description' => 'Outros desinfetantes para uso domissanitario direto', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089419', 'description' => 'Com propriedades acessórias odoríferas ou desodorizantes de ambientes, apresentados em embalagem tipo aerossol', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089419', 'description' => 'À base de hipoclorito de sódio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089421', 'description' => 'Desinfetante a base de 2-(tiocianometiltio) benzotiazol', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089421', 'description' => 'Com propriedades acessórias odoríferas ou desodorizantes de ambientes', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089422', 'description' => 'Outros desinfetantes a base de 2-(tiocianometiltio) benzotiazol', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089422', 'description' => 'Com propriedades acessórias odoríferas ou desodorizantes de ambientes', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089429', 'description' => 'Outros desinfetantes apresentados de out.modo', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089429', 'description' => 'Com propriedades acessórias odoríferas ou desodorizantes de ambientes', 'aliquota_federal' => 27.28, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089429', 'description' => 'À base de hipoclorito de sódio', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089911', 'description' => 'Outs.rodentic.cont.brometo metila,p/uso domissanit.dir.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089919', 'description' => 'Outs.rodenticidas ou semelh.embal.p/uso domissanit.dir.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089920', 'description' => 'Outs.rodenticidas,cont.brometo metila,apresent.out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089991', 'description' => 'Acaricidas a base amitraz,clorfenvinfos, metamidofos,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089992', 'description' => 'Acaricidas a base ciexatin,oxido de fembutatin,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089993', 'description' => 'Outros acaricidas apresentados de out. modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089994', 'description' => 'Nematicidas a base de metam sodio, apresentados out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089995', 'description' => 'Outros nematicidas apresentados de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '38089996', 'description' => 'Raticidas apresentados de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38089999', 'description' => 'Outs.rodenticidas/prods.semelhs.apresentados out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38091010', 'description' => 'Preparacoes a base de materias amilaceas p/ind.textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38091090', 'description' => 'Outros preparacoes a base de materias amilaceas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099110', 'description' => 'Aprestos preparados util.na industria textil/semelhante', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099120', 'description' => 'Preparacoes mordentes p/industria textil/inds.semelhs.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099130', 'description' => 'Prods.ignifugos para industria textil ou inds.semelhs.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099141', 'description' => 'Impermeabilizante a base de parafina,etc .p/ind.textil', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099149', 'description' => 'Outs.impermeabilizantes p/industria textil/inds. semelhs', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099190', 'description' => 'Outs.agentes de apresto ou acabamento,etc. p/ind. textil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099211', 'description' => 'Impermeabilizante a base de parafina,etc.p/ind. papel', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099219', 'description' => 'Outs.impermeabilizantes p/ind.do papel/inds. semelhs.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099290', 'description' => 'Outs.agentes de apresto ou acabamento,etc. p/ind. papel', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099290', 'description' => 'Preparações ignífugas', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099311', 'description' => 'Impermeabilizante a base de parafina,etc. p/ind.couro', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099319', 'description' => 'Outs.impermeabilizantes p/ind.do couro ou inds.semelhs.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099390', 'description' => 'Outs.agentes de apresto ou acabamento, etc. p/ind.couro', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38099390', 'description' => 'Preparações ignífugas', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38101010', 'description' => 'Preparacoes para decapagem de metais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38101020', 'description' => 'Pastas e pos para soldar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38109000', 'description' => 'Outs.fluxos/prepars.auxiliares/varetas,p/ soldar,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38111100', 'description' => 'Prepars.antidetonantes a base de compostos de chumbo', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38111900', 'description' => 'Outros preparacoes antidetonantes', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112110', 'description' => 'Aditivos melhoradores do indice viscosid. p/oleos lubrif', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112120', 'description' => 'Aditivos antidesgastes,anticorrosiv.etc.p/oleos lubrif.', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112130', 'description' => 'Outs.aditivos dispersantes-detergentes, p/oleos lubrif.', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112140', 'description' => 'Prepars.c/melh.indice visc/antidesg.etc. p/oleos lubrif.', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112150', 'description' => 'Aditivos peptizantes,c/oleos petrol. etc. p/oleos lubrif.', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112190', 'description' => 'Outs.aditivos c/oleos de petroleo,etc.p/ oleos lubrific.', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112910', 'description' => 'Outs.aditivos peptizantes/dispersantes-deterg.tbn<170', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112920', 'description' => 'Outs.aditivos peptizantes/dispersantes-deterg.tbn>=170', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38112990', 'description' => 'Outros aditivos p/oleos lubrificantes', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38119010', 'description' => 'Outs.aditivs.dispers.s/cinzas,p/oleo petrol.combust.etc', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38119090', 'description' => 'Outs.aditivos preparados,p/oleos minerais/ outs.liquidos', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38121000', 'description' => 'Preparacoes denominadas aceleradores de vulcanizacao', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38122000', 'description' => 'Plastificantes compostos para borracha ou plastico', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38123100', 'description' => 'Misturas de oligomeros de 2,2,4 trimetil 1,2 diidroquinolina (tmq)', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38123911', 'description' => 'Que contenham derivados n substituidos de p fenilenodiamina', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38123912', 'description' => 'Que contenham fosfitos de alquila, de arila ou de alquil arila', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38123919', 'description' => 'Outros', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38123921', 'description' => 'Que contenham derivados n substituidos de p fenilenodiamina', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38123929', 'description' => 'Outros', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38130010', 'description' => 'Cargas c/bromoclorodifluormetano, etc.p/apars.extintores', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38130020', 'description' => 'Cargas c/hidrobromofluorcarbonetos (hbfc) p/apars.extint', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38130030', 'description' => 'Cargas c/hidroclorofluorcarbonetos (hcfc) p/apars.extint', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38130040', 'description' => 'Composicoes/cargas cont.bromoclorometano p/apars.extint', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38130090', 'description' => 'Composicoes e cargas p/apars.extintores, granadas,etc.', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38140010', 'description' => 'Outs.solventes/diluentes,cont.clorofluorcarbonetos(cfc)', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38140020', 'description' => 'Outs.solventes/diluentes,cont.hidroclorofluorcar organ.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38140030', 'description' => 'Outs.solventes/diluentes,cont.tetracloreto de carbono,', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38140090', 'description' => 'Outs.solventes e diluentes organicos compostos,etc.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38151100', 'description' => 'Catalisador em suporte,subst.ativa=niquel ou composto', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38151210', 'description' => 'Catalisador em suporte,subst.ativa=metal precioso/comp., em colmeia cerâmica ou metálica para conversão catalítica de gases de escape de veículos', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '38151220', 'description' => 'Catalisador em suporte,subst.ativa=metal precioso/comp., com tamanho de partícula < 500 mícrons', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38151290', 'description' => 'Outs catalisador em suporte,subst.ativa=metal precioso/comp.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38151900', 'description' => 'Outros catalisadores em suporte', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38159010', 'description' => 'Outs.preparacoes cataliticas p/craqueamento de petroleo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38159091', 'description' => 'Outs.prepars.cataliticas,subst.ativa=isoprenilaluminio', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38159092', 'description' => 'Outs.prepars.cataliticas,subst.ativa oxido de zinco', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38159093', 'description' => 'Tendo como substância ativa óxidos de terras raras', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38159099', 'description' => 'Outros prepars.cataliticas', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38160011', 'description' => 'Cimento/argamassa,a base magnesita calcinada,refratario', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38160012', 'description' => 'Cimento e argamassa,a base de silimanita, refratarios', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38160019', 'description' => 'Outros cimentos e argamassas,refratarios', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38160021', 'description' => 'Prepars.a base cromo-magnesita,zirconio, etc.refratarios peso .50% corindon ou grafita', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38160029', 'description' => 'Outras (prepars.a base cromo-magnesita, etc. refratarios)', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38160090', 'description' => 'Outs.concretos e composicoes semelhantes, refratarios', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38170010', 'description' => 'Misturas de alquilbenzenos', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38170020', 'description' => 'Misturas de alquilnaftalenos', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38180010', 'description' => 'Elementos quims.impurifs.de silicio,p/util. eletronica', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38180090', 'description' => 'Outs.elementos quimicos impurificados p/util.eletronica', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38190000', 'description' => 'Liquidos p/freios hidraulicos,etc.c/oleos petroleo<=70%', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38200000', 'description' => 'Prepars.anticongelantes/liquidos prepar.p/ descongelacao', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38210000', 'description' => 'Meios de cultura preparados para o desenvolvimento e a manutenção de microrganismos (incluídos os vírus e organismos similares) ou de células vegetais, humanas ou animais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38220010', 'description' => 'Reagentes para determinação de componentes do sangue ou da urina, sobre suporte de papel, em rolos, sem suporte adicional hidrófobo, impróprio para uso direto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38220090', 'description' => 'Outros reagentes de diagnostico/ laboratorio, em suporte/prepars', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38231100', 'description' => 'Acido estearico (ac.graxo monocarboxilico industrial)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38231200', 'description' => 'Acido oleico (acido graxo monocarboxilico industrial)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38231300', 'description' => 'Acido graxo (gordo) do tall oil', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38231910', 'description' => 'Ácido caprílico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38231990', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38237010', 'description' => 'Alcool estearico (alcool graxo industrial)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38237020', 'description' => 'Alcool laurico (alcool graxo industrial)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38237040', 'description' => 'Alcool Cetílico (alcool graxo industrial)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38237040', 'description' => 'Ex 01 - Com características de ceras artificiais', 'aliquota_federal' => 9.68, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38237090', 'description' => 'Outros alcoois graxos industriais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38237090', 'description' => 'Com características de ceras artificiais', 'aliquota_federal' => 9.68, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38241000', 'description' => 'Aglutinantes preparados p/moldes ou nucleos de fundicao', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38243000', 'description' => 'Carbonetos metalicos n/aglomer.misturados entre si,etc.', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38244000', 'description' => 'Aditivos preparados p/cimentos,argamassas ou concretos', 'aliquota_federal' => 6.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38245000', 'description' => 'Argamassas e concretos,nao refratarios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38246000', 'description' => 'Sorbitol,exceto o polialcool d-glucitol', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247110', 'description' => 'Misturas contendo triclorotrifluoretanos', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247190', 'description' => 'Outs.misturas c/hidrocarb.acicl.peralog.c/fluor e cloro', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247200', 'description' => 'Outs.misturas contendo bromoclorodifluormetano, bromotrifluormetano ou dibromotetrafluoretanos', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247300', 'description' => 'Outs.misturas contendo hidrobromofluorcarbonetos (hbfc)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247410', 'description' => 'Preparações à base de clorodifluormetano e pentafluoretano', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247420', 'description' => 'Preparações à base de clorodifluormetano e clorotetrafluoretano', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247490', 'description' => 'Outs.prod.prep.à base d/comp.orgânicos', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247500', 'description' => 'Outros prods.e prepars.contendo tetracloreto de carbono', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247600', 'description' => 'Outros prods.e prepars.contendo 1,1,1-tricloroetano (metilclorofórmio)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247700', 'description' => 'Outs.misturas contendo bromometano (brometo de metila) ou do bromoclorometano', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247810', 'description' => 'Preparações à base de tetrafluoretano e pentafluoretano', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247890', 'description' => 'Outros prods.e prepars.contendo clorofluorcarbonetos (cfc), mesmo que contenham hidroclorofluorcarbonetos (hcfc), perfluorcarbonetos (pfc) ou hidrofluorcarbonetos (hfc)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38247900', 'description' => 'Outros prods.e prepars.misturas contendo derivados halogenados do metano, do etano ou do propano', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38248110', 'description' => 'Mistura de oxido de propileno,c/teor oxido etileno<=30%', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '38248190', 'description' => 'Outras misturas contendo oxirano (óxido de etileno)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38248200', 'description' => 'Outros misturas e preparações contendo polibromobifenilas (pbb), policloroterfenilas (pct) ou policlorobifenilas (pcb', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38248300', 'description' => 'Outros prods.e prepars.contendo fosfato de tris(2,3-dibromopropila)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38248400', 'description' => 'Que contenham aldrin (iso), canfecloro (iso) (toxafeno), clordano (iso), clordecona (iso), ddt (iso) (clofenotano (dci), 1,1,1 tricloro 2,2 bis(p clorofenil)etano), dieldrin (iso, dci), endossulfan (iso), endrin (iso), heptacloro (iso) ou mirex (iso)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38248500', 'description' => 'Que contenham 1,2,3,4,5,6 hexaclorocicloexano (hch (iso)), incluindo o lindano (iso, dci)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38248600', 'description' => 'Que contenham pentaclorobenzeno (iso) ou hexaclorobenzeno (iso)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38248700', 'description' => 'Que contenham acido perfluoroctano sulfonico, seus sais, perfluoroctanossulfonamidas, ou fluoreto de perfluoroctanossulfonila', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38248800', 'description' => 'Que contenham eteres tetra , penta , hexa , hepta  ou octabromodifenilicos', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249100', 'description' => 'Misturas e preparacoes constituidas principalmente por metilfosfonato de (5 etil 2 metil 2 oxido 1,3,2 dioxafosfinan 5 il)metil metila e metilfosfonato de bis[(5 etil 2 metil 2 oxido 1,3,2 dioxafosfinan 5 il)metila]', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249911', 'description' => 'Salinomicina micelial', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249912', 'description' => 'Com um teor de cianocobalamina inferior ou igual a 55 %, em peso', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249913', 'description' => 'Da fabricacao da primicina amonica', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249914', 'description' => 'Senduramicina sodica, da fabricacao da senduramicina', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249915', 'description' => 'Maduramicina amonica, em solucao alcoolica, da fabricacao da maduramicina', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249919', 'description' => 'Outros', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249921', 'description' => 'Acidos graxos dimerizados, preparacoes contendo acidos graxos dimerizados', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249922', 'description' => 'Preparacoes contendo estearoilbenzoilmetano e palmitoilbenzoilmetano, preparacoes contendo caprilato e caprato de propilenoglicol', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249923', 'description' => 'Preparacoes contendo trigliceridios dos acidos caprilico e caprico', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249924', 'description' => 'Esteres de alcoois graxos de c12 a c20 do acido metacrilico e suas misturas, esteres de acidos monocarboxilicos de c10 ramificados com glicerol', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249925', 'description' => 'Misturas de esteres dimetilicos dos acidos adipico, glutarico e succinico, misturas de acidos dibasicos de c11 e c12, acidos naftenicos, seus sais insoluveis em agua e seus esteres', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249929', 'description' => 'Outros', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249931', 'description' => 'Que contenham isocianatos de hexametileno ou outros isocianatos', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249932', 'description' => 'Que contenham aminas graxas de c8 a c22', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249933', 'description' => 'Que contenham polietilenoaminas e dietilenotriaminas, proprias para a coagulacao do latex', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249934', 'description' => 'Outras, contendo polietilenoaminas', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249935', 'description' => 'Misturas de mono , di  e triisopropanolaminas', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249936', 'description' => 'Reticulantes para silicones', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249939', 'description' => 'Outras', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249941', 'description' => 'Preparacoes desincrustantes, anticorrosivas ou antioxidantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249942', 'description' => 'Mistura eutetica de difenila e oxido de difenila', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249943', 'description' => 'A base de trimetil 3,9 dietildecano', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249949', 'description' => 'Outros', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249951', 'description' => 'Antiespumantes contendo fosfato de tributila em solucao de alcool isopropilico', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249952', 'description' => 'Misturas de polietilenoglicois', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249953', 'description' => 'Polipropilenoglicol liquido', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249954', 'description' => 'Retardante de chama contendo misturas de trifenilfosfatos isopropilados', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249959', 'description' => 'Outros', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249971', 'description' => 'Cal sodada, carbonato de calcio hidrofugo', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249972', 'description' => 'Preparacoes a base de silica em suspensao coloidal, nitreto de boro de estrutura cristalina cubica, compactado com substrato de carbeto de tungstenio (volframio)', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249973', 'description' => 'Preparacoes a base de carbeto de tungstenio (volframio) com niquel como aglomerante, brometo de hidrogenio em solucao', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249974', 'description' => 'Preparacoes a base de hidroxido de niquel ou de cadmio, de oxido de cadmio ou de oxido ferroso ferrico, proprios para a fabricacao de acumuladores alcalinos', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249975', 'description' => 'Preparacoes utilizadas na elaboracao de meios de cultura, trocadores de ions para o tratamento de aguas, preparacoes a base de zeolitas artificiais', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249976', 'description' => 'Compostos absorventes a base de metais para aperfeicoar o vacuo nos tubos ou valvulas eletricas', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249977', 'description' => 'Adubos (fertilizantes) foliares contendo zinco ou manganes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249978', 'description' => 'Preparacoes a base de oxido de aluminio e oxido de zirconio, com um conteudo de oxido de zirconio igual ou superior a 20 %, em peso', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249979', 'description' => 'Outros', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249979', 'description' => 'Outros', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249981', 'description' => 'Preparacoes a base de anidrido poliisobutenilsuccinico, em oleo mineral', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249982', 'description' => 'Halquinol, tetraclorohidroxiglicina de aluminio e zirconio', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249983', 'description' => 'Triisocianato de tiofosfato de fenila ou de trifenilmetano, em solucao de cloreto de metileno ou de acetato de etila, preparacoes a base de tetraacetiletilenodiamina (taed), em granulos', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249985', 'description' => 'Metilato de sodio em metanol', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249986', 'description' => 'Maneb, mancozeb, cloreto de benzalconio', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249987', 'description' => 'Dispersao aquosa de microcapsulas de poliuretano ou de melamina formaldeido contendo um precursor de corante em solventes organicos', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '38249988', 'description' => 'Misturas constituidas principalmente pelos compostos seguintes: alquilfosfonofluoridatos de o alquila (de ate c10, incluindo os cicloalquilas), n,n dialquilfosforoamidocianidatos de o alquila (de ate c10, incluindo os cicloalquilas), hidrogenio alquilfosf', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38249989', 'description' => 'Outros', 'aliquota_federal' => 8.02, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38251000', 'description' => 'Lixos municipais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38252000', 'description' => 'Lamas de tratamentos de esgotos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38253000', 'description' => 'Residuos clinicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38254100', 'description' => 'Residuos de solventes organicos halogenados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38254900', 'description' => 'Outs residuos de solventes organicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38255000', 'description' => 'Resíduos de soluções decapantes para metais, de fluidos hidráulicos, de fluidos para freios e de líquidos anticongelantes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38256100', 'description' => 'Outs residuos das ind quimicas ou conexas contendo principalmente constituintes organicos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38256900', 'description' => 'Outs residuos das ind quimicas ou conexas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38259000', 'description' => 'Outs produtos residuais ou lixos não mencionados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38260000', 'description' => 'Biodiesel e suas misturas, que não contenham ou que contenham menos de 70 %, em peso, de óleos de petróleo ou de óleos minerais betuminosos.', 'aliquota_federal' => 17.27, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '38260000', 'description' => 'Biodiesel', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39011010', 'description' => 'Polietileno linear,densidade<0.94,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39011091', 'description' => 'Polietileno com carga,densidade<0.94,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39011092', 'description' => 'Polietileno sem carga,densidade<0.94,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39012011', 'description' => 'Polietileno c/carga,vulcaniz.d>=1.3,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39012019', 'description' => 'Outs.polietilenos c/carga,d>=0.94,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39012021', 'description' => 'Polietileno s/carga,vulcaniz.dens>1.3,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39012029', 'description' => 'Outs.polietilenos s/carga,d>=0.94,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39013010', 'description' => 'Copolimero de etileno/acetato vinila,em liquidos,pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39013090', 'description' => 'Copolimero etileno/acetato vinila,em outs.formas primar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39014000', 'description' => 'Copolimeros de etileno e alfa olefina, de densidade inferior a 0,94', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39019010', 'description' => 'Copolimero de etileno/acido acrilico,em formas primars.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39019020', 'description' => 'Copolimeros de etileno/monomeros etc.em formas primars.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39019030', 'description' => 'Polietileno clorossulfonado,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39019040', 'description' => 'Polietileno clorado', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39019050', 'description' => 'Copolímeros de etileno - ácido metacrílico, com um conteúdo de etileno superior ou igual a 60%, em peso', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39019090', 'description' => 'Outros polimeros de etileno,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39021010', 'description' => 'Polipropileno com carga,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39021020', 'description' => 'Polipropileno sem carga,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39022000', 'description' => 'Poliisobutileno em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39023000', 'description' => 'Copolimeros de propileno,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39029000', 'description' => 'Outs.polimeros de propileno/olefinas,em formas primars.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39031110', 'description' => 'Poliestireno expansivel,com carga,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39031120', 'description' => 'Poliestireno expansivel,sem carga,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39031900', 'description' => 'Outros poliestirenos em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39032000', 'description' => 'Copolimeros de estireno-acrilonitrila,em formas primars', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39033010', 'description' => 'Copolimeros de acrilonitrila-butadieno-estireno,c/carga', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39033020', 'description' => 'Copolimeros de acrilonitrila-butadieno-estireno,s/carga', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39039010', 'description' => 'Copolimeros de metacrilato de metila-butadieno-estireno', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39039020', 'description' => 'Copolimeros de acrilonitrila-estireno-acrilato de butila (asa)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39039090', 'description' => 'Outros polimeros de estireno,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39041010', 'description' => 'Policloreto de vinila,obt.proc.suspensao,forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39041020', 'description' => 'Policloreto de vinila,obt.proc.emulsao,forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39041090', 'description' => 'Outros policloretos de vinila,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39042100', 'description' => 'Policloreto de vinila,n/plastificado,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39042200', 'description' => 'Policloreto de vinila,plastificado,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39043000', 'description' => 'Copolimeros de cloreto,acetato de vinila, formas primars', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39044010', 'description' => 'Copolimeros de cloreto,acetato vinila c/ac. dibasico,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39044090', 'description' => 'Outs.copolimeros de cloreto de vinila,formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39045010', 'description' => 'Copolimeros de cloreto de vinilideno, s/emulsionante,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39045090', 'description' => 'Outs.polimeros de cloreto vinilideno,formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '39046110', 'description' => 'Politetrafluoretileno em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39046190', 'description' => 'Outros politetrafluoretilenos em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39046910', 'description' => 'Copolimero de fluoreto de vinilideno, hexafluorpropileno', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39046990', 'description' => 'Outros polimeros fluorados,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39049010', 'description' => 'Poli(cloreto de vinila) clorado', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39049090', 'description' => 'Outros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 0.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39051200', 'description' => 'Acetato de polivinila,em dispersao aquosa', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39051910', 'description' => 'Acetato de polivinila,com alcool vinilico,em blocos,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39051990', 'description' => 'Outs.polimeros de acetato de polivinila,formas primars.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39052100', 'description' => 'Copolimeros de acetato de vinila,em dispersao aquosa', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39052900', 'description' => 'Outs.copolimeros de acetato de vinila,formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39053000', 'description' => 'Alcool polivinilico,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39059130', 'description' => 'Copolimero de vinilpirrolidona,etc.em solucao alcoolica', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39059190', 'description' => 'Outros copolimeros de acetato de vinila,etc. formas prim', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39059910', 'description' => 'Copolimero polivinilformal,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39059920', 'description' => 'Copolimero polivinilbutiral,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39059930', 'description' => 'Copolimero polivinilpirrolidona iodada,formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39059990', 'description' => 'Outs.copolimeros polivinilpirrolidonas,formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39061000', 'description' => 'Polimetacrilato de metila,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39061000', 'description' => 'Em pó, de granulometria de 50 a 400 mesh, próprio para uso odontológico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069011', 'description' => 'Acido poliacrilico e sais,em liq/pasta,soluvel em agua', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069012', 'description' => 'Sal sodico do ac.poliacrilamidico,em liq.etc. soluv.agua', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069019', 'description' => 'Outs.polimeros acrilicos,em liq.e pastas,soluv. em agua', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069021', 'description' => 'Acido poliacrilico e sais,em liq/pasta,em solvent. organ', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069022', 'description' => 'Copolimero de metacrilato 2-diisopropil.em suspens.etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069029', 'description' => 'Outs.polimeros acrilicos,em liquido/pasta,em solv.organ', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069031', 'description' => 'Acido poliacrilico e sais,em liq/pasta,em outs. solv.etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069032', 'description' => 'Sal sodico do ac.poliacrilam.em liq.pasta.outs. solv.etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069039', 'description' => 'Outs.polimeros acrilicos,em liq.pasta,em outs. solv.etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069041', 'description' => 'Acido poliacrilico e sais,em blocos irregul. pedacos, etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069041', 'description' => 'Em pó, de granulometria de 50 a 400 mesh, próprios para uso odontológico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069042', 'description' => 'Sal sodico do ac.poliacril.em pedacos,etc. soluv.em agua', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069043', 'description' => 'Carboxipolimetileno,em po', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069044', 'description' => 'Poliacrilato de sodio,em blocos irregulares, pedacos,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069045', 'description' => 'Copolímero de poliacrilato de potássio e poliacrilamida (...)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069046', 'description' => 'Copolímeros de acrilato de metila-etileno com um conteúdo de acrilato de metila superior ou igual a 50%, em peso', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069047', 'description' => 'Copolímero de acrilato de etila, acrilato de n-butila e acrilato de 2-metoxietila', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069048', 'description' => 'Copolímero de acrilato de potássio e ácido acrílico, com capacidade de absorção de água destilada de até quatrocentas vezes seu próprio peso', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069049', 'description' => 'Outs.polimeros acrilicos,em blocos irregul. pedacos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39069049', 'description' => 'Em pó, de granulometria de 50 a 400 mesh, próprios para uso odontológico', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071010', 'description' => 'Poliacetais com carga,em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071020', 'description' => 'Poliacetais com carga,em blocos, pós e outs. formas  primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071031', 'description' => 'Polidextrose', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071039', 'description' => 'Outros (poliacetais sem carga,em liquidos e pastas)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071041', 'description' => 'Polidextrose', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071042', 'description' => 'Outros (poliacetais sem carga,em pó que passe atraves de uma peneira c/abertura de malha de 0,85mm (...))', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071049', 'description' => 'Outros (poliacetais sem carga,em blocos, pós eouts.formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071091', 'description' => 'Outros poliacetais em granulos,c/diametro de particula >2mm, segundo a norma astm e 11-70', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39071099', 'description' => 'Outros (poliacetais)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39072011', 'description' => 'Polioxifenileno com carga,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39072012', 'description' => 'Polioxifenileno sem carga,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39072020', 'description' => 'Politetrametilenoeterglicol em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39072031', 'description' => 'Polietilenoglicol 400,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '39072039', 'description' => 'Outros polieterpoliois,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39072041', 'description' => 'Poli(epicloridrina)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39072042', 'description' => 'Copolímeros de óxido de etileno', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39072049', 'description' => 'Outros poli(epicloridrina) (pech) e seus copolímeros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39072090', 'description' => 'Outros polieteres em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39073011', 'description' => 'Resinas epoxidas com carga,em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39073019', 'description' => 'Resinas epoxidas com carga,em outs.formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39073021', 'description' => 'Copolimero tetrabromobisfenol a,etc.s/carga, forma prim.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39073022', 'description' => 'Outs.resinas, nas formas previstas na nota 6 a) deste capítulo', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39073029', 'description' => 'Outras resinas epoxidas sem carga,em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39074010', 'description' => 'Nas formas previstas na nota 6 b) deste capítulo, com transmissão de luz de comprimento de onda de 550nm ou 800nm, superior a 89%, segundo norma astm d 1003-00 e índice de fluidez de massa superior ou igual a 60g/10min e inferior ou igual a 80g/10min segu', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39074090', 'description' => 'Outs.policarbonatos em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39075010', 'description' => 'Resinas alquidicas em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39075090', 'description' => 'Resinas alquidicas em outs.formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39076100', 'description' => 'De um indice de viscosidade de 78 ml/g ou mais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39076900', 'description' => 'Outros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39077000', 'description' => 'Poli(ácido láctico)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079100', 'description' => 'Outs.polieteres nao saturados,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079911', 'description' => '(poli)tereftalato butileno c/carga fibra vidro,forma prim', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079912', 'description' => 'Outros, nas formas previstas na nota 6 a) deste capítulo', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079919', 'description' => 'Tereftalato de polibutileno em outs.formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079991', 'description' => 'Outros poliesteres nas formas previstas na nota 6 a) deste capítulo', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079992', 'description' => 'Poli (epsilon caprolactona)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079993', 'description' => 'Copolímero de tereftalato de dimetila, cicloexanodimetanol e ácido isoftálico', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079994', 'description' => 'Copolímero de tereftalato de dimetila, cicloexanodimetanol e tetrametil cicloexanobutanodiol', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079995', 'description' => 'Copolímero de tereftalato de dimetila, cicloexanodimetanol e etilenoglicol ', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39079999', 'description' => 'Outros poliesteres em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081011', 'description' => 'Poliamida-11 em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081012', 'description' => 'Poliamida-12 em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081013', 'description' => 'Poliamida-6 ou poliamida-6,6,c/garga,em liquidos,pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081014', 'description' => 'Poliamida-6 ou poliamida-6,6,s/carga,em liquidos,pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081019', 'description' => 'Poliamidas-6,9 ou 6,10 ou 6-12,em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081021', 'description' => 'Poliamida-11 em blocos irregulares,pedados,grumos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081022', 'description' => 'Poliamida-12 em blocos irregulares,pedacos, grumos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081023', 'description' => 'Poliamida-6 ou poliamida-6,6,com carga,em pedacos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081024', 'description' => 'Poliamida-6 ou poliamida-6,6,sem carga,em pedacos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39081029', 'description' => 'Poliamidas-6,9 ou 6,10 ou 6-12,em blocos irregul.etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39089010', 'description' => 'Copolimero de lauril-lactama,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39089020', 'description' => 'Obtidas (poliamidas) por condensação de ácidos graxos (...)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39089090', 'description' => 'Outros poliamidas em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39091000', 'description' => 'Resinas ureicas/resinas de tioureia,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39092011', 'description' => 'Melamina-formaldeido,com carga,em po', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39092019', 'description' => 'Outs.resinas melaminicas,com carga,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39092021', 'description' => 'Melamina-formaldeido,sem carga,em po', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39092029', 'description' => 'Outs.resinas melaminicas,sem carga,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39093100', 'description' => 'Poli(isocianato de fenil metileno) (mdi bruto, mdi polimerico)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39093900', 'description' => 'Outras', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39094011', 'description' => 'Fenol-formaldeido,lipossoluvel,puro ou modificado', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39094019', 'description' => 'Outs.resinas fenolicas,lipossoluveis, puras/ modificadas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39094091', 'description' => 'Outros fenois-formaldeidos em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39094099', 'description' => 'Outros resinas fenolicas em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39095011', 'description' => 'Poliuretano em solucoes em solventes organicos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39095012', 'description' => 'Poliuretano em dispersao aquosa', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '39095019', 'description' => 'Outros poliuretanos em liquidos e pastas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39095021', 'description' => 'Poliuretano hidroxil.c/propried.adesiva,em pedacos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39095029', 'description' => 'Outs.poliuretanos em blocos irregulares, pedacos,pos,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39100011', 'description' => 'Oleos hidrolisados de dimetildiclororosilano (silicone)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39100012', 'description' => 'Oleos polidimetilsiloxano,etc.em dispersao (silicone)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39100013', 'description' => 'Oleos copolimeros de dimetilsiloxano, c/comp. vinil.etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39100019', 'description' => 'Outros oleos silicones em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39100021', 'description' => '(elastomeros (silicone)) de vulcanização a quente', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39100029', 'description' => 'Outros (elastomeros (silicone))', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39100030', 'description' => 'Resinas (silicone)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39100090', 'description' => 'Silicones em outs.formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39111010', 'description' => 'Resina de petroleo,de cumarona,etc.c/carga, forma primar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39111021', 'description' => 'Resinas de petróleo, total ou parcialmente hidrogenadas, de cor gardner inferior a 3, segundo norma astm d 1544', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39111029', 'description' => 'Outras resina de petroleo,de cumarona,etc.s/carga, forma primar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119011', 'description' => 'Politerpenos modif.quimicam.c/carga,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119012', 'description' => 'Polieterimidas (pei) e seus copolímeros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119013', 'description' => 'Polieteremidas e seus copolimeros,c/carga,formas primar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119014', 'description' => 'Poli(sulfeto de fenileno)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119019', 'description' => 'Polissulfetos,polissulfonas,etc.c/carga,formas primars.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119021', 'description' => 'Politerpenos modifs.quimicam.sem carga,em formas primar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119022', 'description' => 'Polissulfeto de fenileno,sem carga,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119023', 'description' => 'Polietilenaminas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119024', 'description' => 'Polieterimidas (pei) e seus copolímeros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119025', 'description' => 'Polietersulfonas (pes) e seus copolímeros', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119026', 'description' => 'Polissulfonas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119027', 'description' => 'Cloreto de hexadimetrina', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39119029', 'description' => 'Outs.politerpenos,etc.sem carga,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39121110', 'description' => 'Acetato de celulose,nao plastificado,c/carga, forma prim', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39121120', 'description' => 'Acetato de celulose,nao plastificado,s/carga, forma prim', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39121200', 'description' => 'Acetato de celulose,plastificado,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39122010', 'description' => 'Nitrato de celulose,com carga,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39122021', 'description' => 'Nitrato de celulose,s/carga,em alcool,teor n/volat>=65%', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39122029', 'description' => 'Outs.nitratos de celulose,sem carga,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39123111', 'description' => 'Carboximetilcelulose com teor>=75%,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39123119', 'description' => 'Outros carboximetilceluloses em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39123121', 'description' => 'Sais de carboximetilcelulose,teor>=75%,em formas primar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39123129', 'description' => 'Outs.sais de carboximetilcelulose,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39123910', 'description' => 'Metil-,etil- e propilcelulose,hidroxiladas,forma primar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39123920', 'description' => 'Outros metilceluloses,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39123930', 'description' => 'Outros etilceluloses,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39123990', 'description' => 'Outros eteres de celulose,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39129010', 'description' => 'Propionato de celulose,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39129020', 'description' => 'Acetobutirato de celulose,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39129031', 'description' => 'Celulose microcristalina,em po', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39129039', 'description' => 'Celulose microcristalina,em outs.formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39129040', 'description' => 'Outros celuloses,em po', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39129090', 'description' => 'Outs.celuloses e derivs.quimicos,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39131000', 'description' => 'Acido alginico,seus sais e esteres,em forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39139011', 'description' => 'Borracha clorada ou cloridratada,em pedacos,grumos,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39139012', 'description' => 'Borracha clorada em outs.formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39139019', 'description' => 'Outs.derivs.quims.da borracha natural,em formas primars', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39139020', 'description' => 'Goma xantana,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39139030', 'description' => 'Dextrana em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '39139040', 'description' => 'Proteinas endurecidas em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39139050', 'description' => 'Quitosan,seus sais ou derivados,em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39139060', 'description' => 'Sulfato de condroitina e seus sais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39139090', 'description' => 'Outs.polimeros naturais,incl.modifs.em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39140011', 'description' => 'Permutad.de ions,base copolim.estireno-divinilbenz.etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39140019', 'description' => 'Outs.permutad.de ions,a base poliestireno/seus copolim.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39140090', 'description' => 'Permutad.de ions,a base de outs.polim.em formas primars', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39151000', 'description' => 'Desperdicios,residuos e aparas,de polimeros de etileno', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39152000', 'description' => 'Desperdicios,residuos e aparas,de polimeros de estireno', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39153000', 'description' => 'Desperdicios,residuos,etc.de polim.de cloreto de vinila', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39159000', 'description' => 'Desperdicios,residuos e aparas,de outs. plasticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39161000', 'description' => 'Monofilamentos (monofios),etc.de polimeros de etileno', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39162000', 'description' => 'Monofilamentos (monofios),etc.de polim. cloreto vinila', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39162000', 'description' => 'Forros de policloreto de vinil  PVC  utilizados na construção civil', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39169010', 'description' => 'Monofilamentos (monofios),de outs.plasticos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39169090', 'description' => 'Varas,bastoes e perfis,de outs.plasticos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39171010', 'description' => 'Tripas artificiais de proteinas endurecidas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39171021', 'description' => 'Tripas artifs.fibrosas,de celulose regenerada.d>=150mm', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39171029', 'description' => 'Tripas artificiais de outs.plasticos celulosicos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39172100', 'description' => 'Tubo rigido,de polimeros de etileno', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39172200', 'description' => 'Tubo rigido,de polimeros de propileno', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39172300', 'description' => 'Tubo rigido,de polimeros de cloreto de vinila', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39172900', 'description' => 'Tubo rigido,de outs.plasticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173100', 'description' => 'Tubo flexivel,de plastico,p/suportar pressao>=27.6 mpa', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173210', 'description' => 'Tubo de copolimeros de etileno,n/reforcado, s/acessorios', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173221', 'description' => 'Tubo capilar semipermeav.de polipropileno, p/hemodialise', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173229', 'description' => 'Outs.tubos de polipropileno,n/reforcados,sem acessorios', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173230', 'description' => 'Tubo de tereftalato de polietileno, n/reforcado,s/acess.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173240', 'description' => 'Tubo de silicones,nao reforcado,sem acessorios', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173251', 'description' => 'Tubo capilar semipermeav.celulose regener. p/hemodialise', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173259', 'description' => 'Outs.tubos de celulose regenerada, n/reforcados, s/acess.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173290', 'description' => 'Outs.tubos de plasticos,nao reforcados,sem acessorios', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173300', 'description' => 'Tubo de plastico,nao reforcado,com acessorios', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39173900', 'description' => 'Outros tubos de plasticos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39174010', 'description' => 'Acessórios (para tubos) dos tipos utilizados em linhas de sangue para hemodiálise', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39174090', 'description' => 'Outs acessórios (para tubos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39181000', 'description' => 'Revestim.de pavimentos,etc.de polimer.de cloreto vinila', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39189000', 'description' => 'Revestim.de pavimentos/paredes/tetos,de outs.plasticos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39191010', 'description' => 'Chapas,fls.etc.auto-adesivas,de plasticos, de polipropileno', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39191020', 'description' => 'Chapas,fls.etc.auto-adesivas,de plasticos, de poli(cloreto de vinila)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39191090', 'description' => 'Chapas,fls.etc.auto-adesivas,de plasticos, outras', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39199010', 'description' => 'Outs.chapas,folhas,tiras,etc.auto-adesivas,de plasticos, de polipropileno', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39199020', 'description' => 'Outs.chapas,folhas,tiras,etc.auto-adesivas,de plasticos, de poli(cloreto de vinila)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39199090', 'description' => 'Outs.chapas,folhas,tiras,etc.auto-adesivas,de plasticos, outras', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39201010', 'description' => 'Chapas, etc, de polímero de etileno de densidade >= 0,94 (...)', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39201091', 'description' => 'De densidade inferior a 0,94g/cm3, com óleo de parafina e carga (sílica e negro-de-carbono), apresentando nervuras paralelas entre si, com uma resistência elétrica, segundo norma jis c 2313-90, superior ou igual a 0,059ohms.cm2 mas inferior ou igual a 0,0', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39201099', 'description' => 'Outs chapas (...) de polimero depropileno', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39202011', 'description' => 'Chapas,etc.polim.propileno,biax.orient.metaliz.s/suport', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39202012', 'description' => 'Outs.chapas,etc.polim.propileno,biax.orient.s/suporte, de largura <= 50cm e espessura <= 25 microns (...) norma astm d 3755-97), em rolos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39202019', 'description' => 'Outs.chapas,etc.polim.propileno,biax.orient.s/suporte', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39202019', 'description' => 'Substrato de polipropileno biaxialmente orientado, recoberto em ambas as faces da folha por camadas de tinta opacificante que propiciam receber as impressões ofsete seco, calcográfica, tipográfica e vernizes de proteção com cura a ultravioleta', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39202090', 'description' => 'Outs.chapas,etc.polim.propileno,s/suporte,n/reforc.etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39203000', 'description' => 'Chapas,etc.de polimeros estireno,s/suporte, n/reforc.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '39203000', 'description' => 'De polímeros de estireno', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39204310', 'description' => 'Chapas,etc.policloreto vinila,flexiv.transpar. s/suporte', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39204390', 'description' => 'Outs chapas,etc.de polim.cloreto vinila, c/conteudo deplastificante >=6% empeso', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39204900', 'description' => 'Outschapas,etc.de polim.cloreto vinila', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39204900', 'description' => 'Laminados rígidos de policloreto de vinil  PVC  utilizados para revestimento de móveis', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39205100', 'description' => 'Chapas,etc.polimetacrilato metila,s/suport. n/reforc.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39205900', 'description' => 'Outs.chapas,etc.polimeros acrilicos,s/suporte, n/reforc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39206100', 'description' => 'Chapas,etc.de policarbonatos,s/suporte, n/reforcadas,etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39206211', 'description' => 'Chapas,etc.tereftalato polieteno,e<5 micr.s/suporte,etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39206219', 'description' => 'Outs.chapas,etc.tereft.polietileno,e<=40 micr.s/suporte', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39206291', 'description' => 'Chapas,etc.tereftalato polietileno,l>12cm, s/suporte,etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39206299', 'description' => 'Outs.chapas,etc.tereftalato polietileno, s/suporte,etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39206299', 'description' => 'Laminados de politereftalato de etileno  PET  para revestimento', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39206300', 'description' => 'Chapas,etc.de poliesteres n/saturad. s/suporte, n/reforc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39206900', 'description' => 'Chapas,etc.de outs.poliesteres,s/suporte, n/reforcad.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39207100', 'description' => 'Chapas,etc.de celulose regener.s/suporte, n/reforcad.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39207310', 'description' => 'Chapas,etc.acetato celulose,e<=0.75mm,s/suport. n/reforc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39207390', 'description' => 'Outs.chapas,etc.de acetato celulose,s/suporte, n/reforc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39207910', 'description' => 'Chapas,etc.de fibra vulcaniz.e<=1mm,s/suporte, n/reforc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39207990', 'description' => 'Chapas,etc.de outs.derivs.celulose,s/suporte, n/reforc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209100', 'description' => 'Chapas,etc.butiral polivinila,s/suporte, n/reforcad.etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209200', 'description' => 'Chapas,etc.de poliamidas,s/suporte, n/reforcadas, etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209300', 'description' => 'Chapas,etc.de resinas aminicas,s/suporte, n/reforcad.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209400', 'description' => 'Chapas,etc.de resinas fenolicas,s/suporte, n/reforc.etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209910', 'description' => 'Chapas,etc.de silicones,s/suporte, n/reforcadas,etc.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209920', 'description' => 'Chapas,etc.de alcool polivinilico,s/suport. n/reforc.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209930', 'description' => 'Chapas,etc.polim.fluoreto vinila,s/suporte, n/reforc.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209940', 'description' => 'Chapas, etc de poliimida', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209950', 'description' => 'Outs.chapas,etc.de outs.plasticos,n/alveol. s/suport.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39209990', 'description' => 'Outs.chapas,etc.de outs.plasticos,n/alveol. s/suport.etc', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39211100', 'description' => 'Outs.chapas,etc.de polimeros de estireno, alveolares', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39211200', 'description' => 'Outs.chapas,etc.de polimer.de cloreto vinila, alveolares', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39211310', 'description' => 'Outs.chapas,etc.de polester, 24<=poros<=157, 3,5<=pka<=4', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39211390', 'description' => 'Outs.chapas,etc.de poliuretanos,alveolares', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39211400', 'description' => 'Outs.chapas,etc.de celulose regenerada,alveolares', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39211900', 'description' => 'Outros chapas,etc.de outs.plasticos,alveolares', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39219011', 'description' => 'Chapas,etc.de resina melamina-formaldeido, estratificads', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39219012', 'description' => 'Outs.chapas,etc.de polietileno, com reforço de napas de fibras de polietileno paralelizadas, superpostas entre si em ângulo de 90º e impregnadas com resinas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39219013', 'description' => 'De copolímeros de tetrafluoretileno reforçadas com tecido de fibras politetrafluoretileno, do tipo utilizado como membranas semipermeáveis em células de eletrólise', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39219019', 'description' => 'Outs.chapas,etc.de outs.plasticos,estratificadas c/suporte ou reforco', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39219020', 'description' => 'Outs.chapas,etc.de poli(tereftalato de etileno), com camada antiestática à base de gelatina ou de látex em ambas as faces, mesmo com halogenetos de potássio', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39219090', 'description' => 'Outs.chapas,folhas,peliculas,tiras,laminas,de plasticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39221000', 'description' => 'Banheiras,banheiras p/duchas,pias e lavatorios, de plasticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39222000', 'description' => 'Assentos e tampas de sanitarios,de plasticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39229000', 'description' => 'Outs.artigos p/usos sanitarios/higienicos,de plasticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39231010', 'description' => 'Estojos de plastico,p/acondic.disco leit.raio laser', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39231090', 'description' => 'Outs.artigos semelh.caixas,engradados,etc.de plastico', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39232110', 'description' => 'Sacos,bolsas,cartuchos,de polim.de etileno, cap<=1000cm3', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39232190', 'description' => 'Outs.sacos,bolsas e cartuchos,de polimeros de etileno', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39232910', 'description' => 'Sacos,bolsas e cartuchos,de outs.plasticos, cap<=1000cm3', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39232990', 'description' => 'Outros sacos,bolsas e cartuchos,de outs.plasticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39233000', 'description' => 'Garrafoes,garrafas,frascos,artigos semelhs.de plasticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39233000', 'description' => 'Esboços de garrafas de plástico, fechados em uma extremidade e com a outra aberta e munida de uma rosca sobre a qual irá adaptar-se uma tampa roscada, devendo a parte abaixo da rosca ser transformada, posteriormente, para se obter a dimensão e for', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '39234000', 'description' => 'Bobinas,carreteis e suportes semelhantes,de plasticos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39235000', 'description' => 'Rolhas,tampas,etc.p/fechar recipientes,de plasticos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39239000', 'description' => 'Outs.artigos de transporte ou de embalagem,de plasticos', 'aliquota_federal' => 9.29, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39241000', 'description' => 'Servicos de mesa/outs.artigos mesa/cozinha,de plasticos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39249000', 'description' => 'Outs.artigos de higiene ou de toucador,de plastico', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39251000', 'description' => 'Reservatorios,cisternas,cubas,etc.de plasticos,cap>300l', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 12.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39252000', 'description' => 'Portas,janelas,seus caixilhos,alizares,etc.de plasticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39253000', 'description' => 'Postigos,estores,artigos semelhs.e partes,de plasticos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39259010', 'description' => 'Outras obras de plastico de poliestireno expandido eps', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39259090', 'description' => 'Outras obras de plastico', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39261000', 'description' => 'Artigos de escritorio e artigos escolares,de plasticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39262000', 'description' => 'Vestuario e seus acessorios, de plasticos, incl.luvas', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39262000', 'description' => 'Cintos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39263000', 'description' => 'Guarnicoes p/moveis,carrocarias e semelhs.de plasticos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39264000', 'description' => 'Estatuetas e outs.objetos de ornamentacao,de plasticos', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269010', 'description' => 'Arruelas (anilhas) de plasticos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269021', 'description' => 'Correias de transmissao,de plasticos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269022', 'description' => 'Correias transportadoras,de plasticos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269030', 'description' => 'Bolsas para uso em medicina (hemodiálise e usos semelhantes)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269040', 'description' => 'Artigos de laboratorio ou de farmacia,de plasticos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269040', 'description' => 'Exclusivamente de laboratório de análises clínicas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269050', 'description' => 'Acessórios dos tipo utilizados em linhas de sangue para hemodiálise, tais omo obturadores, clipes e semelhantes', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269061', 'description' => 'Anéis de seção transversal circular (“o-rings”) de tetrafluoroetileno e éter perfluorometilvinil', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269069', 'description' => 'Anéis de seção transversal circular (“o-rings”). outras', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Outros obras de plasticos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Forma para fabricação de calçados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Máscara de proteção', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Revestimento para canais de irrigação, de PVC flexível ou semelhante, com ilhoses para fixação no solo', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Cinto, colete, bóia e equipamento semelhante de salvamento', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Brincos e pulseiras para identificação de animais', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Cabos para ferramentas, utensílios e aparelhos', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Parafusos e porcas', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Recipiente com serpentina e depósito para gelo, próprio para gelar bebidas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Leques e ventarolas', 'aliquota_federal' => 20.87, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Bolsas para coleta de sangue e seus componentes e bolsas de diálise peritoneal  infusão e drenagem ', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '39269090', 'description' => 'Kits para aferese', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40011000', 'description' => 'Latex de borracha natural,mesmo pre-vulcanizado', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40012100', 'description' => 'Borracha natural em folhas fumadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40012200', 'description' => 'Borracha natural tecnicam.especif.(tsnr),em outs.formas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40012910', 'description' => 'Borracha natural crepada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40012920', 'description' => 'Borracha natural granulada ou prensada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40012990', 'description' => 'Borracha natural em outras formas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40013000', 'description' => 'Balata,guta-percha,chicle e gomas naturais analogas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40021110', 'description' => 'Latex de borracha de estireno-butadieno (sbr)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40021120', 'description' => 'Latex de borracha de estireno-butadieno-carboxilada', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40021911', 'description' => 'Borracha de estireno-butadieno,em chapas,folhas,tiras', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40021912', 'description' => 'Borracha de estireno-butadieno,grau alim.forma primaria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40021919', 'description' => 'Borracha de estireno-butadieno,em outs.formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40021920', 'description' => 'Borracha de estireno-butadieno-carboxilad.em chapas,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40022010', 'description' => 'Oleo de borracha de butadieno (br)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40022090', 'description' => 'Borracha de butadieno (br),em chapas,folhas,tiras,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40023100', 'description' => 'Borracha de isobuteno-isopreno (butila),em chapas,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40023900', 'description' => 'Borracha de isobuteno-isopreno halogenada,em chapas,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '40024100', 'description' => 'Latex de borracha de cloropreno (clorobutadieno)(cr)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40024900', 'description' => 'Borracha de cloropreno (clorobutadieno),em chapas,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40025100', 'description' => 'Latex de borracha de acrilonitrila-butadieno (nbr)', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40025900', 'description' => 'Borracha de acrilonitrila-butadieno em chapas,fls.etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40026000', 'description' => 'Borracha de isopreno (ir) em chapas,folhas,tiras,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40027000', 'description' => 'Borracha de etileno-propileno-dieno n/conjug.em chapas,', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40028000', 'description' => 'Misturas de borracha natural com borracha sintetica,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40029100', 'description' => 'Latex de outs.borrachas sinteticas ou artificiais', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40029910', 'description' => 'Borracha estireno-isopreno-estireno em chapas,fls.etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40029920', 'description' => 'Borracha etileno-propileno-dieno n/conjugado-propil.etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40029930', 'description' => 'Borracha acrilonitrila-butadieno hidrogenada', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40029990', 'description' => 'Outs.borrachas sinteticas e artificiais,em chapas,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40030000', 'description' => 'Borracha regenerada,em formas primarias ou chapas,etc.', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40040000', 'description' => 'Desperdicios,residuos,etc.de borracha nao endurecida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40051010', 'description' => 'Borracha etileno-propileno-dieno,etc.c/silica,granulos', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40051090', 'description' => 'Outs.borrachas vulcan.c/negro fumo/silica,em chapas,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40052000', 'description' => 'Borracha misturada,n/vulcanizada,em solucoes,dispersoes', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40059110', 'description' => 'Prepars.base borracha,p/fabr.gomas mascar,em chapas,etc', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40059190', 'description' => 'Outs.borrachas misturadas,n/vulcan.em chapas,fls.tiras', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40059910', 'description' => 'Prepars.base borracha,p/fabr.gomas mascar,formas primar', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40059990', 'description' => 'Outs.borrachas misturadas,n/vulcan.em formas primarias', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40061000', 'description' => 'Perfis para recauchutagem,de borracha nao vulcanizada', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40069000', 'description' => 'Outs.formas e artigos,de borracha nao vulcanizada', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40070011', 'description' => 'Fios recobertos com silicone, (...) (de borracha vulcanizada)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40070019', 'description' => 'Outros (fios de borracha vulcanizada)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40070020', 'description' => 'Cordas (de borracha vulcanizada)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40081100', 'description' => 'Chapas,folhas,etc.de borracha vulcan.alveolar n/endurec', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40081900', 'description' => 'Varetas e perfis,de borracha vulcan.alveolar n/endurec.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40082100', 'description' => 'Chapas,folhas,etc.de borracha vulcan.n/alveol.n/endurec', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40082100', 'description' => 'Remendo e manchão, com superfície recoberta de produtos autovulcanizantes a frio e protegidos por papel, plástico ou outra matéria', 'aliquota_federal' => 8.96, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40082900', 'description' => 'Varetas e perfis de borracha vulcan.n/alveol.n/endurec.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40091100', 'description' => 'Tubo de borracha vulcan.n/endurec.n/reforcado, s/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40091210', 'description' => 'Tubo de borracha vulcan.n/endurec.n/reforcado, c/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40091290', 'description' => 'Outs tubo de borracha vulcan.n/endurec.n/reforcado, c/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40092110', 'description' => 'Tubo de borracha vulc.n/endur.c/metal, s/acess.p<17.3mpa', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40092190', 'description' => 'Outs.tubos de borracha vulcan.n/endur.c/metal, s/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40092210', 'description' => 'Tubos de borracha vulcan.n/endur.c/metal, c/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40092290', 'description' => 'Outs tubos de borracha vulcan.n/endur.c/metal, c/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40093100', 'description' => 'Tubo de borracha vulcan.n/endur.c/mater.textil, s/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40093210', 'description' => 'Tubo de borracha vulcan.n/endur.c/mater.textil, c/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40093290', 'description' => 'Outs tubo de borracha vulcan.n/endur.c/mater. textil, c/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40094100', 'description' => 'Tubo de borracha vulcan.n/endur.c/out.materias, s/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40094210', 'description' => 'Tubo de borracha vulcan.n/endur.c/out. materias,/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40094290', 'description' => 'Outs tubo de borracha vulcan.n/endur.c/out. materias, c/acess.', 'aliquota_federal' => 16.04, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40101100', 'description' => 'Correia transportad.de borracha vulcan. reforcada metal', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40101200', 'description' => 'Correia transportad.de borracha vulcan. reforc.mat.text.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40101900', 'description' => 'Outs.correias transportadoras,de borracha vulcanizada', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40103100', 'description' => 'Correia transm.s/fim,trapez.6dm<c<=18dm, borracha vulcan, estriada', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40103200', 'description' => 'Correia transm.s/fim,trapez.6dm<c<=18dm, borracha vulcan,não estriada', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40103300', 'description' => 'Correia transm.s/fim,trapez.18<c<=24dm, borracha vulcan.,estriada', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40103400', 'description' => 'Correia transm.s/fim,trapez.18<c<=24dm, borracha vulcan., não estriada', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40103500', 'description' => 'Correia transm.s/fim,sincron.6<c<=15dm, borracha vulcan.', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40103600', 'description' => 'Correia transm.s/fim,sincr.150<c<=198cm, borracha vulcan', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '40103900', 'description' => 'Outs.correias de transmissao,de borracha vulcanizada', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40111000', 'description' => 'Pneumaticos novos de borracha,p/automoveis de passag.', 'aliquota_federal' => 20.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40112010', 'description' => 'Pneumat.novos de borracha,p/onibus, caminhoes,m=11,00-24', 'aliquota_federal' => 14.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40112090', 'description' => 'Outs.pneumaticos novos de borracha,p/onibus e caminhoes', 'aliquota_federal' => 14.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40113000', 'description' => 'Pneumaticos novos de borracha,para avioes', 'aliquota_federal' => 13.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40114000', 'description' => 'Pneumaticos novos de borracha,para motocicletas', 'aliquota_federal' => 16.71, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40115000', 'description' => 'Pneumaticos novos de borracha,para bicicletas', 'aliquota_federal' => 26.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40117010', 'description' => 'Nas seguintes medidas: 4,00 15, 4,00 18, 4,00 19, 5,00 15, 5,00 16, 5,50 16, 6,00 16, 6,00 19, 6,00 20, 6,50 16, 6,50 20, 7,50 16, 7,50 18, 7,50 20', 'aliquota_federal' => 20.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40117010', 'description' => 'Nas seguintes medidas: 4,00 15, 4,00 18, 4,00 19, 5,00 15, 5,00 16, 5,50 16, 6,00 16, 6,00 19, 6,00 20, 6,50 16, 6,50 20, 7,50 16, 7,50 18, 7,50 20', 'aliquota_federal' => 14.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40117090', 'description' => 'Outros', 'aliquota_federal' => 20.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40117090', 'description' => 'Outros', 'aliquota_federal' => 14.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40118010', 'description' => 'Radiais, para dumpers concebidos para serem utilizados fora de rodovias, com secao de largura igual ou superior a 940 mm (37), para aros de diametro igual ou superior a 1448 mm (57)', 'aliquota_federal' => 20.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40118020', 'description' => 'Outros, com secao de largura igual ou superior a 1143 mm (45), para aros de diametro igual ou superior a 1143 mm (45)', 'aliquota_federal' => 20.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40118090', 'description' => 'Outros', 'aliquota_federal' => 20.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40119010', 'description' => 'Com secao de largura igual ou superior a 1143 mm (45), para aros de diametro igual ou superior a 1143 mm (45)', 'aliquota_federal' => 20.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40119090', 'description' => 'Outros', 'aliquota_federal' => 20.08, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40121100', 'description' => 'Pneumaticos recauchutados,de borracha p/ automoveis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40121100', 'description' => 'Remoldados', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40121200', 'description' => 'Pneumaticos recauchutados,de borrachap/ onibus e caminhoes', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40121200', 'description' => 'Remoldados', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40121300', 'description' => 'Pneumaticos recauchutados,de borracha,p/ veiculos aereos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40121900', 'description' => 'Outspneumaticos recauchutados,de borracha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40121900', 'description' => 'Remoldados, exceto para máquinas e tratores agrícolas', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40121900', 'description' => 'Remoldados, para máquinas e tratores agrícolas', 'aliquota_federal' => 6.16, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40122000', 'description' => 'Pneumaticos usados,de borracha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40129010', 'description' => 'Flaps para pneumaticos,de borracha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40129090', 'description' => 'Protetores/bandas rodagem,etc.p/pneumaticos,de borracha', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40131010', 'description' => 'Camaras-de-ar borracha,p/pneumat.onibus,etc. m=11,00-24', 'aliquota_federal' => 15.41, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40131090', 'description' => 'Outs.camaras-de-ar borracha,p/pneumats. automoveis, etc.', 'aliquota_federal' => 26.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40131090', 'description' => 'Dos tipos utilizados em ônibus ou caminhões', 'aliquota_federal' => 15.41, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40132000', 'description' => 'Camaras-de-ar de borracha,para bicicletas', 'aliquota_federal' => 26.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40139000', 'description' => 'Outros camaras-de-ar de borracha', 'aliquota_federal' => 26.49, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40139000', 'description' => 'Dos tipos utilizados em colheitadeiras ou tratores agrícolas', 'aliquota_federal' => 15.41, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40141000', 'description' => 'Preservativos de borracha vulcanizada,nao endurecida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 7.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40149010', 'description' => 'Bolsas p/gelo/agua quente,de borracha vulcan.n/endurec.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40149090', 'description' => 'Outs.artigos de higiene,etc.de borracha vulcan.n/endur.', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40151100', 'description' => 'Luvas p/cirurgia,de borracha vulcanizada, n/endurecida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40151900', 'description' => 'Outs.luvas de borracha vulcanizada,nao endurecida', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40151900', 'description' => 'De segurança e proteção', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40159000', 'description' => 'Outs.vestuarios e acessorios,de borracha vulcan.n/endur', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40159000', 'description' => 'Vestuário de segurança e proteção, mesmo com seus acessórios', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40161010', 'description' => 'Partes de automovs.etc.borracha vulcan.alveol. n/endur.', 'aliquota_federal' => 17.80, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40161090', 'description' => 'Outs.obras de borracha vulcanizada alveolar n/endurec.', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169100', 'description' => 'Revestim.p/pavimentos,etc.de borracha vulcan.n/endurec.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169200', 'description' => 'Borrachas de apagar', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169300', 'description' => 'Juntas,gaxetas,semelhs.de borracha vulcan.n/endurecida', 'aliquota_federal' => 6.31, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169400', 'description' => 'Defensas p/atracar embarcacoes,borracha vulcan.n/endur.', 'aliquota_federal' => 11.61, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169510', 'description' => 'Artigos inflav.de salvamento,de borracha vulcan.n/endur', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169590', 'description' => 'Outs.artigos inflaveis,de borracha vulcan.n/endurecida', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169910', 'description' => 'Tampoes vedadores p/capacitor,de epdm,c/perf. p/terminal', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169990', 'description' => 'Outs.obras de borracha vulcanizada,nao endurecida', 'aliquota_federal' => 6.79, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169990', 'description' => 'Sapatas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169990', 'description' => 'Partes dos produtos das posições 8608, 8710 e 8713', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '40169990', 'description' => 'Tapetes próprios para ônibus ou caminhões', 'aliquota_federal' => 13.95, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169990', 'description' => 'Viras para calçados', 'aliquota_federal' => 5.01, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40169990', 'description' => 'Tapetes próprios para veículos automóveis, exceto ônibus ou caminhões', 'aliquota_federal' => 15.67, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40170000', 'description' => 'Borracha endurecida e obras de borracha endurecida', 'aliquota_federal' => 19.45, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40170000', 'description' => 'Placas de borracha endurecida com encaixes de sobreposição, obtidas pela trituração de sucata de pneumáticos', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40170000', 'description' => 'Estrado de borracha endurecida, obtido pela trituração de sucata de pneumáticos', 'aliquota_federal' => 8.05, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '40170000', 'description' => 'Borracha endurecida sob quaisquer formas, incluídos os desperdícios e resíduos', 'aliquota_federal' => 17.24, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41012000', 'description' => 'Couros e peles em bruto, inteiros, não divididos, de peso unitário não superior a 8 kg quando secos, a 10 kg quando salgados a seco e a 16 kg quando frescos, salgados a úmido ou conservados de outro modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41015010', 'description' => 'Couros e peles em bruto,de bovino,inteiras,qdo secas,etc> 16kg,etc. sem dividir', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41015020', 'description' => 'Couros e peles em bruto,de bovino,inteiras,qdo secas, etc>16kg, etc., divididos com a flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41015030', 'description' => 'Couros e peles em bruto,de bovino,inteiras,qdo secas,etc>16kg,etc., divididos sem a flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41019010', 'description' => 'Outs couros e pele em bruto,de bovino, (dorsos), n/dividida, fresca,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41019020', 'description' => 'Outs couros e pele em bruto,de bovino (dorso),divid. c/flor, fresca,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41019030', 'description' => 'Outs ouros e pele em bruto,de bovino (dorso),divid.s/flor, fresca,etc', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41021000', 'description' => 'Peles em bruto,de ovinos,com la', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41022100', 'description' => 'Peles em bruto,de ovinos,picladas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41022900', 'description' => 'Outs.peles em bruto,de ovinos,depiladas ou sem la', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41032000', 'description' => 'Peles em bruto,de repteis', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41033000', 'description' => 'Peles em bruto,de suinos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41039000', 'description' => 'Peles em bruto,de outs.animais', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041111', 'description' => 'Couro/pele inteira,de bovino,s<=2.6m2,wet blue,n/divid.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041112', 'description' => 'Outs couro/pele inteira,de bovino,s<=2.6m2,wet blue,n/divid.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041113', 'description' => 'Outs couro/pele inteira,de bovino,s<=2.6m2,wet blue, com pre-curtimenta vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041114', 'description' => 'Outs couro/pele,inteiro/meio,de bovino (incluidos os búfalos),wet blue, plena flor, não divid', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041119', 'description' => 'Outs couro/pele,inteiro/meio,de outs animais,wet blue, plena flor, não divid', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041121', 'description' => 'Couro/pele inteir.bovina,s<=2.6m2,wet blue,divid.c/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041122', 'description' => 'Outs couro/pele inteir.bovina,s<=2.6m2,wet blue,divid.c/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041123', 'description' => 'Outs couro/pele inteir.bovina,s<=2.6m2,wet blue, com pre-curtimenta vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041124', 'description' => 'Couro/pele,inteiro/meio,de bovino (incluidos os bufalos), wet blue,divid.c/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041129', 'description' => 'Couro/pele inteir.outs animais,s<=2.6m2,wet blue,divid.c/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041910', 'description' => 'Couro/pele inteir.bovina,s<=2.6m2,wet blue,divid.s/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041920', 'description' => 'Outs couro/pele inteir.bovina,s<=2.6m2,wet blue,divid.s/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041930', 'description' => 'Couros e peles,de bovinos,com pre-curtimenta vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041940', 'description' => 'Outs couro/pele,inteiro/meio,de bovino (incluidos os búfalos),wet blue,divid.s/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41041990', 'description' => 'Couros/peles,equideos,umidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41044110', 'description' => 'Couro/pele inteira,de bovino,s<=2.6m2,box-calf, plena flor, n/dividido, dividido c/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41044120', 'description' => 'Couro/pele bovina,curt.ao veg.p/solas,plena flor,s/acab', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41044130', 'description' => 'Outs.couros/peles bovinas,prepar.curt.plena flor,s/acab', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41044190', 'description' => 'Outs couro/pele inteira,de bovino,s<=2.6m2,box-calf', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41044910', 'description' => 'Outs couro/pele inteira,de bovino,s<=2.6m2,box-calf, plena flor, n/dividido, dividido c/flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41044920', 'description' => 'Outs couro/pele bovina,curt.ao veg.p/solas,plena flor,s/acab', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41044990', 'description' => 'Outs couro/pele inteira,de bovino,s<=2.6m2,box-calf', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41051010', 'description' => 'Peles depiladas,de ovinos,com pre-curtimenta vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41051021', 'description' => 'Peles depiladas,de ovinos,curtid.cromo,umido,wet blue', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41051029', 'description' => 'Peles depiladas,de ovinos,pre-curtidas de out.modo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41051090', 'description' => 'Outs.peles depiladas,de ovinos,curtidas ou recurtidas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41053000', 'description' => 'Peles depiladas,de ovinos,seco,crust', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41062110', 'description' => 'Couros e peles depiladas de caprinos, curtidos ou crust, c/pre-curtimenta vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41062121', 'description' => 'Couros e peles depiladas de caprinos, simplesmente curtidos ao cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41062129', 'description' => 'Outs couros e peles depiladas de caprinos, curtidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41062190', 'description' => 'Outs couros e peles depiladas de caprinos, curtidos ou crust', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41062200', 'description' => 'Couros e peles depiladas de caprinos, no estado seco (crust)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41063110', 'description' => 'Couros e peles depiladas de suinos, simplesmente curtidos ao cromo', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '41063190', 'description' => 'Outs couros e peles depiladas de suinos, no estado umido (incluindo wet blue)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41063200', 'description' => 'Couros e peles depiladas de suinos, no estado seco (crust)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41064000', 'description' => 'Couros e peles depiladas de répteis, desprovidos de pelos,curtidos ou crust', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41069100', 'description' => 'Couros e peles depiladas de ouits animais, desprovidos de pelos,no estado umido (curtidos)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41069200', 'description' => 'Couros e peles depiladas de ouits animais, desprovidos de pelos,no estado seco (crust)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071110', 'description' => 'Couros e peles preparados após curtimenta (...),de bovinos,apergaminhadas, depilados, inteiros,plena flor não divid', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071120', 'description' => 'Outs couros e peles preparados após curtimenta (...),de bovinos,apergaminhadas, depilados, inteiros,plena flor não divid', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071190', 'description' => 'Couros e peles preparados após curtimenta (...),de outs animais, apergaminhadas, depilados, inteiros,plena flor não divid', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071210', 'description' => 'Couros e peles preparados após curtimenta (...),de bovinos, apergaminhadas, depilados, inteiros,divididos c/ a flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071220', 'description' => 'Outs couros e peles preparados após curtimenta (...),de bovinos, apergaminhadas, depilados, inteiros,divididos c/ a flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071290', 'description' => 'Couros e peles preparados após curtimenta (...),de outs animais, apergaminhadas, depilados, inteiros,divididos c/ a flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071910', 'description' => 'Outs couros e peles inteiros  de bovinos preparados após curtimenta ou após secagem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071920', 'description' => 'Outs couros e peles de bovinos preparados após curtimenta ou após secagem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41071990', 'description' => 'Outs couros e peles  preparados após curtimenta ou após secagem', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41079110', 'description' => 'Outs couros e peles preparados após curtimenta (...),de bovinos, apergaminhadas, depilados, inteiros,plena flor não divididos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41079190', 'description' => 'Outs couros e peles preparados após curtimenta (...),apergaminhadas, depilados, inteiros,plena flor não divididos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41079210', 'description' => 'Outs couros e peles preparados após curtimenta (...),de bovinos, apergaminhadas, depilados, inteiros,divididos, c/ a flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41079290', 'description' => 'Outs couros e peles preparados após curtimenta (...),apergaminhadas, depilados, inteiros,divididos, c/ a flor', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41079910', 'description' => 'Outs couros e peles preparados após curtimenta (...),de bovinos, apergaminhadas, depilados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41079990', 'description' => 'Outs couros e peles preparados após curtimenta (...),apergaminhadas, depilados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41120000', 'description' => 'Couros de ovinos preparados após curtimenta ou após secagem, apergamins(curtido ao cromo)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41131010', 'description' => 'Couros de caprinos preparados após curtimenta ou após secagem, apergamins(curtido ao cromo)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41131090', 'description' => 'Outs couros de caprinos preparados após curtimenta ou após secagem, apergamins', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41132000', 'description' => 'Couros de suinos preparados após curtimenta ou após secagem, apergamins(curtido ao cromo)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41133000', 'description' => 'Couros de répteis preparados após curtimenta ou após secagem, apergamins(curtido ao cromo)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41139000', 'description' => 'Couros de outs animais preparados após curtimenta ou após secagem, apergamins (curtido ao cromo)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41141000', 'description' => 'Couros e peles,acamurcados,incl.a camurca combinada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41142010', 'description' => 'Couros e peles,envernizados ou revestidos', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41142020', 'description' => 'Couros e peles,metalizados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41151000', 'description' => 'Couro reconstituido em chapas,folhas ou tiras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '41152000', 'description' => 'Aparas e outs.desperd.de couros/peles, preparados,etc.', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42010010', 'description' => 'Artigos de seleiro/correeiro,de couro natural/ reconstit', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42010090', 'description' => 'Artigos de seleiro/correeiro,de outs.materias', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42021100', 'description' => 'Malas,maletas e pastas,de couro natural/ reconst/envern.', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42021210', 'description' => 'Malas,maletas e pastas,de plastico', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42021220', 'description' => 'Malas,maletas e pastas,de materias texteis', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42021900', 'description' => 'Malas,maletas e pastas,de outs.materias', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42022100', 'description' => 'Bolsas de couro natural,reconstituido ou envernizado', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42022210', 'description' => 'Bolsas de folhas de plastico', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42022220', 'description' => 'Bolsas de materias texteis', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42022900', 'description' => 'Bolsas de outs.materias', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42023100', 'description' => 'Artigos de bolsos/bolsas,de couro natural/reconstit.etc', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42023200', 'description' => 'Artigos de bolsos/bolsas,de fls.de plastico/mat.textil', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42023900', 'description' => 'Artigos de bolsos/bolsas,de outs.materias', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42029100', 'description' => 'Outs.artefatos de couro natural/reconstituido/enverniz.', 'aliquota_federal' => 7.19, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42029200', 'description' => 'Outs.artefatos,de fls.de plastico ou materias texteis', 'aliquota_federal' => 7.19, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42029900', 'description' => 'Outros artefatos,de outs.materias', 'aliquota_federal' => 7.19, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42031000', 'description' => 'Vestuario de couro natural ou reconstituido', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42032100', 'description' => 'Luvas,mitemes,etc.p/esportes,de couro natural/reconstit', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42032900', 'description' => 'Outs.luvas,mitemes,etc.de couro natural/ reconstituido', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42032900', 'description' => 'De proteção, para trabalho manual', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42033000', 'description' => 'Cintos,cinturoes,bandoleiras,etc.de couro nat/reconstit', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42034000', 'description' => 'Outs.acessorios de vestuario,de couro natural/reconstit', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '42050000', 'description' => 'Outros obras de couro natural ou reconstituido', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42060000', 'description' => 'Outs.obras de tripa,baudruches,bexiga ou de tendoes', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '42060000', 'description' => 'Cordas de tripa', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43011000', 'description' => 'Peleteria em bruto,de vison,inteira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43013000', 'description' => 'Peleteria em bruto,de cordeiros astraca,etc.inteira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43016000', 'description' => 'Peleteria em bruto,de raposa,inteira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43018000', 'description' => 'Peleteria em bruto,de outs.animais,inteira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43019000', 'description' => 'Cabecas,caudas,patas,etc.de animais util.na ind.peles', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43021100', 'description' => 'Peleteria curtida/acabada,de vison,inteira, n/reunida', 'aliquota_federal' => 41.70, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43021910', 'description' => 'Peleteria curtida/acabada,de ovinos,inteira, n/reunida', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43021990', 'description' => 'Peleteria curtida/acab.de outs.animais,inteir. n/reunida', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43022000', 'description' => 'Cabecas,caudas,etc.curtidas/acabads.inteiras,n/reunidas', 'aliquota_federal' => 41.70, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43022000', 'description' => 'Cabeças, caudas, patas e outras partes, desperdícios e aparas, de coelho ou de lebre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43022000', 'description' => 'Cabeças, caudas, patas e outras partes, desperdícios e aparas, de bovino, de ovino ou de caprino', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43023000', 'description' => 'Peleteria curtida/acabada,inteira/pedacos, etc.reunidos', 'aliquota_federal' => 41.70, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43023000', 'description' => 'De bovino, ovino, caprino, coelho ou de lebre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43023000', 'description' => 'Peles “alongadas”, exceto de bovino, ovino, caprino, coelho ou de lebre', 'aliquota_federal' => 32.77, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43031000', 'description' => 'Vestuario e seus acessorios,de peleteria', 'aliquota_federal' => 32.77, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43031000', 'description' => 'De bovino, ovino, caprino, coelho ou de lebre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43039000', 'description' => 'Outros artefatos de peleteria', 'aliquota_federal' => 32.77, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43039000', 'description' => 'De bovino, ovino, caprino, coelho ou de lebre', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 25.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '43040000', 'description' => 'Peleteria artificial e suas obras', 'aliquota_federal' => 13.29, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44011100', 'description' => 'De coniferas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44011200', 'description' => 'De nao coniferas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44012100', 'description' => 'Madeira de coniferas,em estilhas ou em particulas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44012200', 'description' => 'Madeira de nao coniferas,em estilhas ou em particulas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44013100', 'description' => 'Pellets de madeira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44013900', 'description' => 'Outras serragens,desperdicios e residuos,de madeira', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44014000', 'description' => 'Serragem (serradura), desperdicios e residuos, de madeira, nao aglomerados', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44021000', 'description' => 'Carvao vegetal de bambu', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44029000', 'description' => 'Outs carvao vegetal', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44031100', 'description' => 'De coniferas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44031100', 'description' => 'De coniferas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44031200', 'description' => 'De nao coniferas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44031200', 'description' => 'De nao coniferas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032100', 'description' => 'De pinheiro (pinus spp), cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032100', 'description' => 'De pinheiro (pinus spp), cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032200', 'description' => 'De pinheiro (pinus spp), outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032200', 'description' => 'De pinheiro (pinus spp), outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032300', 'description' => 'De abeto (abies spp) e de espruce (picea) (picea spp), cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032300', 'description' => 'De abeto (abies spp) e de espruce (picea) (picea spp), cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032400', 'description' => 'De abeto (abies spp) e de espruce (picea) (picea spp), outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032400', 'description' => 'De abeto (abies spp) e de espruce (picea) (picea spp), outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032500', 'description' => 'Outras, cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032500', 'description' => 'Outras, cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032600', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44032600', 'description' => 'Outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44034100', 'description' => 'Madeira de dark ou light red meranti,etc.em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44034100', 'description' => 'Esquadriadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44034900', 'description' => 'Outros madeiras tropicais,em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44034900', 'description' => 'Esquadriadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039100', 'description' => 'Madeira de carvalho (quercus spp),em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039100', 'description' => 'Esquadriada', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
        ];

        DB::table('ncm')->insert($data);

        $data = [['ncm' => '44039300', 'description' => 'De faia (fagus spp), cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039300', 'description' => 'De faia (fagus spp), cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039400', 'description' => 'De faia (fagus spp), outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039400', 'description' => 'De faia (fagus spp), outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039500', 'description' => 'De betula (vidoeiro) (betula spp), cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039500', 'description' => 'De betula (vidoeiro) (betula spp), cuja maior dimensao da secao transversal e igual ou superior a 15 cm', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039600', 'description' => 'De betula (vidoeiro) (betula spp), outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039600', 'description' => 'De betula (vidoeiro) (betula spp), outras', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039700', 'description' => 'De choupo (alamo) (populus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039700', 'description' => 'De choupo (alamo) (populus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039800', 'description' => 'De eucalipto (eucalyptus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039800', 'description' => 'De eucalipto (eucalyptus spp)', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039900', 'description' => 'Outros madeiras em bruto', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44039900', 'description' => 'Esquadriadas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44041000', 'description' => 'Arcos de madeira,estacas fendidas,etc.de coniferas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44042000', 'description' => 'Arcos de madeira,estacas fendidas,etc.de nao coniferas', 'aliquota_federal' => 4.20, 'aliquota_estadual' => 18.00, 'aliquota_municipal' => 0.00],
            ['ncm' => '44050000', 'description' => 'La de madeira 