<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
<link href="resources/css/toastr.css" rel="stylesheet"/>
<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
<link href="resources/css/custom.css" rel="stylesheet"/>
<?php
error_reporting(0);

require_once "functions.php";

if (strstr($_SERVER['SCRIPT_NAME'], "index.php") === false)
{
	redirect("index.php");
	die;
}

permission(59);

?>
<div class="col-md-8 col-md-offset-2" align="center">
	<h2>Orçamentos Agendados</h2>
</div>
<table class="table table-hover table-bordered">
	<thead>
		<th>NÚMERO</th>
		<th>CLIENTE</th>
		<th>INICIADO</th>
		<th>AGENDADO PARA</th>
		<th>STATUS</th>
		<th><center>ALTERAR</center></th>
	</thead>
<tbody>
<?

$res = mssql_query("SELECT * FROM dlv_Config WHERE idDelivery = '".$_SERVER['REMOTE_ADDR']."'");
$arr = mssql_fetch_array($res);

$nrAlertaEntrega = $arr['nrAlertaEntrega'];

$sql = "SELECT A.*, C.stCliente FROM dlv_Atendimentos A ".
	   "INNER JOIN dlv_Clientes C ON A.idCliente = C.idCliente ".
	   "WHERE A.flAgendarPedido = '1' AND A.stStatus NOT IN ('S','E') AND A.flAtivo = '1' AND A.flOrcamento = '1' AND A.dtAgendarPedido < '".date("Y-m-d H:i:s", strtotime("+".$nrAlertaEntrega." hours"))."' ".
	   "ORDER BY A.dtAgendarPedido";

$res = mssql_query($sql);

while ($arr = mssql_fetch_array($res))
{
	$stStatus = "";
	$nrOciosidade = 0;
	$stCor = "#F0F0F0";

	if (!$arr['flAtivo'])
		$stStatus = "EXCLUIDO";
	else
	{
		switch ($arr['stStatus'])
		{
			case "F":
				$stStatus = "FORMULAÇÃO";
				break;
			case "P":
				$stStatus = "PENDENTE";
				break;
			case "S":
				$stStatus = "SAIU PARA ENTREGA";
				break;
			case "E":
				$stStatus = "ENTREGUE";
				break;
		}
	}

	?>
	<tr bgcolor="<?=$stCor?>">
		<td><?=$arr['idAtendimento']?></td>
		<td><?=$arr['stCliente']?></td>
		<td><?=date("d/m/Y H:i", strtotime($arr['dtAbertura']))?> H</td>
		<td><?=date("d/m/Y H:i", strtotime($arr['dtAgendarPedido']))?> H</td>
		<td><?=$stStatus?></td>
		<td align="center">
		<?
		if ($arr['flAtivo'])
		{
			?>
			<a class="btn btn-info btn-sm" href="takeConvertOrcamento.php?id=<?=$arr['idAtendimento']?>" onclick="return confirm('Tem certeza que deseja transformar este orçamento em um pedido?')"><span class="glyphicon glyphicon-refresh" alt="Converter em Pedido"></span></a>
			<?
			if ($arr['stStatus'] == "F")
			{
				?>
				<a class="btn btn-success btn-sm" href="index.php?sec=montarPedido&id=<?=$arr['idAtendimento']?>" onclick="return verifyOperador('<?=$arr['idOperador']?>', '<?=$UID?>', '', '<?=$arr['idAtendimento']?>');"><span class="glyphicon glyphicon-pencil" alt="Editar"></span></a>
				<a class="btn btn-danger btn-sm" href="index.php?sec=removerAtendimento&id=<?=$arr['idAtendimento']?>" onclick="return verifyOperador('<?=$arr['idOperador']?>', '<?=$UID?>', 'Tem certeza que deseja cancelar este pedido?', '<?=$arr['idAtendimento']?>');"><span class="glyphicon glyphicon-remove" alt="Cancelar"></span></a>
				<?
			}
			else
			{
				?>
				<a href="#" onclick="NewWindow('reImprimir.php?id=<?=$arr['idAtendimento']?>','reImprimir','400','200','yes','center'); return false;"><img src="imagens/imprimir.png" alt="RE-IMPRIMIR"></a>
				<?
			}
		}
		?>
		</td>
	</tr>
	<?
}
?>
</tbody>
</table>
<script src="resources/js/jquery-2.1.4.js"></script>
<script src="resources/js/bootstrap.min.js"></script>
<script src="resources/js/datatables.min.js"></script>
<script src="resources/js/toastr.js"></script>
<script src="resources/js/sweetalert2.min.js"></script>
<script src="resources/js/functions.js"></script>
