<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
db_conn();

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'getDocByNota':
		getDocByNota($_POST['texto']);
		break;
		case 'getDocByFornecedor':
		getDocByFornecedor($_POST['texto']);
		break;
		case 'getProdutoNome':
		getProdutoNome($_POST['productText'], $_POST['idOrigem']);
		break;
		case 'getProdutoNumero':
		getProdutoNumero($_POST['productText'], $_POST['idOrigem']);
		break;
		case 'extornarLancamento':
		extornarLancamento($_POST['idMovimentacao']);
		break;
		case 'extornarItensLancamento':
		extornarItensLancamento($_POST['idMovimentacao']);
		break;
		case 'adicionaProduto':
		adicionaProduto($_POST['idProduto'], $_POST['idOrigem'], $_POST['idDestino'], $_POST['idMovimentacao']);
		break;
		case 'popularProduto':
		popularProduto($_POST['texto']);
		break;
		case 'getProdutosNota':
		getProdutosNota($_POST['idMovimentacao']);
		break;
		case 'getDadosNota':
		getDadosNota($_POST['idMovimentacao']);
		break;
	}
}


function getDadosNota($idMovimentacao)
{
	$qry = "SELECT * FROM est_Movimentacoes WHERE idMovimentacao = '$idMovimentacao'";
	$res = mssql_query($qry);
	$arr = mssql_fetch_assoc($res);
	$array['stObs'] = $arr['stObservacao'];
	$array['stNotaFiscal'] = $arr['stNotaFiscal'];
	$array['idOrigem'] = $arr['idOrigem'];
	$array['idDestino'] = $arr['idDestino'];
	$array['idMovimentacao'] = $arr['idMovimentacao'];
	$array['flTipoEstoque'] = $arr['flTipoEstoque'];

	if ($arr['flTipoEstoque'])
	{
		$rs = mssql_query("SELECT stEstoque FROM est_Estoques WHERE idEstoque = '".$arr['idOrigem']."'");
		$ar = mssql_fetch_array($rs);
		$array['stOrigem'] = $ar['stEstoque'];
	}
	else
	{
		$rs = mssql_query("SELECT stNomeFornecedor FROM frn_Fornecedores WHERE idFornecedor = '".$arr['idOrigem']."'");
		$ar = mssql_fetch_array($rs);
		$array['stOrigem'] = $ar['stNomeFornecedor'];
	}

	$rs = mssql_query("SELECT stEstoque FROM est_Estoques WHERE idEstoque = '".$arr['idDestino']."'");
	$ar = mssql_fetch_array($rs);
	$array['stDestino'] = $ar['stEstoque'];

	$array['dtMovimentacao'] = date("d/m/Y H:i", strtotime($arr['dtMovimentacao']));

	echo json_encode($array);
}

function getDocByNota($texto)
{
	$qry = "SELECT * FROM est_Movimentacoes WHERE stNotaFiscal like '%".$texto."%' AND idAbertura = '0' ORDER BY dtData DESC";
	
	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
		$rows[] = $arr;
	}

	echo json_encode($rows);
}

function getDocByFornecedor($texto)
{
	$qry = "SELECT M.*, F.stNomeFornecedor FROM est_Movimentacoes M
	INNER JOIN frn_Fornecedores F ON M.idOrigem = F.idFornecedor
	WHERE F.stNomeFornecedor like '%".$texto."%' AND M.idAbertura = '0' AND M.flTipoEstoque = '0'
	ORDER BY M.dtData DESC";
	
	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
		$rows[] = $arr;
	}

	echo json_encode($rows);
}

function getProdutoNome($productText, $idOrigem)
{
	$idOrigem = preg_replace('/\D/', '', $idOrigem);
	$res = mssql_query("SELECT p.idProduto, p.stProduto FROM prd_Produtos p INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto WHERE p.stProduto like '%".$productText."%' AND flControlarEstoque = '1' ORDER BY c.idCodigo");
	while($arr = mssql_fetch_assoc($res))
	{
		$rs = mssql_query("SELECT COUNT(*) FROM frn_FichaFornecedor WHERE idProduto = '".$arr['idProduto']."' AND idFornecedor = '$idOrigem'");
		$ar = mssql_fetch_array($rs);
		$rows[] = $arr;
	}
	if(count($rows) > 0){
		echo json_encode($rows);
	}else{
		echo retornaJson(false, "Nenhum produto encontrado");
	}
}

function getProdutoNumero($productText, $idOrigem)
{
	$idOrigem = preg_replace('/\D/', '', $idOrigem);
	$res = mssql_query("SELECT p.idProduto, p.stProduto FROM prd_Produtos p INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto WHERE c.idCodigo like '%".$productText."%' AND flControlarEstoque = '1' ORDER BY c.idCodigo");
	while($arr = mssql_fetch_assoc($res))
	{
		$rs = mssql_query("SELECT COUNT(*) FROM frn_FichaFornecedor WHERE idProduto = '".$arr['idProduto']."' AND idFornecedor = '$idFornecedor'");
		$ar = mssql_fetch_array($rs);
		if($ar[0]<1){
			$rows[] = $arr;
		}
	}
	if(count($rows) > 0){
		echo json_encode($rows);
	}else{
		echo retornaJson(false, "Nenhum produto encontrado");
	}
}

function adicionaProduto($idProduto, $idOrigem, $idDestino, $idMovimentacao)
{

	$rs = mssql_query("SELECT p.idProduto,p.idCategoria, p.stProduto, p.vrCusto, p.vrUnitario, m.stMedida, m.flFracionado, c.idCodigo, e.stSetor FROM prd_Produtos p 
		INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
		INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
		INNER JOIN prd_Setores e ON p.idSetor = e.idSetor
		WHERE p.idProduto = '$idProduto'");
	$product = mssql_fetch_assoc($rs);
	$custo = $product['vrCusto'];
	$medida = $product['stMedida'];
	if ($product['nrFatorConversao']) {
		$conv = $product['nrFatorConversao'];
	}else{
		$conv = '1';
	}

	$res = mssql_query("SELECT MAX(idItem) FROM est_ItensMovimentacao");
	$arr = mssql_fetch_array($res);
	$idItem = $arr[0] + 1;


	$st ="SELECT flTipoEstoque FROM est_Movimentacoes WHERE idMovimentacao = '$idMovimentacao' AND idAbertura = '0'";

	$res = mssql_query($st);
	$arr = mssql_fetch_array($res);
	$arr = json_encode($arr);
	$flTipoEstoque = $arr[5];

	$product['nrQuantidadeAtual'] = 'N/A';
	$res = mssql_query("SELECT * FROM frn_FichaFornecedor WHERE idProduto = '$idProduto' AND idFornecedor = '$idOrigem'");
	$exists = mssql_num_rows($res);
	if($exists == 0){
		$qry = "INSERT INTO frn_FichaFornecedor (idFornecedor, idProduto, idCategoria) VALUES ('$idOrigem', '$idProduto', '".$product['idCategoria']."')";
		echo $qry;
		mssql_query($qry);
	}

	$st = "INSERT INTO est_ItensMovimentacao (idItem, idMovimentacao, idProduto, nrQuantidade, vrValor, stMedidaConversao, nrQuantidadeConversao)
	VALUES ('$idItem', '$idMovimentacao', '$idProduto', '1', '$custo', '$medida', '$conv')";
	$rs = mssql_query($st);

	$product['stMedidaConversao'] = $medida;
	$product['nrQuantidadeConversao'] = $conv;
	$product['nrQuantidade'] = 1;

	$product['nrQtd1'] = "N/A";
	$product['nrQtd2'] = "N/A";

	if ($product['flFracionado'] > 0) {
		$product['nrQuantidade'] = number_format($product['nrQuantidade'], 3, "", "");
	}

	echo json_encode($product);
}

function popularProduto($texto){
	if(ctype_digit($texto)){
		$qry =	"SELECT TOP 15 p.stProduto, p.idProduto, c.idCodigo FROM prd_Produtos p INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto WHERE c.idCodigo LIKE '".$texto."%' AND flControlarEstoque = '1' AND flAtivo = '1'";
	}else{
		$qry = "SELECT TOP 15 p.stProduto, p.idProduto, c.idCodigo FROM prd_Produtos p INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto WHERE stProduto LIKE '".$texto."%' AND flControlarEstoque = '1' AND flAtivo = '1'";
	}
	$res = mssql_query($qry);
	while($arr = mssql_fetch_assoc($res))
	{
		$arr['stProduto'] = utf8_encode($arr['stProduto']);
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function getProdutosNota($idMovimentacao)
{
	$res = mssql_query("SELECT * FROM est_Movimentacoes WHERE idMovimentacao = '$idMovimentacao'");
	$arr = mssql_fetch_array($res);
	$idOrigem = $arr['idOrigem'];
	$idDestino = $arr['idDestino'];

	$qry = "SELECT p.idProduto, p.stProduto, MIN(c.idCodigo) as idCodigo, s.nrQtd1, t.nrQtd2, m.flFracionado, m.stMedida, e.stSetor, p.vrCusto
	FROM prd_Produtos p
	INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
	INNER JOIN prd_Setores e ON p.idSetor = e.idSetor
	LEFT JOIN prd_Codigos c ON p.idProduto = c.idProduto
	LEFT JOIN(SELECT idProduto, nrQuantidade as nrQtd1 FROM est_Saldos WHERE idEstoque = '$idOrigem') s ON p.idProduto = s.idProduto
	LEFT JOIN(SELECT idProduto, nrQuantidade as nrQtd2 FROM est_Saldos WHERE idEstoque = '$idDestino') t ON p.idProduto = t.idProduto
	WHERE p.flControlarEstoque = '1'
	GROUP BY p.idProduto, p.stProduto, s.nrQtd1, t.nrQtd2, m.flFracionado, m.stMedida, e.stSetor, p.vrCusto
	ORDER BY e.stSetor, p.stProduto";
	
	$res = mssql_query($qry);

	while($arr = mssql_fetch_assoc($res)){
		$_qry = "SELECT * FROM est_ItensMovimentacao WHERE idProduto = '".$arr['idProduto']."' AND idMovimentacao = '$idMovimentacao' AND idAbertura = '0'";
		$_res = mssql_query($_qry);
		if (mssql_num_rows($_res) > 0) {
			$_arr = mssql_fetch_assoc($_res);
			$_arr['dtAlteracao'] = date("d/m/Y H:i", strtotime($_arr['dtAlteracao']));
			if($arr['flFracionado'] > 0){
				$_arr['nrQuantidade'] = number_format($_arr['nrQuantidade'], 3, "", "");
			}
			if($arr['nrQtd2'] == ""){
				$arr['nrQtd2'] = "N/A";
			}
			if($arr['nrQtd1'] == ""){
				$arr['nrQtd1'] = "N/A";
			}
			if (!$arr['idCodigo']) {
				$arr['idCodigo'] = 'INATIVO';
			}
			$_arr['stProduto'] = $arr['stProduto'];
			$_arr['idCodigo'] = $arr['idCodigo'];
			$_arr['flFracionado'] = $arr['flFracionado'];
			$_arr['nrQtd1'] = $arr['nrQtd1'];
			$_arr['nrQtd2'] = $arr['nrQtd2'];
			$_arr['stMedida'] = $arr['stMedida'];
			$_arr['stSetor'] = $arr['stSetor'];

			$rows[] = $_arr; 
		}
	}
	echo json_encode($rows);

}
?>