<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
require_once "../../../database/models/CxCaixaLoginClose.class.php";
db_conn();

$cx_Itens = "cx_FichaRecebimentos";
$cx_Vendas = "cx_Itens";
$cx_FichaPagamentos = "cx_Vendas";

if (isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'initFechamento':
            initFechamento();
            break;
        case 'initCaixa':
            initCaixa();
            break;
        case 'deleteAbertura':
            deleteAbertura($_POST['idAbertura']);
            break;
        case 'reabrirCaixa':
            reabrirCaixa($_POST['idAbertura']);
            break;
        case 'getCaixa':
            getCaixa($_POST['idAbertura']);
            break;
        case 'getVezesFechamentoCaixa':
            getVezesFechamentoCaixa($_POST['idOperador'], $_POST['idCaixa'], $_POST['dtAbertura']);
            break;
        case 'getSangria':
            getSangria($_POST['idAbertura']);
            break;
        case 'getSuprimento':
            getSuprimento($_POST['idAbertura']);
            break;
        case 'getIndustria':
            getIndustria($_POST['idAbertura']);
            break;
        case 'getDespesas':
            getDespesas($_POST['idAbertura']);
            break;
        case 'getContaAssinada':
            getContaAssinada($_POST['idAbertura']);
            break;
        case 'getDepositosConta':
            getDepositosConta($_POST['idAbertura']);
            break;
        case 'getRepique':
            getRepique($_POST['idAbertura']);
            break;
        case 'getCancelamento':
            getCancelamento($_POST['idAbertura']);
            break;
        case 'getTotalVendas':
            getTotalVendas($_POST['idAbertura']);
            break;
        case 'getDetalheVenda':
            getDetalheVenda($_POST['idAbertura'], $_POST['idVenda']);
            break;
        case 'getDescontoDetalheVenda':
            getDescontoDetalheVenda($_POST['idAbertura'], $_POST['idVenda']);
            break;
        case 'getDescontos':
            getDescontos($_POST['idAbertura']);
            break;
        case 'getCVale':
            getCVale($_POST['idAbertura']);
            break;
        case 'getVoucher':
            getVoucher($_POST['idAbertura'], $_POST['flLiquidado']);
            break;
        case 'getVendasCaixa':
            getVendasCaixa($_POST['idAbertura']);
            break;
        case 'getFormaPagamento':
            getFormaPagamento($_POST['idAbertura'], $_POST['idFormaPagamento']);
            break;
        case 'getCaixaNoDia':
            getCaixaNoDia($_POST['idOperador'], $_POST['idCaixa'], $_POST['dtAbertura']);
            break;
        case 'popularFormaPagamento':
            popularFormaPagamento();
            break;
        case 'alterarFormaPagamento':
            alterarFormaPagamento($_POST['idAbertura'], $_POST['idFormaPagamento'], $_POST['idFormaPagamentoOld'], $_POST['idFicha'], $_POST['idVenda']);
            break;
        case 'salvarFechamento':
            salvarFechamento($_POST['vrTrocoEncerramento'], $_POST['idAbertura'], $_POST['vrFechamento'], strtoupper($_POST['stOBS']), $_POST['chkAbrirRelatorio'], $_POST['vrApurado'], $_POST['vrDiferenca'], $_POST['detalhesPagamento']);
            break;
        case 'getDadosTodosCaixas':
            getDadosTodosCaixas();
            break;
        case 'getDadosCaixa':
            getDadosCaixa($_POST['idAbertura']);
            break;
        case 'excluirVenda':
            excluirVenda($_POST['idAbertura'], $_POST['idVenda']);
            break;
        case 'getTurnos':
            getTurnos();
            break;
        case 'cadastraTurno':
            cadastraTurno($_POST['stDesc'], $_POST['hrInicio'], $_POST['hrFim']);
            break;
        case 'editarTurno':
            editarTurno($_POST['idTurno'], $_POST['stDesc'], $_POST['hrInicio'], $_POST['hrFim']);
            break;
        case 'deleteTurno':
            deleteTurno($_POST['idTurno']);
            break;
        case 'getTurnoById':
            getTurnoById($_POST['idTurno']);
            break;
        case 'getDepositosDinheiro':
            getDepositosDinheiro($_POST['idAbertura']);
            break;
    }
}

function getDepositosDinheiro($idAbertura)
{
    $qry = "select COALESCE(SUM(vrPagamento),0) from cli_Pagamento cp
		inner join cx_FormasPagamento fp on fp.idFormaPagamento = cp.idFormaPagamento
		inner join cx_TiposFormaPagamento tfp on fp.idTipo = tfp.idTipoForma
		where cp.idAbertura = ' $idAbertura ' and fp.idTipo = 1";

    $res = mssql_query($qry);
    $arr = mssql_fetch_row($res);

    echo json_encode(['valor' => $arr[0]]);

}

function initFechamento()
{
    $autorization = autorization(113);
    echo $autorization;
}

function initCaixa()
{
    $qry = "SELECT COUNT(*) FROM cx_Gerenciador WHERE flAberto = '1'";
    $arr = mssql_fetch_array(mssql_query($qry));
    $count = $arr[0];
    $aberturasPegas = "AND g.idAbertura NOT IN (";
    $qryTurnos = "SELECT * FROM cx_turnosCaixas ORDER BY hrInicio";
    $resTurnos = mssql_query($qryTurnos);
    if ($count > 0) {
        if (mssql_num_rows($resTurnos) > 0) {
            while ($arrTurnos = mssql_fetch_assoc($resTurnos)) {
                $time = "BETWEEN '" . $arrTurnos['hrInicio'] . "' AND '" . $arrTurnos['hrFim'] . "'";
                $qry = "SELECT g.idAbertura, g.idCaixa, o.stApelido, g.dtAbertura, COALESCE(SUM(c.vrFormaPagamento),0) as vrPagamento FROM cx_Gerenciador g
				INNER JOIN op_Operadores o ON g.idOperador = o.idOperador
				INNER JOIN cx_FichaRecebimentos_Temp c ON g.idAbertura = c.idAbertura
				WHERE g.flAberto = '1' AND c.flAtivo = '1' AND CAST(g.dtAbertura as time) " . $time . "
				GROUP BY g.idAbertura, g.idCaixa, g.dtAbertura, o.stApelido ORDER BY g.dtAbertura";
                $res = mssql_query($qry);
                while ($arr = mssql_fetch_assoc($res)) {
                    $aberturasPegas .= $arr['idAbertura'] . ', ';
                    $arr['dtAbertura'] = date("d/m/Y", strtotime($arr['dtAbertura']));
                    $arr['descTurno'] = $arrTurnos['stDescricao'];
                    $rows['caixas'][] = $arr;
                }
            }
            $rows['numTurnos'] = mssql_num_rows($resTurnos);
            $aberturasPegas .= '0)';
            $qry = "SELECT g.idAbertura, g.idCaixa, o.stApelido, g.dtAbertura, COALESCE(SUM(c.vrFormaPagamento),0) as vrPagamento FROM cx_Gerenciador g
			INNER JOIN op_Operadores o ON g.idOperador = o.idOperador
			INNER JOIN cx_FichaRecebimentos_Temp c ON g.idAbertura = c.idAbertura
			WHERE g.flAberto = '1' AND c.flAtivo = '1' " . $aberturasPegas . "
			GROUP BY g.idAbertura, g.idCaixa, g.dtAbertura, o.stApelido ORDER BY g.dtAbertura";
            $res = mssql_query($qry);
            if (mssql_num_rows($res)) {
                $rows['numTurnos'] = $rows['numTurnos'] + 1;
            }
            while ($arr = mssql_fetch_assoc($res)) {
                $arr['dtAbertura'] = date("d/m/Y", strtotime($arr['dtAbertura']));
                $arr['descTurno'] = 'SEM TURNO';
                $rows['caixas'][] = $arr;
            }
        } else {
            $qry = "SELECT g.idAbertura, g.idCaixa, o.stApelido, g.dtAbertura, COALESCE(SUM(c.vrFormaPagamento), 0) as vrPagamento FROM cx_Gerenciador g
			INNER JOIN op_Operadores o ON g.idOperador = o.idOperador
			INNER JOIN cx_FichaRecebimentos_Temp c ON g.idAbertura = c.idAbertura
			WHERE g.flAberto = '1' AND c.flAtivo = '1'
			GROUP BY g.idAbertura, g.idCaixa, g.dtAbertura, o.stApelido ORDER BY g.dtAbertura";
            $res = mssql_query($qry);
            while ($arr = mssql_fetch_assoc($res)) {
                $arr['dtAbertura'] = date("d/m/Y", strtotime($arr['dtAbertura']));
                $rows['Unico'][] = $arr;
            }
        }
        echo json_encode($rows);
    } else {
        echo 'null';
    }
}

function deleteAbertura($idAbertura)
{
    mssql_query("DELETE FROM cx_Gerenciador WHERE idAbertura = '$idAbertura'") or $trans = false;
    mssql_query("DELETE FROM cx_Vendas_Temp WHERE idAbertura = '$idAbertura'");
    mssql_query("DELETE FROM cx_Itens_temp WHERE idAbertura = '$idAbertura'");
    mssql_query("DELETE FROM cx_FichaRecebimentos_temp WHERE idAbertura = '$idAbertura'");

    if (!$trans) {
        insertLog("FECHAMENTO", "ABERTURA [$idAbertura] EXCLUIDA.");
        echo retornaJson(true, "Caixa excluido com sucesso!<br><br>Redirecionando...", '?sec=presidente&sub=fechamento', 1000);
    } else {
        echo retornaJson(false, "Erro ao excluir caixa");
    }
}


function reabrirCaixa($idAbertura)
{
    $res = mssql_query("
        select * from cx_Gerenciador where idcaixa = (select idCaixa from cx_gerenciador where idabertura = '$idAbertura')
        and flAberto = 1
    ");
    $res = mssql_fetch_assoc($res);
    if($res['idAbertura']) {
        echo retornaJson(false, "Já existe um movimento aberto com esse número de caixa");
        return;
    }

    mssql_query("UPDATE cx_Gerenciador SET flAberto = '1' WHERE idAbertura = '$idAbertura'") or $trans = false;

    if (!$trans) {
        insertLog("FECHAMENTO", "ABERTURA [$idAbertura] REABERTA.");
        echo retornaJson(true, "Caixa re-aberto com sucesso!<br><br>Redirecionando...", '?sec=presidente&sub=fechamento', 1000);
    } else {
        echo retornaJson(false, "Erro ao re-abrir caixa");
    }
}

function getCaixa($idAbertura)
{
    $res = mssql_query("SELECT * FROM cx_Vendas_Temp WHERE idAbertura = '$idAbertura'");
    $cnt = mssql_num_rows($res);
    if ($cnt != 0) {
        $cx_Ficha = "cx_FichaRecebimentos_Temp";
        $cx_Itens = "cx_Itens_Temp";
        $cx_Vendas = "cx_Vendas_Temp";
    } else {
        $cx_Ficha = "cx_FichaPagamentos";
        $cx_Itens = "cx_Itens";
        $cx_Vendas = "cx_Vendas";
    }

    $qry = "SELECT * FROM cx_Gerenciador g

	WHERE idAbertura = '$idAbertura'";
    $res = mssql_query($qry);
    $arr = mssql_fetch_assoc($res);
    $count = count($arr);


    if (count($arr) > 0) {

        $arr['dtAbertura'] = date("d/m/Y H:i", strtotime($arr['dtAbertura']));
        $arr['dtFechamento'] = date("d/m/Y H:i", strtotime($arr['dtFechamento']));


        $res = mssql_query("SELECT COALESCE(SUM(vrSangria),0) as vrSangria FROM cx_Sangrias WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrSangria > '0'");
        $sangria = mssql_fetch_array($res);
        $arr['vrSangria'] = number_format($sangria['vrSangria'], 2, ".", "");

        $res = mssql_query("SELECT COALESCE(SUM(vrSangria),0) as vrSangria FROM cx_Sangrias WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrSangria < '0'");
        $suprimento = mssql_fetch_array($res);
        $arr['vrSuprimento'] = number_format(($suprimento['vrSangria'] * (-1)), 2, ".", "");

        $res = mssql_query("SELECT COALESCE(SUM(vrRepique),0) as vrRepique FROM cx_Repique WHERE flAtivo = '1' AND idAbertura = '$idAbertura'");
        $repique = mssql_fetch_array($res);
        $arr['vrRepique'] = number_format($repique['vrRepique'], 2, ".", "");

        $res = mssql_query("SELECT COALESCE(SUM(d.vrDespesa),0) as vrDespesa,f.stFormaPagamento,d.idFormaPagamento FROM cx_Despesas d
			inner join cx_FormasPagamento f on d.idFormaPagamento = f.idFormaPagamento
			WHERE d.flAtivo = '1' AND d.idAbertura = $idAbertura
			group by f.stFormaPagamento,d.idFormaPagamento");
        $arrDesp = mssql_fetch_array($res);
        $arr['vrDespesa'] = number_format($arrDesp['vrDespesa'], 2, ".", "");


        $res = mssql_query("SELECT COUNT(*) FROM " . $cx_Vendas . " WHERE idAbertura = '$idAbertura' AND flAtivo = '1'");
        $clientes = mssql_fetch_array($res);
        $arr['totalVendas'] = $clientes[0];

        $res = mssql_query("SELECT nrClientes FROM cx_Gerenciador WHERE idAbertura = '$idAbertura'");
        $nrClientes = mssql_fetch_array($res);
        $arr['nrClientes'] = $nrClientes['nrClientes'];

        $res = mssql_query("SELECT COALESCE(SUM(vrTotal),0) as vrTotal " .
            "FROM cli_Extrato " .
            "WHERE idAbertura = '$idAbertura' AND flAtivo = '1'");
        $contas = mssql_fetch_array($res);
        $arr['vrContaAssinada'] = number_format($contas['vrTotal'], 2, ".", "");

        $res = mssql_query("SELECT COALESCE(SUM(vrPagamento),0) as vrPagamento FROM cli_Pagamento WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrPagamento > 0");

        $depContas = mssql_fetch_array($res);
        $arr['vrDepContas'] = number_format($depContas['vrPagamento'], 2, ".", "");

        $res = mssql_query("SELECT COALESCE(SUM(vrPagamento),0) as vrPagamento FROM cli_Pagamento WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrPagamento < 0");
        $EstornoDepContas = mssql_fetch_array($res);
        $arr['vrEstorno'] = number_format($EstornoDepContas['vrPagamento'], 2, ".", "");

        $res = mssql_query("SELECT SUM(p.vrFormaPagamento) as FormaPagamento " .
            "FROM cx_FormasPagamento f " .
            "INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma " .
            "INNER JOIN " . $cx_Ficha . " p ON f.idFormaPagamento = p.idFormaPagamento " .
            "WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '6'");
        $cValesEmitidos = mssql_fetch_array($res);
        $arr['vrCValesEmitidos'] = number_format(($cValesEmitidos['FormaPagamento'] * (-1)), 2, ".", "");

        $res = mssql_query("SELECT SUM(p.vrFormaPagamento) as FormaPagamento " .
            "FROM cx_FormasPagamento f " .
            "INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma " .
            "INNER JOIN " . $cx_Ficha . " p ON f.idFormaPagamento = p.idFormaPagamento " .
            "WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '7'");
        $cValesRecebidos = mssql_fetch_array($res);
        $arr['cValesRecebidos'] = number_format($cValesRecebidos['FormaPagamento'], 2, ".", "");

        $res = mssql_query("SELECT SUM(p.vrFormaPagamento) as FormaPagamento " .
            "FROM cx_FormasPagamento f " .
            "INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma " .
            "INNER JOIN " . $cx_Ficha . " p ON f.idFormaPagamento = p.idFormaPagamento " .
            "WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '20'");
        $vouchers = mssql_fetch_array($res);
        $arr['vouchers'] = number_format($vouchers['FormaPagamento'], 2, ".", "");

        $res = mssql_query("SELECT COALESCE(SUM(vrVaucher),0) as vrVaucher FROM cx_vaucher WHERE flAtivo = '1' AND idAbertura = '$idAbertura' ");

        $vouchersEmitidos = mssql_fetch_array($res);
        $arr['vouchersEmitidos'] = number_format($vouchersEmitidos['vrVaucher'], 2, ".", "");

        $res = mssql_query("SELECT SUM(p.vrFormaPagamento) as FormaPagamento " .
            "FROM cx_FormasPagamento f " .
            "INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma " .
            "INNER JOIN " . $cx_Ficha . " p ON f.idFormaPagamento = p.idFormaPagamento " .
            "WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '17'");
        $cValesRecebidosDG = mssql_fetch_array($res);
        $arr['cValesRecebidosDG'] = number_format($cValesRecebidosDG['FormaPagamento'], 2, ".", "");

        $res = mssql_query("SELECT SUM(p.vrFormaPagamento) as FormaPagamento " .
            "FROM cx_FormasPagamento f " .
            "INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma " .
            "INNER JOIN " . $cx_Ficha . " p ON f.idFormaPagamento = p.idFormaPagamento " .
            "WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '17'");
        $cValesEmitidosDG = mssql_fetch_array($res);
        $arr['cValesEmitidosDG'] = number_format($cValesEmitidosDG['FormaPagamento'], 2, ".", "");

        //Taxa de serviço
        $res = mssql_query("SELECT COALESCE(SUM(vrDesconto),0) as vrDesconto, COALESCE(SUM(vrAcrescimo),0) as vrAcrescimo FROM " . $cx_Vendas . " WHERE flAtivo = '1' AND idAbertura = '$idAbertura'");
        $resp = mssql_fetch_array($res);
        $arr['vrDesconto'] = $resp['vrDesconto'];
        $arr['vrAcrescimo'] = $resp['vrAcrescimo'];


        //Taxa de entrega
        $res = mssql_query("SELECT COALESCE(SUM(vrDesconto),0) as vrtaxaEntrega FROM " . $cx_Vendas . " WHERE flAtivo = '1' AND flDelivery = '1' AND idAbertura = '$idAbertura'");
        $vrTaxaEntrega = mssql_fetch_array($res);
        $arr['vrTaxaEntrega'] = number_format($vrTaxaEntrega['vrTaxaEntrega'], 2, ".", "");

        $res = mssql_query("SELECT COUNT(*) FROM " . $cx_Itens . " WHERE flAtivo = '0' AND idAbertura = '$idAbertura'");
        $ItensExcluidos = mssql_fetch_array($res);
        $arr['itensExcluidos'] = $ItensExcluidos[0];

        echo json_encode($arr);
    } else {
        echo retornaJson(false, "Nenhum caixa encontrado");
    }
}

function getVezesFechamentoCaixa($idOperador, $idCaixa, $dtAbertura)
{
    $objCaixa = new CxCaixaLoginClose();
    $dtAbertura = str_replace("/", "-", $dtAbertura);
    $vezesAbertas = $objCaixa->getNumRows($idOperador, $idCaixa, date('Y-m-d ', strtotime($dtAbertura)));
    echo retornaJson(true, $vezesAbertas);
}

function getSangria($idAbertura)
{
    if ($idAbertura == 0) {
        $qry = "SELECT s.dtData, s.vrSangria, p.stApelido, f.stFormaPagamento FROM cx_Sangrias s
		INNER JOIN op_Operadores p ON s.idOperadorAutorizador = p.idOperador
		INNER JOIN cx_FormasPagamento f ON s.idFormaPagamento = f.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND g.flAberto = '1' AND s.vrSangria > '0'";
    } else {
        $qry = "SELECT s.dtData, s.vrSangria, p.stApelido, f.stFormaPagamento FROM cx_Sangrias s
		INNER JOIN op_Operadores p ON s.idOperadorAutorizador = p.idOperador
		INNER JOIN cx_FormasPagamento f ON s.idFormaPagamento = f.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND s.idAbertura = '$idAbertura' AND s.vrSangria > '0'";
    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['vrSangria'] = number_format($arr['vrSangria'], 2, ".", "");
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getSuprimento($idAbertura)
{
    if ($idAbertura == 0) {
        $qry = "SELECT s.dtData, s.vrSangria, p.stApelido, f.stFormaPagamento FROM cx_Sangrias s
		INNER JOIN op_Operadores p ON s.idOperadorAutorizador = p.idOperador
		INNER JOIN cx_FormasPagamento f ON s.idFormaPagamento = f.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND g.flAberto = '1' AND s.vrSangria < '0'";
    } else {
        $qry = "SELECT s.dtData, s.vrSangria, p.stApelido, f.stFormaPagamento FROM cx_Sangrias s
		INNER JOIN op_Operadores p ON s.idOperadorAutorizador = p.idOperador
		INNER JOIN cx_FormasPagamento f ON s.idFormaPagamento = f.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND s.idAbertura = '$idAbertura' AND s.vrSangria < '0'";
    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['vrSangria'] = number_format($arr['vrSangria'] * (-1), 2, ".", "");
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getDespesas($idAbertura)
{
    if ($idAbertura == 0) {
        $qry = "SELECT cd.dtData, cd.vrDespesa, fp.stFormaPagamento, cd.stDescricao  FROM cx_Despesas cd
		INNER JOIN cx_FormasPagamento fp ON cd.idFormaPagamento = fp.idFormaPagamento
		INNER JOIN cx_Gerenciador gr ON cd.idAbertura = gr.idAbertura
		WHERE cd.flAtivo = '1' AND gr.flAberto = '1'";
    } else {
        $qry = "SELECT cd.dtData, cd.vrDespesa, fp.stFormaPagamento, cd.stDescricao  FROM cx_Despesas cd
		INNER JOIN cx_FormasPagamento fp ON cd.idFormaPagamento = fp.idFormaPagamento
		INNER JOIN cx_Gerenciador gr ON cd.idAbertura = gr.idAbertura
		WHERE cd.flAtivo = '1' AND cd.idAbertura = '$idAbertura'";
    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['vrDespesa'] = number_format($arr['vrDespesa'], 2, ".", "");
        $arr['stDescricao'] = utf8_encode($arr['stDescricao']);
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getContaAssinada($idAbertura)
{
    if ($idAbertura == 0) {
        $qry = "SELECT E.*, C.stCliente FROM cli_Extrato E
		INNER JOIN dlv_Clientes C ON E.idCliente = C.idCliente
		INNER JOIN cx_Gerenciador G ON G.idAbertura = E.idAbertura
		WHERE G.flAberto = '1' AND E.flAtivo = '1'";
    } else {
        $qry = "SELECT E.*, C.stCliente FROM cli_Extrato E
		INNER JOIN dlv_Clientes C ON E.idCliente = C.idCliente
		WHERE E.idAbertura = '$idAbertura' AND E.flAtivo = '1'";
    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {

        $arr['vrDescontoFinal'] = number_format($arr['vrDesconto'], 2, ".", "");
        $arr['vrQuitadoFinal'] = number_format($arr['vrQuitado'], 2, ".", "");
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['stCliente'] = utf8_encode($arr['stCliente']);
        if ($idAbertura == 0) {
            $sqlChild = "SELECT E.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, E.vrDesconto, E.vrQuitado, E.vrAcrescimo, I.vrTotal
			FROM cli_Extrato E
			INNER JOIN cli_ItemExtrato I ON E.idExtrato = I.idExtrato AND E.idAbertura = I.idAbertura
			INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
			INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
			INNER JOIN cx_Gerenciador G ON G.idAbertura = E.idAbertura
			WHERE G.flAberto = '1' AND I.flAtivo = '1' AND E.idExtrato = '" . $arr['idExtrato'] . "' AND E.idAbertura = '" . $arr['idAbertura'] . "'";
        } else {
            $sqlChild = "SELECT E.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, E.vrDesconto, E.vrQuitado, E.vrAcrescimo, I.vrTotal
			FROM cli_Extrato E
			INNER JOIN cli_ItemExtrato I ON E.idExtrato = I.idExtrato AND E.idAbertura = I.idAbertura
			INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
			INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
			WHERE E.idAbertura = '$idAbertura' AND I.flAtivo = '1' AND E.idExtrato = '" . $arr['idExtrato'] . "'";
        }
        $rs = mssql_query($sqlChild);
        while ($ar = mssql_fetch_assoc($rs)) {

            $ar['dtData'] = date("d/m/Y H:i", strtotime($ar['dtData']));
            $ar['stProduto'] = utf8_encode($ar['stProduto']);
            $ar['stMedida'] = utf8_encode($ar['stMedida']);
            if ($ar['flFracionado']) {
                $ar['nrQuantidade'] = number_format(($ar['nrQuantidade'] / 1000), 3, ".", "");
            } else {
                $ar['nrQuantidade'] = intval($ar['nrQuantidade']);
            }

            $ar['vrQuitado'] = number_format($ar['vrQuitado'], 2, ".", "");
            $ar['vrDesconto'] = number_format($ar['vrDesconto'] * (-1), 2, ".", "");
            $ar['vrTotal'] = number_format($ar['vrTotal'], 2, ".", "");
            $childs[] = $ar;

        }
        $arr['childs'] = $childs;
        $rows[] = $arr;
        unset($childs);
    }
    echo json_encode($rows);
}

function getDepositosConta($idAbertura)
{
    if ($idAbertura == 0) {
        $qry = "SELECT DISTINCT f.idFormaPagamento, f.stFormaPagamento FROM cx_Gerenciador g
		INNER JOIN cli_Pagamento p ON g.idAbertura = p.idAbertura
		INNER JOIN dlv_Clientes c ON p.idCliente = c.idCliente
		INNER JOIN cx_FormasPagamento f ON p.idFormaPagamento = f.idFormaPagamento
		WHERE g.flAberto = '1' AND g.flAberto = '1' AND p.flAtivo = '1' AND p.vrPagamento > 0";
    } else {
        $qry = "SELECT p.dtData, p.vrPagamento, c.stCliente, f.stFormaPagamento FROM cx_Gerenciador g
		INNER JOIN cli_Pagamento p ON g.idAbertura = p.idAbertura
		INNER JOIN dlv_Clientes c ON p.idCliente = c.idCliente
		INNER JOIN cx_FormasPagamento f ON p.idFormaPagamento = f.idFormaPagamento
		WHERE g.idAbertura = '$idAbertura' AND p.flAtivo = '1' AND p.vrPagamento > 0 ";
    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['vrPagamento'] = number_format($arr['vrPagamento'], 2, ".", "");
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getRepique($idAbertura)
{
    if ($idAbertura == 0) {
        $qry = "SELECT s.dtData, s.vrRepique, p.stApelido, f.stFormaPagamento FROM cx_Repique s
		INNER JOIN op_Operadores p ON s.idOperadorAutorizador = p.idOperador
		INNER JOIN cx_FormasPagamento f ON s.idFormaPagamento = f.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND g.flAberto = '1'";
    } else {
        $qry = "SELECT s.dtData, s.vrRepique, p.stApelido, f.stFormaPagamento FROM cx_Repique s
		INNER JOIN op_Operadores p ON s.idOperadorAutorizador = p.idOperador
		INNER JOIN cx_FormasPagamento f ON s.idFormaPagamento = f.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND s.idAbertura = '$idAbertura'";
    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['vrRepique'] = number_format($arr['vrRepique'], 2, ".", "");
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getIndustria($idAbertura)
{
    if ($idAbertura == 0) {
        $qry = "SELECT p.stProduto, m.stMedida, m.flFracionado, SUM(i.vrTotal) AS vrTotal, SUM(i.nrQuantidade) AS nrQuantidade, MAX(v.dtData) AS dtData
		FROM cx_Gerenciador g
		INNER JOIN cx_Vendas_Temp v ON g.idAbertura = v.idAbertura
		INNER JOIN cx_Itens_Temp i ON i.idAbertura = v.idAbertura AND i.idVenda = v.idVenda
		INNER JOIN cx_FichaRecebimentos_Temp fi ON fi.idAbertura = v.idAbertura AND fi.idVenda = v.idVenda
		INNER JOIN cx_FormasPagamento fp ON fi.idFormaPagamento = fp.idFormaPagamento
		INNER JOIN prd_Produtos p ON p.idProduto = i.idProduto
		INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
		WHERE fp.idTipo = '9' AND g.flAberto = '1' AND fi.flAtivo = '1'
		GROUP BY p.stProduto, m.stMedida, m.flFracionado, i.idVenda, v.idAbertura
		ORDER BY i.idVenda, v.idAbertura";
    } else {
        $qry = "SELECT p.stProduto, m.stMedida, m.flFracionado, SUM(i.vrTotal) AS vrTotal, SUM(i.nrQuantidade) AS nrQuantidade, MAX(v.dtData) AS dtData
		FROM cx_Gerenciador g
		INNER JOIN cx_Vendas_Temp v ON g.idAbertura = v.idAbertura
		INNER JOIN cx_Itens_Temp i ON i.idAbertura = v.idAbertura AND i.idVenda = v.idVenda
		INNER JOIN cx_FichaRecebimentos_Temp fi ON fi.idAbertura = v.idAbertura AND fi.idVenda = v.idVenda
		INNER JOIN cx_FormasPagamento fp ON fi.idFormaPagamento = fp.idFormaPagamento
		INNER JOIN prd_Produtos p ON p.idProduto = i.idProduto
		INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida
		WHERE g.idAbertura = '$idAbertura' AND fp.idTipo = '9' AND fi.flAtivo = '1'
		GROUP BY p.stProduto, m.stMedida, m.flFracionado, i.idVenda, v.idAbertura
		ORDER BY i.idVenda, v.idAbertura";
    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        if ($arr['flFracionado']) {
            $arr['nrQuantidade'] = number_format(($arr['nrQuantidade'] / 1000), 3, ".", "");
        }
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getCancelamento($idAbertura)
{
    $qry = "SELECT I.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, I.vrTotal, O.stApelido FROM cx_Itens_Temp I
	INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
	INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
	LEFT JOIN op_Operadores O ON I.idOperadorAutorizador = O.idOperador
	WHERE I.flAtivo = '0' AND I.idAbertura = '$idAbertura'
	ORDER BY I.dtData DESC";

    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['stProduto'] = utf8_encode($arr['stProduto']);
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        if ($arr['flFracionado']) {
            $arr['nrQuantidade'] = number_format(($arr['nrQuantidade'] / 1000), 3, ".", "");
        } else {
            $arr['nrQuantidade'] = intval($arr['nrQuantidade']);
        }
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getTotalVendas($idAbertura)
{
    if ($idAbertura == 0) {
        $qry = "SELECT idCliente, v.idVenda, v.idAbertura, v.dtData, (v.vrTotal - v.vrDesconto + v.vrAcrescimo) as vrTotal
		FROM cx_Gerenciador g
		INNER JOIN cx_Vendas_Temp v ON g.idAbertura = v.idAbertura
		WHERE g.flAberto = '1' AND v.flAtivo = '1'";
    } else {
        $qry = "SELECT idCliente, idVenda, idAbertura, dtData, (vrTotal - vrDesconto + vrAcrescimo) as vrTotal FROM cx_Vendas_Temp
		WHERE idAbertura = '$idAbertura' AND flAtivo = '1' ORDER BY idVenda";
    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['vrTotal'] = number_format($arr['vrTotal'], 2, ".", "");
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getDetalheVenda($idAbertura, $idVenda)
{
    $sql = mssql_query("SELECT I.idCodProduto, I.idProduto, P.stProduto, M.stMedida, M.flFracionado, I.nrQuantidade, (I.vrTotal - I.vrDesconto) as vrTotal, stAtendente " .
        "FROM cx_Itens_Temp I " .
        "INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto " .
        "INNER JOIN prd_Medidas M ON M.idMedida = P.idMedida " .
        "WHERE I.idAbertura = '$idAbertura' AND I.idVenda = '$idVenda' AND I.flAtivo = '1'");
    while ($arr = mssql_fetch_assoc($sql)) {

        if ($arr['flFracionado']) {
            $arr['nrQuantidade'] = number_format(($arr['nrQuantidade'] / 1000), 3, ".", "");
        } else {
            $arr['nrQuantidade'] = intval($arr['nrQuantidade']);
        }

        $filename = "C://tpt.log";
        if (file_exists($filename) && $arr['idCodProduto'] == -100) {
            $arr['stProduto'] = "TAXA DE SERVIÇO";
        }

        $arr['vrTotal'] = number_format($arr['vrTotal'], 2, ".", "");

        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getDescontoDetalheVenda($idAbertura, $idVenda)
{
    $sql = "SELECT COALESCE(SUM(vrDesconto),0) as vrDesconto FROM cx_Vendas_Temp WHERE idAbertura = '$idAbertura' AND idVenda = '$idVenda' AND flAtivo = '1'";
    $res = mssql_query($sql);
    $row = mssql_fetch_row($res);
    $vrDesconto = $row[0];
    $vrDesconto = number_format($vrDesconto, 2, ".", "");
    echo retornaJson(true, $vrDesconto);
}

function getDescontos($idAbertura)
{
    $sql = "SELECT idVenda, vrTotal, vrDesconto, stApelido, dtData  FROM cx_Vendas_Temp v
	LEFT JOIN op_Operadores o ON v.idOperadorAutorizador= o.idOperador
	WHERE idAbertura = '$idAbertura' AND vrDesconto <> 0 AND v.flAtivo = 1";
    $res = mssql_query($sql);
    while ($arr = mssql_fetch_assoc($res)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['vrPago'] = $arr['vrTotal'] - $arr['vrDesconto'];
        $arr['vrPago'] = number_format($arr['vrPago'], 2, ",", ".");
        $arr['vrTotal'] = number_format($arr['vrTotal'], 2, ",", ".");
        $arr['vrDesconto'] = number_format($arr['vrDesconto'], 2, ",", ".");
        if ($arr['stApelido']) {
            $arr['stApelido'] = utf8_encode($arr['stApelido']);
        } else {
            $arr['stApelido'] = 'N/A';
        }
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function getCVale($idAbertura)
{
    $resp = mssql_query("SELECT * FROM cx_FormasPagamento WHERE stFormaPagamento = 'CONTRA-VALE' OR stFormaPagamento = 'CONTRA VALE' OR idTipo = '7'");
    $arrp = mssql_fetch_assoc($resp);

    if ($arrp['idFormaPagamento']) {
        $sql = mssql_query("SELECT X.idVenda, X.idFicha, X.vrFormaPagamento, X.idAbertura, X.dtData, C.stCliente, (V.vrTotal - V.vrDesconto + V.vrAcrescimo) as vrTotal FROM
			(SELECT * FROM cx_FichaRecebimentos_Temp UNION SELECT * FROM cx_FichaPagamentos)X INNER JOIN
			(SELECT DISTINCT idVenda, idAbertura, vrTotal, flNotaFiscal, dtData, idCliente, vrDesconto, vrAcrescimo,
			flAtivo, nrTempoAtendimento, idOperadorAutorizador, flDelivery, idAtendimentoDelivery FROM cx_Vendas_Temp
			UNION
			SELECT DISTINCT idVenda, idAbertura, vrTotal, flNotaFiscal, dtData, idCliente, vrDesconto, vrAcrescimo,
			flAtivo, nrTempoAtendimento, idOperadorAutorizador, flDelivery, idAtendimentoDelivery FROM cx_Vendas) V
			ON X.idVenda = V.idVenda AND X.idAbertura = V.idAbertura INNER JOIN dlv_Clientes C ON V.idCliente = C.idCliente WHERE X.flAtivo = '1' AND X.idAbertura = " . $idAbertura . "
			AND X.idFormaPagamento = " . $arrp['idFormaPagamento'] . " AND X.vrFormaPagamento > '0' ORDER BY 1");

        while ($arr = mssql_fetch_assoc($sql)) {
            $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
            $arr['vrFormaPagamento'] = number_format($arr['vrFormaPagamento'], 2, ".", "");
            $arr['vrTotal'] = number_format($arr['vrTotal'], 2, ".", "");
            $rows[] = $arr;
        }
    }
    echo json_encode($rows);
}

function getVoucher($idAbertura, $flLiquidado = true)
{

    $qry = "";
    if ($flLiquidado == true) {
        $qry = "SELECT V.*, O.* FROM cx_Vaucher V
			INNER JOIN op_Operadores O
			ON V.idOperadorAutorizador = O.idOperador
			WHERE idAbertura = '$idAbertura' AND flLiquidado = '1'";
    } else {
        $qry = "SELECT V.*, O.* FROM cx_Vaucher V
			INNER JOIN op_Operadores O
			ON V.idOperadorAutorizador = O.idOperador
			WHERE idAbertura = '$idAbertura'";
    }

    $resp = mssql_query("SELECT * FROM cx_FormasPagamento WHERE stFormaPagamento = 'VOUCHER' OR stFormaPagamento = 'VOUCHERS'");
    $arrp = mssql_fetch_assoc($resp);
    if ($arrp['idFormaPagamento']) {

        $sql = mssql_query($qry);

        while ($arr = mssql_fetch_assoc($sql)) {
            $arr['dtEmissao'] = date("d/m/Y H:i", strtotime($arr['dtEmissao']));
            $arr['vrVaucher'] = number_format($arr['vrVaucher'], 2, ".", "");
            $rows[] = $arr;
        }
    }
    echo json_encode($rows);
}

function getVendasCaixa($idAbertura)
{
    $totalFormaPagamento = 0;
    $totalChildFormaPagamento = 0;
    if ($idAbertura == 0) {
        $qry = "SELECT idCliente, v.idVenda, v.idAbertura, v.dtData, (v.vrTotal - v.vrDesconto + v.vrAcrescimo) as vrTotal
		FROM cx_Gerenciador g
		INNER JOIN cx_Vendas_Temp v ON g.idAbertura = v.idAbertura
		WHERE g.flAberto = '1' AND v.flAtivo = '1'";

    } else {
        $qry = "SELECT COALESCE(SUM(vrPagamento), 0) as vrPagamento, stFormaPagamento, idFormaPagamento, ParentId, [order], vrTaxa, idTipo
            FROM (
                SELECT SUM(p.vrFormaPagamento) as vrPagamento, f.stFormaPagamento, f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                FROM cx_FormasPagamento f LEFT JOIN cx_FichaRecebimentos_Temp p
                ON f.idFormaPagamento = p.idFormaPagamento
                WHERE f.idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')
                AND f.flAtivo = '1' and p.idAbertura = $idAbertura and p.flAtivo=1 and f.ParentId = 0
                GROUP BY f.stFormaPagamento,f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                union
                SELECT SUM(cp.vrPagamento) as vrPagamento, f.stFormaPagamento, f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                FROM cx_FormasPagamento f
                left join cli_Pagamento cp on cp.idFormaPagamento = f.idFormaPagamento
                WHERE f.idTipo NOT IN ('1','6', '7', '9', '12', '14') and cp.idAbertura = $idAbertura and cp.flAtivo = 1
                GROUP BY f.stFormaPagamento,f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa, f.idTipo
                union
                select 0 as vrPagamento,stFormaPagamento,idFormaPagamento, Parentid, [order], vrTaxa, idTipo from cx_FormasPagamento
                where idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')  AND flAtivo = '1' and idFormaPagamento not in(
                select idFormaPagamento from cx_FichaRecebimentos_Temp where idAbertura = $idAbertura and flAtivo = 1) and ParentId = 0
                group by stFormaPagamento,idFormaPagamento, ParentId, [order], vrTaxa, idTipo

            ) as x GROUP BY stFormaPagamento, idFormaPagamento, ParentId, [order], vrTaxa, idTipo order by ParentId, [order]";

    }
    $sql = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['stFormaPagamento'] = utf8_encode($arr['stFormaPagamento']);
        $arr['idTipo'] = utf8_encode($arr['idTipo']);
        $totalFormaPagamento = number_format($arr['vrPagamento'], 2, ".", "");

        $sqlTemChild = "SELECT * FROM cx_FormasPagamento WHERE parentId =" . $arr['idFormaPagamento'];
        $resTemChild = mssql_query($sqlTemChild);
        $tem = mssql_num_rows($resTemChild);
        if (!$tem) {
            $arr['totalAdq'] = $arr['vrPagamento'] * ($arr['vrTaxa'] / 100);
        }

        $sqlChild = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) as vrPagamento, f.stFormaPagamento, f.idFormaPagamento, f.ParentId,f.[order], f.vrTaxa
			FROM cx_FormasPagamento f LEFT JOIN cx_FichaRecebimentos_Temp p
			ON f.idFormaPagamento = p.idFormaPagamento
			WHERE f.idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')
			AND f.flAtivo = '1' AND p.idAbertura = " . $idAbertura . " AND p.flAtivo=1 AND f.ParentId = " . $arr['idFormaPagamento'] . "
			GROUP BY f.stFormaPagamento,f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa
			UNION
			SELECT 0 as vrPagamento,stFormaPagamento,idFormaPagamento, Parentid, [order], vrTaxa FROM cx_FormasPagamento
			WHERE idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')  AND flAtivo = '1' AND idFormaPagamento not IN(
			SELECT idFormaPagamento FROM cx_FichaRecebimentos_Temp WHERE idAbertura = " . $idAbertura . " AND flAtivo = 1) AND ParentId = " . $arr['idFormaPagamento'] . "
			GROUP BY stFormaPagamento,idFormaPagamento, ParentId, [order], vrTaxa
			ORDER BY ParentId, [order]");

        while ($arrChild = mssql_fetch_assoc($sqlChild)) {
            $arrChild['stFormaPagamento'] = utf8_encode($arrChild['stFormaPagamento']);
            $totalFormaPagamento += number_format($arrChild['vrPagamento'], 2, ".", "");
            $totalChildFormaPagamento += number_format($arrChild['vrPagamento'], 2, ".", "");

            $sqlTemChild = "SELECT * FROM cx_FormasPagamento WHERE parentId =" . $arrChild['idFormaPagamento'];
            $resTemChild = mssql_query($sqlTemChild);
            $tem = mssql_num_rows($resTemChild);
            if (!$tem) {
                $arrChild['totalAdq'] = $arrChild['vrPagamento'] * ($arrChild['vrTaxa'] / 100);
            }


            $sqlSecondChild = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) as vrPagamento, f.stFormaPagamento, f.idFormaPagamento, f.ParentId,f.[order], f.vrTaxa
				FROM cx_FormasPagamento f LEFT JOIN cx_FichaRecebimentos_Temp p
				ON f.idFormaPagamento = p.idFormaPagamento
				WHERE f.idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')
				AND f.flAtivo = '1' AND p.idAbertura = " . $idAbertura . " AND p.flAtivo=1 AND f.ParentId = " . $arrChild['idFormaPagamento'] . "
				GROUP BY f.stFormaPagamento,f.idFormaPagamento, f.ParentId, f.[order], f.vrTaxa
				UNION
				SELECT 0 as vrPagamento,stFormaPagamento,idFormaPagamento, Parentid, [order], vrTaxa FROM cx_FormasPagamento
				WHERE idTipo NOT IN ('6', '7', '9', '12', '13', '14', '16', '17', '20')  AND flAtivo = '1' AND idFormaPagamento not IN(
				SELECT idFormaPagamento FROM cx_FichaRecebimentos_Temp WHERE idAbertura = " . $idAbertura . " AND flAtivo = 1) AND ParentId = " . $arrChild['idFormaPagamento'] . "
				GROUP BY stFormaPagamento,idFormaPagamento, ParentId, [order], vrTaxa
				ORDER BY ParentId, [order]");

            while ($arrSecondChild = mssql_fetch_assoc($sqlSecondChild)) {
                $arrSecondChild['stFormaPagamento'] = utf8_encode($arrSecondChild['stFormaPagamento']);
                $totalFormaPagamento += number_format($arrSecondChild['vrPagamento'], 2, ".", "");
                $totalChildFormaPagamento += number_format($arrSecondChild['vrPagamento'], 2, ".", "");
                $arrSecondChild['vrPagamento'] = number_format($arrSecondChild['vrPagamento'], 2, ".", "");
                $arrSecondChild['totalAdq'] = $arrSecondChild['vrPagamento'] * ($arrSecondChild['vrTaxa'] / 100);

                $secondChilds[] = $arrSecondChild;
            }
            $arrChild['vrPagamento'] = $totalChildFormaPagamento;
            unset($totalChildFormaPagamento);
            $arrChild['secondChilds'] = $secondChilds;
            unset($secondChilds);
            $childs[] = $arrChild;
        }
        $arr['vrPagamento'] = $totalFormaPagamento;
        unset($totalFormaPagamento);
        $arr['childs'] = $childs;
        unset($childs);
        $rows[] = $arr;
    }
    echo json_encode($rows);

}

function getFormaPagamento($idAbertura, $idFormaPagamento)
{
    $sql = mssql_query("SELECT X.idVenda, X.idFicha, X.vrFormaPagamento, X.idFormaPagamento, X.idAbertura, X.dtData, C.stCliente, (V.vrTotal - V.vrDesconto + V.vrAcrescimo) as vrTotal FROM
                        (SELECT * FROM cx_FichaRecebimentos_Temp UNION SELECT * FROM cx_FichaPagamentos)X INNER JOIN
                        (SELECT DISTINCT idVenda, idAbertura, vrTotal, flNotaFiscal, dtData, idCliente, vrDesconto, vrAcrescimo,
                        flAtivo, nrTempoAtendimento, idOperadorAutorizador, flDelivery, idAtendimentoDelivery FROM cx_Vendas_Temp
                        UNION

                        SELECT DISTINCT idVenda, idAbertura, vrTotal, flNotaFiscal, dtData, idCliente, vrDesconto, vrAcrescimo,
                        flAtivo, nrTempoAtendimento, idOperadorAutorizador, flDelivery, idAtendimentoDelivery FROM cx_Vendas) V
                        ON X.idVenda = V.idVenda AND X.idAbertura = V.idAbertura INNER JOIN dlv_Clientes C ON V.idCliente = C.idCliente WHERE X.flAtivo = '1' AND X.idAbertura = $idAbertura
                        AND X.idFormaPagamento = $idFormaPagamento AND X.vrFormaPagamento > '0'
                        union
                        select 0 as idVenda, 0 as idFicha, SUM(vrPagamento) as vrFormaPagamento, idFormaPagamento, idAbertura, dtData, c.stCliente, SUM(vrPagamento) as vrTotal
                        from cli_Pagamento cp inner join dlv_Clientes c on cp.idCliente = c.idCliente
                        where idFormaPagamento = $idFormaPagamento and idAbertura = $idAbertura
                        group by idFormaPagamento, idAbertura, dtData, c.stCliente");

    while ($arr = mssql_fetch_assoc($sql)) {
        $arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
        $arr['vrFormaPagamento'] = number_format($arr['vrFormaPagamento'], 2, ".", "");
        $arr['vrTotal'] = number_format($arr['vrTotal'], 2, ".", "");
        $rows[] = $arr;
    }

    echo json_encode($rows);
}

function getCaixaNoDia($idOperador, $idCaixa, $dtAbertura)
{
    $objCaixa = new CxCaixaLoginClose();
    $dtAbertura = str_replace("/", "-", $dtAbertura);
    $objSource = $objCaixa->getAll($idOperador, $idCaixa, date('Y-m-d ', strtotime($dtAbertura)));
    while ($arr = mssql_fetch_object($objSource)) {
        $arr->data_acao = date("d/m/Y", strtotime($arr->data_acao));
        $arr->hora_acao = date("H:i:s", strtotime($arr->hora_acao));
        $arr->descricao = utf8_encode($arr->descricao);
        $arr->operador = utf8_encode($arr->operador);
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function popularFormaPagamento()
{
    $res = mssql_query("SELECT idFormaPagamento, stFormaPagamento FROM cx_FormasPagamento WHERE idTipo NOT IN ('9', '12', '13', '14', '16', '17') AND flVenda = '1' ORDER BY [order], idFormaPagamento");
    while ($arr = mssql_fetch_assoc($res)) {
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function alterarFormaPagamento($idAbertura, $idFormaPagamento, $idFormaPagamentoOld, $idFicha, $idVenda)
{
    $response = array();
    $res = mssql_query("SELECT * FROM cx_FichaRecebimentos_Temp WHERE idAbertura = '$idAbertura' AND idVenda = '$idVenda' AND idFicha = '$idFicha'");
    $arr = mssql_fetch_array($res);
    $response['vrValor'] = $arr['vrFormaPagamento'];
    $response['idPagamentoNovo'] = $idFormaPagamento;
    $response['idPagamentoAntigo'] = $idFormaPagamentoOld;

    $trans = true;
    mssql_query("UPDATE cx_FichaRecebimentos_Temp SET idFormaPagamento = '$idFormaPagamento' WHERE idAbertura = '$idAbertura' AND idVenda = '$idVenda' AND idFicha = '$idFicha'") or $trans = false;

    if ($trans) {
        // insertLog("FECHAMENTO", "ALTERADA FORMA DE PAGTO DA VENDA [A".$idAbertura."V".$idVenda."].");
        echo json_encode($response);
    } else {
        echo retornaJson(false, "Erro ao alterar a forma de pagamento");
    }

}

function salvarFechamento($vrTrocoEncerramento, $idAbertura, $vrFechamento, $stOBS, $chkAbrirRelatorio, $vrApurado, $vrDiferenca, $detalhesPagamento)
{
    $trans = true;
    $res = mssql_query("SELECT MAX(idDetalhe) FROM cx_GerenciadorDetalhes");
    $row = mssql_fetch_row($res) or $trans = false;

    $idDetalhe = $row[0] + 1; //Busco o maior idDetalhe em GerenciadorDetalhes e o incremento em $idDetalhe

    $res = mssql_query("SELECT * FROM cx_Vendas_Temp WHERE idAbertura = '$idAbertura'") or $trans = false;

//Pego a quantidade de linhas na tabela de vendas desta abertura
    if ($trans) {
        $cnt = mssql_num_rows($res);
    } else {
        die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
    }

    $sql = "SELECT stFormaPagamento, idFormaPagamento, COALESCE(SUM(vrPagamento),0) as vrPagamento, COALESCE(SUM(vrPagamento2),0) as vrPagamento2, COALESCE(SUM(vrPagamentoTotal),0) as vrPagamentoTotal " .
        "FROM " .
        "( " .
        "SELECT COALESCE(SUM(Pagamento),0) as vrPagamento, stFormaPagamento, idFormaPagamento, NULL as vrPagamento2, NULL as vrPagamentoTotal " .
        "FROM " .
        "( " .
        "SELECT COALESCE(SUM(p.vrFormaPagamento),0) as Pagamento, f.stFormaPagamento, f.idFormaPagamento " .
        "FROM cx_FormasPagamento f " .
        "LEFT JOIN (SELECT * FROM cx_FichaPagamentos WHERE idAbertura = '$idAbertura' AND flAtivo = '1') p ON f.idFormaPagamento = p.idFormaPagamento " .
        "WHERE f.idTipo NOT IN ('6', '7', '9', '12') " .
        "GROUP BY f.stFormaPagamento, f.idFormaPagamento " .

        "UNION " .

        "SELECT COALESCE(SUM(c.vrPagamento),0) as Pagamento, f.stFormaPagamento, f.idFormaPagamento " .
        "FROM cx_FormasPagamento f " .
        "LEFT JOIN (SELECT * FROM cli_Pagamento WHERE idAbertura = '$idAbertura' AND flAtivo = '1') c ON f.idFormaPagamento = c.idFormaPagamento " .
        "WHERE f.idTipo NOT IN ('6', '7', '9', '12') " .
        "GROUP BY f.stFormaPagamento, f.idFormaPagamento " .
        ") x " .
        "GROUP BY stFormaPagamento, idFormaPagamento " .

        "UNION " .

        "SELECT NULL as vrPagamento, stFormaPagamento2, idFormaPagamento2, NULL as Pagamento2, SUM(Pagamento3) as vrPagamentoTotal " .
        "FROM " .
        "( " .
        "SELECT COALESCE(SUM(d.vrDespesa),0) as Pagamento3, f.stFormaPagamento as stFormaPagamento2, f.idFormaPagamento as idFormaPagamento2 " .
        "FROM cx_FormasPagamento f " .
        "LEFT JOIN (SELECT * FROM cx_Despesas WHERE idAbertura = '$idAbertura' AND flAtivo = '1') d ON f.idFormaPagamento = d.idFormaPagamento " .
        "WHERE f.idTipo NOT IN ('6', '7', '9', '12') " .
        "GROUP BY f.stFormaPagamento, f.idFormaPagamento " .
        ") k " .
        "GROUP BY stFormaPagamento2, idFormaPagamento2 " .

        "UNION " .

        "SELECT NULL as vrPagamento, stFormaPagamento2, idFormaPagamento2, SUM(Pagamento2) as vrPagamento, SUM(Pagamento2) as vrPagamentoTotal " .
        "FROM " .
        "( " .
        "SELECT COALESCE(SUM(s.vrSangria),0) as Pagamento2, f.stFormaPagamento as stFormaPagamento2, f.idFormaPagamento as idFormaPagamento2 " .
        "FROM cx_FormasPagamento f " .
        "LEFT JOIN (SELECT * FROM cx_Sangrias WHERE idAbertura = '$idAbertura' AND flAtivo = '1') s ON f.idFormaPagamento = s.idFormaPagamento " .
        "WHERE f.idTipo NOT IN ('6', '7', '9', '12') " .
        "GROUP BY f.stFormaPagamento, f.idFormaPagamento " .
        ") y " .
        "GROUP BY stFormaPagamento2, idFormaPagamento2 " .
        ") w " .
        "GROUP BY stFormaPagamento, idFormaPagamento";

    $res = mssql_query($sql);

    $Operador = $_COOKIE['idOperador'];
    try {
        while ($arr = mssql_fetch_array($res)) {
            $idFormaPagamento = $arr['idFormaPagamento'];
            for ($i = 0; $i < count($detalhesPagamento); $i++) {
                if ($idFormaPagamento == $detalhesPagamento[$i]['idFormaPagamento']) {
                    $vrPagamento = strtr($detalhesPagamento[$i]['nAtual'], ",", ".");
                    $vrPagamentoMicro = strtr($detalhesPagamento[$i]['xAtual'], ",", ".");

                    mssql_query("INSERT INTO cx_GerenciadorDetalhes (idDetalhe, idAbertura, idFormaPagamento, vrPagamento, idOperador, vrPagamentoMicro) VALUES ('$idDetalhe', '$idAbertura', '" . $idFormaPagamento . "', '$vrPagamento', '$Operador', '$vrPagamentoMicro')");
                }
            }
        }
        $qry = $qry = "INSERT INTO cx_historicoFechamento (idAbertura,vrApurado,vrFechamento,vrDiferenca,dtData) values ($idAbertura,$vrApurado," . $vrFechamento . ",$vrDiferenca,getdate())";
        mssql_query($qry);
    } catch (Exception $ex) {
        die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
    }
    try {
        $QUERYS = array(
            "UPDATE cx_Gerenciador SET flConferencia = '1', vrTrocoEncerramento = '" . strtr($vrTrocoEncerramento, ",", ".") . "', vrFechamento = '" . strtr($vrFechamento, ",", ".") . "', stOBS = '" . $stOBS . "' WHERE idAbertura = " . $idAbertura,
        );
        foreach ($QUERYS as $sql) {
            if (!empty($sql) || !is_null($sql))
                @mssql_query($sql);
        }
    } catch (Exception $ex) {
        die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
    }
    if ($chkAbrirRelatorio == "false") {
        insertLog("FECHAMENTO", "FECHAMENTO DO CAIXA [$idAbertura] REALIZADO.");
        echo retornaJson(true, "Fechamento realizado com sucesso!<br><br>Redirecionando...", '?sec=presidente&sub=fechamento', 1000);
    } else {
        if (!$trans)
            die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
        else {
            insertLog("FECHAMENTO", "FECHAMENTO DO CAIXA [$idAbertura] REALIZADO.");
            echo retornaJson(true, "Fechamento realizado com sucesso!<br><br>Redirecionando...", '?sec=relatorios&sub=fechamento&passo1=true&passo2=true&idab=' . $idAbertura . '', 1000);
        }
    }
}

function getDadosTodosCaixas()
{
    $result['horaAtual'] = date("H:i:s");

    $res = mssql_query("SELECT COUNT(*) FROM cx_Vendas_Temp v
		INNER JOIN cx_Gerenciador g ON v.idAbertura = g.idAbertura
		WHERE g.flAberto = '1' AND v.flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['totalClientes'] = $arr[0];

    $res = mssql_query("SELECT COALESCE(SUM(vrTotal),0) AS vrTotal, sum(vrDesconto) AS vrDesconto, sum(vrAcrescimo) AS vrAcrescimo FROM cx_Vendas_Temp v
		INNER JOIN cx_Gerenciador g ON v.idAbertura = g.idAbertura
		WHERE g.flAberto = '1' AND v.stCPF IS NOT NULL AND v.flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['vrNFP'] = number_format($arr['vrTotal'] - $arr['vrDesconto'] + $arr['vrAcrescimo'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(vrTotal),0) AS vrTotal, sum(vrDesconto) AS vrDesconto, sum(vrAcrescimo) AS vrAcrescimo FROM cx_Vendas_Temp v
		INNER JOIN cx_Gerenciador g ON v.idAbertura = g.idAbertura
		WHERE g.flAberto = '1' AND v.flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['vrNFPTotal'] = number_format($arr['vrTotal'] - $arr['vrDesconto'] + $arr['vrAcrescimo'], 2, ",", ".");

    $res = mssql_query("SELECT count(*) FROM cx_Vendas_Temp v
		INNER JOIN cx_Gerenciador g ON v.idAbertura = g.idAbertura
		WHERE g.flAberto = '1' AND v.stCPF IS NOT NULL AND v.flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['nrVendasNFP'] = $arr[0];

    $res = mssql_query("SELECT COALESCE(SUM(nrClientes),0) AS nrClientes FROM cx_Gerenciador WHERE flAberto = '1'");
    $arr = mssql_fetch_array($res);
    $result['iniciadoEm'] = "TODOS";
    $result['nrClientes'] = $arr['nrClientes'];

    $res = mssql_query("SELECT COALESCE(SUM(vrAbertura),0) AS vrAbertura FROM cx_Gerenciador WHERE flAberto = '1'");
    $arr = mssql_fetch_array($res);
    $result['valorInicial'] = number_format($arr['vrAbertura'], 2, ",", ".");

    $result['stNome'] = "TODOS";

    $res = mssql_query("SELECT COALESCE(SUM(v.vrDesconto),0) AS vrDesconto, COALESCE(SUM(v.vrAcrescimo),0) AS vrAcrescimo
		FROM cx_Vendas_Temp v
		INNER JOIN cx_Gerenciador g ON v.idAbertura = g.idAbertura
		WHERE v.flAtivo = '1' AND g.flAberto = '1'");
    $arr = mssql_fetch_array($res);
    $result['vrDesconto'] = number_format($arr['vrDesconto'], 2, ",", ".");
    $result['vrAcrescimo'] = number_format($arr['vrAcrescimo'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(s.vrSangria),0) AS vrSangria
		FROM cx_Sangrias s
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND g.flAberto = '1' AND s.vrSangria > '0'");
    $arr = mssql_fetch_array($res);
    $result['vrSangria'] = number_format($arr['vrSangria'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(s.vrSangria),0) AS vrSangria
		FROM cx_Sangrias s
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND g.flAberto = '1' AND s.vrSangria < '0'");
    $arr = mssql_fetch_array($res);
    $result['vrSuprimento'] = number_format($arr['vrSangria'] * (-1), 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento
		FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON p.idAbertura = g.idAbertura
		WHERE p.flAtivo = '1' AND g.flAberto = '1' AND t.idTipoForma = '6'");
    $arr = mssql_fetch_array($res);
    $result['cValesEmitidos'] = number_format($arr['FormaPagamento'] * (-1), 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento
		FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON p.idAbertura = g.idAbertura
		WHERE p.flAtivo = '1' AND g.flAberto = '1' AND t.idTipoForma = '7'");
    $arr = mssql_fetch_array($res);
    $result['cValesRecebidos'] = number_format($arr['FormaPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento
		FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON p.idAbertura = g.idAbertura
		WHERE p.flAtivo = '1' AND g.flAberto = '1' AND t.idTipoForma = '16'");
    $arr = mssql_fetch_array($res);
    $result['cValesEmitidosDG'] = number_format($arr['FormaPagamento'] * (-1), 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento
		FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON p.idAbertura = g.idAbertura
		WHERE p.flAtivo = '1' AND g.flAberto = '1' AND t.idTipoForma = '17'");
    $arr = mssql_fetch_array($res);
    $result['cValesRecebidosDG'] = number_format($arr['FormaPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(d.vrDespesa),0) AS vrDespesa
		FROM cx_Despesas d
		INNER JOIN cx_Gerenciador g ON d.idAbertura = g.idAbertura
		WHERE d.flAtivo = '1' AND g.flAberto = '1'");
    $arr = mssql_fetch_array($res);
    $result['outrasDesp'] = number_format($arr['vrDespesa'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento
		FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		INNER JOIN cx_Gerenciador g ON p.idAbertura = g.idAbertura
		WHERE p.flAtivo = '1' AND g.idAbertura = '1' AND t.idTipoForma = '9'");
    $arr = mssql_fetch_array($res);
    $result['industria'] = number_format($arr['FormaPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(E.vrTotal - E.vrDesconto),0) AS vrTotal
		FROM cli_Extrato E
		INNER JOIN cx_Gerenciador G ON E.idAbertura = G.idAbertura
		WHERE G.flAberto = '1' AND E.flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['contas'] = number_format($arr['vrTotal'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(c.vrPagamento),0) AS vrPagamento
		FROM cli_Pagamento c
		INNER JOIN cx_Gerenciador g ON c.idAbertura = g.idAbertura
		WHERE c.flAtivo = '1' AND g.flAberto = '1' AND c.vrPagamento > 0");
    $arr = mssql_fetch_array($res);
    $result['depContas'] = number_format($arr['vrPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(c.vrPagamento),0) AS vrPagamento
		FROM cli_Pagamento c
		INNER JOIN cx_Gerenciador g ON c.idAbertura = g.idAbertura
		WHERE c.flAtivo = '1' AND g.flAberto = '1' AND c.vrPagamento < 0");
    $arr = mssql_fetch_array($res);
    $result['estornoDepContas'] = number_format($arr['vrPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COUNT(I.idItem)
		FROM cx_Itens_Temp I
		INNER JOIN cx_Gerenciador G ON I.idAbertura = G.idAbertura
		WHERE I.flAtivo = '0' AND G.flAberto = '1'");
    $arr = mssql_fetch_array($res);
    $result['itensExcluidos'] = $arr[0];

    $res = mssql_query("SELECT COALESCE(SUM(s.vrRepique),0) AS vrRepique
		FROM cx_Repique s
		INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura
		WHERE s.flAtivo = '1' AND g.flAberto = '1' AND s.vrRepique > '0'");
    $arr = mssql_fetch_array($res);
    $vrRepique = number_format($arr['vrRepique'], 2, ",", ".");
    if (!$vrRepique) {
        $vrRepique = 0.00;
    }
    $result['vrRepique'] = $vrRepique;

    $result['porcentagemNFP'] = 0.00;

    $result['vrTotalPagamento'] = 0.00;
    $qryVoucher = "SELECT idFormaPagamento from cx_FormasPagamento where stFormaPagamento LIKE '%VOUCHER%'";
    $res = mssql_query($qryVoucher);
    $idVoucher = mssql_fetch_array($res)[0];
    if (!$idVoucher) {
        $idVoucher = 0;
    }
    $qryPagamentos = "SELECT COALESCE(SUM(ft.vrFormaPagamento),0) as vrPagamento, fp.stFormaPagamento FROM cx_FichaRecebimentos_Temp ft
	INNER JOIN cx_FormasPagamento fp ON ft.idFormaPagamento = fp.idFormaPagamento
	INNER JOIN cx_Gerenciador g ON ft.idAbertura = g.idAbertura
	WHERE ft.flAtivo = '1' AND g.flAberto = '1' AND fp.idFormaPagamento <> $idVoucher AND fp.idTipo not in (6,7)
	GROUP BY fp.stFormaPagamento ORDER BY fp.stFormaPagamento";
    $res = mssql_query($qryPagamentos);
    while ($arr = mssql_fetch_assoc($res)) {
        $result['vrTotalPagamento'] += $arr['vrPagamento'];
        $arr['vrPagamento'] = number_format($arr['vrPagamento'], 2, ",", ".");
        $result['formasPagamento'][] = $arr;
    }
    $result['vrTotalPagamento'] = number_format($result['vrTotalPagamento'], 2, ",", ".");

    echo json_encode($result);
}

function getDadosCaixa($idAbertura)
{
    $result['horaAtual'] = date("H:i:s");

    $res = mssql_query("SELECT COUNT(*) FROM cx_Vendas_Temp WHERE idAbertura = '$idAbertura' AND flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['totalClientes'] = $arr[0];

    $res = mssql_query("SELECT COALESCE(sum(vrTotal),0) AS vrTotal, sum(vrDesconto) AS vrDesconto, sum(vrAcrescimo) AS vrAcrescimo FROM cx_Vendas_Temp
		WHERE stCPF IS NOT NULL AND idAbertura = '$idAbertura' AND flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['vrNFP'] = number_format($arr['vrTotal'] - $arr['vrDesconto'] + $arr['vrAcrescimo'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(sum(vrTotal),0) AS vrTotal, sum(vrDesconto) AS vrDesconto, sum(vrAcrescimo) AS vrAcrescimo FROM cx_Vendas_Temp
		WHERE idAbertura = '$idAbertura' AND flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['vrNFPTotal'] = number_format($arr['vrTotal'] - $arr['vrDesconto'] + $arr['vrAcrescimo'], 2, ",", ".");

    $res = mssql_query("SELECT count(*) from cx_Vendas_Temp where stCPF IS NOT NULL AND flAtivo = '1' AND idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);
    $result['nrVendasNFP'] = $arr[0];

    $res = mssql_query("SELECT dtAbertura, idOperador, nrClientes, idCaixa FROM cx_Gerenciador WHERE idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);
    $IniciadoEm = $arr['dtAbertura'];
    $IniciadoEm = strtotime($IniciadoEm);
    $result['iniciadoEm'] = date("d/m/y - H:i:s", $IniciadoEm);
    $IniciadoEm = (is_numeric($idAbertura) ? $IniciadoEm : "TODOS");
    $result['idOperador'] = $arr['idOperador'];
    $result['nrClientes'] = $arr['nrClientes'];
    $result['idCaixa'] = $arr['idCaixa'];

    $res = mssql_query("SELECT COALESCE(SUM(vrAbertura),0) AS vrAbertura FROM cx_Gerenciador WHERE idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);
    $result['valorInicial'] = number_format($arr['vrAbertura'], 2, ",", ".");

    $res = mssql_query("SELECT stNome FROM op_Operadores WHERE idOperador = " . $result['idOperador']);
    $arr = mssql_fetch_array($res);
    $result['stNome'] = utf8_encode($arr['stNome']);

    $res = mssql_query("SELECT COALESCE(SUM(vrDesconto),0) AS vrDesconto, SUM(vrAcrescimo) AS vrAcrescimo
		FROM cx_Vendas_Temp
		WHERE flAtivo = '1' AND idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);
    $result['vrDesconto'] = number_format($arr['vrDesconto'], 2, ",", ".");
    $result['vrAcrescimo'] = number_format($arr['vrAcrescimo'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(vrSangria),0) AS vrSangria FROM cx_Sangrias WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrSangria > '0'");
    $arr = mssql_fetch_array($res);
    $result['vrSangria'] = number_format($arr['vrSangria'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(vrSangria),0) AS vrSangria FROM cx_Sangrias WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrSangria < '0'");
    $arr = mssql_fetch_array($res);
    $result['vrSuprimento'] = number_format($arr['vrSangria'] * (-1), 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento  FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '6'");
    $arr = mssql_fetch_array($res);
    $result['cValesEmitidos'] = number_format($arr['FormaPagamento'] * (-1), 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '7'");
    $arr = mssql_fetch_array($res);
    $result['cValesRecebidos'] = number_format($arr['FormaPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '16'");
    $arr = mssql_fetch_array($res);
    $result['cValesEmitidosDG'] = number_format($arr['FormaPagamento'] * (-1), 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '17'");
    $arr = mssql_fetch_array($res);
    $result['cValesRecebidosDG'] = number_format($arr['FormaPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(vrDespesa),0) AS vrDespesa FROM cx_Despesas WHERE flAtivo = '1' AND idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);
    $result['outrasDesp'] = number_format($arr['vrDespesa'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(p.vrFormaPagamento),0) AS FormaPagamento FROM cx_FormasPagamento f
		INNER JOIN cx_TiposFormaPagamento t ON f.idTipo = t.idTipoForma
		INNER JOIN cx_FichaRecebimentos_Temp p ON f.idFormaPagamento = p.idFormaPagamento
		WHERE p.flAtivo = '1' AND p.idAbertura = '$idAbertura' AND t.idTipoForma = '9'");
    $arr = mssql_fetch_array($res);
    $result['industria'] = number_format($arr['FormaPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COALESCE(SUM(vrTotal + vrDesconto),0) AS vrTotal FROM cli_Extrato
		WHERE idAbertura = '$idAbertura' AND flAtivo = '1'");
    $arr = mssql_fetch_array($res);
    $result['contas'] = number_format($arr['vrTotal'], 2, ",", ".");

    $result['vrTotalPagamento'] = 0.00;

    $res = mssql_query("SELECT COALESCE(SUM(vrPagamento),0) as vrPagamento FROM cli_Pagamento WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrPagamento > 0");
    $arr = mssql_fetch_array($res);
    $result['depContas'] = number_format($arr['vrPagamento'], 2, ",", ".");
    $result['vrTotalPagamento'] += $arr['vrPagamento'];

    $res = mssql_query("SELECT COALESCE(SUM(vrPagamento),0) as vrPagamento FROM cli_Pagamento WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrPagamento < 0");
    $arr = mssql_fetch_array($res);
    $result['estornoDepContas'] = number_format($arr['vrPagamento'], 2, ",", ".");

    $res = mssql_query("SELECT COUNT(*) FROM cx_Itens_Temp WHERE flAtivo = '0' AND idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);
    $result['itensExcluidos'] = $arr[0];

    $res = mssql_query("SELECT COALESCE(SUM(vrRepique),0) as vrRepique FROM cx_Repique WHERE flAtivo = '1' AND idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);
    $vrRepique = number_format($arr['vrRepique'], 2, ",", ".");
    if (!$vrRepique) {
        $vrRepique = 0.00;
    }
    $result['vrRepique'] = $vrRepique;

    $qryVoucher = "SELECT idFormaPagamento from cx_FormasPagamento where stFormaPagamento = 'VOUCHER' or stFormaPagamento = 'VOUCHERS'";
    $res = mssql_query($qryVoucher);

    $idVoucher = mssql_fetch_array($res);
    if (!$idVoucher) {
        $idVoucher[0] = 0;
    }
    $qryPagamentos = "SELECT COALESCE(SUM(ft.vrFormaPagamento),0) as vrPagamento, fp.stFormaPagamento FROM cx_FichaRecebimentos_Temp ft
	INNER JOIN cx_FormasPagamento fp ON ft.idFormaPagamento = fp.idFormaPagamento
	WHERE ft.idAbertura = " . $idAbertura . " AND ft.flAtivo = '1' AND fp.idFormaPagamento <> $idVoucher[0] AND fp.idTipo not in (6,7)
	GROUP BY fp.stFormaPagamento ORDER BY fp.stFormaPagamento";
    $res = mssql_query($qryPagamentos);
    while ($arr = mssql_fetch_assoc($res)) {
        $result['vrTotalPagamento'] += $arr['vrPagamento'];
        $arr['vrPagamento'] = number_format($arr['vrPagamento'], 2, ",", ".");
        $result['formasPagamento'][] = $arr;
    }
    $result['vrTotalPagamento'] = number_format($result['vrTotalPagamento'], 2, ",", ".");
    echo json_encode($result);
}

function excluirVenda($idAbertura, $idVenda)
{
    beginTransaction();

    $trans = true;

    mssql_query("UPDATE cx_Vendas_Temp SET flAtivo = '0' WHERE idVenda = '$idVenda' AND idAbertura = '$idAbertura'") or $trans = false;

    $res = mssql_query("SELECT * FROM cx_Gerenciador WHERE idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);
    $idOrigem = $arr['idOrigem'];
    $idDestino = $arr['idDestino'];
    $res = mssql_query("SELECT * FROM cx_FichaPagamentos WHERE idVenda = '$idVenda' AND idAbertura = '$idAbertura'");

    while ($arr = mssql_fetch_array($res)) {
        mssql_query("UPDATE cx_FichaPagamentos SET flAtivo = '0' WHERE idVenda = '$idVenda' AND idAbertura = '$idAbertura'") or $trans = false;
    }

    $res = mssql_query("SELECT * FROM cx_Vendas_Temp WHERE idVenda = '$idVenda' AND idAbertura = '$idAbertura'");
    $arr = mssql_fetch_array($res);

    if ($arr['idCliente'] > 0) {
        $rs = mssql_query("SELECT vrSaldo FROM dlv_Clientes WHERE idCliente = '" . $arr['idCliente'] . "'");
        $ar = mssql_fetch_array($rs);

        $vrSaldo = $ar['vrSaldo'] + ($arr['vrTotal'] + $arr['vrAcrescimo'] - $arr['vrDesconto']);

        mssql_query("UPDATE dlv_Clientes SET vrSaldo = '$vrSaldo' WHERE idCliente = '" . $arr['idCliente'] . "'") or $trans = false;

        mssql_query("UPDATE cli_Extrato SET flAtivo = '0' WHERE idVenda = '$idVenda' AND idAbertura = '$idAbertura'") or $trans = false;

        $rs = mssql_query("SELECT I.*
			FROM cli_Extrato E
			INNER JOIN cli_ItemExtrato I ON E.idExtrato = I.idExtrato AND E.idAbertura = I.idAbertura
			WHERE E.idVenda = '$idVenda' AND E.idAbertura = '$idAbertura'");
        while ($ar = mssql_fetch_array($rs)) {
            mssql_query("UPDATE cli_ItemExtrato SET flAtivo = '0' WHERE idAbertura = '$idAbertura' AND idExtrato = '$ar[idExtrato]'") or $trans = false;
        }
    }

    $res = mssql_query("SELECT * FROM cx_Itens_Temp WHERE idVenda = '$idVenda' AND idAbertura = '$idAbertura'");

    while ($arr = mssql_fetch_array($res)) {
        mssql_query("UPDATE cx_Itens_Temp SET flAtivo = '0' WHERE idVenda = '$idVenda' AND idAbertura = '$idAbertura' AND idItem = '" . $arr['idItem'] . "'") or $trans = false;

        $rs = mssql_query("SELECT * FROM prd_Produtos WHERE idProduto = '" . $arr['idProduto'] . "'");
        $ar = mssql_fetch_array($rs);

        if ($ar['flControlarEstoque']) {
            $r1 = mssql_query("SELECT * FROM est_Saldos WHERE idProduto = '" . $arr['idProduto'] . "' AND idEstoque = '$idOrigem'");
            $a1 = mssql_fetch_array($r1);

            $newQtdOrigem = $a1['nrQuantidade'] + $arr['nrQuantidade'];

            mssql_query("UPDATE est_Saldos SET nrQuantidade = '$newQtdOrigem' WHERE idProduto = '" . $arr['idProduto'] . "' AND idEstoque = '$idOrigem'") or $trans = false;


            $r2 = mssql_query("SELECT * FROM est_Saldos WHERE idProduto = '" . $arr['idProduto'] . "' AND idEstoque = '$idDestino'");
            $a2 = mssql_fetch_array($r2);

            $newQtdDestino = $a2['nrQuantidade'] - $arr['nrQuantidade'];

            mssql_query("UPDATE est_Saldos SET nrQuantidade = '$newQtdDestino' WHERE idProduto = '" . $arr['idProduto'] . "' AND idEstoque = '$idDestino'") or $trans = false;
        }
    }

    if ($trans == true) {
        commit();
        insertLog("PRESIDENTE", "VENDA [$idVenda] EXCLUIDA.");
        echo retornaJson(true, 'Venda cancelada com sucesso.');
    } else {
        rollback();
        echo retornaJson(false, 'Occoreu um erro ao cancelar a venda.');
    }
}

function getTurnos()
{
    $qry = 'SELECT * FROM cx_turnosCaixas ORDER BY hrInicio';
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $arr['stDescricao'] = utf8_encode($arr['stDescricao']);
        $rows[] = $arr;
    }

    echo json_encode($rows);
}

function cadastraTurno($stDesc, $hrInicio, $hrFim)
{
    $stDesc = sanitizeString($stDesc);

    $trans = true;
    beginTransaction();
    $res = mssql_query("SELECT MAX(idTurno) FROM cx_turnosCaixas");
    $row = mssql_fetch_row($res) or $trans = false;

    $idTurno = $row[0] + 1;

    $qry = "INSERT INTO cx_turnosCaixas (idTurno, hrInicio, hrFim, stDescricao) VALUES (" . $idTurno . ", '" . $hrInicio . "', '" . $hrFim . "', '" . $stDesc . "')";
    $res = mssql_query($qry) or $trans = false;

    if ($trans) {
        commit();
        echo retornaJson(true, 'Turno cadastrado com sucesso. Recarregando a pagina.');
    } else {
        mssql_query('ROLL BACK');
        echo retornaJson(false, 'Erro ao cadastrar o turno.');
    }
}

function editarTurno($idTurno, $stDesc, $hrInicio, $hrFim)
{
    $stDesc = sanitizeString($stDesc);

    $trans = true;
    beginTransaction();
    $qry = "UPDATE cx_turnosCaixas SET hrInicio = '" . $hrInicio . "' ,hrFim = '" . $hrFim . "' ,stDescricao = '" . $stDesc . "'
	WHERE idTurno = " . $idTurno;
    $res = mssql_query($qry) or $trans = false;

    if ($trans) {
        commit();
        echo retornaJson(true, 'Turno editado com sucesso. Recarregando a pagina.');
    } else {
        mssql_query('ROLL BACK');
        echo retornaJson(false, 'Erro ao editar o turno.');
    }
}

function deleteTurno($idTurno)
{
    $trans = true;
    $qry = 'DELETE FROM cx_turnosCaixas WHERE idTurno = ' . $idTurno;
    $res = mssql_query($qry) or $trans = false;

    if ($trans) {
        echo retornaJson(true, 'Turno excluido com sucesso.');
    } else {
        echo retornaJson(false, 'Erro ao excluir o turno.');
    }
}

function getTurnoById($idTurno)
{
    $qry = "SELECT * FROM cx_turnosCaixas WHERE idTurno = " . $idTurno;
    $res = mssql_query($qry);
    $arr = mssql_fetch_assoc($res);
    $arr['stDescricao'] = utf8_encode($arr['stDescricao']);

    echo json_encode($arr);
}

?>
