<?php
require_once "../functions.php";

db_conn();

if (autorization(7) == false)
{
	?>
	<SCRIPT>
		document.location = "../?sec=erro&sub=2";
	</SCRIPT>
	<?
	die;
}

$idAbertura = htmlspecialchars($_GET['id'], ENT_QUOTES);
$cxon = htmlspecialchars($_GET['cxon'], ENT_QUOTES);
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Detalhes de Vendas realizadas</title>
	<script type="text/javascript" language="JavaScript" src="../js/lib.js"></script>
	<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
	<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
	<link href="resources/css/toastr.css" rel="stylesheet"/>
	<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
	<link href="resources/css/custom.css" rel="stylesheet"/>
</head>
<body>
	<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
		<caption class="table-caption"><b>Detalhes de Vendas realizadas</b></caption>
		<thead>
			<tr>
				<td class="tdStyle" width="20%"><b>Venda</b></td>
				<td class="tdStyle" width="20%"><b>Cliente</b></td>
				<td class="tdStyle" width="20%"><b>Data</b></td>
				<td class="tdStyle" align="right"><b>Valor Total</b></td>
				<td class="tdStyle" align="center"><b>Ação</b></td>
			</tr>
		</thead>
		<?
		if (is_numeric($idAbertura))
		{
			$sql = "SELECT idCliente, idVenda, idAbertura, dtData, (vrTotal - vrDesconto + vrAcrescimo) as vrTotal ".
			"FROM cx_Vendas_Temp ".
			"WHERE idAbertura = '$idAbertura' AND flAtivo = '1'";
		}
		else
		{
			$sql = "SELECT idCliente, v.idVenda, v.idAbertura, v.dtData, (v.vrTotal - v.vrDesconto + v.vrAcrescimo) as vrTotal ".
			"FROM cx_Gerenciador g ".
			"INNER JOIN cx_Vendas_Temp v ON g.idAbertura = v.idAbertura ".
			"WHERE g.flAberto = '1' AND v.flAtivo = '1'";
		}

		$res = mssql_query($sql);

		while ($arr = mssql_fetch_array($res))
		{
			$dtData = strtotime($arr['dtData']);
			$dtData = date("d/m/y H:i:s", $dtData);
			?>
			<tr>
				<td class="tdStyle"><?php echo $arr['idVenda']?></td>
				<td class="tdStyle"><?php echo $arr['idCliente']?></td>
				<td class="tdStyle"><nobr><?php echo $dtData?> H</nobr></td>
				<td class="tdStyle" align="right">R$ <?php echo number_format($arr['vrTotal'], 2, ",", ".")?></td>
				<td>
					<table width="100%" cellspacing="0" cellpadding="0">
						<tr>
							<td class="tdStyle" align="center"><a href="ver_itensvenda.php?idv=<?php echo $arr['idVenda']?>&ida=<?php echo $arr['idAbertura']?>"><span class="glyphicon glyphicon-search" title='Visualizar'></span></a></td>
							<?
							if ($cxon == true)
							{
								?>
								<td class="tdStyle" align="center"><a href="ver_takedeletevendas.php?idv=<?php echo $arr['idVenda']?>&ida=<?php echo $arr['idAbertura']?>" onClick="return confirmPopup('Tem certeza que deseja cancelar esta venda?');"><span class="glyphicon glyphicon-remove" title="Excluir"></span></a></td>
								<?
							}
							?>
						</tr>
					</table>
				</td>
			</tr>
			<?
			$somaTotal += $arr['vrTotal'];
		}
		?>
		<tr>
			<td class="tdStyle" colspan="3"><b>TOTAL</b></td>
			<td class="tdStyle" align="right"><b>R$ <?php echo number_format($somaTotal, 2, ",", ".")?></b></td>
			<td></td>
		</tr>
	</table>
</td>
</tr>
</table>
</body>
</html>
