<?php
require_once "functions.php";
logincheck();
if (autorization(57) == false) {
    ?>
    <SCRIPT>
        document.location = "?sec=erro&sub=2";
    </SCRIPT>
    <?
    die;
}
?>
<script>
    $(document).ready(function () {
        $('.data').datepicker({
            format: 'dd/mm/yyyy',
            language: 'pt-BR'
        });
    });

    $("#de").mask('00/00/0000');
    $("#ate").mask('00/00/0000');
</script>

<?
$actualDate = date('d/m/Y');
$partes = explode("/", $actualDate);
$startDate = '01/' . $partes[1] . "/" . $partes[2];

?>

<style>
    #filtro {

    }
</style>
<div id="filtro">
    <div class="col-md-12">
        <h2>Transferência de Mesas</h2>
        <hr>
    </div>
    <div class="col-md-4">
        <form>
            <div class="form-group">
                <h4>Período</h4>
                <div class="input-group">
                    <div class="input-group-addon">De:</div>
                    <input type="text" name="de" id="de" class="form-control data" value='<?php echo  $startDate ?>'/>
                    <div class="input-group-addon">Até:</div>
                    <input type="text" name="ate" id="ate" class="form-control data" value='<?php echo  $actualDate ?>'/>
                </div>
            </div>
            <button type="button" id="getTransfer" class="btn btn-new-nati">Gerar</button>
        </form>
    </div>
    <div class="modal-loader"></div>
</div>
<div class="row">

    <div class="col-md-12">
        <table id="relatorio" class="display table table-striped table-bordered hide">
            <thead>
            <th>Data</th>
            <th>Origem</th>
            <th>Destino</th>
            <th>Operador</th>
            <th>Operador Autorizador</th>
            <th></th>
            </thead>
            <tbody id="bodyRelatorio">

            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="modalDetalheMesa" tabindex="-1" role="dialog" aria-labelledby="modalDetalheMesa">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">Detalhe Mesa/Comanda</h4>
            </div>
            <div class="modal-body">
                <div id="detalheHeader">

                </div>
                <table id="detalhe" class="display table table-hover table-bordered tabela-borda-simples">
                    <thead>
                    <tr>
                        <th>Cod</th>
                        <th>Produto</th>
                        <th>Qtd</th>
                        <th>Vr. Unitario</th>
                        <th>Vr. Total</th>
                    </tr>
                    </thead>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>
<script src="js/jquery-2.1.4.js"></script>
<script src="js/bootstrap.min.js"></script>
<script>



    $("#getTransfer").click(function () {
        $("#bodyRelatorio").html('');

        var de = $("#de").val()
        var ate = $("#ate").val()
        $.post('relatorios/resources/php/transferenciasMesas.php', data = {
                action: 'getTransfer',
                de: de,
                ate: ate
            }, function (response) {

                if (response) {
                    var linha = '';
                    for (var i = 0; i < response.length; i++) {
                        var atual = response[i];

                        linha += '<tr>';
                        linha += '<td>' +atual['dtData']+'</td>';
                        linha += '<td>' + atual['idComandaOrigem'] + '</td>';
                        linha += '<td>' + atual['idComandaDestino'] + '</td>';
                        linha += '<td>' + atual['operador'] + '</td>';
                        linha += '<td>' + atual['operadorAutorizador'] + '</td>';
                        linha += '<td><button class="btn btn-primary" onclick="getDetalheMesa(' + atual['id'] + ',' + atual['idComandaOrigem'] + ',' + atual['idComandaDestino'] + ')"><i class="glyphicon glyphicon-search"></i></button></td>';
                    }
                }
                else {
                    swal('Erro', 'Nenhum resultado foi encontrado!', 'error')
                }

                $(linha).appendTo($('#bodyRelatorio'));
                $('#relatorio').removeClass('hide');
                $("body").removeClass("loading");
            }
        );
    });

    function getDetalheMesa(id, origem, destino) {
        $("#detalheHeader").html('');
        $("#detalhe").html('');

        $.post('relatorios/resources/php/transferenciasMesas.php', data = {
            action: 'getDetalhe',
            idMesa: id
        }, function (response) {
            console.log(response)

            if (response) {
                var linha = '';
                for (var i = 0; i < response.length; i++) {
                    var atual = response[i];
                    linha += '<tr>';
                    linha += '<td>' + atual['idCodigo'] + '</td>';
                    linha += '<td>' + atual['stProdutoAbreviado'] + '</td>';
                    linha += '<td>' + atual['nrQuantidade'] + '</td>';
                    linha += '<td>R$ ' + atual['vrUnitario'] + '</td>';
                    linha += '<td>R$ ' + atual['vrTotal'] + '</td>';
                }
            }

            var header = `
                <h3>Mesa Origem:  ${origem}  => Mesa Destino: ${destino}</h3>
                <br>
            `;

            $(header).appendTo($('#detalheHeader'));
            $(linha).appendTo($('#detalhe'));
            $("#modalDetalheMesa").modal('show');
        });
    }
</script>
