<?php

namespace App\Exports\Nati;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromArray;

/**
 * Class ProductsIntegracaoControllerExport
 * @package App\Exports\Nati
 */
class ProductsIntegracaoControllerExport implements FromArray
{
    /**
     * @return array
     */
    public function array() : array
    {
        $query = /** @lang TSQL */
            "SELECT
                    MIN(C.idCodigo) AS 'pr_codint',
                    'M' AS 'pr_master',
                    MAX(C.idCodigo) AS 'pr_codigo_master',
                    P.stProduto AS 'pr_nome',
                    P.stProdutoAbreviado AS 'pr_nomeabreviado',
                    P.stProdutoAbreviado AS 'pr_nomegondola',
                    NULL AS 'pr_volume',
                    M.stMedida AS 'tc_codig',
                    S.idSetor AS 'se_codig',
                    (
                        CASE
                            WHEN P.flAtivo = 1 THEN 'S'
                            ELSE 'N'
                        END
                    ) AS 'pr_ativo',
                    CONVERT(VARCHAR, P.dtAlteracao, 103) AS 'pr_data_alteracao',
                    P.vrUnitario AS 'pr_precovenda_atual',
                    p.vrCusto AS 'pr_ult_precocusto',
                    (
                        CASE
                            WHEN M.flFracionado = 1 THEN 'P'
                            ELSE 'U'
                        END
                    ) AS 'pr_venda_peso_unidade',
                    P.vrMargemLucro AS 'pr_margem_bruta_scusto',
                    NULL AS 'fo_codig',
                    1 AS 'pr_tipo_etiqueta',
                    NULL AS 'pr_qtde_caixa',
                    P.stOperador AS 'usua_inc',
                    FORMAT(P.dtCriacao, 'yyyyMMddhhmm') AS 'data_hora_inc',
                    FORMAT(P.dtCriacao, 'dd/MM/yyyy hh:mm') AS 'data_inc',
                    NULL AS 'lj_associacao',
                    NULL AS 'lj_codig',
                    P.vrUnitario AS 'pr_custo_sem_icms',
                    A.AliquotaIcms AS 'pr_diferenca_icms',
                    NULL AS 'codigo_comprador',
                    M.stMedida AS 'uni_venda',
                    P.nrNCM AS 'ncm',
                    P.nrNCM AS 'ncm_ex',
                    NULL AS 'usua_alt_preco',
                    NULL AS 'id_departamento'
                FROM
                    prd_Produtos P
                    INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
                    INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
                    INNER JOIN prd_Setores S ON P.idSetor = S.idSetor
                    INNER JOIN prd_Aliquotas A ON P.idAliquota = A.idAliquota
                GROUP BY
                    P.stProduto,
                    P.stProdutoAbreviado,
                    M.stMedida,
                    S.idSetor,
                    P.flAtivo,
                    P.dtAlteracao,
                    P.vrCusto,
                    M.flFracionado,
                    P.vrMargemLucro,
                    P.vrUnitario,
                    P.stOperador,
                    P.dtCriacao,
                    P.vrUnitario,
                    A.AliquotaIcms,
                    P.nrNCM";

        $arr = DB::select($query);

        array_unshift($arr,[
            'pr_codint',
            'pr_master',
            'pr_codigo_master',
            'pr_nome',
            'pr_nomeabreviado',
            'pr_nomegondola',
            'pr_volume',
            'tc_codig',
            'se_codig',
            'pr_ativo',
            'pr_data_alteracao',
            'pr_precovenda_atual',
            'pr_ult_precocusto',
            'pr_venda_peso_unidade',
            'pr_margem_bruta_scusto',
            'fo_codig',
            'pr_tipo_etiqueta',
            'pr_qtde_caixa',
            'usua_inc',
            'data_hora_inc',
            'data_inc',
            'lj_associacao',
            'lj_codig',
            'pr_custo_sem_icms',
            'pr_diferenca_icms',
            'codigo_comprador',
            'uni_venda',
            'ncm',
            'ncm_ex',
            'usua_alt_preco',
            'id_departamento'
        ]);

        return $arr;
    }
}
