<?php

namespace App\Http\Controllers;


use App\Entities\Logs;
use App\Http\Controllers\Controller;
use App\Services\Nati\CategoriaService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use App\Http\Requests\Nati\SubCategoriaUpdateRequest;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Entities\Nati\Categoria;

class CategoriasController extends Controller
{

    /**
     * @var CategoriaService
     */
    protected $service;

    /**
     * CategoriasController constructor.
     * @param CategoriaService $service
     */
    public function __construct(CategoriaService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request)
    {
        try {
            return $this->service->all($request->all());
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function store(Request $request)
    {
        try {
            $user = auth()->user();
            $response = $this->service->create($request->all());
            Logs::writeLog($user->stApelido, "CATEGORIAS", 'O USUARIO [' . $user->stApelido . '] CADASTROU A CATEGORIA [' . $response->stCategoria . ']');
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return JsonResponse
     */
    public function show($id)
    {
        try {
            return response()->json($this->service->getById($id));
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param SubCategoriaUpdateRequest $request
     * @param string $id
     *
     * @return JsonResponse
     */

    public function update(Request $request, $id)
    {
        try {
            $oldNameCategory = Categoria::where('idCategoria', $id)->first();
            $user = auth()->user();
            $response = $this->service->update($request->all(), $id);
            Logs::writeLog($user->stApelido, "CATEGORIAS", 'O USUARIO [' . $user->stApelido . '] ALTEROU O NOME DA CATEGORIA [' . $oldNameCategory->stCategoria . '] ' . 'PARA [' . $response->stCategoria . ']');
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return JsonResponse
     */
    public function destroy($id)
    {
        try {
            $user = auth()->user();
            $response = $this->service->delete($id);
            Logs::writeLog($user->stApelido, "CATEGORIAS", 'O OPERADOR [' . $user->stApelido . '] DESATIVOU A CATEGORIA [' . $response->stCategoria . ']');

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }

    public function getAll()
    {
        try {
            return response()->json($this->service->getAll());
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return JsonResponse
     */
    public function getSubcategoria($id)
    {
        try {
            return response()->json($this->service->getSubCategorias($id));
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param SubCategoriaUpdateRequest $request
     * @param int $id
     *
     * @return JsonResponse
     * @throws ValidationException
     */
    public function addSubcategoria(SubCategoriaUpdateRequest $request, $id)
    {
        try {
            $user = auth()->user();
            $response = $this->service->addSubcategoria($request->all(), $id);
            Logs::writeLog($user->stApelido, "CATEGORIAS", 'O USUARIO [' . $user->stApelido . '] CADASTROU A SUBCATEGORIA [' . $response->stSubCategoria . ']');
            return response()->json($response, 201);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (ValidatorException $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }

    public function deleteSubcategoria(Request $request, $id)
    {
        try {
            $user = auth()->user();
            $response = $this->service->deleteSubcategoria($request->all(), $id);
            Logs::writeLog($user->stApelido, "CATEGORIAS", 'O OPERADOR [' . $user->stApelido . '] EXCLUIU A SUBCATEGORIA [' . $response->stSubCategoria . ']');
            return response()->json([
                'message' => 'Categoria Update',
                'data' => $response
            ], 200);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (ValidatorException $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }

    public function updateSub(SubCategoriaUpdateRequest $request, $idSub, $id_category)
    {
        try {
            $user = auth()->user();
            $response = $this->service->updateSub($request->all(), $idSub, $id_category);
            Logs::writeLog($user->stApelido, "CATEGORIAS", 'O USUARIO [' . $user->stApelido . '] ALTEROU A SUBCATEGORIA [' . $response->stProdutoAbreviado . ']');
            return response()->json($response, 200);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (ValidatorException $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }
}
