<?php

namespace App\Http\Controllers\Financeiro;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\EntradaSaidaCreateRequest;
use App\Http\Requests\EntradaSaidaUpdateRequest;
use App\Repositories\EntradaSaidaRepository;
use App\Validators\EntradaSaidaValidator;
use Yajra\Datatables\Datatables;


class EntradaSaidasController extends Controller
{

    /**
     * @var EntradaSaidaRepository
     */
    protected $repository;

    /**
     * @var EntradaSaidaValidator
     */
    protected $validator;

    public function __construct(EntradaSaidaRepository $repository, EntradaSaidaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator  = $validator;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        $entradaSaidas = $this->repository->all();

        if (request()->wantsJson()) {

            return response()->json([
                'data' => $entradaSaidas,
            ]);
        }

        return view('entradaSaidas.index', compact('entradaSaidas'));
    }
    public function dataTable()
    {

        $contasPagar = ContasPagar::select(['dtVencimento']);
        $contasReceber = ContasReceber::select(['dtVencimento'])->union($contasPagar);



        return Datatables::of($contasReceber)
            ->editColumn('dtVencimento', function ($contas) {
                return date("d/m/Y", strtotime($contas['dtVencimento']));
            })
            ->make(true);

    }

    public function all()
    {

        $contasPagar = ContasPagar::all();
        $contasReceber = ContasReceber::all();

        return response()->json([
            'pagar' => $contasPagar,
            'receber' => $contasReceber
        ]);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  EntradaSaidaCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(EntradaSaidaCreateRequest $request)
    {

        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_CREATE);

            $entradaSaida = $this->repository->create($request->all());

            $response = [
                'message' => 'EntradaSaida created.',
                'data'    => $entradaSaida->toArray(),
            ];

            if ($request->wantsJson()) {

                return response()->json($response);
            }

            return redirect()->back()->with('message', $response['message']);
        } catch (ValidatorException $e) {
            if ($request->wantsJson()) {
                return response()->json([
                    'error'   => true,
                    'message' => $e->getMessageBag()
                ]);
            }

            return redirect()->back()->withErrors($e->getMessageBag())->withInput();
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $entradaSaida = $this->repository->find($id);

        if (request()->wantsJson()) {

            return response()->json([
                'data' => $entradaSaida,
            ]);
        }

        return view('entradaSaidas.show', compact('entradaSaida'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $entradaSaida = $this->repository->find($id);

        return view('entradaSaidas.edit', compact('entradaSaida'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  EntradaSaidaUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     */
    public function update(EntradaSaidaUpdateRequest $request, $id)
    {

        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_UPDATE);

            $entradaSaida = $this->repository->update($request->all(), $id);

            $response = [
                'message' => 'EntradaSaida updated.',
                'data'    => $entradaSaida->toArray(),
            ];

            if ($request->wantsJson()) {

                return response()->json($response);
            }

            return redirect()->back()->with('message', $response['message']);
        } catch (ValidatorException $e) {

            if ($request->wantsJson()) {

                return response()->json([
                    'error'   => true,
                    'message' => $e->getMessageBag()
                ]);
            }

            return redirect()->back()->withErrors($e->getMessageBag())->withInput();
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $deleted = $this->repository->delete($id);

        if (request()->wantsJson()) {

            return response()->json([
                'message' => 'EntradaSaida deleted.',
                'deleted' => $deleted,
            ]);
        }

        return redirect()->back()->with('message', 'EntradaSaida deleted.');
    }
}
