<?php

namespace App\Http\Controllers;

use App\Repositories\ShiftRepository;
use App\Validators\ShiftValidator;
use Illuminate\Http\JsonResponse;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;


class ShiftController extends Controller
{

    /**
     * @var ShiftRepository
     */
    protected $repository;

    /**
     * @var ShiftValidator
     */
    protected $validator;

    public function __construct(ShiftRepository $repository, ShiftValidator $validator)
    {
        $this->repository = $repository;
        $this->validator  = $validator;
    }


    /**
     * Display a listing of the resource.
     *
     * @return JsonResponse
     */
    public function index()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        $cxTrunos = $this->repository->all();

        if (request()->wantsJson()) {

            return response()->json([
                'data' => $cxTrunos,
            ]);
        }

        return view('cxTrunos.index', compact('cxTrunos'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  CxTrunosCreateRequest $request
     *
     * @return JsonResponse
     */
    public function store(CxTrunosCreateRequest $request)
    {

        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_CREATE);

            $cxTruno = $this->repository->create($request->all());

            $response = [
                'message' => 'CxTrunos created.',
                'data'    => $cxTruno->toArray(),
            ];

            if ($request->wantsJson()) {

                return response()->json($response);
            }

            return redirect()->back()->with('message', $response['message']);
        } catch (ValidatorException $e) {
            if ($request->wantsJson()) {
                return response()->json([
                    'error'   => true,
                    'message' => $e->getMessageBag()
                ]);
            }

            return redirect()->back()->withErrors($e->getMessageBag())->withInput();
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $cxTruno = $this->repository->find($id);

        if (request()->wantsJson()) {

            return response()->json([
                'data' => $cxTruno,
            ]);
        }

        return view('cxTrunos.show', compact('cxTruno'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $cxTruno = $this->repository->find($id);

        return view('cxTrunos.edit', compact('cxTruno'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  CxTrunosUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     */
    public function update(CxTrunosUpdateRequest $request, $id)
    {

        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_UPDATE);

            $cxTruno = $this->repository->update($request->all(), $id);

            $response = [
                'message' => 'CxTrunos updated.',
                'data'    => $cxTruno->toArray(),
            ];

            if ($request->wantsJson()) {

                return response()->json($response);
            }

            return redirect()->back()->with('message', $response['message']);
        } catch (ValidatorException $e) {

            if ($request->wantsJson()) {

                return response()->json([
                    'error'   => true,
                    'message' => $e->getMessageBag()
                ]);
            }

            return redirect()->back()->withErrors($e->getMessageBag())->withInput();
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $deleted = $this->repository->delete($id);

        if (request()->wantsJson()) {

            return response()->json([
                'message' => 'CxTrunos deleted.',
                'deleted' => $deleted,
            ]);
        }

        return redirect()->back()->with('message', 'CxTrunos deleted.');
    }
}
