<?php

namespace App\Http\Resources\Nati;

use Illuminate\Http\Resources\Json\Resource;

class ConferredResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'operator' => $this->operator,
            'id_open' => $this->id,
            'id_pdv' => $this->id_pdv,
            'open_date' => $this->open_date,
            'close_date' => $this->close_date,
            'conferred_date' => $this->update_date,
            'operator_conferred' => $this->detalhes()->first()['operator_conferred'] ? $this->detalhes()->first()['operator_conferred'] : 'SEM OPERADOR',
            'value_closure' => (float)$this->value_closure,
            'value_conferred' => (float)$this->historico()->first()['value_apured'],
            'difference' => (float)$this->historico()->first()['difference'],
        ];
    }
}
