<?php


namespace App\Reports;


use App\Entities\Nati\Customer;

class MyReport extends \koolreport\KoolReport
{
    use \koolreport\laravel\Friendship;

    function settings()
    {
        return array(
            "dataSources"=>array(
                "sqlsrv"=>array(
                    "class"=>'\koolreport\laravel\Eloquent', // This is important
                )
            )
        );
    }

    function setup()
    {
        // Let say, you have "sale_database" is defined in Laravel's database settings.
        // Now you can use that database without any futher setitngs.
        $this->src("sqlsrv")
            ->query(
                Customer::where('flAtivo', true)
                ->where('idCliente', '>', 0)
            )
            ->pipe($this->dataStore("clientes"));
    }
}
