<?php

namespace App\Repositories\Nati;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\Nati\FichaTecnicaRepository;
use App\Entities\Nati\FichaTecnica;
use App\Validators\Nati\FichaTecnicaValidator;

/**
 * Class FichaTecnicaRepositoryEloquent
 * @package namespace App\Repositories;
 */
class FichaTecnicaRepositoryEloquent extends BaseRepository implements FichaTecnicaRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return FichaTecnica::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return FichaTecnicaValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
