<?php

namespace App\Repositories\Nati;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\Nati\LocalizacaoRepository;
use App\Entities\Nati\Localizacao;
use App\Validators\Nati\LocalizacaoValidator;

/**
 * Class LocalizacaoRepositoryEloquent
 * @package namespace App\Repositories\Nati;
 */
class LocalizacaoRepositoryEloquent extends BaseRepository implements LocalizacaoRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Localizacao::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return LocalizacaoValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
