<?php

namespace App\Repositories\Nati;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\nati\RespostaProdutoRepository;
use App\Entities\Nati\RespostaProduto;
use App\Validators\Nati\RespostaProdutoValidator;

/**
 * Class RespostaProdutoRepositoryEloquent.
 *
 * @package namespace App\Repositories\Nati;
 */
class RespostaProdutoRepositoryEloquent extends BaseRepository implements RespostaProdutoRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return RespostaProduto::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return RespostaProdutoValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
