<?php
/**
 * Created by PhpStorm.
 * User: clecio
 * Date: 14/06/2017
 * Time: 10:29
 */

namespace App\Services;

use App\Repositories\ContasPagarRepository;
use App\Validators\ContasPagarValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class ContasPagarService
{
    private $repository;
    private $validator;

    public function __construct(ContasPagarRepository $repository, ContasPagarValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;

    }

    public function get()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        $contasPagar = $this->repository->all();

        return $contasPagar;
    }

    public function getById($idContasPagar, $idFornecedor)
    {
        $contasPagar = $this->repository->findWhere([
            'idContasPagar' => $idContasPagar,
            'idFornecedor' => $idFornecedor
        ]);

        return  $contasPagar['0'];

    }

    public function insert($request)
    {
        $totalParcelas = intval($request['nrTotalParcelas']);

        if (isset($request['flBaixarAgora'])) {
            $flAtivo = 0;
            $dtPagamento = Carbon::now();
            $vrPago = floatval($request['vrDocumento']) / $totalParcelas;
        } else {
            $flAtivo = 1;
            $dtPagamento = null;
            $vrPago = 0.00;
        }

        $dtLancamento = str_replace('/','-',$request['dtLancamento']);
        $dtVencimento = str_replace('/','-',$request['dtVencimento']);
        $dtPrevisao = str_replace('/','-',$request['dtPrevisao']);

        $contasPagar = [

            "idContasPagar" => $this->getNextId($request['idFornecedor']) + 1,
            "idFornecedor"  => $request['idFornecedor'],
            "idTipoConta"   => $request['idTipoConta'],
            "idCentroCusto" => $request['idCentroCusto'],
            "idAbertura"    => $request['idAbertura'],
            "dtLancamento"  => Carbon::parse($dtLancamento),
            "dtVencimento"  => Carbon::parse($dtVencimento),
            "dtPagamento"   => $dtPagamento,
            "nrParcela"     => 1,
            "nrTotalParcelas"=> $request['nrTotalParcelas'],
            "vrDocumento"   => $request['vrDocumento'],
            "vrJuros"       => 0.00,
            "flJuros"       => null,
            "vrPago"        => $vrPago,
            "flPago"        => isset($request['flPago']) ? $request['flPago'] : 0,
            "flAtivo"       => $flAtivo,
            "stOperador"    => $request['stOperador'] || 'DEFAULT',
            "stObservacao"  => $request['stObservacao'] || '',
            "stDocumento"   => $request['stDocumento'] || '',
            "stTipoBaixa"   => 'I',
            "stTipoJuros"   => 'P',
            "stObservacaoBaixa" => null,
            "vrDescontoLancamento" => $request['vrDescontoLancamento'],
            "idContaBancaria" => 0,
            "idTipoPagamento" => $request['idTipoPagamento'],
            "idConta"       => $request['idConta'],
            "idCheque"      => 0,
            "idContasPagarRecorrente" => 0,
            "idMovimentacao" => 0,
            "flAutorizado" => 0,
            "nrPrioridade" => $request['nrPrioridade'],
            "dtPrevisao"   => Carbon::parse($dtPrevisao),
            "dtAlteracao" => Carbon::now(),
            "vrEncargos" => 0.00,
            "vrOutros" => 0.00,
            "vrDescontos" => 0.00,
        ];

        $this->validator->with($contasPagar)->passesOrFail(ValidatorInterface::RULE_CREATE);
        if ($totalParcelas > 1) {
            $lancamentos = [];
            $valor = $request['vrDocumento'];
            for ($i = 1; $i <= $totalParcelas; $i++) {
                $contasPagar['idContasPagar'] =  $this->getNextId($request['idFornecedor']) + 1;
                $contasPagar['nrParcela'] = $i;
                $contasPagar['vrDocumento'] = $valor / $totalParcelas;
                array_push($lancamentos, $this->repository->create($contasPagar));
            }
            return $lancamentos;
        } else {
            return $this->repository->create($contasPagar);
        }
    }

    public function update($data, $id)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id)
    {
        return $this->repository->update(['flAtivo' => "0"], $id);
    }

    public function getNextId($fornecedor)
    {
        if($this->repository->all()->where('idFornecedor', $fornecedor)->last()){
           return $idContasPagar = $this->repository->all()->where('idFornecedor', $fornecedor)->last()->idContasPagar;
        }else{
           return $idContasPagar = 0;
        }

    }

}