<?php

namespace App\Transformers;

use App\Entities\ProductComposite;
use League\Fractal\TransformerAbstract;

/**
 * Class ProductCompositeTransformer.
 *
 * @package namespace App\Transformers;
 */
class ProductCompositeTransformer extends TransformerAbstract
{
    /**
     * Transform the ProductComposite entity.
     *
     * @param \App\Entities\ProductComposite $model
     *
     * @return array
     */
    public function transform(ProductComposite $model)
    {
        return [
            'id'         => (int) $model->id,

            /* place your other model properties here */

            'created_at' => $model->created_at,
            'updated_at' => $model->updated_at
        ];
    }
}
