<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class V6022 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->changeFormasPagamentoTable();
        $this->changeTelefonesTable();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $this->revertFormasPagamentoTable();
    }

    public function changeFormasPagamentoTable()
    {
        if(Schema::hasTable('cx_FormasPagamento')) {
            if (!Schema::hasColumn('cx_FormasPagamento', 'publicKey')) {
                Schema::table('cx_FormasPagamento', function (Blueprint $table) {
                    $table->string('publicKey', 100)->nullable();
                });
            }
            if (!Schema::hasColumn('cx_FormasPagamento', 'accessToken')) {
                Schema::table('cx_FormasPagamento', function (Blueprint $table) {
                    $table->string('accessToken', 100)->nullable();
                });
            }
            Schema::table('cx_FormasPagamento', function (Blueprint $table) {
                $table->string('stDescricaoFiscal', 25)->nullable()->change();
                $table->string('stFaturado', 50)->nullable()->change();
                $table->boolean('flFaturado')->nullable()->change();
                $table->boolean('flVendaBrowser')->nullable()->change();
                DB::statement($this->deleteConstraintvrTaxa());
                $table->decimal('vrTaxa',5,2)->nullable()->change();
            });
        }
    }

    public function revertFormasPagamentoTable(){
        if(Schema::hasTable('cx_FormasPagamento')) {
            if (Schema::hasColumn('cx_FormasPagamento', 'publicKey')) {
                Schema::table('cx_FormasPagamento', function (Blueprint $table) {
                    $table->dropColumn('publicKey');
                });
            }

            if (Schema::hasColumn('cx_FormasPagamento', 'accessToken')) {
                Schema::table('cx_FormasPagamento', function (Blueprint $table) {
                    $table->dropColumn('accessToken');
                });
            }
        }
    }

    public function changeTelefonesTable(){
        if(Schema::hasTable('dlv_Telefones')) {
            if (Schema::hasColumn('dlv_Telefones', 'nrRamal')) {
                Schema::table('dlv_Telefones', function (Blueprint $table) {
                    $table->smallInteger('nrRamal')->nullable()->change();
                });
            }
        }
    }

    public function deleteConstraintVrTaxa()
    {
        return "DECLARE @MyCursor CURSOR;
                DECLARE @FieldName varchar(200);
                DECLARE @tableName varchar(200) = 'cx_FormasPagamento';
                DECLARE @Column varchar(200) = 'vrTaxa';
                DECLARE @ShortColumn varchar(200) = 'vrTax';
                DECLARE @Cols AS int = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = @tableName AND COLUMN_NAME = @Column AND TABLE_SCHEMA='DBO')

                IF @Cols > 0
                BEGIN
                    SET @MyCursor = CURSOR FOR
                        SELECT name from sys.default_constraints where parent_object_id =OBJECT_ID(@tableName) AND name like '%' + @ShortColumn + '%'
                    OPEN @MyCursor
                    FETCH NEXT FROM @MyCursor
                    INTO @FieldName
                    WHILE @@FETCH_STATUS = 0
                    BEGIN
                    EXEC('ALTER TABLE ['+ @tableName +'] drop constraint [' + @FieldName + ']')
                        FETCH NEXT FROM @MyCursor
                        INTO @FieldName
                    END
                    --EXEC('ALTER TABLE ['+ @tableName +'] drop column [' + @Column + ']')
                END";
    }
}
