<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Carbon\Carbon;

class CreatePrdRespostas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('prd_Respostas')) {
            Schema::create('prd_Respostas', function (Blueprint $table) {
                $table->id('idResposta');
                $table->bigInteger('idPergunta');
                $table->unsignedInteger('idTipoResposta');
                $table->unsignedInteger('idRespostaObservacao')->nullable();
                $table->unsignedInteger('idRespostaProduto')->nullable();
                $table->dateTime('dtAlteracao')->default(DB::raw('GETDATE()'));
                $table->boolean('flAtivo')->default(1);
                $table->integer('nrOrdem')->default(1);

                $table->foreign('idTipoResposta')->references('idTipoResposta')->on('prd_TipoResposta');
                $table->foreign('idPergunta')->references('idPergunta')->on('prd_perguntas');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Respostas');
    }
}
