<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdItensReceitaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_ItensReceita')) {

            DB::statement('CREATE TABLE [dbo].[prd_ItensReceita](
                  [dtAlteracao] [datetime] NOT NULL,
                  [idItem] [int] NOT NULL,
                  [idReceita] [int] NOT NULL,
                  [idProduto] [int] NOT NULL,
                  [nrQuantidade] [decimal](9, 3) NOT NULL,
                  CONSTRAINT [PK_prd_ItensReceita] PRIMARY KEY CLUSTERED
                    (
                      [idItem] ASC,
                      [idReceita] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_ItensReceita');

    }
}
