<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
<link href="resources/css/toastr.css" rel="stylesheet"/>
<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
<link href="resources/css/custom.css" rel="stylesheet"/>
<?php
error_reporting(0);

require_once "functions.php";

if (strstr($_SERVER['SCRIPT_NAME'], "index.php") === false)
{
	redirect("index.php");
	die;
}

permission(59);

$dt_dia = intval($_POST['dt_dia']);
$dt_mes = intval($_POST['dt_mes']);
$dt_ano = intval($_POST['dt_ano']);
?>
<div class="col-md-8 col-md-offset-2" align="center" style="padding-left: 0px">
	<h2>Pendências para Fabricar</h2>
	<center><h4>Lista de produtos internos (código menor que 999999) referênte a atendimentos agêndados</h4></center>
</div>


<form name="selectPedido" method="post" action="?sec=paraFabricar">
	<div class="col-md-12">	
	<table class="tableForm" style="width: auto;" align="center">
		<tr>
			<td>
			<h4>Selecionar um dia específico:
			<input type="text" size="1" name="dt_dia" maxlength="2" value="<?=(!$dt_dia ? date("d") : $dt_dia)?>" onkeypress="return removeInvalidChars(event, '0123456789');" /> /
			<input type="text" size="1" name="dt_mes" maxlength="2" value="<?=(!$dt_mes ? date("m") : $dt_mes)?>" onkeypress="return removeInvalidChars(event, '0123456789');" /> /
			<input type="text" size="3" name="dt_ano" maxlength="4" value="<?=(!$dt_ano ? date("Y") : $dt_ano)?>" onkeypress="return removeInvalidChars(event, '0123456789');" />
			<button class="btn btn-primary">Filtrar</button>
			<?
			if ($_POST)
			{
				?>
				<button class="btn btn-primary" onClick="document.location='?sec=paraFabricar'">Exibir Todos</button>
				<hr>
				<?
			}
			?>
			</td>
		</tr>		
	</table>
	</div>
	<br>
	<table class="table table-bordered">
			<thead>
			<th>PRODUTO</th>
			<th>QUANTIDADE</th>
			<th>OBSERVAÇÃO</th>
		</thead>
		<tbody>
		<?
		$sql = "SELECT I.stOBS, P.stProduto, M.stMedida, M.flFracionado, SUM(I.nrQuantidade) AS nrQuantidade, DAY(A.dtAgendarPedido) AS dtDia, MONTH(A.dtAgendarPedido) AS dtMes, YEAR(A.dtAgendarPedido) AS dtAno
				FROM dlv_Atendimentos A
				INNER JOIN dlv_Itens I ON A.idAtendimento = I.idAtendimento
				INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
				INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida
				INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
				WHERE A.flAgendarPedido = 'true' AND A.stStatus IN ('F','P') AND C.idCodigo <> '-100' AND C.idCodigo <= '999999' AND A.flAtivo = 'true' ".($_POST ? "AND A.dtAgendarPedido BETWEEN '$dt_ano-$dt_mes-$dt_dia 00:00:00' AND '$dt_ano-$dt_mes-$dt_dia 23:59:59' " : "")."
				GROUP BY I.stOBS, P.stProduto, M.stMedida, M.flFracionado, DAY(A.dtAgendarPedido), MONTH(A.dtAgendarPedido), YEAR(A.dtAgendarPedido)
				ORDER BY YEAR(A.dtAgendarPedido), MONTH(A.dtAgendarPedido), DAY(A.dtAgendarPedido), P.stProduto";

		$res = mssql_query($sql);
		$cnt = mssql_num_rows($res);
		
		if ($cnt > 0)
		{
			$old = "";
			
			while ($arr = mssql_fetch_array($res))
			{
				$stStatus = "";
				$nrOciosidade = 0;
				
				switch ($arr['stStatus'])
				{
					case "F":
						$stStatus = "FORMULAÇÃO";
						break;
					case "P":
						$stStatus = "PENDENTE";
						break;
				}
				
				if ($arr['flFracionado'])
					$nrQuantidade = number_format($arr['nrQuantidade'], 3, ".", "");
				else
					$nrQuantidade = intval($arr['nrQuantidade']);
				
				if ($arr['dtAno']."-".$arr['dtMes']."-".$arr['dtDia'] != $old)
				{
					?>
					<tr>
						<td colspan="3" class="trTitleLight" align="center"><?=$arr['dtDia']."/".$arr['dtMes']."/".$arr['dtAno']?></td>
					</tr>
					<?
					$old = $arr['dtAno']."-".$arr['dtMes']."-".$arr['dtDia'];
				}
				
				echo "<tr bgcolor=".(($c++&1)? "#FFFFFF" : "#F0F0F0").">";
				?>
				<td><?=$arr['stProduto']?></td>
				<td><?=$nrQuantidade." ".$arr['stMedida']?></td>
				<td><?=$arr['stOBS']?></td>
				<?
				echo "</tr>";
			}
		}
		else
		{
			?>
			<tr>
				<td colspan="6"><center>NENHUM PENDÊNCIA ENCONTRADA</center></td>
			</tr>
			<?
		}
		?>
		<tbody>
	</table>
	</form>
<script src="resources/js/jquery-2.1.4.js"></script>
<script src="resources/js/bootstrap.min.js"></script>
<script src="resources/js/datatables.min.js"></script>
<script src="resources/js/toastr.js"></script>
<script src="resources/js/sweetalert2.min.js"></script>
<script src="resources/js/functions.js"></script>