<?php

namespace App\Console\Commands;

use App\Entities\Manager;
use Carbon\Carbon;
use Illuminate\Console\Command;

class CloseManager extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'close:pdv';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Encerra os caixas sem conferência';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $movimentos = Manager::where('flConferencia', false)
            ->where('flAberto', false)
            ->where('dtFechamento', '<=', Carbon::now()->subDays(30))
            ->get();

        foreach ($movimentos as $movimento){
            $movimento->flConferencia = true;
            $movimento->dtAlteracao = Carbon::now();
            $movimento->stOBS = 'FINALIZADO AUTOMATICAMENTO PELO SISTEMA';
            $movimento->save();
        }
    }
}
