<?php

namespace App\Console\Commands;

use App\Services\IuguService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Cache;

class GetInvoices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'invoices:get';

    private $service;
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Busca as faturas na Iugu';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(IuguService $service)
    {
        parent::__construct();
        $this->service = $service;
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $invoices = $this->service->getInvoices();
        Cache::forever('INVOICES', $invoices);
        return $invoices;
    }
}
