<?php

namespace App\Entities\Nati;

use App\Entities\CEP;
use App\Entities\Delivery\Phone;
use App\Entities\Sale;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Customer extends Model implements Transformable
{

    use TransformableTrait;

    protected $table = "dlv_clientes";
    protected $primaryKey = 'idCliente';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idCliente',
        'stSenha',
        'flPessoaJuridica',
        'stCliente',
        'stNomeFantasia',
        'stSocios',
        'stContato',
        'stCPF_CNPJ',
        'stRG_IE',
        'nrNumero',
        'stComplemento',
        'idCEP',
        'stEmail',
        'stSite',
        'flBloqueado',
        'stBanco',
        'stAgencia',
        'stConta',
        'stContatoBanco',
        'stTelefoneBanco',
        'stOBS',
        'flAtivo',
        'stVencimentosFatura',
        'dtCadastro',
        'stOperador',
        'vrSaldo',
        'vrLimite',
        'flContaAssinada',
        'dtUltimaCompra',
        'dtUltimaAlteracao',
        'stOperadorUltimaAlteracao',
        'stSexo',
        'flFuncionario',
        'idCategoriaFuncionario',
        'dtUltimoDeposito',
        'stTrilha2',
        'idEmpresa',
        'stMatricula',
        'stFilial',
        'idMotivoBloqueio',
        'vrEntrega',
        'binDigital',
        'vrDescontoVenda',
        'stOBSPrint',
        'stCEP',
        'vrSaldoPagamento',
        'stDigital',
        'nrTipoTerceiro',
        'dtAlteracao',
        'stOBSDelivery',
        'idClienteIntegracao',
        'stEmailGerente',
        'dtNascimento',
        'stEmpresa',
        'idEmpresaContaAssinada',
        'sync'
    ];

    protected $hidden = [
        'flNutricional',
        'sync',
        'binDigital',
        'stDigital',
        'stOBSPrint',
        'stTrilha2',
        'stSocios',
        'stSenha',
        'flFuncionario',
        'idCategoriaFuncionario',
        'idEmpresa',
        'stMatricula',
        'stFilial',
        'binDigital',
        'stOBSPrint',
        'stDigital',
        'idClienteIntegracao',
        'stEmailGerente',
        'dtNascimento',
        'stEmpresa',
        'idEmpresaContaAssinada',
    ];

    protected $casts = [
        'flPessoaJuridica' => 'boolean',
        'conta_assinada' => 'boolean',
        'flBloqueado' => 'boolean',
        'flAtivo' => 'boolean',
        'flContaAssinada' => 'boolean',
    ];

    public function getNextId()
    {
        return Customer::max('idCliente') + 1;
    }

    protected $appends = [
        'vencFatura'
    ];

    public function getVencFaturaAttribute()
    {
        switch ($this->stVencimentosFatura) {
            case '@@@@':
                return "POR COMPRA";
                break;
            case 'D@@@':
                return "DIARIO";
                break;
            case '7@22':
                return "QUINZENAL";
                break;
            case '7@':
                return "MENSAL";
                break;
            case '1':
                return "DOMINGO";
                break;
            case '2':
                return "SEGUNDA-FEIRA";
                break;
            case '3':
                return "TERÇA-FEIRA";
                break;
            case '4':
                return "QUARTA-FEIRA";
                break;
            case '5':
                return "QUINTA-FEIRA";
                break;
            case '6':
                return "SEXTA-FEIRA";
                break;
            case '7':
                return "SÁBADO";
                break;
            default:
                return "NÃO POSSUI DATA";
        }
    }

    public function endereco()
    {
        return $this->hasOne(CEP::class, 'idCEP', 'idCEP');
    }

    public function telefones()
    {
        return $this->hasMany(Phone::class, 'idCliente')->where('flAtivo', true);
    }

    public function vendas()
    {
        return $this->hasMany(Sale::class, 'idCliente', 'idCliente')
            ->orderBy('dtData', 'DESC');
    }
}
