<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Sangria extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'cx_Sangrias';
    protected $primaryKey = ['idSangria', 'idAbertura'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idSangria',
        'idAbertura',
        'idOperador',
        'dtData',
        'vrSangria',
        'idFormaPagamento',
        'idOperadorAutorizador',
        'flAtivo',
        'dtAlteracao',
        'operador',
        'formaPagamento'
    ];

//    protected $appends = [
//        'id',
//        'id_open',
//        'id_operator',
//        'date',
//        'value_sangria',
//        'id_payment',
//        'id_operator_authorizer',
//        'active',
//        'update_date',
//        'operator',
//        'operator_authorizer',
//        'payment'
//    ];

//    protected $hidden = [
//        'idSangria',
//        'idAbertura',
//        'idOperador',
//        'dtData',
//        'vrSangria',
//        'idFormaPagamento',
//        'idOperadorAutorizador',
//        'flAtivo',
//        'dtAlteracao',
//        'operador',
//        'formaPagamento'
//    ];
    protected $casts = [
        'flAtivo' => 'boolean',
        'vrSangria' => 'float',
    ];

//    protected $maps = [
//        'id' => 'idSangria',
//        'id_open' => 'idAbertura',
//        'id_operator' => 'idOperador',
//        'date' => 'dtData',
//        'value_sangria' => 'vrSangria',
//        'id_payment' => 'idFormaPagamento',
//        'id_operator_authorizer' => 'idOperadorAutorizador',
//        'active' => 'flAtivo',
//        'update_date' => 'dtAlteracao',
//        'operator' => 'operador.name',
//        'operator_authorizer' => 'authorizer.name',
//        'payment' => 'formaPagamento.payment'
//    ];

    public function operador()
    {
        return $this->hasOne(User::class, 'idOperador', 'idOperador');
    }

    public function authorizer()
    {
        return $this->hasOne(User::class, 'idOperador', 'idOperadorAutorizador');
    }

    public function abertura()
    {
        return $this->belongsTo(Manager::class, 'idAbertura', 'idAbertura');
    }

    public function formaPagamento()
    {
        return $this->belongsTo(PaymentMethod::class, 'idFormaPagamento', 'idFormaPagamento');
    }

}
