<?php


namespace App\Exports\Nati;

use App\Entities\Nati\Product;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromArray;

class ProductsExportLinx implements FromArray
{

    public function array() : array
    {
        $products = DB::select("
            select
            distinct(idCodigo) as 'Código Barras',
            '' as 'Código Rápido',
            p.descricao as 'Descrição Completa',
            p.descricao as 'Descrição Resumida',
            p.ncm as 'Código NCM',
            p.cest as 'Código CEST',
            p.medida as 'Unidade Venda',
            REPLACE(p.vrUnitario,'.',',') as 'Preço Venda',
            case
            when p.cstIcms = '101' then '00'
            when p.cstIcms = '102' then '10'
            when p.cstIcms = '103' then '20'
            when p.cstIcms = '201' then '30'
            when p.cstIcms = '202' then '40'
            when p.cstIcms = '203' then '41'
            when p.cstIcms = '300' then '50'
            when p.cstIcms = '400' then '51'
            when p.cstIcms = '500' then '60'
            when p.cstIcms = '900' then '70'
            else '90'
            end as 'CST ICMS',
            p.aliquotaIcms as 'Alíquota Icms',
            '' as 'Redução Alíquota ICMS'
            from prd_Codigos C
            inner join vw_produtos P on p.idProduto = c.idProduto
            where len(REPLACE(LTRIM(REPLACE(idCodigo, '0', ' ')), ' ', '0')) = 13
        ");

        array_unshift($products, [
            'Código Barras',
            'Código Rápido',
            'Descrição Completa',
            'Descrição Resumida',
            'Código NCM',
            'Código CEST',
            'Unidade Venda',
            'Preço Venda',
            'CST ICMS',
            'Alíquota Icms',
            'Redução Alíquota ICMS',
        ]);

        return $products;
    }
}
