<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\ComandaCreateRequest;
use App\Http\Requests\ComandaUpdateRequest;
use App\Repositories\ComandaRepository;
use App\Validators\ComandaValidator;

/**
 * Class ComandasController.
 *
 * @package namespace App\Http\Controllers;
 */
class ComandasController extends Controller
{
    /**
     * @var ComandaRepository
     */
    protected $repository;

    /**
     * @var ComandaValidator
     */
    protected $validator;

    /**
     * ComandasController constructor.
     *
     * @param ComandaRepository $repository
     * @param ComandaValidator $validator
     */
    public function __construct(ComandaRepository $repository, ComandaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator  = $validator;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        $comandas = $this->repository->all();


            return response()->json([
                'data' => $comandas,
            ]);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  ComandaCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     *
     * @throws \Prettus\Validator\Exceptions\ValidatorException
     */
    public function store(ComandaCreateRequest $request)
    {
        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_CREATE);

            $comanda = $this->repository->create($request->all());

            $response = [
                'message' => 'Comanda created.',
                'data'    => $comanda->toArray(),
            ];

            if ($request->wantsJson()) {

                return response()->json($response);
            }

            return redirect()->back()->with('message', $response['message']);
        } catch (ValidatorException $e) {
            if ($request->wantsJson()) {
                return response()->json([
                    'error'   => true,
                    'message' => $e->getMessageBag()
                ]);
            }

            return redirect()->back()->withErrors($e->getMessageBag())->withInput();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $comanda = $this->repository->find($id);

        if (request()->wantsJson()) {

            return response()->json([
                'data' => $comanda,
            ]);
        }

        return view('comandas.show', compact('comanda'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $comanda = $this->repository->find($id);

        return view('comandas.edit', compact('comanda'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  ComandaUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     *
     * @throws \Prettus\Validator\Exceptions\ValidatorException
     */
    public function update(ComandaUpdateRequest $request, $id)
    {
        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_UPDATE);

            $comanda = $this->repository->update($request->all(), $id);

            $response = [
                'message' => 'Comanda updated.',
                'data'    => $comanda->toArray(),
            ];

            if ($request->wantsJson()) {

                return response()->json($response);
            }

            return redirect()->back()->with('message', $response['message']);
        } catch (ValidatorException $e) {

            if ($request->wantsJson()) {

                return response()->json([
                    'error'   => true,
                    'message' => $e->getMessageBag()
                ]);
            }

            return redirect()->back()->withErrors($e->getMessageBag())->withInput();
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $deleted = $this->repository->delete($id);

        if (request()->wantsJson()) {

            return response()->json([
                'message' => 'Comanda deleted.',
                'deleted' => $deleted,
            ]);
        }

        return redirect()->back()->with('message', 'Comanda deleted.');
    }
}
