<?php


namespace App\Http\Controllers\Financeiro;


use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Services\Delivery\CustomerService;
use App\Http\Requests\CustomerCreateRequest;
use App\Http\Requests\CustomerUpdateRequest;
use Prettus\Validator\Exceptions\ValidatorException;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class CustomersController extends Controller
{
    protected $service;

    public function __construct(CustomerService $service)
    {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request)
    {
        try {
            return response()->json($this->service->get($request->query()));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }
    /**
     * get customer by phone or name
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function search(string $data)
    {
        try {
            return response()->json($this->service->filter($data));
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    public function getNextId()
    {
        return response()->json($this->service->getNextId());
    }

    /**
     * Store a newly created resource in storage.
     * @param CustomerCreateRequest $request
     * @return JsonResponse
     */
    public function store(CustomerCreateRequest $request)
    {
        // dd($request);
        try {
            return $this->service->insert($request->all());
        }catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
        catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }


    /**
     * Show the specified resource.
     * @param $id
     * @return JsonResponse
     */
    public function show($id)
    {
        try {
            return $this->service->getById($id);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Update the specified resource in storage.
     * @param CustomerUpdateRequest $request
     * @param                       $id
     * @return JsonResponse
     */
    public function update(CustomerUpdateRequest $request, $id)
    {
        // dd($request);
        try {

            return response()->json($this->service->update($request->all(), $id));

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param $id
     * @return JsonResponse
     */
    public function destroy($id)
    {
        try {
            $response = $this->service->delete($id);
            return response()->json([
                'data' => $response,
                'message' => 'Success'
            ]);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }


}
