<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\DesenfilaConfigRepository;
use App\Entities\DesenfilaConfig;
use App\Validators\DesenfilaConfigValidator;

/**
 * Class DesenfilaConfigRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class DesenfilaConfigRepositoryEloquent extends BaseRepository implements DesenfilaConfigRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return DesenfilaConfig::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return DesenfilaConfigValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
