<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Entities\Delivery\MobyoConfig;
use App\Validators\MobyoConfigValidator;

/**
 * Class MasterRepositoryEloquent
 * @package namespace App\Repositories;
 */
class MobyoConfigRepositoryEloquent extends BaseRepository implements MobyoConfigRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return MobyoConfig::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return MobyoConfigValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
