<?php

namespace App\Repositories\Nati;

use App\Entities\Nati\StockBalance;
use App\Validators\Nati\StockBalanceValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class StockBalanceRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class StockBalanceRepositoryEloquent extends BaseRepository implements StockBalanceRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return StockBalance::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return StockBalanceValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }

}
