<?php

namespace App\Services;

use App\Entities\Financeiro\Conta;
use App\Repositories\ContaRepository;
use App\Validators\ContaValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class ContaService
{
    private $repository;
    private $validator;

    public function __construct(ContaRepository $repository ,ContaValidator $validator)
    {
        $this->validator = $validator;
        $this->repository = $repository;
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));

    }

    public function get()
    {
        return $this->repository->all();
    }
    public function getById($id)
    {
        return $this->repository->find($id);
    }
    public function getBySubId($id)
    {
        return $this->repository->findWhere(['idTipoConta' => $id]);
    }

    public function insert($data)
    {

        $data = [
            'idConta'       => $this->nextId(),
            'idTipoConta'  => $data['idTipoConta'],
            'stConta'       => $data['stConta'],
            'dtAlteracao'       => Carbon::now()
        ];
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);
        return $this->repository->create($data);
    }

    public function update($data, $id) {

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id) {

        return $this->repository->delete($id);
    }

    public function nextId(){
        return Conta::max('idConta') + 1;
    }

}
