<?php

namespace App\Services\Nati;

use App\Entities\Nati\ProdutoPergunta;
use App\Repositories\Nati\ProdutoPerguntaRepository;
use App\Services\Service;
use App\Validators\Nati\ProdutoPerguntaValidator;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;

class ProdutoPerguntaService extends Service
{
    private $repository;
    private $validator;

    /**
     * CategoriaService constructor.
     * @param ProdutoPerguntaRepository $repository
     */
    public function __construct(ProdutoPerguntaRepository $repository)
    {
        $this->repository = $repository;
    }

    public function linkProductQuestion($question, $idProduto)
    {
        if(!$idProduto || !$question['idPergunta']) {
            return;
        }
        $alreadyExists = ProdutoPergunta::where('idProduto', $idProduto)->where('idPergunta', $question['idPergunta'])->first();
        if($alreadyExists) {
            return;
        }

        $arr = [
            'idProduto' => $idProduto,
            'idPergunta' => $question['idPergunta'],
            'nrOrder' => $question['nrOrdem'],
            'dtAlteracao' => Carbon::now(),
        ];
        return $this->repository->create($arr);
    }
    public function unlinkProductQuestion($idProduct, $idQuestion)
    {
        $alreadyExists = ProdutoPergunta::where('idProduto', $idProduct)->where('idPergunta', $idQuestion)->first();;
        if(!$alreadyExists) {
            return;
        }
        return $this->repository->where('idProduto', $idProduct)->where('idPergunta', $idQuestion)->delete();
    }

    public function deleteByIdPergunta($idPergunta)
    {
          $this->repository->where('idPergunta', $idPergunta)->delete();
    }
    public function deleteByProduct($idProduto)
    {
            $this->repository->where('idProduto', $idProduto)->delete();
    }
}
