<?php

namespace App\Services;

use Carbon\Carbon;
use App\Entities\User;
use Illuminate\Support\Str;
use App\Validators\UserValidator;
use Illuminate\Support\Facades\DB;
use App\Repositories\UserRepository;
use Illuminate\Support\Facades\Cache;
use App\Repositories\ProfileRepository;
use Prettus\Validator\Contracts\ValidatorInterface;

class UsersService
{
    protected $repository;
    protected $validator;
    protected $repositoryProfle;
    protected $user;

    public function __construct(UserRepository $repository, UserValidator $validator, ProfileRepository $repositoryProfle)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->repositoryProfle = $repositoryProfle;
        $this->user = auth()->user();
    }

    public function get($request)
    {
        $key = md5(json_encode($request));
        if (Cache::tags(['ListaUsuarios'])->has($key)) {
            return Cache::tags(['ListaUsuarios'])->get($key);
        } else {
            $order = !$request['order'] ? 'ASC' : Str::upper($request['order']);
            $response = null;
            if (isset($request['filter']) && strlen($request['filter']) > 0) {
                $filter = $request['filter'];
                $response = User::join('op_Perfis', 'op_Perfis.idPerfil', '=', 'op_operadores.idPerfil')
                    ->select(['op_operadores.*', 'op_perfis.stDescricao'])
                    ->where('op_operadores.flAtivo', true)
                    ->where('op_operadores.idOperador', '<>', 99)
                    ->where('op_operadores.idOperador', '>', 0)
                    ->where(function ($query) use ($filter) {
                        $query->where('op_operadores.stNome', 'LIKE', '%' . $filter . '%')
                            ->orWhere('op_operadores.stApelido', 'LIKE', '%' . $filter . '%');
                    })
                    ->orderBy('op_operadores.idOperador', $order)
                    ->offset($request['offset'])
                    ->paginate($request['limit'], $request['page']);
            }else {
                $response = User::join('op_Perfis', 'op_Perfis.idPerfil', '=', 'op_operadores.idPerfil')
                    ->select(['op_operadores.*', 'op_perfis.stDescricao'])
                    ->where('op_operadores.flAtivo', true)
                    ->where('op_operadores.idOperador', '<>', 99)
                    ->where('op_operadores.idOperador', '>', 0)
                    ->orderBy('op_operadores.idOperador', $order)
                    ->offset($request['offset'])
                    ->paginate($request['limit'], $request['page']);
            }
            Cache::tags(['ListaUsuarios'])->put($key, $response, 1440);
            return $response;
        }
    }

    public function create($data)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);
        $password = strtoupper(md5($data['stSenha']));

        $data['flAtivo'] = true;
        $data['nrAcessos'] = 0;
        $data['stNome'] = isset($data['stNome']) ? $data['stNome'] : ' ';
        $data['stCartao'] =  isset($data['stCartao']) ? $data['stCartao'] : ' ';
        $data['stTelefone1'] =  isset($data['stTelefone1']) ? $data['stTelefone1'] : ' ';
        $data['stTelefone2'] =  isset($data['stTelefone2']) ? $data['stTelefone2'] : ' ';

        $data['stSenha'] = $password;
        $data['dtAdmissao'] = isset($data['dtAdmissao']) ? Carbon::createFromFormat('d/m/Y', $data['dtAdmissao'])->toDateTimeString() : Carbon::now();
        $data['dtAlteracao'] = Carbon::now()->toDateTimeString();
        $data['dtUltimoacesso'] = null;

        $request = array_map('strtoupper', $data);
        $response = $this->repository->create($request);
        unset($response->password);

        //Incluindo Permissoes !Legado!
        $permissoes = json_decode(DB::select("SELECT stIds FROM op_Perfis WHERE idPerfil = " . $data['idPerfil'])[0]->stIds);
        $id = $data['idOperador'];
        foreach($permissoes as $permissao){
            DB::insert("INSERT INTO op_Acessos (idOperador, idPermissao) VALUES ($id, $permissao)");
        }

        return $response;
    }

    public function update($data, $id)
    {
        $data['stCartao'] =  isset($data['stCartao']) ? $data['stCartao'] : ' ';
        $data['dtAlteracao'] = Carbon::now()->toDateTimeString();
        $data['dtAdmissao'] = Carbon::createFromFormat('d/m/Y', $data['dtAdmissao'])->toDateTimeString();
        $request = array_map('strtoupper', $data);
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        foreach($request as $key => $value){
            if ($value == null || $value == ''){
                $request[$key] = " ";
            }
        }

        //Atualizando Permissoes !LEGADO"
        $id = $data['idOperador'];
        DB::statement("DELETE FROM op_Acessos WHERE idOperador = $id");
        $permissoes = json_decode(DB::select("SELECT stIds FROM op_Perfis WHERE idPerfil = " . $data['idPerfil'])[0]->stIds);
        foreach($permissoes as $permissao){
            DB::insert("INSERT INTO op_Acessos (idOperador, idPermissao) VALUES ($id, $permissao)");
        }
        Cache::tags(['ListaUsuarios'])->flush();
        return $this->repository->update($request, $id);
    }

    public function getById($id)
    {
        return $this->repository->hidden(['password'])->find($id);
    }

    public function getNextId()
    {
        return User::max('idOperador') + 1;
    }

    public function changePwd($id,$data){
        $user = User::find($id);
        $user->stSenha = md5($data);
        return $user->save();
    }

    public function delete($id)
    {
        $user = User::find($id);
        $user->flAtivo = false;
        $user->save();
        Cache::tags(['ListaUsuarios'])->flush();
        return $user;
    }

    public function storeCard($idUser, $codCard){
        $user = User::find($idUser);
        $user->stCartao = $codCard;
        $user->save();

        return $user;
    }

    public function getCashiers()
    {
        $cashiers = DB::table('op_operadores')
                        ->join('cx_gerenciador', 'op_operadores.idOperador', '=', 'cx_gerenciador.idOperador')
                        ->select('op_operadores.idOperador', 'op_operadores.stApelido')
                        ->groupBy('op_operadores.idOperador', 'op_operadores.stApelido')
                        ->orderBy('op_operadores.stApelido')
                        ->get();

        return $cashiers;
    }
}
