<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOpPermissoesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('op_Permissoes')) {
            Schema::create('op_Permissoes', function (Blueprint $table) {
                $table->smallInteger('idPermissao', false, true);
                $table->string('stPermissao', 50);
                $table->smallInteger('idCategoria', false, true);
                $table->string('stDescricao', 150);
                $table->dateTime('dtAlteracao')->default(Carbon::now());

                $table->primary('idPermissao');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('op_Permissoes');

    }
}
