<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxFichaPagamentosTempTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_FichaRecebimentos_Temp')) {
            Schema::create('cx_FichaRecebimentos_Temp', function (Blueprint $table) {
                $table->integer('idFicha', false, true);
                $table->integer('idVenda', false, true);
                $table->integer('idAbertura', false, true);
                $table->integer('idFormaPagamento', false, true);
                $table->decimal('vrFormaPagamento', 9, 2);
                $table->dateTime('dtdata');
                $table->boolean('flTroco');
                $table->boolean('flAtivo');
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->integer('idBanco', false, true);
                $table->decimal('nrCheque', 18, 0)->nullable();
                $table->decimal('nrAgenciaCheque', 18, 0)->nullable();
                $table->decimal('nrContaCheque', 18, 0)->nullable();
                $table->dateTime('dtDepositoCheque')->nullable();
                $table->boolean('flVaucher')->default(false);
                $table->string('adiquirente', 10)->default('0000000000');
                $table->string('bandeira', 20)->default('');
                $table->string('autorizacao', 20)->default('');
                $table->integer('parcelas', false, true)->default(1);
                $table->bigInteger('bin')->default(0);
                $table->bigInteger('nsu')->default(0);
                $table->string('tipo_pagamento', 2)->default('00');
                $table->string('modalidade_pagamento', 2)->default('00');
                $table->boolean('flSentConciliacao')->default(false);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_FichaRecebimentos_Temp');

    }
}
