<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinContasPagarTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_ContasPagar')) {
            Schema::create('fin_ContasPagar', function (Blueprint $table) {

                $table->unsignedInteger('idContasPagar', false);
                $table->unsignedInteger('idFornecedor', false);
                $table->unsignedInteger('idTipoConta', false);
                $table->unsignedInteger('idCentroCusto', false);
                $table->unsignedInteger('idMovimentacao', false);
                $table->unsignedInteger('idAbertura', false);
                $table->dateTime('dtLancamento');
                $table->dateTime('dtVencimento');
                $table->dateTime('dtPagamento');
                $table->integer('nrParcela');
                $table->integer('nrTotalParcelas');
                $table->decimal('vrDocumento', 9, 2);
                $table->decimal('vrJuros', 9, 2);
                $table->boolean('flJuros')->default(false);
                $table->decimal('vrPago', 9, 2);
                $table->boolean('flPago')->default(false);
                $table->boolean('flAtivo')->default(true);
                $table->string('stOperador', 20);
                $table->string('stObservacao', 255);
                $table->string('stDocumento', 50);
                $table->string('stTipoBaixa', 1);
                $table->string('stTipoJuros', 1);
                $table->string('stObservacaoBaixa', 255);
                $table->decimal('vrDescontoLancamento', 9, 2);
                $table->unsignedInteger('idContaBancaria', false);
                $table->unsignedInteger('idTipoPagamento', false);
                $table->unsignedInteger('idConta', false);
                $table->unsignedInteger('idCheque', false);
                $table->unsignedInteger('idContasPagarRecorrente', false);
                $table->dateTime('dtAlteracao');
                $table->boolean('flAutorizado');
                $table->unsignedInteger('nrPrioridade');
                $table->dateTime('dtPrevisao');
                $table->decimal('vrEncargos', 9, 2);
                $table->decimal('vrOutros', 9, 2);
                $table->decimal('vrDescontos', 9, 2);

                $table->primary(['idContasPagar', 'idFornecedor']);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_ContasPagar');

    }
}
