<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtPrintsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_Prints')) {
            Schema::create('mt_Prints', function (Blueprint $table) {
                $table->integer('idPrint', false, true);
                $table->string('stPrint', 20);
                $table->string('stLocalPrint', 50);
                $table->string('stCanal', 2);
                $table->string('stModelo', 20);
                $table->boolean('flAgruparItens')->default(false);
                $table->dateTime('dtAlteracao')->default(Carbon::now());

                $table->primary('idPrint');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_Prints');

    }
}
