<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdReceitasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Receitas')) {

            DB::statement('CREATE TABLE [dbo].[prd_Receitas](
                  [dtAlteracao] [datetime] NOT NULL,
                  [idReceita] [int] NOT NULL,
                  [stReceita] [nvarchar](50) NOT NULL,
                  [idProduto] [int] NOT NULL,
                  [nrRendimentoKg] [decimal](9, 3) NOT NULL,
                  [nrRendimentoUn] [int] NOT NULL,
                  [dtCadastro] [datetime] NOT NULL,
                  [dtUltimaAlteracao] [datetime] NOT NULL,
                  [stModoPreparo] [nvarchar](4000) NOT NULL,
                  CONSTRAINT [PK_prd_Receitas] PRIMARY KEY CLUSTERED
                    (
                      [idReceita] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Receitas');

    }
}
