document.addEventListener("DOMContentLoaded", function() {
    initSelect2();
    var data = {action: "getOrigensEstoque"};
    $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
        $('#selectOrigens').append($("<option></option>").attr("value", "VAZIO").attr("selected", "selected").attr("disabled", "disabled").text("Selecione a Origem"));
        $('#selectOrigens').append($("<option></option>").attr("value", "VAZIO").attr("disabled", "disabled").text("--ESTOQUES--"));
        if(dados){
            for (var i = 0; i < dados.length; i++) {
                $('#selectOrigens').append($("<option></option>").attr("value", dados[i].idEstoque).text(dados[i].stEstoque));
            }
        }
        $("#selectOrigens").select2()
    });

    var data = {action: "getOrigensFornecedor"};
    $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
        if(dados){
            $('#selectOrigens').append($("<option></option>").attr("value", "VAZIO").attr("disabled", "disabled").text("--FORNECEDORES--"));
            for (var i = 0; i < dados.length; i++) {
                $('#selectOrigens').append($("<option></option>").attr("value", dados[i].idFornecedor).text(dados[i].stNomeFornecedor));
            }
        }
    });

    data = {action: "getDestinos"}
    $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
        $('#selectDestinos').append($("<option></option>").attr("value", "VAZIO").attr("selected", "selected").attr("disabled", "disabled").text("Selecione o Destino"));
        if(dados){
            for (var i = 0; i < dados.length; i++) {
                $('#selectDestinos').append($("<option></option>").attr("value", dados[i].idEstoque).text(dados[i].stEstoque));
            }
        }
        $("#selectDestinos").select2()
    });

    data = {action: "getSetoresFiltro"}
    $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
        $('#selectSetores').append($("<option></option>").attr("value", "TODOS").text("TODOS"));
        if(dados){
            for (var i = 0; i < dados.length; i++) {
                $('#selectSetores').append($("<option></option>").attr("value", dados[i].idSetor).text(dados[i].stSetor));
            }
        }
        $("#selectSetores").select2()
    });

    var today = new Date();
    var day = today.getDate();
    var month = (1 + today.getMonth()).toString();
    if(month.length < 2) month = '0' + month;
    var year = today.getFullYear();
    $("#dtDia").val(day);
    $("#dtMes").val(month);
    $("#dtAno").val(year);
    $("#dtData").val(day + "/" + month + "/" + year);
    $("#dtVenc").val(day + "/" + month + "/" + year);
    getData("nota");
    getData("venc");
});

function getData(tipo) {
    switch(tipo) {
        case "nota":
            var datas = $("#dtData").val().split("/");
            $("#dtDia").val(datas[0]);
            $("#dtMes").val(datas[1]);
            $("#dtAno").val(datas[2]);
            break;
        case "venc":
            var datas = $("#dtVenc").val().split("/");
            $("#dtDiaVenc").val(datas[0]);
            $("#dtMesVenc").val(datas[1]);
            $("#dtAnoVenc").val(datas[2]);
            break;
        default:
            var datas = $("#dtDataValidade" + tipo).val().split("/");
            $("#dtDiaValidade" + tipo).val(datas[0]);
            $("#dtMesValidade" + tipo).val(datas[1]);
            $("#dtAnoValidade" + tipo).val(datas[2]);
            break;
    }
}

function checkFinanceiro() {
    var checkbox = $('#chkFinanceiro').is(":checked");
    if (checkbox) {

        data = {action: "getFormasPagamento"}
        $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
            if(dados){
                var selected = 0;
                for (var i = 0; i < dados.length; i++) {
                    if(selected === 0){
                        $('#selectFormasPagamento').append($("<option></option>").attr("value", dados[i].idTipoPagamento).attr("selected", "selected").text(dados[i].stTipoPagamento));
                        selected ++;
                    }else{
                        $('#selectFormasPagamento').append($("<option></option>").attr("value", dados[i].idTipoPagamento).text(dados[i].stTipoPagamento));
                    }
                }
            }
        });

        data = {action: "getGrupo"}
        $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
            if(dados){
                for (var i = 0; i < dados.length; i++) {
                    $('#selectGrupo').append($("<option></option>").attr("value", dados[i].idCategoriaConta).text(dados[i].stCategoriaConta));
                }
            }
        });

        data = {action: "getSubGrupo"}
        $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
            if(dados){
                for (var i = 0; i < dados.length; i++) {
                    $('#selectSubGrupo').append($("<option></option>").attr("value", dados[i].idTipoConta).text(dados[i].stTipoConta));
                }
            }
        });

        data = {action: "getConta"}
        $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
            if(dados){
                for (var i = 0; i < dados.length; i++) {
                    $('#selectConta').append($("<option></option>").attr("value", dados[i].idConta).text(dados[i].stConta));
                }
            }
        });

        data = {action: "getCentroCusto"}
        $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
            if(dados){
                for (var i = 0; i < dados.length; i++) {
                    $('#selectCentroCusto').append($("<option></option>").attr("value", dados[i].idCentroCusto).text(dados[i].stCentroCusto));
                }
            }
        });

        $("#divFinanceiro").removeAttr("hidden");
    }else{
        $("#divFinanceiro").attr("hidden", "hidden");
        $('#selectFormasPagamento').html("");
        $('#selectGrupo').html("");
    }
}

function changeGrupo() {
    var idGrupo = $('#selectGrupo').find(":selected").val();
    data = {action: "getSubGrupo", idGrupo}
    $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
        $('#selectSubGrupo').html("");
        if(dados){
            for (var i = 0; i < dados.length; i++) {
                $('#selectSubGrupo').append($("<option></option>").attr("value", dados[i].idTipoConta).text(dados[i].stTipoConta));
            }
            changeSubGrupo();
        }
    });
}

function changeSubGrupo() {
    var idSubGrupo = $('#selectSubGrupo').find(":selected").val();
    data = {action: "getConta", idSubGrupo}
    $.post('estoque/resources/php/lancamento_functions.php', data, function(dados) {
        $('#selectConta').html("");
        if(dados){
            for (var i = 0; i < dados.length; i++) {
                $('#selectConta').append($("<option></option>").attr("value", dados[i].idConta).text(dados[i].stConta));
            }
        }
    });
}

function changeSetor() {
    var setor = $("#selectSetores").find(":selected").text();
    $("input[id*=setorProduto]").each(function() {
        if(setor === "TODOS"){
            $("#row"+this.id.replace(/\D/g,'')).removeAttr("hidden");
        }else{
            var setorProduto = this.value
            if(setorProduto !== setor){
                $("#row"+this.id.replace(/\D/g,'')).attr("hidden", "hidden");
            }else{
                $("#row"+this.id.replace(/\D/g,'')).removeAttr("hidden");
            }
        }
    });
}

function changeEstoque() {
    var origem = $("#selectOrigens").find(":selected").val();
    var destino = $("#selectDestinos").find(":selected").val();
    var setor = $("#selectSetores").find(":selected").val();
    var tipoOrigem = origem.replace(/[0-9]/g, '');
    var tipoDestino = destino.replace(/[0-9]/g, '');
    $("#idOrigem").val(origem)
    $("#idDestino").val(destino)
    if (origem === destino) {
        $("#labelErroEstoques").html("Selecione uma Origem e Destino distintos.");
        $("#erroEstoques").removeAttr("hidden");
        $("#divProcuraProduto").attr("hidden", "hidden");
        $("#divTabelaProduto").attr("hidden", "hidden");
        $("#saveTop").attr("hidden", "hidden");
        $("#divCheckFinanceiro").attr("hidden");
        $("#saveBottom").attr("hidden", "hidden");
    }else if(tipoOrigem === tipoDestino === "f"){
        $("#labelErroEstoques").html("Você não pode fazer uma movimentação entre dois fornecedores.");
        $("#erroEstoques").removeAttr("hidden");
        $("#divProcuraProduto").attr("hidden", "hidden");
        $("#divTabelaProduto").attr("hidden", "hidden");
        $("#saveTop").attr("hidden", "hidden");
        $("#divCheckFinanceiro").attr("hidden");
        $("#saveBottom").attr("hidden", "hidden");
    }else if (origem !== "VAZIO" && destino !== "VAZIO") {
        $("#erroEstoques").attr("hidden", "hidden");
        $("#divCheckFinanceiro").removeAttr("hidden", "hidden");
        $("#divProcuraProduto").removeAttr("hidden");
        $("#divTabelaProduto").removeAttr("hidden");
        $("#saveTop").removeAttr("hidden");
        $("#saveBottom").removeAttr("hidden");
    }
}

function initSelect2() {
    $('#selectProduto').select2({
        placeholder: "Digite o Código ou o Nome do Produto",
        multiple: false,
        width: '100%',
        theme: "bootstrap",
        ajax: {
            url: "estoque/resources/php/lancamento_functions.php",
            dataType: 'json',
            type: "POST",
            delay: 250,
            data: function (params) {
                return {
                    action: 'popularProduto',
                    texto: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.idCodigo + " - " + item.stProduto,
                            id: item.idProduto
                        }
                    })
                }
            },
            minimumInputLength: 1
        }
    });
}

$('#selectProduto').on("select2:close", function (e) {
    initSelect2();
});

$('#selectProduto').on("select2:select", function (e) {
    $('#btnAddProduto').focus();
});

$('#selectOrigens').on("select2:select", function (e) {
    $('#selectDestinos').focus();
    $('#selectDestinos').select2("open");
});

$('#selectDestinos').on("select2:select", function (e) {
    $('#stNotaFiscal').focus();
});

function getProduto() {
    toastr.options={
        "positionClass": "toast-top-right"
    };
    var escolhido = $("#selectProduto option:selected").val();
    var origem = $("#selectOrigens").find(":selected").val();
    var destino = $("#selectDestinos").find(":selected").val();
    var origem2 = $("#selectOrigens :selected").text();
    var destino2 = $("#selectDestinos :selected").text();
    var setor = $("#selectSetores").find(":selected").val();
    var tipoOrigem = origem.replace(/[0-9]/g, '');
    var data = {action: "adicionaProduto", idProduto: escolhido, idOrigem: origem, idSetorFiltro: setor, idDestino: destino, tipoOrigem: tipoOrigem};
    $.post('estoque/resources/php/lancamento_functions.php', data, function (data) {
        if(data){
            if($("#row"+ data.idProduto +"").html()){
                toastr.error("Produto já foi adicionado");
                $('#selectProduto').select2("open");
            }else{
                var today = new Date();
                var day = today.getDate();
                if(day < 10) day = '0' + day;
                var month = (1 + today.getMonth()).toString();
                if(month < 10) month = '0' + month;
                var year = today.getFullYear();
                toastr.success("Produto adicionado com sucesso");
                var linha = '<tr id="row'+ data.idProduto +'">'+
                    '<td hidden><input id="setorProduto'+ data.idProduto +'" name="setorProduto'+ data.idProduto +'" value="'+ data.stSetor +'"></td>'+
                    '<td hidden><input id="idCodigoProduto'+ data.idProduto +'" name="idCodigoProduto'+ data.idProduto +'" value="'+ data.idProduto +'"></td>'+
                    '<td hidden><input id="flFracionado'+ data.idProduto +'" name="flFracionado'+ data.idProduto +'" value="'+ data.flFracionado +'"></td>'+
                    '<td id="codigo'+ data.idProduto +'">'+ data.idCodigo +'</td>'+
                    '<td>'+ data.stProduto +'</td>'+
                    '<td>'+
                    '<input class="form-control input-sm" id="dtDataValidade'+ data.idProduto +'" name="dtDataValidade'+ data.idProduto +' maxlength="10" value="'+day+'/'+month+'/'+year+'" onchange="getData(' + data.idProduto +')">'+
                    '<input id="dtDiaValidade'+ data.idProduto +'" name="dtDiaValidade'+ data.idProduto +'" hidden>'+
                    '<input id="dtMesValidade'+ data.idProduto +'" name="dtMesValidade'+ data.idProduto +'" hidden>'+
                    '<input id="dtAnoValidade'+ data.idProduto +'" name="dtAnoValidade'+ data.idProduto +'" hidden>'+
                    '</td>'+
                    '<td id="qtd1'+ data.idProduto +'">'+ origem2 +'</td>'+
                    '<td id="qtd2'+ data.idProduto +'">'+ destino2 +'</td>'+
                    '<td><input class="form-control input-sm" id="stMedidaConversao'+ data.idProduto +'" name="stMedidaConversao'+ data.idProduto +'" value="'+ data.stMedida +'"></td>'+
                    '<td><input class="form-control input-sm" id="stQuantidadeConversao'+ data.idProduto +'" name="stQuantidadeConversao'+ data.idProduto +'" value="'+ data.nrFatorConversao +'" onkeyup="calculaProduto(this.id)"></td>'+
                    '<td><input class="money form-control input-sm" id="vrCusto'+ data.idProduto +'" name="vrCusto'+ data.idProduto +'" value="'+ data.vrCusto +'" onkeyup="calculaProduto(this.id); nextInput('+ data.idProduto +', event)"></td>'+
                    '<td><input class="form-control input-sm" id="vrQuantidade'+ data.idProduto +'" name="vrQuantidade'+ data.idProduto +'" value="0" onkeyup="calculaProduto(this.id); nextInput(null, event)"></td>'+
                    '<td><input class="money form-control input-sm" id="vrTotal'+ data.idProduto +'" name="vrTotal'+ data.idProduto +'" value="0,00" readonly></td>'+
                    '<td align="center"><a onclick="removerProduto(this.id)" style="cursor: pointer;" id="remover'+ data.idProduto +'" name="remover'+ data.idProduto +'"><span class="glyphicon glyphicon-remove" title="Remover"></span></a></td>'+
                    '</tr>';
                if(data.stSetor){
                    var setor = data.stSetor.split(" ");
                }else{
                    var setor = "SEM SETOR";
                }
                if($("#setor" + setor[0]).length > 0){
                    $(linha).insertAfter($("#setor" + setor[0]));
                }else{
                    var novaArea ="<tr bgcolor=#E2F0F9 id=setor" + data.stSetor + ">" +
                        "<td colspan=11><font size=2><center><b>" + data.stSetor + "</b></center></font></td>" +
                        "</tr>";
                    novaArea += linha;
                    $(novaArea).appendTo($("#bodyTabelaProduto"));
                }
                if(data.flFracionado){
                    $("#stMedidaConversao"+ data.idProduto +"").attr("readonly", "readonly");
                    $("#stQuantidadeConversao"+ data.idProduto +"").attr("readonly", "readonly");
                }
                $("#dtDataValidade"+ data.idProduto).mask('00/00/0000');
                $("#vrCusto"+ data.idProduto).focus();
            }
        }else{
            toastr.error("Produto não disponível neste estoque");
        }
    });
}

function nextInput (idProduto, e) {
    if( e.keyCode === 13 ){
        if(idProduto > 0){
            $("#vrQuantidade"+ idProduto).val("");
            $("#vrQuantidade"+ idProduto).focus();
        }else{
            $('#selectProduto').select2("open");
        }
    }
}

function removerProduto(input) {
    idProduto = input.replace(/\D/g,'');
    var row = $("#row"+idProduto);
    row.remove();
    calculaTotal();
}

function abrirCalculadora(identificador) {
    $("#identificador").val(identificador);
    var linha = '<div><input class="form-control" value = "'+ $("#total"+identificador).val() +'" onkeyup="setValoresCalculadora()"/></div>';
    $(linha).appendTo($("#divCamposCalculadora"));
    setValoresCalculadora();
    $("#calculadora").modal('show');
}

function addCampoCalculadora(){
    var linha = '<br><div><input class="form-control" value = "0.00" onkeyup="setValoresCalculadora()"/></div>';
    $(linha).appendTo($("#divCamposCalculadora"));
}

function removeCampoCalculadora() {
    if($("#divCamposCalculadora").find("div").length > 1){
        $("#divCamposCalculadora div:last").remove()
        $("#divCamposCalculadora br:last").remove()
        setValoresCalculadora();
    }
}

function setValoresCalculadora() {
    var total = 0.00;
    $("#divCamposCalculadora").find("input").each(function (i, el){
        total += parseFloat(this.value.replace(",","."));
    });
    total = total.toFixed(2);
    $("#campoTotal").val(total);
}

function fecharCalculadora() {
    var local = $("#identificador").val();
    var total = $("#campoTotal").val();
    var destino = $("#total"+local).val(total);
    $("#calculadora").modal("hide");
    $("#divCamposCalculadora").html("");
}

function calculaProduto(idInput) {
    idProduto = idInput.replace(/\D/g,'');
    var flFracionado = $("#flFracionado"+idProduto).val();
    var custo = parseFloat($("#vrCusto"+idProduto).val().replace(",","."));
    var quantidade = $("#vrQuantidade"+idProduto).val();
    var conversao = $("#stQuantidadeConversao"+idProduto).val();

    if (flFracionado !== 0) {
        quantidade = quantidade/1000;
    }
    var novoTotal = ((custo * (quantidade * conversao)).toFixed(2)).replace(".",",");
    $("#vrTotal"+idProduto).val(novoTotal);
    calculaTotal();
}

function calculaTotal() {
    var totalNota = 0;
    var totais = $("input[id*=vrTotal]").each(function() {
        totalNota += parseFloat((this.value).replace(",","."));
    });
    totalNota = totalNota.toFixed(2);
    $("#totalNota").val(totalNota);
}

$("#modalAddProduto").on("hidden.bs.modal", function(){
    $("#idProdutoAdicionar").html("");
});

function salvarLancamento() {
    toastr.options={
        "positionClass": "toast-top-right"
    };
    var produtos = 0;
    var totais = $("input[id*=vrQuantidade]").each(function() {
        if(this.value !== "0" && this.value !== "") {
            produtos++;
        }
    });
    if(produtos === 0){
        toastr.error("Para fazer um lançamento deve haver no mínimo um produto.");
        return false;
    }else if($("#stNotaFiscal").val() === ""){
        toastr.error("Por favor, preencha o campo de Documento(Nota Fiscal).");
        return false;
    }else{
        var data = $("#novoCadastro").serialize();
        $("body").addClass("loading");
        $.post('estoque/takeinsertlancamento.php', data , function (data) {
            $("body").removeClass("loading");
            if(data === "success"){
                toastr.success("Lançamento feito com sucesso!");
                setTimeout(function() {
                    document.location = "?sec=estoque&sub=lancamento";
                }, 2000);
            }else{
                toastr.error("Ocorreu um erro ao salvar os dados.");
            }
        });
    }
}

$('.money').mask('#########0,00', {reverse: true});
