<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
db_conn();

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'getOrigensEstoque':
		getOrigensEstoque();
		break;
		case 'getOrigensFornecedor':
		getOrigensFornecedor();
		break;
		case 'getDestinos':
		getDestinos();
		break;
		case 'getSetoresFiltro':
		getSetoresFiltro();
		break;
		case 'getFormasPagamento':
		getFormasPagamento();
		break;
		case 'getGrupo':
		getGrupo();
		break;
		case 'getSubGrupo':
		getSubGrupo($_POST['idGrupo']);
		break;
		case 'getConta':
		getConta($_POST['idSubGrupo']);
		break;
		case 'getCentroCusto':
		getCentroCusto();
		break;
		case 'popularProduto':
		popularProduto($_POST['texto']);
		break;
		case 'adicionaProduto':
		adicionaProduto($_POST['idProduto'], $_POST['idOrigem'], $_POST['idSetorFiltro'], $_POST['idDestino'], $_POST['tipoOrigem']);
		break;
	}
}

function getOrigensEstoque()
{
	$res = mssql_query("SELECT * FROM est_Estoques WHERE flAtivo = '1' AND flOrigem = '1' ORDER BY stEstoque");
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['idEstoque'] = 'e' . $arr['idEstoque'];
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function getOrigensFornecedor()
{
	$res = mssql_query("SELECT * FROM frn_Fornecedores WHERE flAtivo = '1' ORDER BY stNomeFornecedor");
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['idFornecedor'] = 'f' . $arr['idFornecedor'];
		$arr['stNomeFornecedor'] = utf8_encode($arr['stNomeFornecedor']);
		$arr['stContato'] = utf8_encode($arr['stContato']);
		$arr['stEndereco'] = utf8_encode($arr['stEndereco']);
		$arr['stBairro'] = utf8_encode($arr['stBairro']);
		$arr['stRazaoSocial'] = utf8_encode($arr['stRazaoSocial']);
		$arr['stEstado'] = utf8_encode($arr['stEstado']);
		$arr['stCidade'] = utf8_encode($arr['stCidade']);
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function getDestinos()
{
	$res = mssql_query("SELECT * FROM est_Estoques WHERE flAtivo = '1' ORDER BY stEstoque");
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['idEstoque'] = 'e' . $arr['idEstoque'];
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function getSetoresFiltro()
{
	$res = mssql_query("SELECT * FROM prd_Setores WHERE flAtivo = '1' ORDER BY stSetor");
	while ($arr = mssql_fetch_assoc($res)) {
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function getFormasPagamento()
{
	$res = mssql_query("SELECT * FROM fin_TiposPagamento ORDER BY stTipoPagamento");
	while ($arr = mssql_fetch_assoc($res)) {
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function getGrupo()
{
	$res = mssql_query("SELECT COUNT(*) FROM est_Config C");
	$ct = 0;
	$idTipoConta = 0;

	$id = mssql_fetch_array($res);

	if($id['idConfig'] == null || $id['idConfig'] == ""){
		$res = mssql_query("SELECT T.* FROM est_Config C FULL OUTER JOIN fin_CategoriaContas T ON T.idCategoriaConta = C.idCategoriaConta");
	}else{
		$res = mssql_query("SELECT * FROM est_Config C INNER JOIN fin_CategoriaContas T ON T.idCategoriaConta = C.idCategoriaConta ORDER BY C.idConfig DESC");
	}

	while ($arr = mssql_fetch_array($res))
	{
		$rs = mssql_query("SELECT COUNT(idTipoConta) FROM fin_TipoContas WHERE flEntrada = '0' AND idCategoriaConta = '".$arr['idCategoriaConta']."'");
		$ar = mssql_fetch_array($rs);

		if ($ar[0] > 0)
		{
			if ($ct == 0)
			{
				$idCategoriaConta = $arr['idCategoriaConta'];
				$ct++;
			}

			$rows[] = $arr;
		}
	}

	echo json_encode($rows);
}

function getSubGrupo($idGrupo)
{

	if ($idGrupo == null) {
		if($id['idConfig'] == null || $id['idConfig'] == ""){
			$res = mssql_query("SELECT T.* FROM est_Config C FULL OUTER JOIN fin_CategoriaContas T ON T.idCategoriaConta = C.idCategoriaConta");
		}else{
			$res = mssql_query("SELECT * FROM est_Config C INNER JOIN fin_CategoriaContas T ON T.idCategoriaConta = C.idCategoriaConta ORDER BY C.idConfig DESC");
		}

		$arr = mssql_fetch_array($res);
		$idSubGrupo = $arr['idCategoriaConta'];
	}

	$ct = 0;
	$idTipoConta = 0;

	if($id[0] == null || $id[0] == "" || $id[0] == 0){
		$res = mssql_query("SELECT * FROM fin_TipoContas WHERE flEntrada = '0' AND idCategoriaConta = '$idGrupo' ORDER BY stTipoConta");
	}else{
		$res = mssql_query("SELECT T.* FROM est_Config C FULL OUTER JOIN fin_TipoContas T ON T.idTipoConta = C.idTipoConta WHERE T.flEntrada = '0' AND T.idCategoriaConta = '$idCategoriaConta' ORDER BY C.idConfig DESC");
	}

	while ($arr = mssql_fetch_array($res))
	{
		if ($ct == 0)
		{
			$idTipoConta = $arr['idTipoConta'];
			$ct++;
		}

		$rows[] = $arr;
	}

	echo json_encode($rows);
}

function getConta($idSubGrupo)
{
	if ($idSubGrupo == null) {
		if($id[0] == null || $id[0] == "" || $id[0] == 0){
			$res = mssql_query("SELECT * FROM fin_TipoContas WHERE flEntrada = '0' AND idCategoriaConta = '$idGrupo' ORDER BY stTipoConta");
		}else{
			$res = mssql_query("SELECT T.* FROM est_Config C FULL OUTER JOIN fin_TipoContas T ON T.idTipoConta = C.idTipoConta WHERE T.flEntrada = '0' AND T.idCategoriaConta = '$idCategoriaConta' ORDER BY C.idConfig DESC");
		}

		$arr = mssql_fetch_array($res);
		$idSubGrupo = $arr['idTipoConta'];
	}

	if($id[0] == null || $id[0] == "" || $id[0] == 0){
		$res = mssql_query("SELECT * FROM fin_Contas WHERE idTipoConta = '$idSubGrupo' ORDER BY stConta");
	}else{
		$res = mssql_query("SELECT T.* FROM est_Config C FULL OUTER JOIN fin_Contas T ON T.idConta = C.idConta WHERE T.idTipoConta = '$idTipoConta' ORDER BY C.idConfig DESC");
	}

	while ($arr = mssql_fetch_array($res))
	{
		$rows[] = $arr;
	}

	echo json_encode($rows);
}

function getCentroCusto()
{
	if($id[0] == null || $id[0] == "" || $id[0] == 0){
		$res = mssql_query("SELECT * FROM fin_CentroCusto ORDER BY stCentroCusto");
	}else{
		$res = mssql_query("SELECT T.* FROM est_Config C FULL OUTER JOIN fin_CentroCusto T ON T.idCentroCusto = C.idCentroCusto ORDER BY C.idConfig DESC");
	}

	while ($arr = mssql_fetch_array($res))
	{
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function popularProduto($texto){
	if (strlen($texto) > 0) {
		if(ctype_digit($texto)){
			$qry =	"SELECT TOP 15 p.stProduto, p.idProduto, c.idCodigo FROM prd_Produtos p INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto WHERE c.idCodigo LIKE '".$texto."%' AND flAtivo = '1'";
		}else{
			$qry = "SELECT TOP 15 p.stProduto, p.idProduto, c.idCodigo FROM prd_Produtos p INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto WHERE stProduto LIKE '".$texto."%' AND flAtivo = '1'";
		}
		$res = mssql_query($qry);
		while($arr = mssql_fetch_assoc($res))
		{
			$arr['stProduto'] = utf8_encode($arr['stProduto']);
			$rows[] = $arr;
		}
		echo json_encode($rows);
	}
}

function adicionaProduto($idProduto, $idOrigem, $idSetorFiltro, $idDestino, $tipoOrigem)
{
	$res = mssql_query("SELECT * FROM prd_Produtos WHERE idProduto = '$idProduto'");
	$arr = mssql_fetch_array($res);
	$idOrigem = preg_replace('/\D/', '', $idOrigem);
	$idDestino = preg_replace('/\D/', '', $idDestino);
	$res = mssql_query("SELECT * FROM frn_FichaFornecedor WHERE idProduto = '$idProduto' AND idFornecedor = '$idOrigem'");
	$exists = mssql_fetch_array($res);
	if(!$exists){
		mssql_query("INSERT INTO frn_FichaFornecedor (idFornecedor, idProduto, idCategoria) VALUES ('$idOrigem', '$idProduto', '".$arr['idCategoria']."')");
	}

	if($tipoOrigem == "f"){
		$qry = "SELECT p.idProduto, p.stProduto, c.idCodigo, p.vrCusto, p.vrUnitario, p.nrFatorConversao, m.flFracionado, m.stMedida, e.stSetor
		FROM prd_Produtos p
		INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
		INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida or p.idMedidaCompra = m.idMedida
		INNER JOIN prd_Setores e ON p.idSetor = e.idSetor
		INNER JOIN frn_FichaFornecedor f ON p.idProduto = f.idProduto
		WHERE p.idProduto = '". $idProduto ."' AND p.flControlarEstoque = '1' AND p.flAtivo = '1' AND f.idFornecedor ='". $idOrigem ."'";
	}else{
		$verDestino = "SELECT * FROM est_Saldos WHERE idEstoque ='". $idDestino ."' AND idProduto = '". $idProduto ."' ";
		$resDestino = mssql_query($verDestino);
		if(mssql_num_rows($resDestino) < 1){
			$resIdSaldo = mssql_query("SELECT MAX(idSaldo) FROM est_Saldos");
			$arrIdSaldo = mssql_fetch_array($resIdSaldo);
			$idSaldo = $arrIdSaldo[0] + 1;

			$addDestino = "INSERT INTO est_Saldos (idSaldo, idEstoque, idProduto, nrQuantidade, nrReservas, dtModificacao, dtConferencia, nrMinimo, dtAlteracao)
			VALUES ('".$idSaldo."','".$idDestino."','".$idProduto."','0','0',GETDATE(),GETDATE(), '0', GETDATE() )";
			mssql_query($addDestino);
		}
		$qry = "SELECT p.idProduto, p.stProduto, c.idCodigo, p.vrCusto, p.vrUnitario, p.nrFatorConversao, m.flFracionado, m.stMedida, e.stSetor, s.nrQtd1, t.nrQtd2
		FROM prd_Produtos p
		INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
		INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida or p.idMedidaCompra = m.idMedida
		INNER JOIN prd_Setores e ON p.idSetor = e.idSetor
		INNER JOIN frn_FichaFornecedor f ON p.idProduto = f.idProduto
		INNER JOIN (SELECT idProduto, nrQuantidade as nrQtd1 FROM est_Saldos WHERE idEstoque='". $idOrigem ."')s ON p.idProduto = s.idProduto
		INNER JOIN (SELECT idProduto, nrQuantidade as nrQtd2 FROM est_Saldos WHERE idEstoque='". $idDestino ."')t ON p.idProduto = t.idProduto
		WHERE p.idProduto = '". $idProduto ."' AND p.flControlarEstoque = '1' AND p.flAtivo = '1' AND f.idFornecedor ='". $idOrigem ."'";
	}
	$res = mssql_query($qry);
	$arr = mssql_fetch_assoc($res);
	if($arr){
		$arr["vrUnitario"] = number_format($arr["vrUnitario"], 2, ",", "");
		$arr["vrCusto"] = number_format($arr["vrCusto"], 2, ",", "");
		$arr["vrCusto2"] = number_format($arr["vrCusto"], 2, ",", "");

		if(!$arr["nrQtd1"]){
			$arr["nrQtd1"] = "0";
		}else{
			if ($arr['flFracionado']) {
				$arr["nrQtd1"] = number_format($arr["nrQtd1"], 3, ",", "");
			}
		}
		if(!$arr["nrQtd2"]){
			$arr["nrQtd2"] = "N/A";
		}else{
			if ($arr['flFracionado']) {
				$arr["nrQtd2"] = number_format($arr["nrQtd2"], 3, ",", "");
			}
		}
		if(!$arr["nrFatorConversao"]){
			$arr["nrFatorConversao"] = "1";
		}
	}

	echo json_encode($arr);
}
?>