<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
db_conn();

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'getCaixas':
		getCaixas();
		break;	
		case 'getVendasCaixas':
		getVendasCaixas($_POST['de'], $_POST['ate'], $_POST['caixa']);
		break;
		case 'gerarRelatorio':
		gerarRelatorio($_POST['idAbertura']);
		break;
		case 'getXML':
		getXML($_POST['venda'], $_POST['abertura']);
		break;
		case 'visualizarXML':
		visualizarXML($_POST['venda'], $_POST['abertura']);
		break;
		case 'deleteFile':
		deleteFile();
		break;
	}
}


function getCaixas()
{
	$qry = "SELECT DISTINCT idCaixa FROM cx_Gerenciador ORDER BY idCaixa ASC";
	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function getVendasCaixas($de, $ate, $caixa) {

	$de = explode('/', $de);
	$ate = explode('/', $ate);

	$de = $de[2].'-'.$de[1].'-'.$de[0].' 00:00:00';
	$ate = $ate[2].'-'.$ate[1].'-'.$ate[0].' 23:59:59';
	$sql = "SELECT g.idAbertura, o.stApelido, g.dtAbertura, g.dtFechamento, g.idCaixa FROM cx_Gerenciador g
	INNER JOIN op_Operadores o ON g.idOperador = o.idOperador
	WHERE g.dtAbertura BETWEEN '".$de."' AND '".$ate."'";
	if ($caixa != 0) {
		$sql .= " AND g.idCaixa = ".$caixa;
	}
	$sql .= " ORDER BY g.idAbertura";
	$res = mssql_query($sql);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['stApelido'] = utf8_encode($arr['stApelido']);
		$arr['dtAbertura'] = date("d/m/Y H:i", strtotime($arr['dtAbertura']));
		$arr['dtFechamento'] = date("d/m/Y H:i", strtotime($arr['dtFechamento']));
		$rows[] = $arr;
	}
	echo json_encode($rows);
}

function gerarRelatorio($idAbertura) {

	$qry = "SELECT flAberto FROM cx_Gerenciador WHERE idAbertura = ".$idAbertura."";
	if (mssql_fetch_array(mssql_query($qry)) == 0) {
		$sql = "SELECT v.dtData, g.idCaixa, v.idAbertura, v.idVenda, v.vrTotal, c.stCliente, v.flNotaFiscal FROM cx_Vendas_Temp v
		INNER JOIN cx_Gerenciador g ON v.idAbertura = g.idAbertura 
		INNER JOIN dlv_Clientes c ON v.idCliente = c.idCliente
		WHERE v.idAbertura = ".$idAbertura."
		ORDER BY convert(varchar(10), v.dtData, 103), g.idCaixa, v.idAbertura, v.idVenda";
	}
	else {
		$sql = "SELECT v.dtData, g.idCaixa, v.idAbertura, v.idVenda, v.vrTotal, c.stCliente, v.flNotaFiscal FROM cx_Vendas v
		INNER JOIN cx_Gerenciador g ON v.idAbertura = g.idAbertura 
		INNER JOIN dlv_Clientes c ON v.idCliente = c.idCliente
		WHERE v.idAbertura = ".$idAbertura."
		ORDER BY convert(varchar(10), v.dtData, 103), g.idCaixa, v.idAbertura, v.idVenda";
	}
	
	ini_set('memory_limit', '-1');
	$res = mssql_query($sql);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['stCliente'] = utf8_encode($arr['stCliente']);
		$arr['vrTotal'] = number_format($arr['vrTotal'], 2, ',', '.');
		$arr['dtData'] = date("d/m/Y H:i", strtotime($arr['dtData']));
		$rows[] = $arr;
	}
	$qry = mssql_query("SELECT * FROM op_Operadores WHERE idOperador = ".$_COOKIE['idOperador']."");
	$ret = mssql_fetch_assoc($qry);

	$result['op'] = $ret;
	$result['date'] = date('d/m/Y');
	$result['time'] = date('H:i');
	$result['vendas'] = $rows;

	echo json_encode($result);
}

function getXML($venda, $abertura) {

	$qry = "SELECT x.xml FROM sat_xml x
	INNER JOIN sat_vendas s ON x.id = s.XmlSat_Id
	WHERE s.idVenda = '".$venda."' AND s.idAbertura = '".$abertura."' ";
	$res = mssql_fetch_assoc(mssql_query($qry));

	$x = $res['xml'];
	if ( base64_encode(base64_decode($res['xml'])) === $res['xml'])
	{
		$res['xml'] = base64_decode($res['xml']);
	}
	$erro = false;

	$fileName = substr($res['xml'],55, 47).'.zip';
	if (file_exists($fileName)) {
		unlink($fileName);
	}
	$zip = new ZipArchive();
	$tmp_file = $fileName;
	$zip->open($tmp_file, ZipArchive::CREATE);

	$file = substr($res['xml'],55, 47).".xml";
	@unlink($file);
	$fopen = @fopen($file, "w") or $erro = true;
	@fwrite($fopen, $res['xml']) or $erro = true;
	@fclose($fopen) or $erro = true;

	$zip->addFile($file);
	$zip->close();

	if($erro){
		echo retornaJson(false, 'nok');
	}else{
		echo retornaJson(true, $fileName);
	}
}

function visualizarXML($venda, $abertura) {

	$qry = "SELECT x.xml FROM sat_xml x
	INNER JOIN sat_vendas s ON x.id = s.XmlSat_Id
	WHERE s.idVenda = '".$venda."' AND s.idAbertura = '".$abertura."' ";

	$res = mssql_fetch_assoc(mssql_query($qry));

	if ( base64_encode(base64_decode($res['xml'])) === $res['xml'])
	{
		$res['xml'] = base64_decode($res['xml']);
	}
	$erro = false;
	$file = substr($res['xml'],55, 47).".xml";
	@unlink($file);
	$fopen = @fopen($file, "w") or $erro = true;
	@fwrite($fopen, $res['xml']) or $erro = true;
	@fclose($fopen) or $erro = true;


	$xml = simplexml_load_file($file);

	$result['xml'] = $xml;

	if($erro){
		echo retornaJson(false, 'nok');
	}else{
		array_map('unlink', glob("./*.xml"));

		echo retornaJson(true, $result);
	}
}

function deleteFile() {

	array_map('unlink', glob("./*.xml"));
	array_map('unlink', glob("./*.zip"));
}

?>