<?php

namespace App\Entities\Delivery;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;
use App\Entities\Mobyo\MobyoPayment;

class MobyoConfig extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'mobyo_config';
    protected $primaryKey = 'id';
    // public $incrementing = false;
    public $timestamps = true;

    protected $fillable = [
        'engine',
        'idMerchant',
        'flClienteFixo',
        'idCliente',
        'codProdutoGenerico',
        'idCaixa',
        'idUser',
        'flFormaPagamentoFixa',
        'idFormaPagamento',
        'idDeliveryPadrao',
        'flClienteObservacao',
        'flCupomDelivery',
        'flCumpoRemoto',
        'flPainelPreparo',
        'flSalvarVendaAutomatico',
        'flCupomAutomatico',
        'idContaFinanceiro',
        'flEmitirCFEAutomaticamente',
        'flSalvarTaxaServico',
        'flSalvarDesconto'
    ];

    protected $casts = [
        'flClienteFixo' => 'boolean',
        'flFormaPagamentoFixa' => 'boolean',
        'flSalvarClienteObservacao' => 'boolean',
        'flSalvarTaxaEntrega' => 'boolean',
        'flEmitirCupomDelivery' => 'boolean',
        'flEmitirCupomRemoto' => 'boolean',
        'flUsarPainelPreparo' => 'boolean',
        'flSalvarVendaAutomaticamente' => 'boolean',
        'flDespacharPedidoAutomaticamente' => 'boolean',
        'flEmitirCFEAutomaticamente' => 'boolean',
        'flSalvarTaxaServico' => 'boolean',
        'flSalvarDesconto' => 'boolean'
    ];

    public function payments()
    {
        return $this->hasMany(MobyoPayment::class, 'idMobyoConfig', 'id');
    }

    public function getIntegrationFromDB($request)
    {
        try {
            $integration = MobyoConfig::where('engine', $request['engineType'])
                                        ->with('payments')
                                        ->first();
            return $integration;
        } catch (\Exception $e) {
            throw new \Exception($e);
        }

    }


}
