<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class DesenfilaConfig.
 *
 * @package namespace App\Entities;
 */
class DesenfilaConfig extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'desenfila_config';
    public $timestamps = false;
    public $incrementing = false;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'id',
        'token',
        'posId',
        'paymentId',
        'shifts',
        'startTabId',
        'endTabId',
        'taxApi',
        'allowRangeTab',
        'brand',
        'createdAt',
        'updatedAt',
        'desenfilaApi',
        'userId',
    ];

    protected $casts = [
        'allowRangeTab' => 'boolean',
    ];
}
