<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class FormaPagamento extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'cx_FormasPagamento';
    public $primaryKey = 'idFormaPagamento';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idFormaPagamento',
        'stFormaPagamento',
        'stDescricaoFiscal',
        'idTipo',
        'stCor',
        'stAtalho',
        'idBandeira',
        'idTEF',
        'stfaturado',
        'dtAlteracao',
        'stTipo2',
        'stOperadora',

        'flTroco',
        'flVenda',
        'flSangria',
        'flGiveDifference',
        'flDespesas',
        'flSenha',
        'flAcionaGaveta',
        'flDelivery',
        'flAtivo',
        'flfaturado',
        'flImprimeRelatorio',
        'flvendabrowser',
        'flAdquirente',

        'Order',
        'parentId',
        'vrTaxa',
        'pagamentoSat',
        'sync',
    ];

    protected $casts = [
        'flTroco' => 'boolean',
        'flVenda' => 'boolean',
        'flSangria' => 'boolean',
        'flGiveDifference' => 'boolean',
        'flDespesas' => 'boolean',
        'flSenha' => 'boolean',
        'flAcionaGaveta' => 'boolean',
        'flDelivery' => 'boolean',
        'flAtivo' => 'boolean',
        'flfaturado' => 'boolean',
        'flImprimeRelatorio' => 'boolean',
        'flvendabrowser' => 'boolean',
        'flAdquirente' => 'boolean',
        'id_type' => 'integer',
    ];

    public function tipo()
    {
        return $this->hasOne(TipoFormaPagamento::class, 'idTipoForma', 'idTipo');
    }

    public function generateTags(): array
    {
        return [
            'config'
        ];
    }

    protected $auditExclude = [
        'dtAlteracao',
        'ParentId'
    ];
}
