<?php

namespace App\Entities\Nati;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class OrderTab extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'mt_Atendimentos';
    protected $primaryKey = 'idComanda';
    public $incrementing = false;
    public $timestamps = false;

    public function __construct(array $attributes = [])
    {
        $this->dtAlteracao = Carbon::now();
        $this->dtFirstDate = Carbon::now();
        $this->dtLastdate = Carbon::now();
        $this->flReturn = false;
        $this->flConta = false;
        $this->flBloqueada = false;
        $this->idMesa = 0;
        $this->nrPessoas = 0;
        $this->vrLimite = 0;
        $this->idMicroterminallock = '';
        $this->stOperadorlock = '';
    }

    protected $fillable = [
        'idComanda',
        'dtFirstDate',
        'dtLastdate',
        'flReturn',
        'idOperadorCaixa',
        'flBloqueada',
        'idMesa',
        'nrPessoas',
        'flConta',
        'idMicroterminallock',
        'stOperadorlock',
        'idCliente',
        'vrLimite',
        'dtAlteracao',
        'vrDesconto'
    ];
    protected $casts = [
        'flReturn' => 'boolean',
        'flBloqueada' => 'boolean',
        'flConta' => 'boolean',
        'vrDesconto' => 'float',
        'vrLimite' => 'float'
    ];

    protected $appends = [
        'vrTotal'
    ];

    public function items()
    {
        return $this->hasMany(OrderItem::class, 'idComanda');
    }

    public function getVrTotalAttribute(){
        $items = $this->items()->get();

        return $items->reduce(function($total, $item){
            return $total + $item->vrTotal;
        }, 0);
    }
}
